/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.util.unsafe.UnsafeHolder;

@CoreClass(name="SizedQueue")
public abstract class SizedQueueNodes {

    @CoreMethod(names={"num_waiting"})
    public static abstract class NumWaitingNode
    extends CoreMethodArrayArgumentsNode {
        private static final long LOCK_FIELD_OFFSET = UnsafeHolder.fieldOffset(ArrayBlockingQueue.class, (String)"lock");
        private static final long NOT_EMPTY_CONDITION_FIELD_OFFSET = UnsafeHolder.fieldOffset(ArrayBlockingQueue.class, (String)"notEmpty");
        private static final long NOT_FULL_CONDITION_FIELD_OFFSET = UnsafeHolder.fieldOffset(ArrayBlockingQueue.class, (String)"notFull");

        public NumWaitingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public int num_waiting(DynamicObject self) {
            BlockingQueue queue = Layouts.SIZED_QUEUE.getQueue(self);
            ArrayBlockingQueue arrayBlockingQueue = (ArrayBlockingQueue)queue;
            final ReentrantLock lock = (ReentrantLock)UnsafeHolder.U.getObject(arrayBlockingQueue, LOCK_FIELD_OFFSET);
            Condition notEmptyCondition = (Condition)UnsafeHolder.U.getObject(arrayBlockingQueue, NOT_EMPTY_CONDITION_FIELD_OFFSET);
            Condition notFullCondition = (Condition)UnsafeHolder.U.getObject(arrayBlockingQueue, NOT_FULL_CONDITION_FIELD_OFFSET);
            this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    lock.lockInterruptibly();
                    return true;
                }
            });
            try {
                int n = lock.getWaitQueueLength(notEmptyCondition) + lock.getWaitQueueLength(notFullCondition);
                return n;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject clear(DynamicObject self) {
            BlockingQueue queue = Layouts.SIZED_QUEUE.getQueue(self);
            queue.clear();
            return self;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size(DynamicObject self) {
            BlockingQueue queue = Layouts.SIZED_QUEUE.getQueue(self);
            return queue.size();
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean empty(DynamicObject self) {
            BlockingQueue queue = Layouts.SIZED_QUEUE.getQueue(self);
            return queue.isEmpty();
        }
    }

    @CoreMethod(names={"pop", "shift", "deq"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="queue"), @NodeChild(type=RubyNode.class, value="nonBlocking")})
    public static abstract class PopNode
    extends CoreMethodNode {
        public PopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"nonBlocking"})
        public RubyNode coerceToBoolean(RubyNode nonBlocking) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), false, nonBlocking);
        }

        @Specialization(guards={"!nonBlocking"})
        public Object popBlocking(DynamicObject self, boolean nonBlocking) {
            final BlockingQueue queue = Layouts.SIZED_QUEUE.getQueue(self);
            return this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Object>(){

                @Override
                public Object block() throws InterruptedException {
                    return queue.take();
                }
            });
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"nonBlocking"})
        public Object popNonBlock(DynamicObject self, boolean nonBlocking) {
            BlockingQueue queue = Layouts.SIZED_QUEUE.getQueue(self);
            Object value = queue.poll();
            if (value == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("queue empty", this));
            }
            return value;
        }
    }

    @CoreMethod(names={"push", "<<", "enq"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="queue"), @NodeChild(type=RubyNode.class, value="value"), @NodeChild(type=RubyNode.class, value="nonBlocking")})
    public static abstract class PushNode
    extends CoreMethodNode {
        public PushNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"nonBlocking"})
        public RubyNode coerceToBoolean(RubyNode nonBlocking) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), false, nonBlocking);
        }

        @Specialization(guards={"!nonBlocking"})
        public DynamicObject pushBlocking(DynamicObject self, final Object value, boolean nonBlocking) {
            final BlockingQueue queue = Layouts.SIZED_QUEUE.getQueue(self);
            this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    queue.put(value);
                    return true;
                }
            });
            return self;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"nonBlocking"})
        public DynamicObject pushNonBlock(DynamicObject self, Object value, boolean nonBlocking) {
            BlockingQueue queue = Layouts.SIZED_QUEUE.getQueue(self);
            boolean pushed = queue.offer(value);
            if (!pushed) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("queue full", this));
            }
            return self;
        }
    }

    @CoreMethod(names={"max"})
    public static abstract class MaxNode
    extends CoreMethodArrayArgumentsNode {
        public MaxNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int max(DynamicObject self) {
            BlockingQueue queue = Layouts.SIZED_QUEUE.getQueue(self);
            return queue.size() + queue.remainingCapacity();
        }
    }

    @CoreMethod(names={"max="}, required=1)
    public static abstract class SetMaxNode
    extends CoreMethodArrayArgumentsNode {
        public SetMaxNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setMax(DynamicObject self, int newCapacity) {
            Object element;
            if (newCapacity <= 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("queue size must be positive", this));
            }
            BlockingQueue oldQueue = Layouts.SIZED_QUEUE.getQueue(self);
            ArrayBlockingQueue newQueue = new ArrayBlockingQueue(newCapacity);
            while ((element = oldQueue.poll()) != null) {
                newQueue.add(element);
            }
            Layouts.SIZED_QUEUE.setQueue(self, newQueue);
            return newCapacity;
        }
    }

    @CoreMethod(names={"initialize"}, visibility=Visibility.PRIVATE, required=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject initialize(DynamicObject self, int capacity) {
            if (capacity <= 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("queue size must be positive", this));
            }
            ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(capacity);
            Layouts.SIZED_QUEUE.setQueue(self, blockingQueue);
            return self;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return Layouts.SIZED_QUEUE.createSizedQueue(Layouts.CLASS.getInstanceFactory(rubyClass), null);
        }
    }
}

