/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.RangeNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=RangeNodes.class)
public final class RangeNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(CollectNodeFactory.getInstance(), EachNodeFactory.getInstance(), ExcludeEndNodeFactory.getInstance(), BeginNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), EndNodeFactory.getInstance(), StepNodeFactory.getInstance(), ToANodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=RangeNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<RangeNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(RangeNodes.AllocateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static RangeNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends RangeNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=RangeNodes.InternalSetExcludeEndNode.class)
    public static final class InternalSetExcludeEndNodeGen
    extends RangeNodes.InternalSetExcludeEndNode {
        @Node.Child
        private RubyNode self_;
        @Node.Child
        private RubyNode excludeEnd_;

        private InternalSetExcludeEndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode excludeEnd) {
            super(context, sourceSection);
            this.self_ = self;
            this.excludeEnd_ = this.castToBoolean(excludeEnd);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            boolean excludeEndValue_;
            DynamicObject selfValue_;
            try {
                selfValue_ = this.self_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object excludeEndValue = this.excludeEnd_.execute(frameValue);
                throw this.unsupported(ex.getResult(), excludeEndValue);
            }
            try {
                excludeEndValue_ = this.excludeEnd_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                throw this.unsupported(selfValue_, ex.getResult());
            }
            if (RubyGuards.isObjectRange(selfValue_)) {
                return this.setExcludeEnd(selfValue_, excludeEndValue_);
            }
            throw this.unsupported(selfValue_, excludeEndValue_);
        }

        protected UnsupportedSpecializationException unsupported(Object selfValue, Object excludeEndValue) {
            return new UnsupportedSpecializationException((Node)this, new Node[]{this.self_, this.excludeEnd_}, new Object[]{selfValue, excludeEndValue});
        }

        public static RangeNodes.InternalSetExcludeEndNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode excludeEnd) {
            return new InternalSetExcludeEndNodeGen(context, sourceSection, self, excludeEnd);
        }
    }

    @GeneratedBy(value=RangeNodes.InternalSetEndNode.class)
    public static final class InternalSetEndNodeGen
    extends RangeNodes.InternalSetEndNode {
        @Node.Child
        private RubyNode self_;
        @Node.Child
        private RubyNode end_;

        private InternalSetEndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode end) {
            super(context, sourceSection);
            this.self_ = self;
            this.end_ = end;
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject selfValue_;
            try {
                selfValue_ = this.self_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object endValue = this.end_.execute(frameValue);
                throw this.unsupported(ex.getResult(), endValue);
            }
            Object endValue_ = this.end_.execute(frameValue);
            if (RubyGuards.isObjectRange(selfValue_)) {
                return this.setEnd(selfValue_, endValue_);
            }
            throw this.unsupported(selfValue_, endValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected UnsupportedSpecializationException unsupported(Object selfValue, Object endValue) {
            return new UnsupportedSpecializationException((Node)this, new Node[]{this.self_, this.end_}, new Object[]{selfValue, endValue});
        }

        public static RangeNodes.InternalSetEndNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode end) {
            return new InternalSetEndNodeGen(context, sourceSection, self, end);
        }
    }

    @GeneratedBy(value=RangeNodes.InternalSetBeginNode.class)
    public static final class InternalSetBeginNodeGen
    extends RangeNodes.InternalSetBeginNode {
        @Node.Child
        private RubyNode self_;
        @Node.Child
        private RubyNode begin_;

        private InternalSetBeginNodeGen(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode begin) {
            super(context, sourceSection);
            this.self_ = self;
            this.begin_ = begin;
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject selfValue_;
            try {
                selfValue_ = this.self_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object beginValue = this.begin_.execute(frameValue);
                throw this.unsupported(ex.getResult(), beginValue);
            }
            Object beginValue_ = this.begin_.execute(frameValue);
            if (RubyGuards.isObjectRange(selfValue_)) {
                return this.setBegin(selfValue_, beginValue_);
            }
            throw this.unsupported(selfValue_, beginValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected UnsupportedSpecializationException unsupported(Object selfValue, Object beginValue) {
            return new UnsupportedSpecializationException((Node)this, new Node[]{this.self_, this.begin_}, new Object[]{selfValue, beginValue});
        }

        public static RangeNodes.InternalSetBeginNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode begin) {
            return new InternalSetBeginNodeGen(context, sourceSection, self, begin);
        }
    }

    @GeneratedBy(value=RangeNodes.ToANode.class)
    public static final class ToANodeFactory
    extends NodeFactoryBase<RangeNodes.ToANode> {
        private static ToANodeFactory toANodeFactoryInstance;

        private ToANodeFactory() {
            super(RangeNodes.ToANode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.ToANode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToANodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.ToANode> getInstance() {
            if (toANodeFactoryInstance == null) {
                toANodeFactoryInstance = new ToANodeFactory();
            }
            return toANodeFactoryInstance;
        }

        public static RangeNodes.ToANode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToANodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        public static final class ToANodeGen
        extends RangeNodes.ToANode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToANodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="toA(VirtualFrame, DynamicObject)", value=RangeNodes.ToANode.class)
            private static final class ToA1Node_
            extends BaseNode_ {
                ToA1Node_(ToANodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isObjectRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.toA(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToANodeGen root) {
                    return new ToA1Node_(root);
                }
            }

            @GeneratedBy(methodName="toA(DynamicObject)", value=RangeNodes.ToANode.class)
            private static final class ToA0Node_
            extends BaseNode_ {
                ToA0Node_(ToANodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isIntegerFixnumRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.toA(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToANodeGen root) {
                    return new ToA0Node_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.ToANode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToANodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToANodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.ToANode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToANodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToANodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.ToANode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ToANodeGen root;

                BaseNode_(ToANodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_)) {
                            return ToA0Node_.create(this.root);
                        }
                        if (RubyGuards.isObjectRange(arguments0Value_)) {
                            return ToA1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.StepNode.class)
    public static final class StepNodeFactory
    extends NodeFactoryBase<RangeNodes.StepNode> {
        private static StepNodeFactory stepNodeFactoryInstance;

        private StepNodeFactory() {
            super(RangeNodes.StepNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.StepNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StepNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.StepNode> getInstance() {
            if (stepNodeFactoryInstance == null) {
                stepNodeFactoryInstance = new StepNodeFactory();
            }
            return stepNodeFactoryInstance;
        }

        public static RangeNodes.StepNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new StepNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        public static final class StepNodeGen
        extends RangeNodes.StepNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private StepNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="step(VirtualFrame, DynamicObject, Object, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class StepNode_
            extends BaseNode_ {
                StepNode_(StepNodeGen root) {
                    super(root, 14);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isObjectRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.step(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepNode_(root);
                }
            }

            @GeneratedBy(methodName="stepObject(VirtualFrame, DynamicObject, NotProvided, DynamicObject)", value=RangeNodes.StepNode.class)
            private static final class StepObject2Node_
            extends BaseNode_ {
                StepObject2Node_(StepNodeGen root) {
                    super(root, 13);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isObjectRange(arguments0Value_) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepObject2Node_(root);
                }
            }

            @GeneratedBy(methodName="stepObject(VirtualFrame, DynamicObject, NotProvided, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class StepObject1Node_
            extends BaseNode_ {
                StepObject1Node_(StepNodeGen root) {
                    super(root, 12);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isObjectRange(arguments0Value_)) {
                            return this.root.stepObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepObject1Node_(root);
                }
            }

            @GeneratedBy(methodName="stepObject(VirtualFrame, DynamicObject, Object, DynamicObject)", value=RangeNodes.StepNode.class)
            private static final class StepObject0Node_
            extends BaseNode_ {
                StepObject0Node_(StepNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isObjectRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepObject(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepObject0Node_(root);
                }
            }

            @GeneratedBy(methodName="stepLong(VirtualFrame, DynamicObject, Object, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class StepLong3Node_
            extends BaseNode_ {
                StepLong3Node_(StepNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isLongFixnumRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.stepLong(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepLong3Node_(root);
                }
            }

            @GeneratedBy(methodName="stepLong(VirtualFrame, DynamicObject, NotProvided, DynamicObject)", value=RangeNodes.StepNode.class)
            private static final class StepLong2Node_
            extends BaseNode_ {
                StepLong2Node_(StepNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isLongFixnumRange(arguments0Value_) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepLong(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepLong2Node_(root);
                }
            }

            @GeneratedBy(methodName="stepLong(VirtualFrame, DynamicObject, NotProvided, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class StepLong1Node_
            extends BaseNode_ {
                StepLong1Node_(StepNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isLongFixnumRange(arguments0Value_)) {
                            return this.root.stepLong(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepLong1Node_(root);
                }
            }

            @GeneratedBy(methodName="stepInt(VirtualFrame, DynamicObject, Object, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class StepInt3Node_
            extends BaseNode_ {
                StepInt3Node_(StepNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.stepInt(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepInt3Node_(root);
                }
            }

            @GeneratedBy(methodName="stepInt(VirtualFrame, DynamicObject, NotProvided, DynamicObject)", value=RangeNodes.StepNode.class)
            private static final class StepInt2Node_
            extends BaseNode_ {
                StepInt2Node_(StepNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepInt(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepInt2Node_(root);
                }
            }

            @GeneratedBy(methodName="stepInt(VirtualFrame, DynamicObject, NotProvided, NotProvided)", value=RangeNodes.StepNode.class)
            private static final class StepInt1Node_
            extends BaseNode_ {
                StepInt1Node_(StepNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_)) {
                            return this.root.stepInt(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepInt1Node_(root);
                }
            }

            @GeneratedBy(methodName="stepFallbackLong(VirtualFrame, DynamicObject, Object, DynamicObject)", value=RangeNodes.StepNode.class)
            private static final class StepFallbackLongNode_
            extends BaseNode_ {
                StepFallbackLongNode_(StepNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isLongFixnumRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepFallbackLong(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepFallbackLongNode_(root);
                }
            }

            @GeneratedBy(methodName="stepFallbackInt(VirtualFrame, DynamicObject, Object, DynamicObject)", value=RangeNodes.StepNode.class)
            private static final class StepFallbackIntNode_
            extends BaseNode_ {
                StepFallbackIntNode_(StepNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepFallbackInt(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepFallbackIntNode_(root);
                }
            }

            @GeneratedBy(methodName="stepLong(VirtualFrame, DynamicObject, int, DynamicObject)", value=RangeNodes.StepNode.class)
            private static final class StepLong0Node_
            extends BaseNode_ {
                StepLong0Node_(StepNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isLongFixnumRange(arguments0Value_) && arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                        return this.root.stepLong(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isLongFixnumRange(arguments0Value_) && arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepLong(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepLong0Node_(root);
                }
            }

            @GeneratedBy(methodName="stepInt(VirtualFrame, DynamicObject, int, DynamicObject)", value=RangeNodes.StepNode.class)
            private static final class StepInt0Node_
            extends BaseNode_ {
                StepInt0Node_(StepNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                        return this.root.stepInt(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Integer && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                            return this.root.stepInt(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new StepInt0Node_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.StepNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(StepNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.StepNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(StepNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(StepNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.StepNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final StepNodeGen root;

                BaseNode_(StepNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments2Value_;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments2Value instanceof DynamicObject) {
                            arguments2Value_ = (DynamicObject)arguments2Value;
                            if (arguments1Value instanceof Integer) {
                                int arguments1Value_ = (Integer)arguments1Value;
                                if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                                    return StepInt0Node_.create(this.root);
                                }
                                if (RubyGuards.isLongFixnumRange(arguments0Value_) && arguments1Value_ > 0 && RubyGuards.isRubyProc(arguments2Value_)) {
                                    return StepLong0Node_.create(this.root);
                                }
                            }
                            if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                                return StepFallbackIntNode_.create(this.root);
                            }
                            if (RubyGuards.isLongFixnumRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                                return StepFallbackLongNode_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof NotProvided) {
                            if (arguments2Value instanceof NotProvided && RubyGuards.isIntegerFixnumRange(arguments0Value_)) {
                                return StepInt1Node_.create(this.root);
                            }
                            if (arguments2Value instanceof DynamicObject) {
                                arguments2Value_ = (DynamicObject)arguments2Value;
                                if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && RubyGuards.isRubyProc(arguments2Value_)) {
                                    return StepInt2Node_.create(this.root);
                                }
                            }
                        }
                        if (arguments2Value instanceof NotProvided) {
                            if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && !RubyGuards.isInteger(arguments1Value) && !RubyGuards.isLong(arguments1Value) && RubyGuards.wasProvided(arguments1Value)) {
                                return StepInt3Node_.create(this.root);
                            }
                            if (arguments1Value instanceof NotProvided && RubyGuards.isLongFixnumRange(arguments0Value_)) {
                                return StepLong1Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof NotProvided && arguments2Value instanceof DynamicObject) {
                            arguments2Value_ = (DynamicObject)arguments2Value;
                            if (RubyGuards.isLongFixnumRange(arguments0Value_) && RubyGuards.isRubyProc(arguments2Value_)) {
                                return StepLong2Node_.create(this.root);
                            }
                        }
                        if (arguments2Value instanceof NotProvided && RubyGuards.isLongFixnumRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return StepLong3Node_.create(this.root);
                        }
                        if (arguments2Value instanceof DynamicObject) {
                            arguments2Value_ = (DynamicObject)arguments2Value;
                            if (RubyGuards.isObjectRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value) && RubyGuards.isRubyProc(arguments2Value_)) {
                                return StepObject0Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof NotProvided) {
                            if (arguments2Value instanceof NotProvided && RubyGuards.isObjectRange(arguments0Value_)) {
                                return StepObject1Node_.create(this.root);
                            }
                            if (arguments2Value instanceof DynamicObject) {
                                arguments2Value_ = (DynamicObject)arguments2Value;
                                if (RubyGuards.isObjectRange(arguments0Value_) && RubyGuards.isRubyProc(arguments2Value_)) {
                                    return StepObject2Node_.create(this.root);
                                }
                            }
                        }
                        if (arguments2Value instanceof NotProvided && RubyGuards.isObjectRange(arguments0Value_) && RubyGuards.wasProvided(arguments1Value)) {
                            return StepNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.EndNode.class)
    public static final class EndNodeFactory
    extends NodeFactoryBase<RangeNodes.EndNode> {
        private static EndNodeFactory endNodeFactoryInstance;

        private EndNodeFactory() {
            super(RangeNodes.EndNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.EndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EndNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.EndNode> getInstance() {
            if (endNodeFactoryInstance == null) {
                endNodeFactoryInstance = new EndNodeFactory();
            }
            return endNodeFactoryInstance;
        }

        public static RangeNodes.EndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EndNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.EndNode.class)
        public static final class EndNodeGen
        extends RangeNodes.EndNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private EndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="lastObject(DynamicObject)", value=RangeNodes.EndNode.class)
            private static final class LastObjectNode_
            extends BaseNode_ {
                LastObjectNode_(EndNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isObjectRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.lastObject(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new LastObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="lastLong(DynamicObject)", value=RangeNodes.EndNode.class)
            private static final class LastLongNode_
            extends BaseNode_ {
                LastLongNode_(EndNodeGen root) {
                    super(root, 2);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return EndNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (RubyGuards.isLongFixnumRange(arguments0Value_)) {
                        return this.root.lastLong(arguments0Value_);
                    }
                    return EndNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isLongFixnumRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.lastLong(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new LastLongNode_(root);
                }
            }

            @GeneratedBy(methodName="lastInt(DynamicObject)", value=RangeNodes.EndNode.class)
            private static final class LastIntNode_
            extends BaseNode_ {
                LastIntNode_(EndNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return EndNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (RubyGuards.isIntegerFixnumRange(arguments0Value_)) {
                        return this.root.lastInt(arguments0Value_);
                    }
                    return EndNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isIntegerFixnumRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.lastInt(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new LastIntNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EndNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EndNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EndNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EndNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EndNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EndNodeGen root;

                BaseNode_(EndNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return EndNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return EndNodeGen.expectLong(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_)) {
                            return LastIntNode_.create(this.root);
                        }
                        if (RubyGuards.isLongFixnumRange(arguments0Value_)) {
                            return LastLongNode_.create(this.root);
                        }
                        if (RubyGuards.isObjectRange(arguments0Value_)) {
                            return LastObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<RangeNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(RangeNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static RangeNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends RangeNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="initialize(DynamicObject, Object, Object, boolean)", value=RangeNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    boolean arguments3Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        Object arguments3Value = this.executeArguments3_((Frame)frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    try {
                        arguments3Value_ = this.root.arguments3_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
                    }
                    if (RubyGuards.isObjectRange(arguments0Value_)) {
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments3Value instanceof Boolean) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        boolean arguments3Value_ = (Boolean)arguments3Value;
                        if (RubyGuards.isObjectRange(arguments0Value_)) {
                            return this.root.initialize(arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, Object, Object, NotProvided)", value=RangeNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject && arguments3Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        if (RubyGuards.isObjectRange(arguments0Value_)) {
                            return this.root.initialize(arguments0Value_, arguments1Value, arguments2Value, arguments3Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.executeArguments3_((Frame)frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments3Value instanceof NotProvided && RubyGuards.isObjectRange(arguments0Value_)) {
                            return Initialize0Node_.create(this.root);
                        }
                        if (arguments3Value instanceof Boolean && RubyGuards.isObjectRange(arguments0Value_)) {
                            return Initialize1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments3_(Frame frameValue) {
                    Object object;
                    Class arguments3Type_ = this.root.arguments3Type_;
                    if (arguments3Type_ == Boolean.TYPE) {
                        return this.root.arguments3_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments3Type_ != null) return this.root.arguments3_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments3_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments3Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments3Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments3Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.BeginNode.class)
    public static final class BeginNodeFactory
    extends NodeFactoryBase<RangeNodes.BeginNode> {
        private static BeginNodeFactory beginNodeFactoryInstance;

        private BeginNodeFactory() {
            super(RangeNodes.BeginNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.BeginNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BeginNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.BeginNode> getInstance() {
            if (beginNodeFactoryInstance == null) {
                beginNodeFactoryInstance = new BeginNodeFactory();
            }
            return beginNodeFactoryInstance;
        }

        public static RangeNodes.BeginNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BeginNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.BeginNode.class)
        public static final class BeginNodeGen
        extends RangeNodes.BeginNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private BeginNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="eachObject(DynamicObject)", value=RangeNodes.BeginNode.class)
            private static final class EachObjectNode_
            extends BaseNode_ {
                EachObjectNode_(BeginNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isObjectRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.eachObject(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new EachObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="eachLong(DynamicObject)", value=RangeNodes.BeginNode.class)
            private static final class EachLongNode_
            extends BaseNode_ {
                EachLongNode_(BeginNodeGen root) {
                    super(root, 2);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return BeginNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (RubyGuards.isLongFixnumRange(arguments0Value_)) {
                        return this.root.eachLong(arguments0Value_);
                    }
                    return BeginNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isLongFixnumRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.eachLong(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new EachLongNode_(root);
                }
            }

            @GeneratedBy(methodName="eachInt(DynamicObject)", value=RangeNodes.BeginNode.class)
            private static final class EachIntNode_
            extends BaseNode_ {
                EachIntNode_(BeginNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return BeginNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (RubyGuards.isIntegerFixnumRange(arguments0Value_)) {
                        return this.root.eachInt(arguments0Value_);
                    }
                    return BeginNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isIntegerFixnumRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.eachInt(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new EachIntNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.BeginNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BeginNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.BeginNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BeginNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.BeginNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final BeginNodeGen root;

                BaseNode_(BeginNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BeginNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return BeginNodeGen.expectLong(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_)) {
                            return EachIntNode_.create(this.root);
                        }
                        if (RubyGuards.isLongFixnumRange(arguments0Value_)) {
                            return EachLongNode_.create(this.root);
                        }
                        if (RubyGuards.isObjectRange(arguments0Value_)) {
                            return EachObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
    public static final class ExcludeEndNodeFactory
    extends NodeFactoryBase<RangeNodes.ExcludeEndNode> {
        private static ExcludeEndNodeFactory excludeEndNodeFactoryInstance;

        private ExcludeEndNodeFactory() {
            super(RangeNodes.ExcludeEndNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.ExcludeEndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExcludeEndNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.ExcludeEndNode> getInstance() {
            if (excludeEndNodeFactoryInstance == null) {
                excludeEndNodeFactoryInstance = new ExcludeEndNodeFactory();
            }
            return excludeEndNodeFactoryInstance;
        }

        public static RangeNodes.ExcludeEndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExcludeEndNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        public static final class ExcludeEndNodeGen
        extends RangeNodes.ExcludeEndNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ExcludeEndNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="excludeEndObject(DynamicObject)", value=RangeNodes.ExcludeEndNode.class)
            private static final class ExcludeEndObjectNode_
            extends BaseNode_ {
                ExcludeEndObjectNode_(ExcludeEndNodeGen root) {
                    super(root, 3);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isObjectRange(arguments0Value_)) {
                        return this.root.excludeEndObject(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isObjectRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.excludeEndObject(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExcludeEndNodeGen root) {
                    return new ExcludeEndObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="excludeEndLong(DynamicObject)", value=RangeNodes.ExcludeEndNode.class)
            private static final class ExcludeEndLongNode_
            extends BaseNode_ {
                ExcludeEndLongNode_(ExcludeEndNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isLongFixnumRange(arguments0Value_)) {
                        return this.root.excludeEndLong(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isLongFixnumRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.excludeEndLong(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExcludeEndNodeGen root) {
                    return new ExcludeEndLongNode_(root);
                }
            }

            @GeneratedBy(methodName="excludeEndInt(DynamicObject)", value=RangeNodes.ExcludeEndNode.class)
            private static final class ExcludeEndIntNode_
            extends BaseNode_ {
                ExcludeEndIntNode_(ExcludeEndNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isIntegerFixnumRange(arguments0Value_)) {
                        return this.root.excludeEndInt(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isIntegerFixnumRange(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.excludeEndInt(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExcludeEndNodeGen root) {
                    return new ExcludeEndIntNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ExcludeEndNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExcludeEndNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ExcludeEndNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ExcludeEndNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ExcludeEndNodeGen root;

                BaseNode_(ExcludeEndNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_)) {
                            return ExcludeEndIntNode_.create(this.root);
                        }
                        if (RubyGuards.isLongFixnumRange(arguments0Value_)) {
                            return ExcludeEndLongNode_.create(this.root);
                        }
                        if (RubyGuards.isObjectRange(arguments0Value_)) {
                            return ExcludeEndObjectNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<RangeNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(RangeNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        public static RangeNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        public static final class EachNodeGen
        extends RangeNodes.EachNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="each(VirtualFrame, DynamicObject, DynamicObject)", value=RangeNodes.EachNode.class)
            private static final class Each1Node_
            extends BaseNode_ {
                Each1Node_(EachNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isObjectRange(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.each(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new Each1Node_(root);
                }
            }

            @GeneratedBy(methodName="each(VirtualFrame, DynamicObject, NotProvided)", value=RangeNodes.EachNode.class)
            private static final class Each0Node_
            extends BaseNode_ {
                Each0Node_(EachNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (RubyGuards.isObjectRange(arguments0Value_)) {
                            return this.root.each(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new Each0Node_(root);
                }
            }

            @GeneratedBy(methodName="eachObject(VirtualFrame, DynamicObject, NotProvided)", value=RangeNodes.EachNode.class)
            private static final class EachObjectNode_
            extends BaseNode_ {
                EachObjectNode_(EachNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (RubyGuards.isLongFixnumRange(arguments0Value_)) {
                            return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachObjectNode_(root);
                }
            }

            @GeneratedBy(methodName="eachLong(VirtualFrame, DynamicObject, DynamicObject)", value=RangeNodes.EachNode.class)
            private static final class EachLongNode_
            extends BaseNode_ {
                EachLongNode_(EachNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isLongFixnumRange(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachLong(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachLongNode_(root);
                }
            }

            @GeneratedBy(methodName="eachInt(VirtualFrame, DynamicObject, DynamicObject)", value=RangeNodes.EachNode.class)
            private static final class EachIntNode_
            extends BaseNode_ {
                EachIntNode_(EachNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                            return this.root.eachInt(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachIntNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EachNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EachNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=RangeNodes.EachNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EachNodeGen root;

                BaseNode_(EachNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof DynamicObject) {
                            arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachIntNode_.create(this.root);
                            }
                            if (RubyGuards.isLongFixnumRange(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return EachLongNode_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof NotProvided) {
                            if (RubyGuards.isLongFixnumRange(arguments0Value_)) {
                                return EachObjectNode_.create(this.root);
                            }
                            if (RubyGuards.isObjectRange(arguments0Value_)) {
                                return Each0Node_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isObjectRange(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                                return Each1Node_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=RangeNodes.CollectNode.class)
    public static final class CollectNodeFactory
    extends NodeFactoryBase<RangeNodes.CollectNode> {
        private static CollectNodeFactory collectNodeFactoryInstance;

        private CollectNodeFactory() {
            super(RangeNodes.CollectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.CollectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CollectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<RangeNodes.CollectNode> getInstance() {
            if (collectNodeFactoryInstance == null) {
                collectNodeFactoryInstance = new CollectNodeFactory();
            }
            return collectNodeFactoryInstance;
        }

        public static RangeNodes.CollectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CollectNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        public static final class CollectNodeGen
        extends RangeNodes.CollectNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private CollectNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isIntegerFixnumRange(arguments0Value_) && RubyGuards.isRubyProc(arguments1Value_)) {
                    return this.collect(frameValue, arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }
}

