/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.RegexpNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

public class InterpolatedRegexpNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;
    private final RegexpOptions options;
    @Node.Child
    private CallDispatchHeadNode toS;

    public InterpolatedRegexpNode(RubyContext context, SourceSection sourceSection, RubyNode[] children, RegexpOptions options) {
        super(context, sourceSection);
        this.children = children;
        this.options = options;
        this.toS = DispatchHeadNodeFactory.createMethodCall(context);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        RubyString[] strings = new RubyString[this.children.length];
        for (int n = 0; n < this.children.length; ++n) {
            Object child = this.children[n].execute(frame);
            strings[n] = RubyString.newString((Ruby)this.getContext().getRuntime(), (ByteList)Layouts.STRING.getByteList((DynamicObject)this.toS.call(frame, child, "to_s", null, new Object[0])));
        }
        RubyString preprocessed = RubyRegexp.preprocessDRegexp((Ruby)this.getContext().getRuntime(), (IRubyObject[])strings, (RegexpOptions)this.options);
        DynamicObject regexp = RegexpNodes.createRubyRegexp((Node)this, this.getContext().getCoreLibrary().getRegexpClass(), preprocessed.getByteList(), this.options);
        if (this.options.isEncodingNone()) {
            if (!BodyTranslator.all7Bit(preprocessed.getByteList().bytes())) {
                Layouts.REGEXP.getSource(regexp).setEncoding(this.getContext().getRuntime().getEncodingService().getAscii8bitEncoding());
            } else {
                Layouts.REGEXP.getSource(regexp).setEncoding(this.getContext().getRuntime().getEncodingService().getUSAsciiEncoding());
            }
        }
        return regexp;
    }
}

