/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;

@NodeChild(value="child")
public abstract class ProcCastNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toProc;

    public ProcCastNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toProc = DispatchHeadNodeFactory.createMethodCall(context);
    }

    @Specialization(guards={"isNil(nil)"})
    public DynamicObject doNil(Object nil) {
        return this.nil();
    }

    @Specialization(guards={"isRubyProc(proc)"})
    public DynamicObject doRubyProc(DynamicObject proc) {
        return proc;
    }

    @Specialization
    public Object doObject(VirtualFrame frame, DynamicObject object) {
        return this.toProc.call(frame, object, "to_proc", null, new Object[0]);
    }
}

