/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.exceptions.RaiseException;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.defined.DefinedWrapperNode;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.methods.CatchNextNode;
import org.jruby.truffle.nodes.methods.CatchRetryAsErrorNode;
import org.jruby.truffle.nodes.methods.CatchReturnAsErrorNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.MethodTranslator;
import org.jruby.truffle.translator.ModuleTranslator;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.ParseEnvironment;
import org.jruby.truffle.translator.TranslatorEnvironment;

public class TranslatorDriver {
    private final ParseEnvironment parseEnvironment;

    public TranslatorDriver(RubyContext context) {
        this.parseEnvironment = new ParseEnvironment(context);
    }

    public RubyRootNode parse(RubyContext context, Source source, Encoding defaultEncoding, ParserContext parserContext, MaterializedFrame parentFrame, boolean ownScopeForAssignments, com.oracle.truffle.api.nodes.Node currentNode, NodeWrapper wrapper) {
        RootNode node;
        Parser parser = new Parser(context.getRuntime());
        StaticScope staticScope = context.getRuntime().getStaticScopeFactory().newLocalScope(null);
        if (parentFrame != null) {
            MaterializedFrame frame = parentFrame;
            while (frame != null) {
                for (FrameSlot slot : frame.getFrameDescriptor().getSlots()) {
                    if (!(slot.getIdentifier() instanceof String)) continue;
                    String name = (String)slot.getIdentifier();
                    staticScope.addVariableThisScope(name);
                }
                frame = RubyArguments.getDeclarationFrame(frame.getArguments());
            }
        }
        boolean isInlineSource = parserContext == ParserContext.SHELL;
        boolean isEvalParse = parserContext == ParserContext.EVAL || parserContext == ParserContext.MODULE;
        ParserConfiguration parserConfiguration = new ParserConfiguration(context.getRuntime(), 0, isInlineSource, !isEvalParse, true);
        parserConfiguration.setDefaultEncoding(defaultEncoding);
        try {
            node = (RootNode)parser.parse(source.getName(), source.getCode().getBytes(StandardCharsets.UTF_8), (DynamicScope)new ManyVarsDynamicScope(staticScope), parserConfiguration);
        }
        catch (RaiseException e) {
            String message = e.getException().getMessage().asJavaString();
            if (message == null) {
                message = "(no message)";
            }
            throw new org.jruby.truffle.runtime.control.RaiseException(context.getCoreLibrary().syntaxError(message, currentNode));
        }
        return this.parse(currentNode, context, source, parserContext, parentFrame, ownScopeForAssignments, node, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyRootNode parse(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, Source source, ParserContext parserContext, MaterializedFrame parentFrame, boolean ownScopeForAssignments, RootNode rootNode, NodeWrapper wrapper) {
        RubyNode truffleNode;
        SourceSection sourceSection = source.createSection("<main>", 0, source.getCode().length());
        InternalMethod parentMethod = parentFrame == null ? null : RubyArguments.getMethod(parentFrame.getArguments());
        LexicalScope lexicalScope = parentMethod != null && parentMethod.getSharedMethodInfo().getLexicalScope() != null ? parentMethod.getSharedMethodInfo().getLexicalScope() : context.getRootLexicalScope();
        if (parserContext == ParserContext.MODULE) {
            Object module = RubyArguments.getSelf(Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, true).getArguments());
            lexicalScope = new LexicalScope(lexicalScope, (RubyModule)module);
        }
        this.parseEnvironment.resetLexicalScope(lexicalScope);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.parseEnvironment.getLexicalScope(), Arity.NO_ARGUMENTS, "<main>", false, (Node)rootNode, false);
        TranslatorEnvironment environment = new TranslatorEnvironment(context, this.environmentForFrame(context, parentFrame), this.parseEnvironment, this.parseEnvironment.allocateReturnID(), ownScopeForAssignments, false, sharedMethodInfo, sharedMethodInfo.getName(), false, null);
        Object data = this.getData(context);
        if (data != null) {
            context.getCoreLibrary().getObjectClass().setConstant(currentNode, "DATA", data);
        }
        BodyTranslator translator = parserContext == ParserContext.MODULE ? new ModuleTranslator(currentNode, context, null, environment, source) : new BodyTranslator(currentNode, context, null, environment, source, parserContext == ParserContext.TOP_LEVEL);
        if (rootNode.getBodyNode() == null || rootNode.getBodyNode() instanceof NilNode) {
            translator.parentSourceSection.push(sourceSection);
            try {
                truffleNode = new DefinedWrapperNode(context, sourceSection, new LiteralNode(context, sourceSection, context.getCoreLibrary().getNilObject()), "nil");
            }
            finally {
                translator.parentSourceSection.pop();
            }
        } else {
            truffleNode = (RubyNode)((Object)rootNode.getBodyNode().accept((NodeVisitor)translator));
        }
        if (environment.getFlipFlopStates().size() > 0) {
            truffleNode = SequenceNode.sequence(context, truffleNode.getSourceSection(), translator.initFlipFlopStates(truffleNode.getSourceSection()), truffleNode);
        }
        truffleNode = new CatchNextNode(context, truffleNode.getSourceSection(), truffleNode);
        truffleNode = new CatchReturnAsErrorNode(context, truffleNode.getSourceSection(), truffleNode);
        truffleNode = new CatchRetryAsErrorNode(context, truffleNode.getSourceSection(), truffleNode);
        truffleNode = wrapper.wrap(truffleNode);
        if (MethodTranslator.PRINT_PARSE_TREE_METHOD_NAMES.contains("main")) {
            System.err.println(source.getShortName() + " main");
            System.err.println(sharedMethodInfo.getParseTree().toString(true, 0));
        }
        if (MethodTranslator.PRINT_AST_METHOD_NAMES.contains("main")) {
            System.err.println(source.getShortName() + " main");
            NodeUtil.printCompactTree((OutputStream)System.err, (com.oracle.truffle.api.nodes.Node)truffleNode);
        }
        if (MethodTranslator.PRINT_FULL_AST_METHOD_NAMES.contains("main")) {
            System.err.println(source.getShortName() + " main");
            NodeUtil.printTree((OutputStream)System.err, (com.oracle.truffle.api.nodes.Node)truffleNode);
        }
        return new RubyRootNode(context, truffleNode.getSourceSection(), environment.getFrameDescriptor(), sharedMethodInfo, truffleNode, environment.needsDeclarationFrame());
    }

    private Object getData(RubyContext context) {
        return null;
    }

    private TranslatorEnvironment environmentForFrame(RubyContext context, MaterializedFrame frame) {
        if (frame == null) {
            return null;
        }
        NullSourceSection sourceSection = new NullSourceSection("Unknown source section", "(unknown)");
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, context.getRootLexicalScope(), Arity.NO_ARGUMENTS, "(unknown)", false, null, false);
        MaterializedFrame parent = RubyArguments.getDeclarationFrame(frame.getArguments());
        return new TranslatorEnvironment(context, this.environmentForFrame(context, parent), this.parseEnvironment, this.parseEnvironment.allocateReturnID(), true, true, sharedMethodInfo, sharedMethodInfo.getName(), false, null, frame.getFrameDescriptor());
    }

    public static enum ParserContext {
        TOP_LEVEL,
        SHELL,
        MODULE,
        EVAL;

    }
}

