/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Syntax;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2ConstNode;
import org.jruby.ast.Colon2ImplicitNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.InvalidSourcePosition;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.ThreadLocalObjectNode;
import org.jruby.truffle.nodes.arguments.IsRubiniusUndefinedNode;
import org.jruby.truffle.nodes.cast.HashCastNodeGen;
import org.jruby.truffle.nodes.cast.ProcCastNodeGen;
import org.jruby.truffle.nodes.cast.SplatCastNode;
import org.jruby.truffle.nodes.cast.SplatCastNodeGen;
import org.jruby.truffle.nodes.cast.StringToSymbolNodeGen;
import org.jruby.truffle.nodes.cast.ToSNode;
import org.jruby.truffle.nodes.cast.ToSNodeGen;
import org.jruby.truffle.nodes.constants.ReadConstantNode;
import org.jruby.truffle.nodes.constants.WriteConstantNode;
import org.jruby.truffle.nodes.control.BreakNode;
import org.jruby.truffle.nodes.control.ElidableResultNode;
import org.jruby.truffle.nodes.control.IfNode;
import org.jruby.truffle.nodes.control.NotNode;
import org.jruby.truffle.nodes.control.OnceNode;
import org.jruby.truffle.nodes.control.RetryNode;
import org.jruby.truffle.nodes.control.ReturnNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.control.TraceNode;
import org.jruby.truffle.nodes.control.WhenSplatNode;
import org.jruby.truffle.nodes.control.WhileNode;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.core.InterpolatedRegexpNode;
import org.jruby.truffle.nodes.core.InterpolatedStringNode;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.MatchDataNodesFactory;
import org.jruby.truffle.nodes.core.RaiseIfFrozenNode;
import org.jruby.truffle.nodes.core.RangeNodesFactory;
import org.jruby.truffle.nodes.core.RegexpNodes;
import org.jruby.truffle.nodes.core.RegexpNodesFactory;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.ThreadPassNode;
import org.jruby.truffle.nodes.core.TimeNodesFactory;
import org.jruby.truffle.nodes.core.array.ArrayConcatNode;
import org.jruby.truffle.nodes.core.array.ArrayDropTailNode;
import org.jruby.truffle.nodes.core.array.ArrayDropTailNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayGetTailNode;
import org.jruby.truffle.nodes.core.array.ArrayGetTailNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayLiteralNode;
import org.jruby.truffle.nodes.core.array.ArrayNodesFactory;
import org.jruby.truffle.nodes.core.array.PrimitiveArrayNodeFactory;
import org.jruby.truffle.nodes.core.fixnum.FixnumLiteralNode;
import org.jruby.truffle.nodes.core.hash.ConcatHashLiteralNode;
import org.jruby.truffle.nodes.core.hash.HashLiteralNode;
import org.jruby.truffle.nodes.core.hash.HashNodesFactory;
import org.jruby.truffle.nodes.debug.AssertConstantNodeGen;
import org.jruby.truffle.nodes.debug.AssertNotCompiledNodeGen;
import org.jruby.truffle.nodes.defined.DefinedNode;
import org.jruby.truffle.nodes.defined.DefinedWrapperNode;
import org.jruby.truffle.nodes.dispatch.RubyCallNode;
import org.jruby.truffle.nodes.exceptions.EnsureNode;
import org.jruby.truffle.nodes.exceptions.RescueAnyNode;
import org.jruby.truffle.nodes.exceptions.RescueClassesNode;
import org.jruby.truffle.nodes.exceptions.RescueNode;
import org.jruby.truffle.nodes.exceptions.RescueSplatNode;
import org.jruby.truffle.nodes.exceptions.TryNode;
import org.jruby.truffle.nodes.globals.CheckMatchVariableTypeNode;
import org.jruby.truffle.nodes.globals.CheckOutputSeparatorVariableTypeNode;
import org.jruby.truffle.nodes.globals.CheckProgramNameVariableTypeNode;
import org.jruby.truffle.nodes.globals.CheckRecordSeparatorVariableTypeNode;
import org.jruby.truffle.nodes.globals.CheckStdoutVariableTypeNode;
import org.jruby.truffle.nodes.globals.GetFromThreadLocalNodeGen;
import org.jruby.truffle.nodes.globals.ReadLastBacktraceNode;
import org.jruby.truffle.nodes.globals.ReadMatchReferenceNode;
import org.jruby.truffle.nodes.globals.UpdateLastBacktraceNode;
import org.jruby.truffle.nodes.globals.UpdateVerbosityNode;
import org.jruby.truffle.nodes.globals.WrapInThreadLocalNodeGen;
import org.jruby.truffle.nodes.globals.WriteReadOnlyGlobalNode;
import org.jruby.truffle.nodes.literal.RangeLiteralNodeGen;
import org.jruby.truffle.nodes.literal.StringLiteralNode;
import org.jruby.truffle.nodes.locals.DeclarationFlipFlopStateNode;
import org.jruby.truffle.nodes.locals.FlipFlopNode;
import org.jruby.truffle.nodes.locals.FlipFlopStateNode;
import org.jruby.truffle.nodes.locals.InitFlipFlopSlotNode;
import org.jruby.truffle.nodes.locals.LocalFlipFlopStateNode;
import org.jruby.truffle.nodes.locals.ReadLocalVariableNode;
import org.jruby.truffle.nodes.locals.WriteDeclarationVariableNode;
import org.jruby.truffle.nodes.locals.WriteLocalVariableNode;
import org.jruby.truffle.nodes.methods.AddMethodNode;
import org.jruby.truffle.nodes.methods.AliasNodeGen;
import org.jruby.truffle.nodes.methods.BlockDefinitionNode;
import org.jruby.truffle.nodes.methods.CatchBreakNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.objects.DefineOrGetClassNode;
import org.jruby.truffle.nodes.objects.DefineOrGetModuleNode;
import org.jruby.truffle.nodes.objects.LexicalScopeNode;
import org.jruby.truffle.nodes.objects.OpenModuleNode;
import org.jruby.truffle.nodes.objects.ReadClassVariableNode;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeGen;
import org.jruby.truffle.nodes.objects.WriteClassVariableNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.nodes.rubinius.RubiniusLastStringReadNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.nodes.rubinius.RubiniusSingleBlockArgNode;
import org.jruby.truffle.nodes.yield.YieldNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.DeadNode;
import org.jruby.truffle.translator.MethodTranslator;
import org.jruby.truffle.translator.ModuleTranslator;
import org.jruby.truffle.translator.ReadLocalDummyNode;
import org.jruby.truffle.translator.ReadNode;
import org.jruby.truffle.translator.Translator;
import org.jruby.truffle.translator.TranslatorEnvironment;
import org.jruby.truffle.translator.WriteNode;
import org.jruby.util.ByteList;
import org.jruby.util.KeyValuePair;

public class BodyTranslator
extends Translator {
    protected final BodyTranslator parent;
    protected final TranslatorEnvironment environment;
    public boolean translatingForStatement = false;
    public boolean useClassVariablesAsIfInClass = false;
    private boolean translatingNextExpression = false;
    private boolean translatingWhile = false;
    protected String currentCallMethodName = null;
    private boolean privately = false;
    protected boolean usesRubiniusPrimitive = false;
    private static final Set<String> debugIgnoredCalls = new HashSet<String>();
    public static final Set<String> THREAD_LOCAL_GLOBAL_VARIABLES;
    private final Set<String> readOnlyGlobalVariables = new HashSet<String>();
    private final Map<String, String> globalVariableAliases = new HashMap<String, String>();

    public BodyTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, Source source, boolean topLevel) {
        super(currentNode, context, source);
        this.parent = parent;
        this.environment = environment;
        this.initGlobalVariableAliases();
        this.initReadOnlyGlobalVariables();
    }

    public RubyNode visitAliasNode(AliasNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        LiteralNode oldName = (LiteralNode)node.getOldName();
        LiteralNode newName = (LiteralNode)node.getNewName();
        return AliasNodeGen.create(this.context, sourceSection, newName.getName(), oldName.getName(), new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection));
    }

    public RubyNode visitAndNode(AndNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode x = node.getFirstNode() == null ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)node.getFirstNode().accept((NodeVisitor)this));
        RubyNode y = node.getSecondNode() == null ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)node.getSecondNode().accept((NodeVisitor)this));
        return new org.jruby.truffle.nodes.control.AndNode(this.context, sourceSection, x, y);
    }

    public RubyNode visitArgsCatNode(ArgsCatNode node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.collectArgsCatNodes(nodes, node);
        ArrayList<Object> translatedNodes = new ArrayList<Object>();
        for (Node catNode : nodes) {
            translatedNodes.add(catNode.accept((NodeVisitor)this));
        }
        return new ArrayConcatNode(this.context, this.translate(node.getPosition()), translatedNodes.toArray(new RubyNode[translatedNodes.size()]));
    }

    private void collectArgsCatNodes(List<Node> nodes, ArgsCatNode node) {
        if (node.getFirstNode() instanceof ArgsCatNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatNode)node.getFirstNode());
        } else {
            nodes.add(node.getFirstNode());
        }
        if (node.getSecondNode() instanceof ArgsCatNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatNode)node.getSecondNode());
        } else {
            SplatNode secondNode = new SplatNode(node.getSecondNode().getPosition(), node.getSecondNode());
            nodes.add((Node)secondNode);
        }
    }

    public RubyNode visitArgsPushNode(ArgsPushNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return ArrayNodesFactory.PushOneNodeFactory.create(this.context, sourceSection, new RubyNode[]{KernelNodesFactory.DupNodeFactory.create(this.context, sourceSection, new RubyNode[]{(RubyNode)((Object)node.getFirstNode().accept((NodeVisitor)this))}), (RubyNode)((Object)node.getSecondNode().accept((NodeVisitor)this))});
    }

    public RubyNode visitArrayNode(ArrayNode node) {
        Node[] values = node.children();
        RubyNode[] translatedValues = new RubyNode[values.length];
        for (int n = 0; n < values.length; ++n) {
            translatedValues[n] = (RubyNode)((Object)values[n].accept((NodeVisitor)this));
        }
        return new ArrayLiteralNode.UninitialisedArrayLiteralNode(this.context, this.translate(node.getPosition()), translatedValues);
    }

    public RubyNode visitAttrAssignNode(AttrAssignNode node) {
        return this.visitAttrAssignNodeExtraArgument(node, null);
    }

    public RubyNode visitAttrAssignNodeExtraArgument(AttrAssignNode node, RubyNode extraArgument) {
        ArrayNode fixedArgsNode;
        ArrayNode newArgsNode;
        WriteLocalVariableNode writeValue;
        SourceSection sourceSection = this.translate(node.getPosition());
        FrameSlot frameSlot = this.environment.declareVar(this.environment.allocateLocalTemp("attrasgn"));
        if (extraArgument == null) {
            ArrayList<ReadLocalDummyNode> argChildNodes = new ArrayList<ReadLocalDummyNode>(node.getArgsNode().childNodes());
            Node valueNode = (Node)argChildNodes.get(argChildNodes.size() - 1);
            argChildNodes.remove(argChildNodes.size() - 1);
            writeValue = new WriteLocalVariableNode(this.context, sourceSection, (RubyNode)((Object)valueNode.accept((NodeVisitor)this)), frameSlot);
            argChildNodes.add(new ReadLocalDummyNode(node.getPosition(), sourceSection, frameSlot));
            newArgsNode = new ArrayNode(node.getPosition(), (Node)argChildNodes.get(0));
            argChildNodes.remove(0);
            for (Node node2 : argChildNodes) {
                newArgsNode.add(node2);
            }
        } else {
            RubyNode valueNode = extraArgument;
            writeValue = new WriteLocalVariableNode(this.context, sourceSection, valueNode, frameSlot);
            ArrayList<ReadLocalDummyNode> argChildNodes = new ArrayList<ReadLocalDummyNode>();
            if (node.getArgsNode() != null) {
                argChildNodes.addAll(node.getArgsNode().childNodes());
            }
            argChildNodes.add(new ReadLocalDummyNode(node.getPosition(), sourceSection, frameSlot));
            newArgsNode = new ArrayNode(node.getPosition(), (Node)argChildNodes.get(0));
            argChildNodes.remove(0);
            for (Node node3 : argChildNodes) {
                newArgsNode.add(node3);
            }
        }
        if (node.getArgsNode() instanceof ArgsPushNode) {
            if (newArgsNode.size() != 2) {
                throw new UnsupportedOperationException();
            }
            fixedArgsNode = new ArgsPushNode(newArgsNode.getPosition(), newArgsNode.children()[0], newArgsNode.children()[1]);
        } else {
            fixedArgsNode = newArgsNode;
        }
        CallNode callNode = new CallNode(node.getPosition(), node.getReceiverNode(), node.getName(), (Node)fixedArgsNode, null);
        boolean isAccessorOnSelf = node.getReceiverNode() instanceof SelfNode;
        RubyNode rubyNode = this.visitCallNodeExtraArgument(callNode, null, isAccessorOnSelf, false);
        return SequenceNode.sequence(this.context, sourceSection, writeValue, rubyNode, new ReadLocalVariableNode(this.context, sourceSection, frameSlot));
    }

    public RubyNode visitBeginNode(BeginNode node) {
        return (RubyNode)((Object)node.getBodyNode().accept((NodeVisitor)this));
    }

    public RubyNode visitBignumNode(BignumNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        BigInteger value = node.getValue();
        if (value.bitLength() >= 64) {
            return new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, BignumNodes.createRubyBignum(this.context.getCoreLibrary().getBignumClass(), node.getValue()));
        }
        return new FixnumLiteralNode.LongFixnumLiteralNode(this.context, sourceSection, value.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode visitBlockNode(BlockNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> translatedChildren = new ArrayList<RubyNode>();
        for (Node child : node.children()) {
            RubyNode translatedChild;
            if (child.getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection.push(sourceSection);
            }
            try {
                translatedChild = (RubyNode)((Object)child.accept((NodeVisitor)this));
            }
            finally {
                if (child.getPosition() == InvalidSourcePosition.INSTANCE) {
                    this.parentSourceSection.pop();
                }
            }
            if (translatedChild instanceof DeadNode) continue;
            translatedChildren.add(translatedChild);
        }
        if (translatedChildren.size() == 1) {
            return (RubyNode)((Object)translatedChildren.get(0));
        }
        return SequenceNode.sequence(this.context, sourceSection, translatedChildren.toArray(new RubyNode[translatedChildren.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode visitBreakNode(org.jruby.ast.BreakNode node) {
        RubyNode resultNode;
        assert (this.environment.isBlock() || this.translatingWhile) : "The parser did not see an invalid break";
        SourceSection sourceSection = this.translate(node.getPosition());
        if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
            this.parentSourceSection.push(sourceSection);
            try {
                resultNode = (RubyNode)((Object)node.getValueNode().accept((NodeVisitor)this));
            }
            finally {
                this.parentSourceSection.pop();
            }
        } else {
            resultNode = (RubyNode)((Object)node.getValueNode().accept((NodeVisitor)this));
        }
        return new BreakNode(this.context, sourceSection, this.environment.getBreakID(), resultNode);
    }

    public RubyNode visitCallNode(CallNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        Node receiver = node.getReceiverNode();
        String methodName = node.getName();
        if (receiver instanceof ConstNode && ((ConstNode)receiver).getName().equals("Rubinius")) {
            if (methodName.equals("primitive")) {
                return this.translateRubiniusPrimitive(sourceSection, node);
            }
            if (methodName.equals("invoke_primitive")) {
                return this.translateRubiniusInvokePrimitive(sourceSection, node);
            }
            if (methodName.equals("privately")) {
                return this.translateRubiniusPrivately(sourceSection, node);
            }
            if (methodName.equals("single_block_arg")) {
                return this.translateRubiniusSingleBlockArg(sourceSection, node);
            }
            if (methodName.equals("check_frozen")) {
                return this.translateRubiniusCheckFrozen(sourceSection);
            }
        } else if (receiver instanceof Colon2ConstNode && ((Colon2ConstNode)receiver).getLeftNode() instanceof ConstNode && ((ConstNode)((Colon2ConstNode)receiver).getLeftNode()).getName().equals("Truffle") && ((Colon2ConstNode)receiver).getName().equals("Primitive")) {
            if (methodName.equals("assert_constant")) {
                return AssertConstantNodeGen.create(this.context, sourceSection, (RubyNode)((Object)((Node)node.getArgsNode().childNodes().get(0)).accept((NodeVisitor)this)));
            }
            if (methodName.equals("assert_not_compiled")) {
                return AssertNotCompiledNodeGen.create(this.context, sourceSection);
            }
        } else if (receiver instanceof ConstNode && ((ConstNode)receiver).getName().equals("Truffle")) {
            if (methodName.equals("omit")) {
                return new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
            }
        } else if (receiver instanceof VCallNode && ((VCallNode)receiver).getName().equals("undefined") && sourceSection.getSource().getPath().startsWith("core:/core/") && methodName.equals("equal?")) {
            RubyNode argument = this.translateArgumentsAndBlock(sourceSection, null, node.getArgsNode(), null, methodName).getArguments()[0];
            return new IsRubiniusUndefinedNode(this.context, sourceSection, argument);
        }
        return this.visitCallNodeExtraArgument(node, null, false, false);
    }

    private RubyNode translateRubiniusPrimitive(SourceSection sourceSection, CallNode node) {
        this.usesRubiniusPrimitive = true;
        if (node.getArgsNode().childNodes().size() != 1 || !(node.getArgsNode().childNodes().get(0) instanceof SymbolNode)) {
            throw new UnsupportedOperationException("Rubinius.primitive must have a single literal symbol argument");
        }
        String primitiveName = ((SymbolNode)node.getArgsNode().childNodes().get(0)).getName();
        RubiniusPrimitiveConstructor primitive = this.context.getRubiniusPrimitiveManager().getPrimitive(primitiveName);
        long returnID = this.environment.getReturnID();
        return primitive.createCallPrimitiveNode(this.context, sourceSection, returnID);
    }

    private RubyNode translateRubiniusInvokePrimitive(SourceSection sourceSection, CallNode node) {
        if (node.getArgsNode().childNodes().size() < 1 || !(node.getArgsNode().childNodes().get(0) instanceof SymbolNode)) {
            throw new UnsupportedOperationException("Rubinius.invoke_primitive must have at least an initial literal symbol argument");
        }
        String primitiveName = ((SymbolNode)node.getArgsNode().childNodes().get(0)).getName();
        RubiniusPrimitiveConstructor primitive = this.context.getRubiniusPrimitiveManager().getPrimitive(primitiveName);
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>();
        for (int n = 1; n < node.getArgsNode().childNodes().size(); ++n) {
            RubyNode readArgumentNode = (RubyNode)((Object)((Node)node.getArgsNode().childNodes().get(n)).accept((NodeVisitor)this));
            arguments.add(readArgumentNode);
        }
        return primitive.createInvokePrimitiveNode(this.context, sourceSection, arguments.toArray(new RubyNode[arguments.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateRubiniusPrivately(SourceSection sourceSection, CallNode node) {
        if (!(node.getIterNode() instanceof IterNode)) {
            throw new UnsupportedOperationException("Rubinius.privately needs a literal block");
        }
        if (node.getArgsNode() != null && node.getArgsNode().childNodes().size() > 0) {
            throw new UnsupportedOperationException("Rubinius.privately should not have any arguments");
        }
        this.currentCallMethodName = "privately";
        boolean previousPrivately = this.privately;
        this.privately = true;
        try {
            RubyNode rubyNode = (RubyNode)((Object)((IterNode)node.getIterNode()).getBodyNode().accept((NodeVisitor)this));
            return rubyNode;
        }
        finally {
            this.privately = previousPrivately;
        }
    }

    public RubyNode translateRubiniusSingleBlockArg(SourceSection sourceSection, CallNode node) {
        return new RubiniusSingleBlockArgNode(this.context, sourceSection);
    }

    private RubyNode translateRubiniusCheckFrozen(SourceSection sourceSection) {
        RubyCallNode frozen = new RubyCallNode(this.context, sourceSection, "frozen?", (RubyNode)new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection), null, false, new RubyNode[0]);
        RubyCallNode constructException = new RubyCallNode(this.context, sourceSection, "new", (RubyNode)new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getRuntimeErrorClass()), null, false, new StringLiteralNode(this.context, sourceSection, ByteList.create((CharSequence)"FrozenError: can't modify frozen TODO"), 0));
        RubyCallNode raise = new RubyCallNode(this.context, sourceSection, "raise", (RubyNode)new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection), null, false, true, constructException);
        return new IfNode(this.context, sourceSection, frozen, raise, new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil"));
    }

    public RubyNode visitCallNodeExtraArgument(CallNode node, RubyNode extraArgument, boolean ignoreVisibility, boolean isVCall) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode receiverTranslated = (RubyNode)((Object)node.getReceiverNode().accept((NodeVisitor)this));
        Node args = node.getArgsNode();
        Node block = node.getIterNode();
        if (block == null && args instanceof IterNode) {
            block = args;
            args = null;
        }
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, block, args, extraArgument, node.getName());
        RubyNode translated = new RubyCallNode(this.context, sourceSection, node.getName(), receiverTranslated, argumentsAndBlock.getBlock(), argumentsAndBlock.isSplatted(), this.privately || ignoreVisibility, isVCall, argumentsAndBlock.getArguments());
        if (argumentsAndBlock.getBlock() instanceof BlockDefinitionNode) {
            BlockDefinitionNode blockDef = (BlockDefinitionNode)argumentsAndBlock.getBlock();
            translated = new CatchBreakNode(this.context, sourceSection, translated, blockDef.getBreakID());
        }
        return translated;
    }

    protected ArgumentsAndBlockTranslation translateArgumentsAndBlock(SourceSection sourceSection, Node iterNode, Node argsNode, RubyNode extraArgument, String nameToSetWhenTranslatingBlock) {
        RubyNode blockTranslated;
        assert (!(argsNode instanceof IterNode));
        ArrayList<Node> arguments = new ArrayList<Node>();
        Node blockPassNode = null;
        boolean isSplatted = false;
        if (argsNode instanceof ListNode) {
            arguments.addAll(argsNode.childNodes());
        } else if (argsNode instanceof BlockPassNode) {
            BlockPassNode blockPass = (BlockPassNode)argsNode;
            Node blockPassArgs = blockPass.getArgsNode();
            if (blockPassArgs instanceof ListNode) {
                arguments.addAll(blockPassArgs.childNodes());
            } else if (blockPassArgs instanceof ArgsCatNode) {
                arguments.add(blockPassArgs);
            } else if (blockPassArgs != null) {
                throw new UnsupportedOperationException("Don't know how to block pass " + blockPassArgs);
            }
            blockPassNode = blockPass.getBodyNode();
        } else if (argsNode instanceof SplatNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode instanceof ArgsCatNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode != null) {
            isSplatted = true;
            arguments.add(argsNode);
        }
        ArrayList<Object> argumentsTranslated = new ArrayList<Object>();
        for (Node argument : arguments) {
            argumentsTranslated.add(argument.accept((NodeVisitor)this));
        }
        if (extraArgument != null) {
            argumentsTranslated.add((Object)extraArgument);
        }
        RubyNode[] argumentsTranslatedArray = argumentsTranslated.toArray(new RubyNode[argumentsTranslated.size()]);
        if (iterNode instanceof BlockPassNode) {
            blockPassNode = ((BlockPassNode)iterNode).getBodyNode();
        }
        this.currentCallMethodName = nameToSetWhenTranslatingBlock;
        if (blockPassNode != null) {
            blockTranslated = ProcCastNodeGen.create(this.context, sourceSection, (RubyNode)((Object)blockPassNode.accept((NodeVisitor)this)));
        } else if (iterNode != null) {
            blockTranslated = (RubyNode)((Object)iterNode.accept((NodeVisitor)this));
            if (blockTranslated instanceof org.jruby.truffle.nodes.literal.LiteralNode && ((org.jruby.truffle.nodes.literal.LiteralNode)blockTranslated).getObject() == this.context.getCoreLibrary().getNilObject()) {
                blockTranslated = null;
            }
        } else {
            blockTranslated = null;
        }
        return new ArgumentsAndBlockTranslation(blockTranslated, argumentsTranslatedArray, isSplatted);
    }

    public RubyNode visitCaseNode(CaseNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode elseNode = node.getElseNode() != null ? (RubyNode)((Object)node.getElseNode().accept((NodeVisitor)this)) : new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil");
        if (node.getCaseNode() != null) {
            String tempName = this.environment.allocateLocalTemp("case");
            RubyNode readTemp = this.environment.findLocalVarNode(tempName, sourceSection);
            RubyNode assignTemp = ((ReadNode)((Object)readTemp)).makeWriteNode((RubyNode)((Object)node.getCaseNode().accept((NodeVisitor)this)));
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                WhenNode when = (WhenNode)node.getCases().get(n);
                List<Node> expressions = when.getExpressionNodes() instanceof ListNode && !(when.getExpressionNodes() instanceof ArrayNode) ? when.getExpressionNodes().childNodes() : Arrays.asList(when.getExpressionNodes());
                ArrayList<RubyNode> comparisons = new ArrayList<RubyNode>();
                for (Node expressionNode : expressions) {
                    RubyNode rubyExpression = (RubyNode)((Object)expressionNode.accept((NodeVisitor)this));
                    if (expressionNode instanceof SplatNode) {
                        SplatCastNode splatCastNode = (SplatCastNode)rubyExpression;
                        comparisons.add(new WhenSplatNode(this.context, sourceSection, (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)readTemp), splatCastNode));
                        continue;
                    }
                    if (expressionNode instanceof ArgsCatNode) {
                        ArrayConcatNode arrayConcatNode = (ArrayConcatNode)rubyExpression;
                        comparisons.add(new WhenSplatNode(this.context, sourceSection, (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)readTemp), arrayConcatNode));
                        continue;
                    }
                    comparisons.add(new RubyCallNode(this.context, sourceSection, "===", rubyExpression, null, false, (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)readTemp)));
                }
                RubyNode conditionNode = (RubyNode)((Object)comparisons.get(comparisons.size() - 1));
                for (int i = comparisons.size() - 2; i >= 0; --i) {
                    conditionNode = new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, (RubyNode)((Object)comparisons.get(i)), conditionNode);
                }
                RubyNode thenNode = when.getBodyNode() == null || when.getBodyNode().isNil() ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)when.getBodyNode().accept((NodeVisitor)this));
                IfNode ifNode = new IfNode(this.context, sourceSection, conditionNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            RubyNode ifNode = elseNode;
            return SequenceNode.sequence(this.context, sourceSection, assignTemp, ifNode);
        }
        for (int n = node.getCases().size() - 1; n >= 0; --n) {
            WhenNode when = (WhenNode)node.getCases().get(n);
            List<Node> expressions = when.getExpressionNodes() instanceof ListNode ? when.getExpressionNodes().childNodes() : Arrays.asList(when.getExpressionNodes());
            ArrayList<RubyNode> tests = new ArrayList<RubyNode>();
            for (Node expressionNode : expressions) {
                RubyNode rubyExpression = (RubyNode)((Object)expressionNode.accept((NodeVisitor)this));
                tests.add(rubyExpression);
            }
            RubyNode conditionNode = (RubyNode)((Object)tests.get(tests.size() - 1));
            for (int i = tests.size() - 2; i >= 0; --i) {
                conditionNode = new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, (RubyNode)((Object)tests.get(i)), conditionNode);
            }
            RubyNode thenNode = (RubyNode)((Object)when.getBodyNode().accept((NodeVisitor)this));
            IfNode ifNode = new IfNode(this.context, sourceSection, conditionNode, thenNode, elseNode);
            elseNode = ifNode;
        }
        return elseNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode openModule(SourceSection sourceSection, RubyNode defineOrGetNode, String name, Node bodyNode) {
        LexicalScope newLexicalScope = this.environment.pushLexicalScope();
        try {
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, newLexicalScope, Arity.NO_ARGUMENTS, name, false, bodyNode, false);
            TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), this.environment.getParseEnvironment().allocateReturnID(), true, true, sharedMethodInfo, name, false, null);
            ModuleTranslator classTranslator = new ModuleTranslator(this.currentNode, this.context, this, newEnvironment, this.source);
            MethodDefinitionNode definitionMethod = classTranslator.compileClassNode(sourceSection, name, bodyNode);
            OpenModuleNode openModuleNode = new OpenModuleNode(this.context, sourceSection, defineOrGetNode, definitionMethod, newLexicalScope);
            return openModuleNode;
        }
        finally {
            this.environment.popLexicalScope();
        }
    }

    public RubyNode visitClassNode(ClassNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        RubyNode superClass = node.getSuperNode() != null ? (RubyNode)((Object)node.getSuperNode().accept((NodeVisitor)this)) : new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        DefineOrGetClassNode defineOrGetClass = new DefineOrGetClassNode(this.context, sourceSection, name, lexicalParent, superClass);
        return this.openModule(sourceSection, defineOrGetClass, name, node.getBodyNode());
    }

    public RubyNode visitClassVarAsgnNode(ClassVarAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode rhs = (RubyNode)((Object)node.getValueNode().accept((NodeVisitor)this));
        return new WriteClassVariableNode(this.context, sourceSection, node.getName(), this.environment.getLexicalScope(), rhs);
    }

    public RubyNode visitClassVarNode(ClassVarNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new ReadClassVariableNode(this.context, sourceSection, node.getName(), this.environment.getLexicalScope());
    }

    public RubyNode visitColon2Node(Colon2Node node) {
        if (!(node instanceof Colon2ConstNode)) {
            throw new UnsupportedOperationException(node.toString());
        }
        RubyNode lhs = (RubyNode)((Object)node.getLeftNode().accept((NodeVisitor)this));
        return new ReadConstantNode(this.context, this.translate(node.getPosition()), node.getName(), lhs, LexicalScope.NONE);
    }

    public RubyNode visitColon3Node(Colon3Node node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        org.jruby.truffle.nodes.literal.LiteralNode root = new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        return new ReadConstantNode(this.context, sourceSection, node.getName(), root, LexicalScope.NONE);
    }

    private RubyNode translateCPath(SourceSection sourceSection, Colon3Node node) {
        if (node instanceof Colon2ImplicitNode) {
            return new LexicalScopeNode(this.context, sourceSection, this.environment.getLexicalScope());
        }
        if (node instanceof Colon2ConstNode) {
            return (RubyNode)((Object)((Node)node.childNodes().get(0)).accept((NodeVisitor)this));
        }
        return new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
    }

    public RubyNode visitComplexNode(ComplexNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.translateRationalComplex(sourceSection, "Complex", new FixnumLiteralNode.IntegerFixnumLiteralNode(this.context, sourceSection, 0), (RubyNode)((Object)node.getNumber().accept((NodeVisitor)this)));
    }

    public RubyNode visitConstDeclNode(ConstDeclNode node) {
        return this.visitConstDeclNode(node, (RubyNode)((Object)node.getValueNode().accept((NodeVisitor)this)));
    }

    private RubyNode visitConstDeclNode(ConstDeclNode node, RubyNode rhs) {
        RubyNode moduleNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        Node constNode = node.getConstNode();
        if (constNode == null || constNode instanceof Colon2ImplicitNode) {
            moduleNode = new LexicalScopeNode(this.context, sourceSection, this.environment.getLexicalScope());
        } else if (constNode instanceof Colon2ConstNode) {
            constNode = ((Colon2Node)constNode).getLeftNode();
            moduleNode = (RubyNode)((Object)constNode.accept((NodeVisitor)this));
        } else if (constNode instanceof Colon3Node) {
            moduleNode = new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass());
        } else {
            throw new UnsupportedOperationException();
        }
        return new WriteConstantNode(this.context, sourceSection, node.getName(), moduleNode, rhs);
    }

    public RubyNode visitConstNode(ConstNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (node.getName().equals("Rubinius") && sourceSection.getSource().getPath().startsWith("core:/core/rubinius")) {
            return (RubyNode)((Object)new Colon3Node(node.getPosition(), node.getName()).accept((NodeVisitor)this));
        }
        LexicalScope lexicalScope = this.environment.getLexicalScope();
        LexicalScopeNode moduleNode = new LexicalScopeNode(this.context, sourceSection, lexicalScope);
        return new ReadConstantNode(this.context, sourceSection, node.getName(), moduleNode, lexicalScope);
    }

    public RubyNode visitDAsgnNode(DAsgnNode node) {
        return (RubyNode)((Object)new LocalAsgnNode(node.getPosition(), node.getName(), node.getDepth(), node.getValueNode()).accept((NodeVisitor)this));
    }

    public RubyNode visitDRegxNode(DRegexpNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<Object> children = new ArrayList<Object>();
        for (Node child : node.children()) {
            children.add(child.accept((NodeVisitor)this));
        }
        InterpolatedRegexpNode i = new InterpolatedRegexpNode(this.context, sourceSection, children.toArray(new RubyNode[children.size()]), node.getOptions());
        if (node.getOptions().isOnce()) {
            return new OnceNode(this.context, i.getEncapsulatingSourceSection(), i);
        }
        return i;
    }

    public RubyNode visitDStrNode(DStrNode node) {
        return this.translateInterpolatedString(this.translate(node.getPosition()), node.children());
    }

    public RubyNode visitDSymbolNode(DSymbolNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode stringNode = this.translateInterpolatedString(sourceSection, node.children());
        return StringToSymbolNodeGen.create(this.context, sourceSection, stringNode);
    }

    private RubyNode translateInterpolatedString(SourceSection sourceSection, Node[] childNodes) {
        ToSNode[] children = new ToSNode[childNodes.length];
        for (int i = 0; i < childNodes.length; ++i) {
            children[i] = ToSNodeGen.create(this.context, sourceSection, (RubyNode)((Object)childNodes[i].accept((NodeVisitor)this)));
        }
        return new InterpolatedStringNode(this.context, sourceSection, children);
    }

    public RubyNode visitDVarNode(DVarNode node) {
        RubyNode readNode = this.environment.findLocalVarNode(node.getName(), this.translate(node.getPosition()));
        if (readNode == null) {
            int depth = node.getDepth();
            TranslatorEnvironment e = this.environment;
            for (int n = 0; n < depth; ++n) {
                e = e.getParent();
            }
            e.declareVar(node.getName());
            readNode = this.environment.findLocalVarNode(node.getName(), this.translate(node.getPosition()));
        }
        return readNode;
    }

    public RubyNode visitDXStrNode(DXStrNode node) {
        DStrNode string = new DStrNode(node.getPosition(), node.getEncoding());
        string.addAll((ListNode)node);
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), (Node)string, new Node[0]);
        FCallNode callNode = new FCallNode(node.getPosition(), "`", (Node)argsNode, null);
        return (RubyNode)((Object)callNode.accept((NodeVisitor)this));
    }

    public RubyNode visitDefinedNode(org.jruby.ast.DefinedNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        Node expressionNode = node.getExpressionNode();
        while (expressionNode instanceof NewlineNode) {
            expressionNode = ((NewlineNode)expressionNode).getNextNode();
        }
        return new DefinedNode(this.context, sourceSection, (RubyNode)((Object)node.getExpressionNode().accept((NodeVisitor)this)));
    }

    public RubyNode visitDefnNode(DefnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition(), node.getName());
        RubyNode classNode = this.parent == null ? new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getObjectClass()) : new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection);
        return this.translateMethodDefinition(sourceSection, classNode, node.getName(), (Node)node, node.getArgsNode(), node.getBodyNode());
    }

    public RubyNode visitDefsNode(DefsNode node) {
        SourceSection sourceSection = this.translate(node.getPosition(), node.getName());
        RubyNode objectNode = (RubyNode)((Object)node.getReceiverNode().accept((NodeVisitor)this));
        SingletonClassNode singletonClassNode = SingletonClassNodeGen.create(this.context, sourceSection, objectNode);
        return new SetMethodDeclarationContext(this.context, sourceSection, Visibility.PUBLIC, "defs", this.translateMethodDefinition(sourceSection, singletonClassNode, node.getName(), (Node)node, node.getArgsNode(), node.getBodyNode()));
    }

    protected RubyNode translateMethodDefinition(SourceSection sourceSection, RubyNode classNode, String methodName, Node parseTree, ArgsNode argsNode, Node bodyNode) {
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.environment.getLexicalScope(), MethodTranslator.getArity(argsNode), methodName, false, parseTree, false);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), this.environment.getParseEnvironment().allocateReturnID(), true, true, sharedMethodInfo, methodName, false, null);
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, false, this.source, argsNode);
        MethodDefinitionNode functionExprNode = (MethodDefinitionNode)methodCompiler.compileFunctionNode(sourceSection, methodName, bodyNode, sharedMethodInfo);
        return new AddMethodNode(this.context, sourceSection, classNode, functionExprNode);
    }

    public RubyNode visitDotNode(DotNode node) {
        RubyNode begin = (RubyNode)((Object)node.getBeginNode().accept((NodeVisitor)this));
        RubyNode end = (RubyNode)((Object)node.getEndNode().accept((NodeVisitor)this));
        SourceSection sourceSection = this.translate(node.getPosition());
        return RangeLiteralNodeGen.create(this.context, sourceSection, node.isExclusive(), begin, end);
    }

    public RubyNode visitEncodingNode(EncodingNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, EncodingNodes.getEncoding(node.getEncoding()));
    }

    public RubyNode visitEnsureNode(org.jruby.ast.EnsureNode node) {
        RubyNode tryPart = (RubyNode)((Object)node.getBodyNode().accept((NodeVisitor)this));
        RubyNode ensurePart = (RubyNode)((Object)node.getEnsureNode().accept((NodeVisitor)this));
        return new EnsureNode(this.context, this.translate(node.getPosition()), tryPart, ensurePart);
    }

    public RubyNode visitEvStrNode(EvStrNode node) {
        if (node.getBody() == null) {
            SourceSection sourceSection = this.translate(node.getPosition());
            return new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, StringNodes.createEmptyString(this.context.getCoreLibrary().getStringClass()));
        }
        return (RubyNode)((Object)node.getBody().accept((NodeVisitor)this));
    }

    public RubyNode visitFCallNode(FCallNode node) {
        SelfNode receiver = new SelfNode(node.getPosition());
        CallNode callNode = new CallNode(node.getPosition(), (Node)receiver, node.getName(), node.getArgsNode(), node.getIterNode());
        return this.visitCallNodeExtraArgument(callNode, null, true, false);
    }

    public RubyNode visitFalseNode(FalseNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, false), "false");
    }

    public RubyNode visitFixnumNode(FixnumNode node) {
        long value = node.getValue();
        if (CoreLibrary.fitsIntoInteger(value)) {
            return new FixnumLiteralNode.IntegerFixnumLiteralNode(this.context, this.translate(node.getPosition()), (int)value);
        }
        return new FixnumLiteralNode.LongFixnumLiteralNode(this.context, this.translate(node.getPosition()), value);
    }

    public RubyNode visitFlipNode(FlipNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode begin = (RubyNode)((Object)node.getBeginNode().accept((NodeVisitor)this));
        RubyNode end = (RubyNode)((Object)node.getEndNode().accept((NodeVisitor)this));
        FlipFlopStateNode stateNode = this.createFlipFlopState(sourceSection, 0);
        return new FlipFlopNode(this.context, sourceSection, begin, end, stateNode, node.isExclusive());
    }

    protected FlipFlopStateNode createFlipFlopState(SourceSection sourceSection, int depth) {
        FrameSlot frameSlot = this.environment.declareVar(this.environment.allocateLocalTemp("flipflop"));
        this.environment.getFlipFlopStates().add(frameSlot);
        if (depth == 0) {
            return new LocalFlipFlopStateNode(sourceSection, frameSlot);
        }
        return new DeclarationFlipFlopStateNode(sourceSection, depth, frameSlot);
    }

    public RubyNode visitFloatNode(FloatNode node) {
        return new org.jruby.truffle.nodes.literal.LiteralNode(this.context, this.translate(node.getPosition()), node.getValue());
    }

    public RubyNode visitForNode(ForNode node) {
        String temp = this.environment.allocateLocalTemp("for");
        Node receiver = node.getIterNode();
        LocalVarNode readTemp = new LocalVarNode(node.getPosition(), 0, temp);
        Node forVar = node.getVarNode();
        Node assignTemp = BodyTranslator.setRHS(forVar, (Node)readTemp);
        BlockNode bodyWithTempAssign = new BlockNode(node.getPosition());
        bodyWithTempAssign.add(assignTemp);
        bodyWithTempAssign.add(node.getBodyNode());
        ArgumentNode blockVar = new ArgumentNode(node.getPosition(), temp);
        ListNode blockArgsPre = new ListNode(node.getPosition(), (Node)blockVar);
        ArgsNode blockArgs = new ArgsNode(node.getPosition(), blockArgsPre, null, null, null, null, null, null);
        IterNode block = new IterNode(node.getPosition(), (Node)blockArgs, node.getScope(), (Node)bodyWithTempAssign);
        CallNode callNode = new CallNode(node.getPosition(), receiver, "each", null, (Node)block);
        this.translatingForStatement = true;
        RubyNode translated = (RubyNode)((Object)callNode.accept((NodeVisitor)this));
        this.translatingForStatement = false;
        return translated;
    }

    private static Node setRHS(Node node, Node rhs) {
        if (node instanceof LocalAsgnNode) {
            LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
            return new LocalAsgnNode(node.getPosition(), localAsgnNode.getName(), 0, rhs);
        }
        if (node instanceof DAsgnNode) {
            DAsgnNode dAsgnNode = (DAsgnNode)node;
            return new DAsgnNode(node.getPosition(), dAsgnNode.getName(), 0, rhs);
        }
        if (node instanceof MultipleAsgnNode) {
            MultipleAsgnNode multAsgnNode = (MultipleAsgnNode)node;
            MultipleAsgnNode newNode = new MultipleAsgnNode(node.getPosition(), multAsgnNode.getPre(), multAsgnNode.getRest(), multAsgnNode.getPost());
            newNode.setValueNode(rhs);
            return newNode;
        }
        if (node instanceof InstAsgnNode) {
            InstAsgnNode instAsgnNode = (InstAsgnNode)node;
            return new InstAsgnNode(node.getPosition(), instAsgnNode.getName(), rhs);
        }
        if (node instanceof ClassVarAsgnNode) {
            ClassVarAsgnNode instAsgnNode = (ClassVarAsgnNode)node;
            return new ClassVarAsgnNode(node.getPosition(), instAsgnNode.getName(), rhs);
        }
        if (node instanceof ConstDeclNode) {
            ConstDeclNode constDeclNode = (ConstDeclNode)node;
            return new ConstDeclNode(node.getPosition(), constDeclNode.getName(), (INameNode)constDeclNode.getConstNode(), rhs);
        }
        throw new UnsupportedOperationException("Don't know how to set the RHS of a " + node.getClass().getName());
    }

    private void initReadOnlyGlobalVariables() {
        Set<String> s = this.readOnlyGlobalVariables;
        s.add("$:");
        s.add("$LOAD_PATH");
        s.add("$-I");
        s.add("$\"");
        s.add("$LOADED_FEATURES");
        s.add("$<");
        s.add("$FILENAME");
        s.add("$?");
        s.add("$-a");
        s.add("$-l");
        s.add("$-p");
        s.add("$!");
    }

    private void initGlobalVariableAliases() {
        Map<String, String> m = this.globalVariableAliases;
        m.put("$-I", "$LOAD_PATH");
        m.put("$:", "$LOAD_PATH");
        m.put("$-d", "$DEBUG");
        m.put("$-v", "$VERBOSE");
        m.put("$-w", "$VERBOSE");
        m.put("$-0", "$/");
    }

    public RubyNode visitGlobalAsgnNode(GlobalAsgnNode node) {
        return this.translateGlobalAsgnNode(node, (RubyNode)((Object)node.getValueNode().accept((NodeVisitor)this)));
    }

    public RubyNode translateGlobalAsgnNode(GlobalAsgnNode node, RubyNode rhs) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getName();
        if (this.globalVariableAliases.containsKey(name)) {
            name = this.globalVariableAliases.get(name);
        }
        if (name.equals("$~")) {
            rhs = new CheckMatchVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$0")) {
            rhs = new CheckProgramNameVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$/")) {
            rhs = new CheckRecordSeparatorVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$,")) {
            rhs = new CheckOutputSeparatorVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$_")) {
            rhs = WrapInThreadLocalNodeGen.create(this.context, sourceSection, rhs);
        } else if (name.equals("$stdout")) {
            rhs = new CheckStdoutVariableTypeNode(this.context, sourceSection, rhs);
        } else if (name.equals("$VERBOSE")) {
            rhs = new UpdateVerbosityNode(this.context, sourceSection, rhs);
        } else if (name.equals("$@")) {
            return new UpdateLastBacktraceNode(this.context, sourceSection, rhs);
        }
        if (this.readOnlyGlobalVariables.contains(name)) {
            return new WriteReadOnlyGlobalNode(this.context, sourceSection, name, rhs);
        }
        if (THREAD_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            ThreadLocalObjectNode threadLocalVariablesObjectNode = new ThreadLocalObjectNode(this.context, sourceSection);
            return new WriteInstanceVariableNode(this.context, sourceSection, name, threadLocalVariablesObjectNode, rhs, true);
        }
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            RubyNode localVarNode;
            if (this.environment.getNeverAssignInParentScope()) {
                this.environment.declareVar(name);
            }
            if ((localVarNode = this.environment.findLocalVarNode(node.getName(), sourceSection)) == null) {
                if (this.environment.hasOwnScopeForAssignments()) {
                    this.environment.declareVar(node.getName());
                }
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
                localVarNode = this.environment.findLocalVarNode(node.getName(), sourceSection);
                if (localVarNode == null) {
                    throw new RuntimeException("shouldn't be here");
                }
            }
            RubyNode assignment = ((ReadNode)((Object)localVarNode)).makeWriteNode(rhs);
            if (name.equals("$_")) {
                assignment = GetFromThreadLocalNodeGen.create(this.context, sourceSection, assignment);
            }
            return assignment;
        }
        org.jruby.truffle.nodes.literal.LiteralNode globalVariablesObjectNode = new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getGlobalVariablesObject());
        return new WriteInstanceVariableNode(this.context, sourceSection, name, globalVariablesObjectNode, rhs, true);
    }

    public RubyNode visitGlobalVarNode(GlobalVarNode node) {
        String name = node.getName();
        if (this.globalVariableAliases.containsKey(name)) {
            name = this.globalVariableAliases.get(name);
        }
        SourceSection sourceSection = this.translate(node.getPosition());
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            this.environment.declareVarWhereAllowed(name);
            RubyNode readNode = this.environment.findLocalVarNode(name, sourceSection);
            if (name.equals("$_")) {
                readNode = sourceSection.getSource().getPath().equals("core:/core/rubinius/common/regexp.rb") ? new RubiniusLastStringReadNode(this.context, sourceSection) : GetFromThreadLocalNodeGen.create(this.context, sourceSection, readNode);
            }
            return readNode;
        }
        if (THREAD_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            ThreadLocalObjectNode threadLocalVariablesObjectNode = new ThreadLocalObjectNode(this.context, sourceSection);
            return new ReadInstanceVariableNode(this.context, sourceSection, name, threadLocalVariablesObjectNode, true);
        }
        if (name.equals("$@")) {
            return new ReadLastBacktraceNode(this.context, sourceSection);
        }
        org.jruby.truffle.nodes.literal.LiteralNode globalVariablesObjectNode = new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getGlobalVariablesObject());
        return new ReadInstanceVariableNode(this.context, sourceSection, name, globalVariablesObjectNode, true);
    }

    public RubyNode visitHashNode(HashNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> hashConcats = new ArrayList<RubyNode>();
        ArrayList<Object> keyValues = new ArrayList<Object>();
        for (KeyValuePair pair : node.getPairs()) {
            if (pair.getKey() == null) {
                HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, this.translate(node.getPosition()), keyValues.toArray(new RubyNode[keyValues.size()]));
                hashConcats.add(hashLiteralSoFar);
                hashConcats.add(HashCastNodeGen.create(this.context, sourceSection, (RubyNode)((Object)((Node)pair.getValue()).accept((NodeVisitor)this))));
                keyValues.clear();
                continue;
            }
            keyValues.add(((Node)pair.getKey()).accept((NodeVisitor)this));
            if (pair.getValue() == null) {
                keyValues.add((Object)new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil"));
                continue;
            }
            keyValues.add(((Node)pair.getValue()).accept((NodeVisitor)this));
        }
        HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, this.translate(node.getPosition()), keyValues.toArray(new RubyNode[keyValues.size()]));
        hashConcats.add(hashLiteralSoFar);
        if (hashConcats.size() == 1) {
            return (RubyNode)((Object)hashConcats.get(0));
        }
        return new ConcatHashLiteralNode(this.context, sourceSection, hashConcats.toArray(new RubyNode[hashConcats.size()]));
    }

    public RubyNode visitIfNode(org.jruby.ast.IfNode node) {
        Node elseBody;
        SourceSection sourceSection = this.translate(node.getPosition());
        Node thenBody = node.getThenBody();
        if (thenBody == null || thenBody.isNil()) {
            thenBody = new NilNode(node.getPosition());
        }
        if ((elseBody = node.getElseBody()) == null || elseBody.isNil()) {
            elseBody = new NilNode(node.getPosition());
        }
        RubyNode condition = node.getCondition() == null ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)node.getCondition().accept((NodeVisitor)this));
        RubyNode thenBodyTranslated = (RubyNode)((Object)thenBody.accept((NodeVisitor)this));
        RubyNode elseBodyTranslated = (RubyNode)((Object)elseBody.accept((NodeVisitor)this));
        return new IfNode(this.context, sourceSection, condition, thenBodyTranslated, elseBodyTranslated);
    }

    public RubyNode visitInstAsgnNode(InstAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getName();
        RubyNode rhs = node.getValueNode() == null ? new DeadNode(this.context, sourceSection, new Exception("null RHS of instance variable assignment")) : (RubyNode)((Object)node.getValueNode().accept((NodeVisitor)this));
        RaiseIfFrozenNode self = new RaiseIfFrozenNode(new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection));
        if (sourceSection.getSource().getPath().equals("core:/core/rubinius/common/time.rb")) {
            if (name.equals("@is_gmt")) {
                return TimeNodesFactory.InternalSetGMTNodeFactory.create(this.context, sourceSection, self, rhs);
            }
            if (name.equals("@offset")) {
                return TimeNodesFactory.InternalSetOffsetNodeFactory.create(this.context, sourceSection, self, rhs);
            }
        }
        if (sourceSection.getSource().getPath().equals("core:/core/rubinius/common/hash.rb")) {
            if (name.equals("@default")) {
                return HashNodesFactory.SetDefaultValueNodeFactory.create(this.context, sourceSection, self, rhs);
            }
            if (name.equals("@default_proc")) {
                return HashNodesFactory.SetDefaultProcNodeFactory.create(this.context, sourceSection, self, rhs);
            }
        }
        if ((sourceSection.getSource().getPath().equals("core:/core/rubinius/bootstrap/string.rb") || sourceSection.getSource().getPath().equals("core:/core/rubinius/common/string.rb")) && name.equals("@hash")) {
            return StringNodesFactory.ModifyBangNodeFactory.create(this.context, sourceSection, new RubyNode[0]);
        }
        if (sourceSection.getSource().getPath().equals("core:/core/rubinius/common/range.rb")) {
            if (name.equals("@begin")) {
                return RangeNodesFactory.InternalSetBeginNodeGen.create(this.context, sourceSection, self, rhs);
            }
            if (name.equals("@end")) {
                return RangeNodesFactory.InternalSetEndNodeGen.create(this.context, sourceSection, self, rhs);
            }
            if (name.equals("@excl")) {
                return RangeNodesFactory.InternalSetExcludeEndNodeGen.create(this.context, sourceSection, self, rhs);
            }
        }
        return new WriteInstanceVariableNode(this.context, sourceSection, name, self, rhs, false);
    }

    public RubyNode visitInstVarNode(InstVarNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getName();
        org.jruby.truffle.nodes.objects.SelfNode self = new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection);
        if (sourceSection.getSource().getPath().equals("core:/core/rubinius/common/array.rb") || sourceSection.getSource().getPath().equals("core:/core/rubinius/api/shims/array.rb")) {
            if (name.equals("@total")) {
                return new RubyCallNode(this.context, sourceSection, "size", (RubyNode)self, null, false, new RubyNode[0]);
            }
            if (name.equals("@tuple")) {
                return self;
            }
            if (name.equals("@start")) {
                return new FixnumLiteralNode.IntegerFixnumLiteralNode(this.context, sourceSection, 0);
            }
        }
        if (sourceSection.getSource().getPath().equals("core:/core/rubinius/common/regexp.rb")) {
            if (name.equals("@source")) {
                return MatchDataNodesFactory.RubiniusSourceNodeGen.create(this.context, sourceSection, self);
            }
            if (name.equals("@full")) {
                return new RubyCallNode(this.context, sourceSection, "full", (RubyNode)self, null, false, new RubyNode[0]);
            }
            if (name.equals("@regexp")) {
                return MatchDataNodesFactory.RegexpNodeFactory.create(this.context, sourceSection, new RubyNode[]{self});
            }
            if (name.equals("@names")) {
                return RegexpNodesFactory.RubiniusNamesNodeGen.create(this.context, sourceSection, self);
            }
        }
        if (sourceSection.getSource().getPath().equals("core:/core/rubinius/bootstrap/string.rb") || sourceSection.getSource().getPath().equals("core:/core/rubinius/common/string.rb")) {
            if (name.equals("@num_bytes")) {
                return StringNodesFactory.ByteSizeNodeFactory.create(this.context, sourceSection, new RubyNode[]{self});
            }
            if (name.equals("@data")) {
                StringNodes.BytesNode bytes = StringNodesFactory.BytesNodeFactory.create(this.context, sourceSection, new RubyNode[]{self});
                org.jruby.truffle.nodes.literal.LiteralNode stringDataClass = new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getStringDataClass());
                return new RubyCallNode(this.context, sourceSection, "new", (RubyNode)stringDataClass, null, false, bytes);
            }
        }
        if (sourceSection.getSource().getPath().equals("core:/core/rubinius/common/time.rb")) {
            if (name.equals("@is_gmt")) {
                return TimeNodesFactory.InternalGMTNodeFactory.create(this.context, sourceSection, self);
            }
            if (name.equals("@offset")) {
                return TimeNodesFactory.InternalOffsetNodeFactory.create(this.context, sourceSection, self);
            }
        }
        if (sourceSection.getSource().getPath().equals("core:/core/rubinius/common/hash.rb")) {
            if (name.equals("@default")) {
                return HashNodesFactory.DefaultValueNodeFactory.create(this.context, sourceSection, self);
            }
            if (name.equals("@default_proc")) {
                return HashNodesFactory.DefaultProcNodeFactory.create(this.context, sourceSection, new RubyNode[]{self});
            }
            if (name.equals("@size")) {
                return HashNodesFactory.SizeNodeFactory.create(this.context, sourceSection, new RubyNode[]{self});
            }
        }
        if (sourceSection.getSource().getPath().equals("core:/core/rubinius/common/range.rb") || sourceSection.getSource().getPath().equals("core:/core/rubinius/api/shims/range.rb")) {
            if (name.equals("@begin")) {
                return RangeNodesFactory.BeginNodeFactory.create(this.context, sourceSection, new RubyNode[]{self});
            }
            if (name.equals("@end")) {
                return RangeNodesFactory.EndNodeFactory.create(this.context, sourceSection, new RubyNode[]{self});
            }
            if (name.equals("@excl")) {
                return RangeNodesFactory.ExcludeEndNodeFactory.create(this.context, sourceSection, new RubyNode[]{self});
            }
        }
        return new ReadInstanceVariableNode(this.context, sourceSection, name, self, false);
    }

    public RubyNode visitIterNode(IterNode node) {
        ArgsNode argsNode;
        boolean hasOwnScope;
        SourceSection sourceSection = this.translate(node.getPosition());
        boolean bl = hasOwnScope = !this.translatingForStatement;
        if (node.getVarNode() instanceof ArgsNode) {
            argsNode = (ArgsNode)node.getVarNode();
        } else if (node.getVarNode() instanceof DAsgnNode) {
            ArgumentNode arg = new ArgumentNode(node.getPosition(), ((DAsgnNode)node.getVarNode()).getName());
            ArrayNode preArgs = new ArrayNode(node.getPosition(), (Node)arg);
            argsNode = new ArgsNode(node.getPosition(), (ListNode)preArgs, null, null, null, null, null, null);
        } else if (node.getVarNode() == null) {
            argsNode = null;
        } else {
            throw new UnsupportedOperationException();
        }
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.environment.getLexicalScope(), MethodTranslator.getArity(argsNode), this.currentCallMethodName, true, (Node)node, false);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), this.environment.getReturnID(), hasOwnScope, false, sharedMethodInfo, this.environment.getNamedMethodName(), true, this.environment.getParseEnvironment().allocateBreakID());
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, true, this.source, argsNode);
        methodCompiler.translatingForStatement = this.translatingForStatement;
        if (this.translatingForStatement && this.useClassVariablesAsIfInClass) {
            methodCompiler.useClassVariablesAsIfInClass = true;
        }
        return methodCompiler.compileFunctionNode(this.translate(node.getPosition()), sharedMethodInfo.getName(), node.getBodyNode(), sharedMethodInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode visitLocalAsgnNode(LocalAsgnNode node) {
        RubyNode rhs;
        RubyNode lhs;
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.getNeverAssignInParentScope()) {
            this.environment.declareVar(node.getName());
        }
        if ((lhs = this.environment.findLocalVarNode(node.getName(), sourceSection)) == null) {
            if (this.environment.hasOwnScopeForAssignments()) {
                this.environment.declareVar(node.getName());
            } else {
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
            }
            lhs = this.environment.findLocalVarNode(node.getName(), sourceSection);
            if (lhs == null) {
                throw new RuntimeException("shouldn't be here");
            }
        }
        if (node.getValueNode() == null) {
            rhs = new DeadNode(this.context, sourceSection, new Exception());
        } else {
            if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection.push(sourceSection);
            }
            try {
                rhs = (RubyNode)((Object)node.getValueNode().accept((NodeVisitor)this));
            }
            finally {
                if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                    this.parentSourceSection.pop();
                }
            }
        }
        return ((ReadNode)((Object)lhs)).makeWriteNode(rhs);
    }

    public RubyNode visitLocalVarNode(LocalVarNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getName();
        RubyNode readNode = this.environment.findLocalVarNode(name, sourceSection);
        if (readNode == null) {
            this.environment.declareVar(node.getName());
            readNode = this.environment.findLocalVarNode(name, sourceSection);
        }
        return readNode;
    }

    public RubyNode visitMatchNode(MatchNode node) {
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), (Node)new GlobalVarNode(node.getPosition(), "$_"), new Node[0]);
        CallNode callNode = new CallNode(node.getPosition(), node.getRegexpNode(), "=~", (Node)argsNode, null);
        return (RubyNode)((Object)callNode.accept((NodeVisitor)this));
    }

    public RubyNode visitMatch2Node(Match2Node node) {
        RegexpNode regexpNode;
        Regex regex;
        if (node.getReceiverNode() instanceof RegexpNode && (regex = new Regex((regexpNode = (RegexpNode)node.getReceiverNode()).getValue().bytes(), 0, regexpNode.getValue().length(), regexpNode.getOptions().toOptions(), regexpNode.getEncoding(), Syntax.RUBY)).numberOfNames() > 0) {
            Iterator i = regex.namedBackrefIterator();
            while (i.hasNext()) {
                NameEntry e = (NameEntry)i.next();
                String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                if (this.environment.hasOwnScopeForAssignments()) {
                    this.environment.declareVar(name);
                    continue;
                }
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(name);
            }
        }
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]);
        CallNode callNode = new CallNode(node.getPosition(), node.getReceiverNode(), "=~", (Node)argsNode, null);
        return (RubyNode)((Object)callNode.accept((NodeVisitor)this));
    }

    public RubyNode visitMatch3Node(Match3Node node) {
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]);
        CallNode callNode = new CallNode(node.getPosition(), node.getReceiverNode(), "=~", (Node)argsNode, null);
        return (RubyNode)((Object)callNode.accept((NodeVisitor)this));
    }

    public RubyNode visitModuleNode(ModuleNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        DefineOrGetModuleNode defineModuleNode = new DefineOrGetModuleNode(this.context, sourceSection, name, lexicalParent);
        return this.openModule(sourceSection, defineModuleNode, name, node.getBodyNode());
    }

    public RubyNode visitMultipleAsgnNode(MultipleAsgnNode node) {
        RubyNode result;
        RubyNode rhsTranslated;
        SourceSection sourceSection = this.translate(node.getPosition());
        ListNode preArray = node.getPre();
        ListNode postArray = node.getPost();
        Node rhs = node.getValueNode();
        if (rhs == null) {
            this.context.getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, this.source.getName(), node.getPosition().getLine(), "no RHS for multiple assignment - using nil");
            rhsTranslated = new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil");
        } else {
            rhsTranslated = (RubyNode)((Object)rhs.accept((NodeVisitor)this));
        }
        if (preArray != null && node.getPost() == null && node.getRest() == null && rhsTranslated instanceof ArrayLiteralNode.UninitialisedArrayLiteralNode && ((ArrayLiteralNode.UninitialisedArrayLiteralNode)rhsTranslated).getValues().length == preArray.size()) {
            RubyNode[] rhsValues = ((ArrayLiteralNode.UninitialisedArrayLiteralNode)rhsTranslated).getValues();
            int assignedValuesCount = preArray.size();
            RubyNode[] sequence = new RubyNode[assignedValuesCount * 2];
            RubyNode[] tempValues = new RubyNode[assignedValuesCount];
            for (int n = 0; n < assignedValuesCount; ++n) {
                String tempName = this.environment.allocateLocalTemp("multi");
                RubyNode readTemp = this.environment.findLocalVarNode(tempName, sourceSection);
                RubyNode assignTemp = ((ReadNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)readTemp)).makeWriteNode(rhsValues[n]);
                RubyNode assignFinalValue = this.translateDummyAssignment(preArray.get(n), (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)readTemp));
                sequence[n] = assignTemp;
                sequence[assignedValuesCount + n] = assignFinalValue;
                tempValues[n] = (RubyNode)NodeUtil.cloneNode((com.oracle.truffle.api.nodes.Node)readTemp);
            }
            RubyNode blockNode = SequenceNode.sequence(this.context, sourceSection, sequence);
            ArrayLiteralNode.UninitialisedArrayLiteralNode arrayNode = new ArrayLiteralNode.UninitialisedArrayLiteralNode(this.context, sourceSection, tempValues);
            ElidableResultNode elidableResult = new ElidableResultNode(this.context, sourceSection, blockNode, arrayNode);
            result = elidableResult;
        } else if (preArray != null) {
            ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = ((ReadNode)((Object)this.environment.findLocalVarNode(tempRHSName, sourceSection))).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            String tempName = this.environment.allocateLocalTemp("array");
            SplatCastNode splatCastNode = SplatCastNodeGen.create(this.context, sourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, false, this.environment.findLocalVarNode(tempRHSName, sourceSection));
            RubyNode writeTemp = ((ReadNode)((Object)this.environment.findLocalVarNode(tempName, sourceSection))).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            for (int n = 0; n < preArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.environment.findLocalVarNode(tempName, sourceSection), n);
                sequence.add(this.translateDummyAssignment(preArray.get(n), assignedValue));
            }
            if (node.getRest() != null) {
                ArrayGetTailNode assignedValue = ArrayGetTailNodeGen.create(this.context, sourceSection, preArray.size(), this.environment.findLocalVarNode(tempName, sourceSection));
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            result = new ElidableResultNode(this.context, sourceSection, SequenceNode.sequence(this.context, sourceSection, sequence), this.environment.findLocalVarNode(tempRHSName, sourceSection));
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() instanceof StarNode) {
            result = rhsTranslated;
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && !(rhs instanceof ArrayNode)) {
            ReadNode restRead;
            RubyNode restTranslated = ((RubyNode)((Object)node.getRest().accept((NodeVisitor)this))).getNonProxyNode();
            if (restTranslated instanceof ReadNode) {
                restRead = (ReadNode)((Object)restTranslated);
            } else if (restTranslated instanceof WriteNode) {
                restRead = (ReadNode)((Object)((WriteNode)((Object)restTranslated)).makeReadNode());
            } else {
                throw new RuntimeException("Unknown form of multiple assignment " + node + " at " + node.getPosition());
            }
            SplatCastNode rhsSplatCast = SplatCastNodeGen.create(this.context, sourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, false, rhsTranslated);
            result = restRead.makeWriteNode(rhsSplatCast);
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && rhs instanceof ArrayNode) {
            ReadNode restRead;
            RubyNode restTranslated = ((RubyNode)((Object)node.getRest().accept((NodeVisitor)this))).getNonProxyNode();
            if (restTranslated instanceof ReadNode) {
                restRead = (ReadNode)((Object)restTranslated);
            } else if (restTranslated instanceof WriteNode) {
                restRead = (ReadNode)((Object)((WriteNode)((Object)restTranslated)).makeReadNode());
            } else {
                throw new RuntimeException("Unknown form of multiple assignment " + node + " at " + node.getPosition());
            }
            result = restRead.makeWriteNode(rhsTranslated);
        } else if (node.getPre() == null && node.getRest() != null && node.getPost() != null) {
            String tempName = this.environment.allocateLocalTemp("array");
            ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
            SplatCastNode splatCastNode = SplatCastNodeGen.create(this.context, sourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, false, rhsTranslated);
            RubyNode writeTemp = ((ReadNode)((Object)this.environment.findLocalVarNode(tempName, sourceSection))).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            if (node.getRest() != null) {
                ArrayDropTailNode assignedValue = ArrayDropTailNodeGen.create(this.context, sourceSection, postArray.size(), this.environment.findLocalVarNode(tempName, sourceSection));
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            for (int n = 0; n < postArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.environment.findLocalVarNode(tempName, sourceSection), -(postArray.size() - n));
                sequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
            }
            result = SequenceNode.sequence(this.context, sourceSection, sequence);
        } else {
            this.context.getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, this.source.getName(), node.getPosition().getLine(), node + " unknown form of multiple assignment");
            result = new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil");
        }
        return new DefinedWrapperNode(this.context, sourceSection, result, "assignment");
    }

    private RubyNode translateDummyAssignment(Node dummyAssignment, RubyNode rhs) {
        RubyNode translated;
        SourceSection sourceSection = this.translate(dummyAssignment.getPosition());
        if (dummyAssignment instanceof LocalAsgnNode) {
            WriteNode dummyTranslated = (WriteNode)((Object)((RubyNode)((Object)dummyAssignment.accept((NodeVisitor)this))).getNonProxyNode());
            translated = ((ReadNode)((Object)dummyTranslated.makeReadNode())).makeWriteNode(rhs);
        } else if (dummyAssignment instanceof InstAsgnNode) {
            WriteInstanceVariableNode dummyTranslated = (WriteInstanceVariableNode)dummyAssignment.accept((NodeVisitor)this);
            translated = ((ReadNode)((Object)dummyTranslated.makeReadNode())).makeWriteNode(rhs);
        } else if (dummyAssignment instanceof AttrAssignNode) {
            AttrAssignNode dummyAttrAssignment = (AttrAssignNode)dummyAssignment;
            translated = this.visitAttrAssignNodeExtraArgument(dummyAttrAssignment, rhs);
        } else if (dummyAssignment instanceof DAsgnNode) {
            RubyNode dummyTranslated = (RubyNode)((Object)dummyAssignment.accept((NodeVisitor)this));
            translated = dummyTranslated.getNonProxyNode() instanceof WriteDeclarationVariableNode ? ((ReadNode)((Object)((WriteDeclarationVariableNode)dummyTranslated.getNonProxyNode()).makeReadNode())).makeWriteNode(rhs) : ((ReadNode)((Object)((WriteLocalVariableNode)dummyTranslated.getNonProxyNode()).makeReadNode())).makeWriteNode(rhs);
        } else {
            if (dummyAssignment instanceof GlobalAsgnNode) {
                return this.translateGlobalAsgnNode((GlobalAsgnNode)dummyAssignment, rhs);
            }
            if (dummyAssignment instanceof ConstDeclNode) {
                return this.visitConstDeclNode((ConstDeclNode)dummyAssignment, rhs);
            }
            translated = ((ReadNode)((Object)this.environment.findLocalVarNode(this.environment.allocateLocalTemp("dummy"), sourceSection))).makeWriteNode(rhs);
        }
        return translated;
    }

    public RubyNode visitNewlineNode(NewlineNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> lineSequence = new ArrayList<RubyNode>();
        lineSequence.add(new TraceNode(this.context, sourceSection));
        lineSequence.add((RubyNode)((Object)node.getNextNode().accept((NodeVisitor)this)));
        ((RubyNode)((Object)lineSequence.get(0))).setAtNewline();
        return SequenceNode.sequence(this.context, sourceSection, lineSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyNode visitNextNode(NextNode node) {
        RubyNode resultNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        if (!this.environment.isBlock() && !this.translatingWhile) {
            throw new RaiseException(this.context.getCoreLibrary().syntaxError("Invalid next", this.currentNode));
        }
        boolean t = this.translatingNextExpression;
        this.translatingNextExpression = true;
        if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
            this.parentSourceSection.push(sourceSection);
        }
        try {
            resultNode = (RubyNode)((Object)node.getValueNode().accept((NodeVisitor)this));
        }
        finally {
            if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection.pop();
            }
            this.translatingNextExpression = t;
        }
        return new org.jruby.truffle.nodes.control.NextNode(this.context, sourceSection, resultNode);
    }

    public RubyNode visitNilNode(NilNode node) {
        if (node.getPosition() == InvalidSourcePosition.INSTANCE && this.parentSourceSection.peek() == null) {
            return new DeadNode(this.context, null, new Exception());
        }
        SourceSection sourceSection = this.translate(node.getPosition());
        return new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil");
    }

    public RubyNode visitNthRefNode(NthRefNode node) {
        return new ReadMatchReferenceNode(this.context, this.translate(node.getPosition()), node.getMatchNumber());
    }

    public RubyNode visitOpAsgnAndNode(OpAsgnAndNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        Node lhs = node.getFirstNode();
        Node rhs = node.getSecondNode();
        return new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.control.AndNode(this.context, sourceSection, (RubyNode)((Object)lhs.accept((NodeVisitor)this)), (RubyNode)((Object)rhs.accept((NodeVisitor)this))), "assignment");
    }

    public RubyNode visitOpAsgnNode(OpAsgnNode node) {
        if (node.getOperatorName().equals("||")) {
            String temp = this.environment.allocateLocalTemp("opassign");
            LocalAsgnNode writeReceiverToTemp = new LocalAsgnNode(node.getPosition(), temp, 0, node.getReceiverNode());
            LocalVarNode readReceiverFromTemp = new LocalVarNode(node.getPosition(), 0, temp);
            CallNode readMethod = new CallNode(node.getPosition(), (Node)readReceiverFromTemp, node.getVariableName(), null, null);
            CallNode writeMethod = new CallNode(node.getPosition(), (Node)readReceiverFromTemp, node.getVariableName() + "=", (Node)BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]), null);
            SourceSection sourceSection = this.translate(node.getPosition());
            RubyNode lhs = (RubyNode)((Object)readMethod.accept((NodeVisitor)this));
            RubyNode rhs = (RubyNode)((Object)writeMethod.accept((NodeVisitor)this));
            return new DefinedWrapperNode(this.context, sourceSection, SequenceNode.sequence(this.context, sourceSection, (RubyNode)((Object)writeReceiverToTemp.accept((NodeVisitor)this)), new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, lhs, rhs)), "assignment");
        }
        String temp = this.environment.allocateLocalTemp("opassign");
        LocalAsgnNode writeReceiverToTemp = new LocalAsgnNode(node.getPosition(), temp, 0, node.getReceiverNode());
        LocalVarNode readReceiverFromTemp = new LocalVarNode(node.getPosition(), 0, temp);
        CallNode readMethod = new CallNode(node.getPosition(), (Node)readReceiverFromTemp, node.getVariableName(), null, null);
        CallNode operation = new CallNode(node.getPosition(), (Node)readMethod, node.getOperatorName(), (Node)BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new Node[0]), null);
        CallNode writeMethod = new CallNode(node.getPosition(), (Node)readReceiverFromTemp, node.getVariableName() + "=", (Node)BodyTranslator.buildArrayNode(node.getPosition(), (Node)operation, new Node[0]), null);
        BlockNode block = new BlockNode(node.getPosition());
        block.add((Node)writeReceiverToTemp);
        block.add((Node)writeMethod);
        return (RubyNode)((Object)block.accept((NodeVisitor)this));
    }

    public RubyNode visitOpAsgnOrNode(OpAsgnOrNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode lhs = (RubyNode)((Object)node.getFirstNode().accept((NodeVisitor)this));
        RubyNode rhs = (RubyNode)((Object)node.getSecondNode().accept((NodeVisitor)this));
        if (node.getFirstNode().needsDefinitionCheck() && !(node.getFirstNode() instanceof InstVarNode)) {
            DefinedNode defined = new DefinedNode(this.context, lhs.getSourceSection(), lhs);
            lhs = new org.jruby.truffle.nodes.control.AndNode(this.context, lhs.getSourceSection(), defined, lhs);
        }
        return new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, lhs, rhs), "assignment");
    }

    public RubyNode visitOpElementAsgnNode(OpElementAsgnNode node) {
        Node index = node.getArgsNode() == null ? null : (Node)node.getArgsNode().childNodes().get(0);
        Node operand = node.getValueNode();
        String temp = this.environment.allocateLocalTemp("opelementassign");
        LocalAsgnNode writeArrayToTemp = new LocalAsgnNode(node.getPosition(), temp, 0, node.getReceiverNode());
        LocalVarNode readArrayFromTemp = new LocalVarNode(node.getPosition(), 0, temp);
        CallNode arrayRead = new CallNode(node.getPosition(), (Node)readArrayFromTemp, "[]", (Node)BodyTranslator.buildArrayNode(node.getPosition(), index, new Node[0]), null);
        String op = node.getOperatorName();
        Object operation = null;
        operation = op.equals("||") ? new OrNode(node.getPosition(), (Node)arrayRead, operand) : (op.equals("&&") ? new AndNode(node.getPosition(), (Node)arrayRead, operand) : new CallNode(node.getPosition(), (Node)arrayRead, node.getOperatorName(), (Node)BodyTranslator.buildArrayNode(node.getPosition(), operand, new Node[0]), null));
        CallNode arrayWrite = new CallNode(node.getPosition(), (Node)readArrayFromTemp, "[]=", (Node)BodyTranslator.buildArrayNode(node.getPosition(), index, new Node[]{operation}), null);
        BlockNode block = new BlockNode(node.getPosition());
        block.add((Node)writeArrayToTemp);
        block.add((Node)arrayWrite);
        return (RubyNode)((Object)block.accept((NodeVisitor)this));
    }

    private static ArrayNode buildArrayNode(ISourcePosition sourcePosition, Node first, Node ... rest) {
        if (first == null) {
            return new ArrayNode(sourcePosition);
        }
        ArrayNode array = new ArrayNode(sourcePosition, first);
        for (Node node : rest) {
            array.add(node);
        }
        return array;
    }

    public RubyNode visitOrNode(OrNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode x = node.getFirstNode() == null ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)node.getFirstNode().accept((NodeVisitor)this));
        RubyNode y = node.getSecondNode() == null ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)node.getSecondNode().accept((NodeVisitor)this));
        return new org.jruby.truffle.nodes.control.OrNode(this.context, sourceSection, x, y);
    }

    public RubyNode visitPreExeNode(PreExeNode node) {
        return (RubyNode)((Object)node.getBodyNode().accept((NodeVisitor)this));
    }

    public RubyNode visitPostExeNode(PostExeNode node) {
        return (RubyNode)((Object)node.getBodyNode().accept((NodeVisitor)this));
    }

    public RubyNode visitRationalNode(RationalNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return this.translateRationalComplex(sourceSection, "Rational", new FixnumLiteralNode.LongFixnumLiteralNode(this.context, sourceSection, node.getNumerator()), new FixnumLiteralNode.LongFixnumLiteralNode(this.context, sourceSection, node.getDenominator()));
    }

    private RubyNode translateRationalComplex(SourceSection sourceSection, String name, RubyNode a, RubyNode b) {
        LexicalScope lexicalScope = this.environment.getLexicalScope();
        LexicalScopeNode moduleNode = new LexicalScopeNode(this.context, sourceSection, lexicalScope);
        return new RubyCallNode(this.context, sourceSection, "convert", (RubyNode)new ReadConstantNode(this.context, sourceSection, name, moduleNode, lexicalScope), null, false, true, a, b);
    }

    public RubyNode visitRedoNode(RedoNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            throw new RaiseException(this.context.getCoreLibrary().syntaxError("Invalid redo", this.currentNode));
        }
        return new org.jruby.truffle.nodes.control.RedoNode(this.context, this.translate(node.getPosition()));
    }

    public RubyNode visitRegexpNode(RegexpNode node) {
        Regex regex = RegexpNodes.compile(this.currentNode, this.context, node.getValue(), node.getOptions());
        RubyBasicObject regexp = RegexpNodes.createRubyRegexp(this.context.getCoreLibrary().getRegexpClass(), regex, node.getValue(), node.getOptions());
        RegexpNodes.getOptions(regexp).setLiteral(true);
        org.jruby.truffle.nodes.literal.LiteralNode literalNode = new org.jruby.truffle.nodes.literal.LiteralNode(this.context, this.translate(node.getPosition()), regexp);
        if (node.getOptions().isOnce()) {
            return new OnceNode(this.context, literalNode.getEncapsulatingSourceSection(), literalNode);
        }
        return literalNode;
    }

    public static boolean all7Bit(byte[] bytes) {
        for (int n = 0; n < bytes.length; ++n) {
            if (bytes[n] < 0) {
                return false;
            }
            if (bytes[n] != 92 || n + 1 >= bytes.length || bytes[n + 1] != 120) continue;
            boolean isSecondHex = n + 3 < bytes.length && Character.digit(bytes[n + 3], 16) != -1;
            String num = isSecondHex ? new String(Arrays.copyOfRange(bytes, n + 2, n + 4), StandardCharsets.UTF_8) : new String(Arrays.copyOfRange(bytes, n + 2, n + 3), StandardCharsets.UTF_8);
            int b = Integer.parseInt(num, 16);
            if (b > 127) {
                return false;
            }
            if (isSecondHex) {
                n += 3;
                continue;
            }
            n += 2;
        }
        return true;
    }

    public RubyNode visitRescueNode(org.jruby.ast.RescueNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode tryPart = node.getBodyNode() == null || node.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)node.getBodyNode().accept((NodeVisitor)this));
        ArrayList<RescueNode> rescueNodes = new ArrayList<RescueNode>();
        for (RescueBodyNode rescueBody = node.getRescueNode(); rescueBody != null; rescueBody = rescueBody.getOptRescueNode()) {
            if (rescueBody.getExceptionNodes() != null) {
                RescueNode rescueNode;
                if (rescueBody.getExceptionNodes() instanceof ArrayNode) {
                    Node[] exceptionNodes = ((ArrayNode)rescueBody.getExceptionNodes()).children();
                    RubyNode[] handlingClasses = new RubyNode[exceptionNodes.length];
                    for (int n = 0; n < handlingClasses.length; ++n) {
                        handlingClasses[n] = (RubyNode)((Object)exceptionNodes[n].accept((NodeVisitor)this));
                    }
                    RubyNode translatedBody = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)rescueBody.getBodyNode().accept((NodeVisitor)this));
                    rescueNode = new RescueClassesNode(this.context, sourceSection, handlingClasses, translatedBody);
                    rescueNodes.add(rescueNode);
                    continue;
                }
                if (rescueBody.getExceptionNodes() instanceof SplatNode) {
                    SplatNode splat = (SplatNode)rescueBody.getExceptionNodes();
                    RubyNode splatTranslated = splat.getValue() == null ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)splat.getValue().accept((NodeVisitor)this));
                    RubyNode bodyTranslated = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)rescueBody.getBodyNode().accept((NodeVisitor)this));
                    rescueNode = new RescueSplatNode(this.context, sourceSection, splatTranslated, bodyTranslated);
                    rescueNodes.add(rescueNode);
                    continue;
                }
                this.unimplemented((Node)node);
                continue;
            }
            RubyNode bodyNode = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)rescueBody.getBodyNode().accept((NodeVisitor)this));
            RescueAnyNode rescueNode = new RescueAnyNode(this.context, sourceSection, bodyNode);
            rescueNodes.add(rescueNode);
        }
        RubyNode elsePart = node.getElseNode() == null || node.getElseNode().getPosition() == InvalidSourcePosition.INSTANCE ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)node.getElseNode().accept((NodeVisitor)this));
        return new TryNode(this.context, sourceSection, new ExceptionTranslatingNode(this.context, sourceSection, tryPart), rescueNodes.toArray(new RescueNode[rescueNodes.size()]), elsePart);
    }

    public RubyNode visitRetryNode(org.jruby.ast.RetryNode node) {
        return new RetryNode(this.context, this.translate(node.getPosition()));
    }

    public RubyNode visitReturnNode(org.jruby.ast.ReturnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode translatedChild = (RubyNode)((Object)node.getValueNode().accept((NodeVisitor)this));
        return new ReturnNode(this.context, sourceSection, this.environment.getReturnID(), translatedChild);
    }

    public RubyNode visitSClassNode(SClassNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode receiverNode = (RubyNode)((Object)node.getReceiverNode().accept((NodeVisitor)this));
        SingletonClassNode singletonClassNode = SingletonClassNodeGen.create(this.context, sourceSection, receiverNode);
        return this.openModule(sourceSection, singletonClassNode, "(singleton-def)", node.getBodyNode());
    }

    public RubyNode visitSValueNode(SValueNode node) {
        return (RubyNode)((Object)node.getValue().accept((NodeVisitor)this));
    }

    public RubyNode visitSelfNode(SelfNode node) {
        return new org.jruby.truffle.nodes.objects.SelfNode(this.context, this.translate(node.getPosition()));
    }

    public RubyNode visitSplatNode(SplatNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode value = node.getValue() == null ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)node.getValue().accept((NodeVisitor)this));
        return SplatCastNodeGen.create(this.context, sourceSection, SplatCastNode.NilBehavior.EMPTY_ARRAY, false, value);
    }

    public RubyNode visitStrNode(StrNode node) {
        return new StringLiteralNode(this.context, this.translate(node.getPosition()), node.getValue(), node.getCodeRange());
    }

    public RubyNode visitSymbolNode(SymbolNode node) {
        ByteList byteList = ByteList.create((CharSequence)node.getName());
        byteList.setEncoding(node.getEncoding());
        return new org.jruby.truffle.nodes.literal.LiteralNode(this.context, this.translate(node.getPosition()), this.context.getSymbol(byteList));
    }

    public RubyNode visitTrueNode(TrueNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        return new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, true), "true");
    }

    public RubyNode visitUndefNode(UndefNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        org.jruby.truffle.nodes.objects.SelfNode classNode = new org.jruby.truffle.nodes.objects.SelfNode(this.context, sourceSection);
        return new org.jruby.truffle.nodes.methods.UndefNode(this.context, sourceSection, classNode, ((LiteralNode)node.getName()).getName());
    }

    public RubyNode visitUntilNode(UntilNode node) {
        org.jruby.ast.WhileNode whileNode = new org.jruby.ast.WhileNode(node.getPosition(), node.getConditionNode(), node.getBodyNode(), node.evaluateAtStart());
        return this.visitWhileNode(whileNode, true);
    }

    public RubyNode visitVCallNode(VCallNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (node.getName().equals("undefined") && sourceSection.getSource().getPath().startsWith("core:/core/")) {
            return new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getRubiniusUndefined());
        }
        SelfNode receiver = new SelfNode(node.getPosition());
        CallNode callNode = new CallNode(node.getPosition(), (Node)receiver, node.getName(), null, null);
        return this.visitCallNodeExtraArgument(callNode, null, true, true);
    }

    public RubyNode visitWhileNode(org.jruby.ast.WhileNode node) {
        return this.visitWhileNode(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode visitWhileNode(org.jruby.ast.WhileNode node, boolean conditionInversed) {
        RubyNode body;
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode condition = (RubyNode)((Object)node.getConditionNode().accept((NodeVisitor)this));
        if (conditionInversed) {
            condition = new NotNode(this.context, sourceSection, condition);
        }
        TranslatorEnvironment.BreakID whileBreakID = this.environment.getParseEnvironment().allocateBreakID();
        boolean oldTranslatingWhile = this.translatingWhile;
        this.translatingWhile = true;
        TranslatorEnvironment.BreakID oldBreakID = this.environment.getBreakID();
        this.environment.setBreakIDForWhile(whileBreakID);
        try {
            body = node.getBodyNode().isNil() ? new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil") : (RubyNode)((Object)node.getBodyNode().accept((NodeVisitor)this));
        }
        finally {
            this.environment.setBreakIDForWhile(oldBreakID);
            this.translatingWhile = oldTranslatingWhile;
        }
        if (YIELDS) {
            body = SequenceNode.sequence(this.context, sourceSection, new ThreadPassNode(this.context, sourceSection), body);
        }
        WhileNode loop = node.evaluateAtStart() ? WhileNode.createWhile(this.context, sourceSection, condition, body) : WhileNode.createDoWhile(this.context, sourceSection, condition, body);
        return new CatchBreakNode(this.context, sourceSection, loop, whileBreakID);
    }

    public RubyNode visitXStrNode(XStrNode node) {
        ArrayNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), (Node)new StrNode(node.getPosition(), node.getValue()), new Node[0]);
        FCallNode callNode = new FCallNode(node.getPosition(), "`", (Node)argsNode, null);
        return (RubyNode)((Object)callNode.accept((NodeVisitor)this));
    }

    public RubyNode visitYieldNode(org.jruby.ast.YieldNode node) {
        ArrayList<Node> arguments = new ArrayList<Node>();
        Node argsNode = node.getArgsNode();
        boolean unsplat = argsNode instanceof SplatNode;
        if (unsplat) {
            argsNode = ((SplatNode)argsNode).getValue();
        }
        if (argsNode != null) {
            if (argsNode instanceof ListNode) {
                arguments.addAll(node.getArgsNode().childNodes());
            } else {
                arguments.add(node.getArgsNode());
            }
        }
        ArrayList<Object> argumentsTranslated = new ArrayList<Object>();
        for (Node argument : arguments) {
            argumentsTranslated.add(argument.accept((NodeVisitor)this));
        }
        RubyNode[] argumentsTranslatedArray = argumentsTranslated.toArray(new RubyNode[argumentsTranslated.size()]);
        return new YieldNode(this.context, this.translate(node.getPosition()), argumentsTranslatedArray, unsplat);
    }

    public RubyNode visitZArrayNode(ZArrayNode node) {
        RubyNode[] values = new RubyNode[]{};
        return new ArrayLiteralNode.UninitialisedArrayLiteralNode(this.context, this.translate(node.getPosition()), values);
    }

    public RubyNode visitBackRefNode(BackRefNode node) {
        int index = 0;
        switch (node.getType()) {
            case '`': {
                index = -1;
                break;
            }
            case '\'': {
                index = -2;
                break;
            }
            case '&': {
                index = -3;
                break;
            }
            case '+': {
                index = -4;
                break;
            }
            default: {
                throw new UnsupportedOperationException(Character.toString(node.getType()));
            }
        }
        return new ReadMatchReferenceNode(this.context, this.translate(node.getPosition()), index);
    }

    public RubyNode visitLambdaNode(LambdaNode node) {
        ArgsNode argsNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        if (node.getVarNode() instanceof ArgsNode) {
            argsNode = (ArgsNode)node.getVarNode();
        } else if (node.getVarNode() instanceof DAsgnNode) {
            ArgumentNode arg = new ArgumentNode(node.getPosition(), ((DAsgnNode)node.getVarNode()).getName());
            ArrayNode preArgs = new ArrayNode(node.getPosition(), (Node)arg);
            argsNode = new ArgsNode(node.getPosition(), (ListNode)preArgs, null, null, null, null, null, null);
        } else if (node.getVarNode() == null) {
            argsNode = null;
        } else {
            throw new UnsupportedOperationException();
        }
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, this.environment.getLexicalScope(), MethodTranslator.getArity(argsNode), "(lambda)", true, (Node)node, false);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), this.environment.getReturnID(), false, false, sharedMethodInfo, sharedMethodInfo.getName(), true, this.environment.getParseEnvironment().allocateBreakID());
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, false, this.source, argsNode);
        RubyNode definitionNode = methodCompiler.compileFunctionNode(this.translate(node.getPosition()), sharedMethodInfo.getName(), node.getBodyNode(), sharedMethodInfo);
        return new org.jruby.truffle.nodes.cast.LambdaNode(this.context, this.translate(node.getPosition()), definitionNode);
    }

    protected RubyNode initFlipFlopStates(SourceSection sourceSection) {
        RubyNode[] initNodes = new RubyNode[this.environment.getFlipFlopStates().size()];
        for (int n = 0; n < initNodes.length; ++n) {
            initNodes[n] = new InitFlipFlopSlotNode(this.context, sourceSection, this.environment.getFlipFlopStates().get(n));
        }
        return SequenceNode.sequence(this.context, sourceSection, initNodes);
    }

    protected RubyNode defaultVisit(Node node) {
        return this.unimplemented(node);
    }

    protected RubyNode unimplemented(Node node) {
        this.context.getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, this.source.getName(), node.getPosition().getLine(), node + " does nothing - translating as nil");
        SourceSection sourceSection = this.translate(node.getPosition());
        return new DefinedWrapperNode(this.context, sourceSection, new org.jruby.truffle.nodes.literal.LiteralNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject()), "nil");
    }

    public TranslatorEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    protected String getIdentifier() {
        if (this.environment.isBlock()) {
            TranslatorEnvironment methodParent = this.environment.getParent();
            while (methodParent.isBlock()) {
                methodParent = methodParent.getParent();
            }
            return "block in " + methodParent.getNamedMethodName();
        }
        return this.environment.getNamedMethodName();
    }

    public RubyNode visitOther(Node node) {
        if (node instanceof ReadLocalDummyNode) {
            ReadLocalDummyNode readLocal = (ReadLocalDummyNode)node;
            return new ReadLocalVariableNode(this.context, readLocal.getSourceSection(), readLocal.getFrameSlot());
        }
        throw new UnsupportedOperationException();
    }

    static {
        debugIgnoredCalls.add("downto");
        debugIgnoredCalls.add("each");
        debugIgnoredCalls.add("times");
        debugIgnoredCalls.add("upto");
        THREAD_LOCAL_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$~", "$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9", "$!"));
    }

    protected static class ArgumentsAndBlockTranslation {
        private final RubyNode block;
        private final RubyNode[] arguments;
        private final boolean isSplatted;

        public ArgumentsAndBlockTranslation(RubyNode block, RubyNode[] arguments, boolean isSplatted) {
            this.block = block;
            this.arguments = arguments;
            this.isSplatted = isSplatted;
        }

        public RubyNode getBlock() {
            return this.block;
        }

        public RubyNode[] getArguments() {
            return Arrays.copyOf(this.arguments, this.arguments.length);
        }

        public boolean isSplatted() {
            return this.isSplatted;
        }
    }
}

