/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.util.FileUtils;

public class SourceManager {
    private final RubyContext context;
    private final Map<String, Source> sources = new HashMap<String, Source>();

    public SourceManager(RubyContext context) {
        this.context = context;
    }

    public synchronized Source forFile(String path) {
        String canonicalPath;
        try {
            canonicalPath = new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Source source = this.sources.get(canonicalPath);
        if (source == null) {
            byte[] bytes = FileUtils.readAllBytesInterruptedly(this.context, path);
            source = Source.fromText((CharSequence)new String(bytes, StandardCharsets.UTF_8), (String)path);
            this.sources.put(canonicalPath, source);
        }
        return source;
    }

    public synchronized Source forFileBestFuzzily(final String path) {
        ArrayList<Map.Entry<String, Source>> matches = new ArrayList<Map.Entry<String, Source>>(this.sources.entrySet());
        Collections.sort(matches, new Comparator<Map.Entry<String, Source>>(){

            @Override
            public int compare(Map.Entry<String, Source> a, Map.Entry<String, Source> b) {
                return Integer.compare(SourceManager.this.common(path, b.getKey()), SourceManager.this.common(path, a.getKey()));
            }
        });
        return (Source)((Map.Entry)matches.get(0)).getValue();
    }

    public int common(String path, String existingPath) {
        int n;
        for (n = 0; n < path.length() && n < existingPath.length() && path.charAt(path.length() - n - 1) == existingPath.charAt(existingPath.length() - n - 1); ++n) {
        }
        return n;
    }
}

