/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.hash;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jruby.RubyHash;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.hash.HashGuards;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.hash.Entry;

public abstract class BucketsStrategy {
    public static final double LOAD_FACTOR = 0.75;
    public static final int OVERALLOCATE_FACTOR = 4;
    public static final int SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int[] CAPACITIES = Arrays.copyOf(RubyHash.MRI_PRIMES, RubyHash.MRI_PRIMES.length - 1);

    public static RubyBasicObject create(RubyClass hashClass, int capacity) {
        int bucketsCount = BucketsStrategy.capacityGreaterThan(capacity) * 4;
        Entry[] newEntries = new Entry[bucketsCount];
        return HashNodes.createHash(hashClass, null, null, newEntries, 0, null, null);
    }

    public static RubyBasicObject create(RubyClass hashClass, Collection<Map.Entry<Object, Object>> entries, boolean byIdentity) {
        int actualSize = entries.size();
        int bucketsCount = BucketsStrategy.capacityGreaterThan(entries.size()) * 4;
        Entry[] newEntries = new Entry[bucketsCount];
        Entry firstInSequence = null;
        Entry lastInSequence = null;
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            if (!byIdentity && RubyGuards.isRubyString(key)) {
                key = DebugOperations.send(hashClass.getContext(), DebugOperations.send(hashClass.getContext(), key, "dup", null, new Object[0]), "freeze", null, new Object[0]);
            }
            int hashed = HashNodes.slowHashKey(hashClass.getContext(), key);
            Entry newEntry = new Entry(hashed, key, entry.getValue());
            int index = BucketsStrategy.getBucketIndex(hashed, newEntries.length);
            Entry bucketEntry = newEntries[index];
            if (bucketEntry == null) {
                newEntries[index] = newEntry;
            } else {
                Entry previousInBucket = null;
                while (bucketEntry != null) {
                    if (hashed == bucketEntry.getHashed() && HashNodes.slowAreKeysEqual(hashClass.getContext(), bucketEntry.getKey(), key, byIdentity)) {
                        bucketEntry.setValue(entry.getValue());
                        --actualSize;
                        if (bucketEntry.getPreviousInSequence() != null) {
                            bucketEntry.getPreviousInSequence().setNextInSequence(bucketEntry.getNextInSequence());
                        }
                        if (bucketEntry.getNextInSequence() != null) {
                            bucketEntry.getNextInSequence().setPreviousInSequence(bucketEntry.getPreviousInSequence());
                        }
                        if (bucketEntry == lastInSequence) {
                            lastInSequence = bucketEntry.getPreviousInSequence();
                        }
                        newEntry = bucketEntry;
                        previousInBucket = null;
                        break;
                    }
                    previousInBucket = bucketEntry;
                    bucketEntry = bucketEntry.getNextInLookup();
                }
                if (previousInBucket != null) {
                    previousInBucket.setNextInLookup(newEntry);
                }
            }
            if (firstInSequence == null) {
                firstInSequence = newEntry;
            }
            if (lastInSequence != null) {
                lastInSequence.setNextInSequence(newEntry);
            }
            newEntry.setPreviousInSequence(lastInSequence);
            newEntry.setNextInSequence(null);
            lastInSequence = newEntry;
        }
        return HashNodes.createHash(hashClass, null, null, newEntries, actualSize, firstInSequence, lastInSequence);
    }

    public static int capacityGreaterThan(int size) {
        for (int capacity : CAPACITIES) {
            if (capacity <= size) continue;
            return capacity;
        }
        return CAPACITIES[CAPACITIES.length - 1];
    }

    public static int getBucketIndex(int hashed, int bucketsCount) {
        return (hashed & Integer.MAX_VALUE) % bucketsCount;
    }

    public static void addNewEntry(RubyBasicObject hash, int hashed, Object key, Object value) {
        assert (HashGuards.isBucketHash(hash));
        assert (HashNodes.verifyStore(hash));
        Entry[] buckets = (Entry[])HashNodes.getStore(hash);
        Entry entry = new Entry(hashed, key, value);
        if (HashNodes.getFirstInSequence(hash) == null) {
            HashNodes.setFirstInSequence(hash, entry);
        } else {
            HashNodes.getLastInSequence(hash).setNextInSequence(entry);
            entry.setPreviousInSequence(HashNodes.getLastInSequence(hash));
        }
        HashNodes.setLastInSequence(hash, entry);
        int bucketIndex = BucketsStrategy.getBucketIndex(hashed, buckets.length);
        Entry previousInLookup = buckets[bucketIndex];
        if (previousInLookup == null) {
            buckets[bucketIndex] = entry;
        } else {
            while (previousInLookup.getNextInLookup() != null) {
                previousInLookup = previousInLookup.getNextInLookup();
            }
            previousInLookup.setNextInLookup(entry);
        }
        HashNodes.setSize(hash, HashNodes.getSize(hash) + 1);
        assert (HashNodes.verifyStore(hash));
    }

    @CompilerDirectives.TruffleBoundary
    public static void resize(RubyBasicObject hash) {
        assert (HashGuards.isBucketHash(hash));
        assert (HashNodes.verifyStore(hash));
        int bucketsCount = BucketsStrategy.capacityGreaterThan(HashNodes.getSize(hash)) * 4;
        Entry[] newEntries = new Entry[bucketsCount];
        for (Entry entry = HashNodes.getFirstInSequence(hash); entry != null; entry = entry.getNextInSequence()) {
            int bucketIndex = BucketsStrategy.getBucketIndex(entry.getHashed(), bucketsCount);
            Entry previousInLookup = newEntries[bucketIndex];
            if (previousInLookup == null) {
                newEntries[bucketIndex] = entry;
            } else {
                while (previousInLookup.getNextInLookup() != null) {
                    previousInLookup = previousInLookup.getNextInLookup();
                }
                previousInLookup.setNextInLookup(entry);
            }
            entry.setNextInLookup(null);
        }
        HashNodes.setStore(hash, newEntries, HashNodes.getSize(hash), HashNodes.getFirstInSequence(hash), HashNodes.getLastInSequence(hash));
        assert (HashNodes.verifyStore(hash));
    }

    public static Iterator<Map.Entry<Object, Object>> iterateKeyValues(final Entry firstInSequence) {
        return new Iterator<Map.Entry<Object, Object>>(){
            private Entry entry;
            {
                this.entry = firstInSequence;
            }

            @Override
            public boolean hasNext() {
                return this.entry != null;
            }

            @Override
            public Map.Entry<Object, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                final Entry finalEntry = this.entry;
                Map.Entry<Object, Object> entryResult = new Map.Entry<Object, Object>(){

                    @Override
                    public Object getKey() {
                        return finalEntry.getKey();
                    }

                    @Override
                    public Object getValue() {
                        return finalEntry.getValue();
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }
                };
                this.entry = this.entry.getNextInSequence();
                return entryResult;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterable<Map.Entry<Object, Object>> iterableKeyValues(final Entry firstInSequence) {
        return new Iterable<Map.Entry<Object, Object>>(){

            @Override
            public Iterator<Map.Entry<Object, Object>> iterator() {
                return BucketsStrategy.iterateKeyValues(firstInSequence);
            }
        };
    }

    public static void copyInto(RubyBasicObject from, RubyBasicObject to) {
        assert (RubyGuards.isRubyHash(from));
        assert (HashGuards.isBucketHash(from));
        assert (HashNodes.verifyStore(from));
        assert (RubyGuards.isRubyHash(to));
        assert (HashNodes.verifyStore(to));
        Entry[] newEntries = new Entry[((Entry[])HashNodes.getStore(from)).length];
        Entry firstInSequence = null;
        Entry lastInSequence = null;
        for (Entry entry = HashNodes.getFirstInSequence(from); entry != null; entry = entry.getNextInSequence()) {
            Entry newEntry = new Entry(entry.getHashed(), entry.getKey(), entry.getValue());
            int index = BucketsStrategy.getBucketIndex(entry.getHashed(), newEntries.length);
            newEntry.setNextInLookup(newEntries[index]);
            newEntries[index] = newEntry;
            if (firstInSequence == null) {
                firstInSequence = newEntry;
            }
            if (lastInSequence != null) {
                lastInSequence.setNextInSequence(newEntry);
                newEntry.setPreviousInSequence(lastInSequence);
            }
            lastInSequence = newEntry;
        }
        HashNodes.setStore(to, newEntries, HashNodes.getSize(from), firstInSequence, lastInSequence);
    }
}

