/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.yield;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.yield.UninitializedYieldDispatchNode;
import org.jruby.truffle.nodes.yield.YieldDispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyModule;

public class YieldDispatchHeadNode
extends Node {
    @Node.Child
    private YieldDispatchNode dispatch;

    public YieldDispatchHeadNode(RubyContext context) {
        this.dispatch = new UninitializedYieldDispatchNode(context);
    }

    public Object dispatch(VirtualFrame frame, RubyBasicObject block, Object ... argumentsObjects) {
        assert (block == null || RubyGuards.isRubyProc(block));
        return this.dispatch.dispatchWithSelfAndBlock(frame, block, ProcNodes.getSelfCapturedInScope(block), ProcNodes.getBlockCapturedInScope(block), argumentsObjects);
    }

    public Object dispatchWithModifiedBlock(VirtualFrame frame, RubyBasicObject block, RubyBasicObject modifiedBlock, Object ... argumentsObjects) {
        assert (block == null || RubyGuards.isRubyProc(block));
        assert (modifiedBlock == null || RubyGuards.isRubyProc(modifiedBlock));
        return this.dispatch.dispatchWithSelfAndBlock(frame, block, ProcNodes.getSelfCapturedInScope(block), modifiedBlock, argumentsObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatchWithModifiedSelf(VirtualFrame currentFrame, RubyBasicObject block, Object self, Object ... argumentsObjects) {
        assert (block == null || RubyGuards.isRubyProc(block));
        MaterializedFrame frame = ProcNodes.getDeclarationFrame(block);
        if (frame != null) {
            FrameSlot slot = this.getVisibilitySlot((Frame)frame);
            Object oldVisibility = frame.getValue(slot);
            try {
                frame.setObject(slot, (Object)Visibility.PUBLIC);
                Object object = this.dispatch.dispatchWithSelfAndBlock(currentFrame, block, self, ProcNodes.getBlockCapturedInScope(block), argumentsObjects);
                return object;
            }
            finally {
                frame.setObject(slot, oldVisibility);
            }
        }
        return this.dispatch.dispatchWithSelfAndBlock(currentFrame, block, self, ProcNodes.getBlockCapturedInScope(block), argumentsObjects);
    }

    @CompilerDirectives.TruffleBoundary
    private FrameSlot getVisibilitySlot(Frame frame) {
        return frame.getFrameDescriptor().findOrAddFrameSlot(RubyModule.VISIBILITY_FRAME_SLOT_ID, (Object)"dynamic visibility for def", FrameSlotKind.Object);
    }

    public YieldDispatchNode getDispatch() {
        return this.dispatch;
    }
}

