/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.methods.InternalMethod;

@NodeChild(value="self")
public abstract class LookupSuperMethodNode
extends RubyNode {
    @Node.Child
    MetaClassNode metaClassNode;

    public LookupSuperMethodNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
    }

    public abstract InternalMethod executeLookupSuperMethod(VirtualFrame var1, Object var2);

    @Specialization(guards={"getCurrentMethod(frame) == currentMethod", "metaClass(frame, self) == selfMetaClass"}, assumptions={"selfMetaClass.getUnmodifiedAssumption()"}, limit="getCacheLimit()")
    protected InternalMethod lookupSuperMethodCached(VirtualFrame frame, Object self, @Cached(value="getCurrentMethod(frame)") InternalMethod currentMethod, @Cached(value="metaClass(frame, self)") RubyClass selfMetaClass, @Cached(value="doLookup(currentMethod, selfMetaClass)") InternalMethod superMethod) {
        return superMethod;
    }

    @Specialization
    protected InternalMethod lookupSuperMethodUncached(VirtualFrame frame, Object self) {
        InternalMethod currentMethod = this.getCurrentMethod(frame);
        RubyClass selfMetaClass = this.metaClass(frame, self);
        return this.doLookup(currentMethod, selfMetaClass);
    }

    protected InternalMethod getCurrentMethod(VirtualFrame frame) {
        return RubyArguments.getMethod(frame.getArguments());
    }

    protected RubyClass metaClass(VirtualFrame frame, Object object) {
        return this.metaClassNode.executeMetaClass(frame, object);
    }

    protected InternalMethod doLookup(InternalMethod currentMethod, RubyClass selfMetaClass) {
        InternalMethod superMethod = ModuleOperations.lookupSuperMethod(currentMethod, selfMetaClass);
        if (superMethod != null && superMethod.isUndefined()) {
            superMethod = null;
        }
        return superMethod;
    }
}

