/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.byref.IntByReference;
import org.jruby.RubyEncoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.nodes.rubinius.PointerNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.sockets.FDSet;
import org.jruby.truffle.runtime.sockets.FDSetFactory;
import org.jruby.truffle.runtime.sockets.FDSetFactoryFactory;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.unsafe.UnsafeHolder;

public abstract class IOPrimitiveNodes {
    private static int STDOUT = 1;
    private static final String IBUFFER_IDENTIFIER = "@ibuffer";
    private static final Property IBUFFER_PROPERTY;
    private static final String LINENO_IDENTIFIER = "@lineno";
    private static final Property LINENO_PROPERTY;
    private static final String DESCRIPTOR_IDENTIFIER = "@descriptor";
    private static final Property DESCRIPTOR_PROPERTY;
    private static final String MODE_IDENTIFIER = "@mode";
    private static final Property MODE_PROPERTY;
    private static final DynamicObjectFactory IO_FACTORY;

    public static int getDescriptor(RubyBasicObject io) {
        assert (io.getDynamicObject().getShape().hasProperty((Object)DESCRIPTOR_IDENTIFIER));
        return (Integer)DESCRIPTOR_PROPERTY.get(io.getDynamicObject(), true);
    }

    public static void setDescriptor(RubyBasicObject io, int newDescriptor) {
        assert (io.getDynamicObject().getShape().hasProperty((Object)DESCRIPTOR_IDENTIFIER));
        try {
            DESCRIPTOR_PROPERTY.set(io.getDynamicObject(), (Object)newDescriptor, io.getDynamicObject().getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static void setMode(RubyBasicObject io, int newMode) {
        assert (io.getDynamicObject().getShape().hasProperty((Object)MODE_IDENTIFIER));
        try {
            MODE_PROPERTY.set(io.getDynamicObject(), (Object)newMode, io.getDynamicObject().getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        IBUFFER_PROPERTY = Property.create((Object)IBUFFER_IDENTIFIER, (Location)allocator.locationForType(RubyBasicObject.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
        LINENO_PROPERTY = Property.create((Object)LINENO_IDENTIFIER, (Location)allocator.locationForType(Integer.TYPE), (int)0);
        DESCRIPTOR_PROPERTY = Property.create((Object)DESCRIPTOR_IDENTIFIER, (Location)allocator.locationForType(Integer.TYPE), (int)0);
        MODE_PROPERTY = Property.create((Object)MODE_IDENTIFIER, (Location)allocator.locationForType(Integer.TYPE), (int)0);
        IO_FACTORY = RubyBasicObject.EMPTY_SHAPE.addProperty(IBUFFER_PROPERTY).addProperty(LINENO_PROPERTY).addProperty(DESCRIPTOR_PROPERTY).addProperty(MODE_PROPERTY).createFactory();
    }

    @RubiniusPrimitive(name="io_select", needsSelf=false)
    public static abstract class IOSelectPrimitiveNode
    extends RubiniusPrimitiveNode {
        private static final FDSetFactory fdSetFactory = FDSetFactoryFactory.create();

        public IOSelectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyArray(readables)", "isNil(writables)", "isNil(errorables)"})
        public Object select(RubyBasicObject readables, RubyBasicObject writables, RubyBasicObject errorables, int timeout) {
            Object[] readableObjects = ArrayNodes.slowToArray(readables);
            final int[] readableFds = this.getFileDescriptors(readables);
            final FDSet readableSet = fdSetFactory.create();
            for (int fd : readableFds) {
                readableSet.set(fd);
            }
            int result = this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return IOSelectPrimitiveNode.this.nativeSockets().select(IOSelectPrimitiveNode.max(readableFds) + 1, readableSet.getPointer(), PointerNodes.NULL_POINTER, PointerNodes.NULL_POINTER, PointerNodes.NULL_POINTER);
                }
            });
            if (result == -1) {
                return this.nil();
            }
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), this.getSetObjects(readableObjects, readableFds, readableSet), ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), new Object[0]), ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), new Object[0]));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(readables)", "isRubyArray(writables)", "isNil(errorables)"})
        public Object selectNilReadables(RubyBasicObject readables, RubyBasicObject writables, RubyBasicObject errorables, int timeout) {
            Object[] writableObjects = ArrayNodes.slowToArray(writables);
            final int[] writableFds = this.getFileDescriptors(writables);
            final FDSet writableSet = fdSetFactory.create();
            for (int fd : writableFds) {
                writableSet.set(fd);
            }
            int result = this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return IOSelectPrimitiveNode.this.nativeSockets().select(IOSelectPrimitiveNode.max(writableFds) + 1, PointerNodes.NULL_POINTER, writableSet.getPointer(), PointerNodes.NULL_POINTER, PointerNodes.NULL_POINTER);
                }
            });
            if (result == -1) {
                return this.nil();
            }
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), new Object[0]), this.getSetObjects(writableObjects, writableFds, writableSet), ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), new Object[0]));
        }

        private int[] getFileDescriptors(RubyBasicObject fileDescriptorArray) {
            assert (RubyGuards.isRubyArray(fileDescriptorArray));
            Object[] objects = ArrayNodes.slowToArray(fileDescriptorArray);
            int[] fileDescriptors = new int[objects.length];
            for (int n = 0; n < objects.length; ++n) {
                if (!(objects[n] instanceof RubyBasicObject)) {
                    throw new UnsupportedOperationException();
                }
                fileDescriptors[n] = IOPrimitiveNodes.getDescriptor((RubyBasicObject)objects[n]);
            }
            return fileDescriptors;
        }

        private static int max(int[] values) {
            assert (values.length > 0);
            int max = Integer.MIN_VALUE;
            for (int n = 0; n < values.length; ++n) {
                max = Math.max(max, values[n]);
            }
            return max;
        }

        private RubyBasicObject getSetObjects(Object[] objects, int[] fds, FDSet set) {
            Object[] setObjects = new Object[objects.length];
            int setFdsCount = 0;
            for (int n = 0; n < objects.length; ++n) {
                if (!set.isSet(fds[n])) continue;
                setObjects[setFdsCount] = objects[n];
                ++setFdsCount;
            }
            return this.createArray(setObjects, setFdsCount);
        }
    }

    @RubiniusPrimitive(name="io_sysread")
    public static abstract class IOSysReadPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOSysReadPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject sysread(VirtualFrame frame, RubyBasicObject file, int length) {
            int readIteration;
            int fd = IOPrimitiveNodes.getDescriptor(file);
            ByteBuffer buffer = ByteBuffer.allocate(length);
            for (int toRead = length; toRead > 0; toRead -= readIteration) {
                this.getContext().getSafepointManager().poll(this);
                readIteration = this.posix().read(fd, buffer, toRead);
                buffer.position(readIteration);
            }
            return this.createString(buffer);
        }
    }

    @RubiniusPrimitive(name="io_accept")
    public static abstract class AcceptNode
    extends RubiniusPrimitiveNode {
        public AcceptNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public int accept(VirtualFrame frame, RubyBasicObject io) {
            int newFd;
            int fd = IOPrimitiveNodes.getDescriptor(io);
            IntByReference addressLength = new IntByReference(16);
            long address = UnsafeHolder.U.allocateMemory(addressLength.intValue());
            try {
                newFd = this.nativeSockets().accept(fd, this.getMemoryManager().newPointer(address), addressLength);
            }
            finally {
                UnsafeHolder.U.freeMemory(address);
            }
            if (newFd == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return newFd;
        }
    }

    @RubiniusPrimitive(name="io_seek", lowerFixnumParameters={0, 1})
    public static abstract class IOSeekPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOSeekPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int seek(VirtualFrame frame, RubyBasicObject io, int amount, int whence) {
            int fd = IOPrimitiveNodes.getDescriptor(io);
            return this.posix().lseek(fd, (long)amount, whence);
        }
    }

    @RubiniusPrimitive(name="io_close")
    public static abstract class IOClosePrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode ensureOpenNode;

        public IOClosePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.ensureOpenNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public int close(VirtualFrame frame, RubyBasicObject io) {
            this.ensureOpenNode.call(frame, io, "ensure_open", null, new Object[0]);
            int fd = IOPrimitiveNodes.getDescriptor(io);
            if (fd == -1) {
                return 0;
            }
            IOPrimitiveNodes.setDescriptor(io, -1);
            if (fd < 3) {
                return 0;
            }
            int result = this.posix().close(fd);
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return 0;
        }
    }

    @RubiniusPrimitive(name="io_write")
    public static abstract class IOWritePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOWritePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public int write(VirtualFrame frame, RubyBasicObject file, RubyBasicObject string) {
            int fd = IOPrimitiveNodes.getDescriptor(file);
            ByteList byteList = StringNodes.getByteList(string);
            if (this.getContext().getDebugStandardOut() != null && fd == STDOUT) {
                this.getContext().getDebugStandardOut().write(byteList.unsafeBytes(), byteList.begin(), byteList.length());
                return byteList.length();
            }
            ByteBuffer buffer = ByteBuffer.wrap(byteList.unsafeBytes(), byteList.begin(), byteList.length());
            int total = 0;
            while (buffer.hasRemaining()) {
                this.getContext().getSafepointManager().poll(this);
                int written = this.posix().write(fd, buffer, buffer.remaining());
                if (written == -1) {
                    throw new UnsupportedOperationException();
                }
                buffer.position(buffer.position() + written);
                total += written;
            }
            return total;
        }
    }

    @RubiniusPrimitive(name="io_reopen_path")
    public static abstract class IOReopenPathPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode resetBufferingNode;

        public IOReopenPathPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.resetBufferingNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Specialization(guards={"isRubyString(path)"})
        public Object reopenPath(VirtualFrame frame, RubyBasicObject file, RubyBasicObject path, int mode) {
            int fd;
            block6: {
                fd = IOPrimitiveNodes.getDescriptor(file);
                String pathString = path.toString();
                int otherFd = this.posix().open((CharSequence)pathString, mode, 666);
                if (otherFd < 0) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
                }
                int result = this.posix().dup2(otherFd, fd);
                if (result == -1) {
                    int errno = this.posix().errno();
                    if (errno == Errno.EBADF.intValue()) {
                        IOPrimitiveNodes.setDescriptor(file, otherFd);
                        fd = otherFd;
                        break block6;
                    } else {
                        if (otherFd > 0) {
                            this.posix().close(otherFd);
                        }
                        CompilerDirectives.transferToInterpreter();
                        throw new RaiseException(this.getContext().getCoreLibrary().errnoError(errno, this));
                    }
                }
                this.posix().close(otherFd);
            }
            int newMode = this.posix().fcntl(fd, Fcntl.F_GETFL);
            if (newMode < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            IOPrimitiveNodes.setMode(file, newMode);
            this.resetBufferingNode.call(frame, file, "reset_buffering", null, new Object[0]);
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_reopen")
    public static abstract class IOReopenPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode resetBufferingNode;

        public IOReopenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.resetBufferingNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object reopen(VirtualFrame frame, RubyBasicObject file, RubyBasicObject io) {
            int fd = IOPrimitiveNodes.getDescriptor(file);
            int fdOther = IOPrimitiveNodes.getDescriptor(io);
            int result = this.posix().dup2(fd, fdOther);
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            int mode = this.posix().fcntl(fd, Fcntl.F_GETFL);
            if (mode < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            IOPrimitiveNodes.setMode(file, mode);
            this.resetBufferingNode.call(frame, io, "reset_buffering", null, new Object[0]);
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_read_if_available")
    public static abstract class IOReadIfAvailableNode
    extends RubiniusPrimitiveNode {
        private static final FDSetFactory fdSetFactory = FDSetFactoryFactory.create();

        public IOReadIfAvailableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object readIfAvailable(RubyBasicObject file, int numberOfBytes) {
            if (numberOfBytes == 0) {
                return StringNodes.createEmptyString(this.getContext().getCoreLibrary().getStringClass());
            }
            int fd = IOPrimitiveNodes.getDescriptor(file);
            FDSet fdSet = fdSetFactory.create();
            fdSet.set(fd);
            Pointer timeout = Runtime.getSystemRuntime().getMemoryManager().allocateDirect(16);
            timeout.putLong(0L, 0L);
            timeout.putLong(8L, 0L);
            int res = this.nativeSockets().select(fd + 1, fdSet.getPointer(), PointerNodes.NULL_POINTER, PointerNodes.NULL_POINTER, timeout);
            if (res == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(Errno.EAGAIN.intValue(), this));
            }
            if (res < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.getContext().getPosix().errno(), this));
            }
            byte[] bytes = new byte[numberOfBytes];
            int bytesRead = this.getContext().getPosix().read(fd, bytes, numberOfBytes);
            if (bytesRead == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.getContext().getPosix().errno(), this));
            }
            if (bytesRead == 0) {
                return StringNodes.createEmptyString(this.getContext().getCoreLibrary().getStringClass());
            }
            return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), bytes);
        }
    }

    @RubiniusPrimitive(name="io_ensure_open")
    public static abstract class IOEnsureOpenPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOEnsureOpenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject ensureOpen(VirtualFrame frame, RubyBasicObject file) {
            int fd = IOPrimitiveNodes.getDescriptor(file);
            if (fd == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().ioError("closed stream", this));
            }
            if (fd == -2) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().ioError("shutdown stream", this));
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_fnmatch", needsSelf=false)
    public static abstract class IOFNMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOFNMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)", "isRubyString(path)"})
        public boolean fnmatch(RubyBasicObject pattern, RubyBasicObject path, int flags) {
            return Dir.fnmatch((byte[])StringNodes.getByteList(pattern).getUnsafeBytes(), (int)StringNodes.getByteList(pattern).getBegin(), (int)(StringNodes.getByteList(pattern).getBegin() + StringNodes.getByteList(pattern).getRealSize()), (byte[])StringNodes.getByteList(path).getUnsafeBytes(), (int)StringNodes.getByteList(path).getBegin(), (int)(StringNodes.getByteList(path).getBegin() + StringNodes.getByteList(path).getRealSize()), (int)flags) != 1;
        }
    }

    @RubiniusPrimitive(name="io_ftruncate")
    public static abstract class IOFTruncatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOFTruncatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int ftruncate(VirtualFrame frame, RubyBasicObject io, int length) {
            return this.ftruncate(frame, io, (long)length);
        }

        @Specialization
        public int ftruncate(VirtualFrame frame, RubyBasicObject io, long length) {
            int fd = IOPrimitiveNodes.getDescriptor(io);
            return this.posix().ftruncate(fd, length);
        }
    }

    @RubiniusPrimitive(name="io_truncate", needsSelf=false)
    public static abstract class IOTruncatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOTruncatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(path)"})
        public int truncate(RubyBasicObject path, int length) {
            return this.truncate(path, (long)length);
        }

        @Specialization(guards={"isRubyString(path)"})
        public int truncate(RubyBasicObject path, long length) {
            ByteList byteList = StringNodes.getByteList(path);
            String pathString = RubyEncoding.decodeUTF8((byte[])byteList.getUnsafeBytes(), (int)byteList.getBegin(), (int)byteList.getRealSize());
            int result = this.posix().truncate((CharSequence)pathString, length);
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }

    @RubiniusPrimitive(name="io_open", needsSelf=false)
    public static abstract class IOOpenPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOOpenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(path)"})
        public int open(RubyBasicObject path, int mode, int permission) {
            return this.posix().open((CharSequence)StringNodes.getByteList(path), mode, permission);
        }
    }

    @RubiniusPrimitive(name="io_connect_pipe", needsSelf=false)
    public static abstract class IOConnectPipeNode
    extends RubiniusPrimitiveNode {
        private final int RDONLY;
        private final int WRONLY;

        public IOConnectPipeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.RDONLY = (Integer)context.getRubiniusConfiguration().get("rbx.platform.file.O_RDONLY");
            this.WRONLY = (Integer)context.getRubiniusConfiguration().get("rbx.platform.file.O_WRONLY");
        }

        @Specialization
        public boolean connectPipe(VirtualFrame frame, RubyBasicObject lhs, RubyBasicObject rhs) {
            int[] fds = new int[2];
            if (this.posix().pipe(fds) == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            this.newOpenFd(fds[0]);
            this.newOpenFd(fds[1]);
            IOPrimitiveNodes.setDescriptor(lhs, fds[0]);
            IOPrimitiveNodes.setMode(lhs, this.RDONLY);
            IOPrimitiveNodes.setDescriptor(rhs, fds[1]);
            IOPrimitiveNodes.setMode(rhs, this.WRONLY);
            return true;
        }

        private void newOpenFd(int newFd) {
            boolean FD_CLOEXEC = true;
            if (newFd > 2) {
                int flags = this.posix().fcntl(newFd, Fcntl.F_GETFD);
                if (flags == -1) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
                }
                flags = this.posix().fcntlInt(newFd, Fcntl.F_SETFD, flags | 1);
                if (flags == -1) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
                }
            }
        }
    }

    @RubiniusPrimitive(name="io_allocate")
    public static abstract class IOAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode newBufferNode;

        public IOAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.newBufferNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public RubyBasicObject allocate(VirtualFrame frame, RubyClass classToAllocate) {
            Object buffer = this.newBufferNode.call(frame, this.getContext().getCoreLibrary().getIOBufferClass(), "new", null, new Object[0]);
            return new RubyBasicObject(classToAllocate, IO_FACTORY.newInstance(new Object[]{buffer, 0, 0, 0}));
        }
    }

    public static class IOAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyBasicObject(rubyClass, IO_FACTORY.newInstance(new Object[]{context.getCoreLibrary().getNilObject(), 0, 0, 0}));
        }
    }
}

