/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.hash.HashNode;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashLookupResult;

public class LookupEntryNode
extends RubyNode {
    @Node.Child
    HashNode hashNode;
    @Node.Child
    CallDispatchHeadNode eqlNode;
    @Node.Child
    BasicObjectNodes.ReferenceEqualNode equalNode;
    private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();

    public LookupEntryNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = new HashNode(context, sourceSection);
        this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
    }

    public HashLookupResult lookup(VirtualFrame frame, RubyBasicObject hash, Object key) {
        int hashed = this.hashNode.hash(frame, key);
        Entry[] entries = (Entry[])HashNodes.getStore(hash);
        int index = BucketsStrategy.getBucketIndex(hashed, entries.length);
        Entry previousEntry = null;
        for (Entry entry = entries[index]; entry != null; entry = entry.getNextInLookup()) {
            if (this.byIdentityProfile.profile(HashNodes.isCompareByIdentity(hash)) ? this.equalNode.executeReferenceEqual(frame, key, entry.getKey()) : this.eqlNode.callBoolean(frame, key, "eql?", null, entry.getKey())) {
                return new HashLookupResult(hashed, index, previousEntry, entry);
            }
            previousEntry = entry;
        }
        return new HashLookupResult(hashed, index, previousEntry, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }
}

