/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array")})
public abstract class PopOneNode
extends RubyNode {
    public PopOneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executePopOne(RubyBasicObject var1);

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public RubyBasicObject popOneEmpty(RubyBasicObject array) {
        return this.nil();
    }

    @Specialization(guards={"isRubyArray(array)", "!isEmptyArray(array)", "isIntArray(array)"})
    public Object popOneInteger(RubyBasicObject array) {
        return this.popOneGeneric(array, ArrayMirror.reflect((int[])ArrayNodes.getStore(array)));
    }

    @Specialization(guards={"isRubyArray(array)", "!isEmptyArray(array)", "isLongArray(array)"})
    public Object popOneLong(RubyBasicObject array) {
        return this.popOneGeneric(array, ArrayMirror.reflect((long[])ArrayNodes.getStore(array)));
    }

    @Specialization(guards={"isRubyArray(array)", "!isEmptyArray(array)", "isDoubleArray(array)"})
    public Object popOneDouble(RubyBasicObject array) {
        return this.popOneGeneric(array, ArrayMirror.reflect((double[])ArrayNodes.getStore(array)));
    }

    @Specialization(guards={"isRubyArray(array)", "!isEmptyArray(array)", "isObjectArray(array)"})
    public Object popOneObject(RubyBasicObject array) {
        return this.popOneGeneric(array, ArrayMirror.reflect((Object[])ArrayNodes.getStore(array)));
    }

    private Object popOneGeneric(RubyBasicObject array, ArrayMirror storeMirror) {
        int size = ArrayNodes.getSize(array);
        Object value = storeMirror.get(size - 1);
        ArrayNodes.setSize(array, size - 1);
        return value;
    }
}

