/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.interop.TruffleObject;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.MethodNodes;
import org.jruby.truffle.nodes.core.MutexNodes;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.core.UnboundMethodNodes;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.nodes.ext.BigDecimalNodes;
import org.jruby.truffle.nodes.rubinius.ByteArrayNodes;
import org.jruby.truffle.nodes.rubinius.PointerNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.ThreadLocalObject;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyEncodingConverter;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubyTime;

public abstract class RubyGuards {
    public static boolean isBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static boolean isInteger(Object value) {
        return value instanceof Integer;
    }

    public static boolean isLong(Object value) {
        return value instanceof Long;
    }

    public static boolean isDouble(Object value) {
        return value instanceof Double;
    }

    public static boolean isRubyBignum(Object value) {
        return value instanceof RubyBasicObject && RubyGuards.isRubyBignum((RubyBasicObject)value);
    }

    public static boolean isRubyBignum(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == BignumNodes.BIGNUM_TYPE;
    }

    public static boolean isRubyBigDecimal(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == BigDecimalNodes.BIG_DECIMAL_TYPE;
    }

    public static boolean isIntegerFixnumRange(Object value) {
        return value instanceof RubyRange.IntegerFixnumRange;
    }

    public static boolean isRubyRange(Object value) {
        return value instanceof RubyRange;
    }

    public static boolean isRubyArray(Object value) {
        return value instanceof RubyBasicObject && RubyGuards.isRubyArray((RubyBasicObject)value);
    }

    public static boolean isRubyArray(RubyBasicObject value) {
        return value instanceof RubyArray;
    }

    public static boolean isRubyBinding(Object value) {
        return value instanceof RubyBinding;
    }

    public static boolean isRubyClass(Object value) {
        return value instanceof RubyClass;
    }

    public static boolean isRubyHash(Object value) {
        return value instanceof RubyBasicObject && RubyGuards.isRubyHash((RubyBasicObject)value);
    }

    public static boolean isRubyHash(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == HashNodes.HASH_TYPE;
    }

    public static boolean isRubyModule(Object value) {
        return value instanceof RubyModule;
    }

    public static boolean isRubyRegexp(Object value) {
        return value instanceof RubyRegexp;
    }

    public static boolean isRubyString(Object value) {
        return value instanceof RubyBasicObject && RubyGuards.isRubyString((RubyBasicObject)value);
    }

    public static boolean isRubyString(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == StringNodes.STRING_TYPE;
    }

    public static boolean isRubyEncoding(Object value) {
        return value instanceof RubyEncoding;
    }

    public static boolean isRubySymbol(Object value) {
        return value instanceof RubyBasicObject && RubyGuards.isRubySymbol((RubyBasicObject)value);
    }

    public static boolean isRubySymbol(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == SymbolNodes.SYMBOL_TYPE;
    }

    public static boolean isRubyMethod(Object value) {
        return value instanceof RubyBasicObject && RubyGuards.isRubyMethod((RubyBasicObject)value);
    }

    public static boolean isRubyMethod(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == MethodNodes.METHOD_TYPE;
    }

    public static boolean isRubyUnboundMethod(Object value) {
        return value instanceof RubyBasicObject && RubyGuards.isRubyUnboundMethod((RubyBasicObject)value);
    }

    public static boolean isRubyUnboundMethod(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == UnboundMethodNodes.UNBOUND_METHOD_TYPE;
    }

    public static boolean isRubyMutex(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == MutexNodes.MUTEX_TYPE;
    }

    public static boolean isRubyBasicObject(Object value) {
        return value instanceof RubyBasicObject;
    }

    public static boolean isRubyPointer(Object value) {
        return value instanceof RubyBasicObject && RubyGuards.isRubyPointer((RubyBasicObject)value);
    }

    public static boolean isRubyPointer(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == PointerNodes.POINTER_TYPE;
    }

    public static boolean isRubiniusByteArray(Object value) {
        return value instanceof RubyBasicObject && RubyGuards.isRubiniusByteArray((RubyBasicObject)value);
    }

    public static boolean isRubiniusByteArray(RubyBasicObject value) {
        return value.getDynamicObject().getShape().getObjectType() == ByteArrayNodes.BYTE_ARRAY_TYPE;
    }

    public static boolean isRubyProc(Object value) {
        return value instanceof RubyProc;
    }

    public static boolean isRubyEncodingConverter(RubyBasicObject encodingConverter) {
        return encodingConverter instanceof RubyEncodingConverter;
    }

    public static boolean isRubyTime(RubyBasicObject time) {
        return time instanceof RubyTime;
    }

    public static boolean isThreadLocal(Object value) {
        return value instanceof ThreadLocalObject;
    }

    public static boolean isForeignObject(Object object) {
        return object instanceof TruffleObject && !(object instanceof RubyBasicObject);
    }

    public static boolean wasProvided(Object value) {
        return !RubyGuards.wasNotProvided(value);
    }

    public static boolean wasNotProvided(Object value) {
        return value == NotProvided.INSTANCE;
    }

    public static boolean isNaN(double value) {
        return Double.isNaN(value);
    }

    public static boolean isInfinity(double value) {
        return Double.isInfinite(value);
    }
}

