/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.backtrace;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.backtrace.DebugBacktraceFormatter;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class ImplementationDebugBacktraceFormatter
implements BacktraceFormatter {
    @Override
    public String[] format(RubyContext context, RubyException exception, Backtrace backtrace) {
        try {
            List<Activation> activations = backtrace.getActivations();
            ArrayList<String> lines = new ArrayList<String>();
            if (exception != null) {
                lines.add(String.format("%s (%s)", exception.getMessage(), exception.getLogicalClass().getName()));
            }
            for (Activation activation : activations) {
                ImplementationDebugBacktraceFormatter.formatActivation(context, activation, lines);
            }
            return lines.toArray(new String[lines.size()]);
        }
        catch (Exception e) {
            throw new TruffleFatalException("Exception while trying to format a Ruby call stack", e);
        }
    }

    private static void formatActivation(RubyContext context, Activation activation, List<String> lines) {
        lines.add(DebugBacktraceFormatter.formatBasicLine(activation));
        MaterializedFrame frame = activation.getMaterializedFrame();
        Object[] arguments = frame.getArguments();
        InternalMethod method = RubyArguments.getMethod(arguments);
        lines.add(String.format("      method = %s", method));
        lines.add("      declaration frame:");
        ImplementationDebugBacktraceFormatter.formatDeclarationFrame(context, RubyArguments.getDeclarationFrame(arguments), lines);
        lines.add(String.format("      self = %s", DebugBacktraceFormatter.debugString(context, RubyArguments.getSelf(arguments))));
        lines.add(String.format("      block = %s", RubyArguments.getBlock(arguments)));
        lines.add("      arguments:");
        for (int n = 0; n < RubyArguments.getUserArgumentsCount(arguments); ++n) {
            lines.add(String.format("        [%d] = %s", n, DebugBacktraceFormatter.debugString(context, RubyArguments.getUserArgument(arguments, n))));
        }
        lines.add("      frame:");
        ImplementationDebugBacktraceFormatter.formatFrame(context, frame, lines);
    }

    private static void formatDeclarationFrame(RubyContext context, MaterializedFrame frame, List<String> lines) {
        if (frame != null) {
            ImplementationDebugBacktraceFormatter.formatDeclarationFrame(context, RubyArguments.getDeclarationFrame(frame.getArguments()), lines);
            ImplementationDebugBacktraceFormatter.formatFrame(context, frame, lines);
        }
    }

    private static void formatFrame(RubyContext context, MaterializedFrame frame, List<String> lines) {
        FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
        for (Object identifier : frameDescriptor.getIdentifiers()) {
            lines.add(String.format("        %s = %s", identifier, DebugBacktraceFormatter.debugString(context, frame.getValue(frameDescriptor.findFrameSlot(identifier)))));
        }
    }
}

