/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.yield;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyProc;

public class YieldNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] arguments;
    @Node.Child
    private YieldDispatchHeadNode dispatch;
    private final boolean unsplat;

    public YieldNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments, boolean unsplat) {
        super(context, sourceSection);
        this.arguments = arguments;
        this.dispatch = new YieldDispatchHeadNode(this.getContext());
        this.unsplat = unsplat;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        RubyProc block = RubyArguments.getBlock(frame.getArguments());
        if (block == null) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().noBlockToYieldTo(this));
        }
        if (this.unsplat) {
            argumentsObjects = this.unsplat(argumentsObjects);
        }
        return this.dispatch.dispatch(frame, block, argumentsObjects);
    }

    @CompilerDirectives.TruffleBoundary
    private Object[] unsplat(Object[] argumentsObjects) {
        assert (argumentsObjects.length == 1);
        assert (RubyGuards.isRubyArray(argumentsObjects[0]));
        return ArrayNodes.slowToArray((RubyBasicObject)argumentsObjects[0]);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (RubyArguments.getBlock(frame.getArguments()) == null) {
            return this.nil();
        }
        return this.createString("yield");
    }
}

