/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.time;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.constants.ReadConstantNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyString;

public class ReadTimeZoneNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode hashNode;
    @Node.Child
    private ReadConstantNode envNode;
    private final RubyBasicObject TZ;

    public ReadTimeZoneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.envNode = new ReadConstantNode(context, sourceSection, "ENV", new LiteralNode(context, sourceSection, this.getContext().getCoreLibrary().getObjectClass()), LexicalScope.NONE);
        this.TZ = this.createString("TZ");
    }

    @Override
    public RubyString executeRubyString(VirtualFrame frame) {
        Object tz = this.hashNode.call(frame, this.envNode.execute(frame), "[]", null, this.TZ);
        if (tz == this.nil()) {
            return (RubyString)this.createString("UTC");
        }
        if (tz instanceof RubyString) {
            return (RubyString)tz;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeRubyString(frame);
    }
}

