/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.methods.CallMethodNode;
import org.jruby.truffle.nodes.methods.CallMethodNodeGen;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNode;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class GeneralSuperCallNode
extends RubyNode {
    private final boolean isSplatted;
    @Node.Child
    private RubyNode block;
    @Node.Children
    private final RubyNode[] arguments;
    @Node.Child
    LookupSuperMethodNode lookupSuperMethodNode;
    @Node.Child
    CallMethodNode callMethodNode;

    public GeneralSuperCallNode(RubyContext context, SourceSection sourceSection, RubyNode block, RubyNode[] arguments, boolean isSplatted) {
        super(context, sourceSection);
        assert (arguments != null);
        assert (!isSplatted || arguments.length == 1);
        this.block = block;
        this.arguments = arguments;
        this.isSplatted = isSplatted;
        this.lookupSuperMethodNode = LookupSuperMethodNodeGen.create(context, sourceSection, null);
        this.callMethodNode = CallMethodNodeGen.create(context, sourceSection, null, new RubyNode[0]);
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object blockTempObject;
        CompilerAsserts.compilationConstant((Object)this.arguments.length);
        Object self = RubyArguments.getSelf(frame.getArguments());
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        RubyProc blockObject = this.block != null ? ((blockTempObject = this.block.execute(frame)) == this.nil() ? null : (RubyProc)blockTempObject) : null;
        Object[] argumentsArray = this.isSplatted ? ArrayNodes.slowToArray((RubyBasicObject)argumentsObjects[0]) : argumentsObjects;
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            CompilerDirectives.transferToInterpreter();
            String name = RubyArguments.getMethod(frame.getArguments()).getSharedMethodInfo().getName();
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(String.format("super: no superclass method `%s'", name), name, this));
        }
        Object[] frameArguments = RubyArguments.pack(superMethod, superMethod.getDeclarationFrame(), self, blockObject, argumentsArray);
        return this.callMethodNode.executeCallMethod(frame, superMethod, frameArguments);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame.getArguments());
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            return this.nil();
        }
        return this.createString("super");
    }
}

