/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.kenai.jffi.MemoryIO;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import jnr.ffi.Pointer;
import org.jruby.truffle.nodes.core.PointerGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.rubinius.PointerNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.rubinius.RubiniusTypes;
import org.jruby.util.ByteList;
import org.jruby.util.unsafe.UnsafeHolder;

public abstract class PointerPrimitiveNodes {

    @RubiniusPrimitive(name="pointer_write_int")
    public static abstract class PointerWriteIntPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerWriteIntPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject address(RubyBasicObject pointer, int value) {
            PointerNodes.getPointer(pointer).putInt(0L, value);
            return pointer;
        }
    }

    @RubiniusPrimitive(name="pointer_read_string_to_null")
    @ImportStatic(value={PointerGuards.class})
    public static abstract class PointerReadStringToNullPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerReadStringToNullPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullPointer(pointer)"})
        public RubyBasicObject readNullPointer(RubyBasicObject pointer) {
            return StringNodes.createEmptyString(this.getContext().getCoreLibrary().getStringClass());
        }

        @Specialization(guards={"!isNullPointer(pointer)"})
        public RubyBasicObject readStringToNull(RubyBasicObject pointer) {
            return this.createString(MemoryIO.getInstance().getZeroTerminatedByteArray(PointerNodes.getPointer(pointer).address()));
        }
    }

    @RubiniusPrimitive(name="pointer_write_string")
    public static abstract class PointerWriteStringPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerWriteStringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject address(RubyBasicObject pointer, RubyString string, int maxLength) {
            ByteList bytes = StringNodes.getByteList(string);
            int length = Math.min(bytes.length(), maxLength);
            PointerNodes.getPointer(pointer).put(0L, bytes.unsafeBytes(), bytes.begin(), length);
            return pointer;
        }
    }

    @RubiniusPrimitive(name="pointer_get_at_offset")
    @ImportStatic(value={RubiniusTypes.class})
    public static abstract class PointerGetAtOffsetPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerGetAtOffsetPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"type == TYPE_CHAR"})
        public int getAtOffsetChar(RubyBasicObject pointer, int offset, int type) {
            return PointerNodes.getPointer(pointer).getByte((long)offset);
        }

        @Specialization(guards={"type == TYPE_UCHAR"})
        public int getAtOffsetUChar(RubyBasicObject pointer, int offset, int type) {
            return PointerNodes.getPointer(pointer).getByte((long)offset);
        }

        @Specialization(guards={"type == TYPE_INT"})
        public int getAtOffsetInt(RubyBasicObject pointer, int offset, int type) {
            return PointerNodes.getPointer(pointer).getInt((long)offset);
        }

        @Specialization(guards={"type == TYPE_SHORT"})
        public int getAtOffsetShort(RubyBasicObject pointer, int offset, int type) {
            return PointerNodes.getPointer(pointer).getShort((long)offset);
        }

        @Specialization(guards={"type == TYPE_USHORT"})
        public int getAtOffsetUShort(RubyBasicObject pointer, int offset, int type) {
            return PointerNodes.getPointer(pointer).getShort((long)offset);
        }

        @Specialization(guards={"type == TYPE_LONG"})
        public long getAtOffsetLong(RubyBasicObject pointer, int offset, int type) {
            return PointerNodes.getPointer(pointer).getLong((long)offset);
        }

        @Specialization(guards={"type == TYPE_ULONG"})
        public long getAtOffsetULong(RubyBasicObject pointer, int offset, int type) {
            return PointerNodes.getPointer(pointer).getLong((long)offset);
        }

        @Specialization(guards={"type == TYPE_ULL"})
        public long getAtOffsetULL(RubyBasicObject pointer, int offset, int type) {
            return PointerNodes.getPointer(pointer).getLongLong((long)offset);
        }

        @Specialization(guards={"type == TYPE_STRING"})
        public RubyBasicObject getAtOffsetString(RubyBasicObject pointer, int offset, int type) {
            return this.createString(PointerNodes.getPointer(pointer).getString((long)offset));
        }

        @Specialization(guards={"type == TYPE_PTR"})
        public RubyBasicObject getAtOffsetPointer(RubyBasicObject pointer, int offset, int type) {
            Pointer readPointer = PointerNodes.getPointer(pointer).getPointer((long)offset);
            if (readPointer == null) {
                return this.nil();
            }
            return PointerNodes.createPointer(pointer.getLogicalClass(), readPointer);
        }
    }

    @RubiniusPrimitive(name="pointer_address")
    public static abstract class PointerAddressPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerAddressPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long address(RubyBasicObject pointer) {
            return PointerNodes.getPointer(pointer).address();
        }
    }

    @RubiniusPrimitive(name="pointer_read_pointer")
    public static abstract class PointerReadPointerPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerReadPointerPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject readPointer(RubyBasicObject pointer) {
            return PointerNodes.createPointer(pointer.getLogicalClass(), PointerNodes.getPointer(pointer).getPointer(0L));
        }
    }

    @RubiniusPrimitive(name="pointer_set_at_offset", lowerFixnumParameters={0, 1})
    @ImportStatic(value={RubiniusTypes.class})
    public static abstract class PointerSetAtOffsetPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerSetAtOffsetPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"type == TYPE_INT"})
        public int setAtOffsetInt(RubyBasicObject pointer, int offset, int type, int value) {
            PointerNodes.getPointer(pointer).putInt((long)offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_LONG"})
        public long setAtOffsetLong(RubyBasicObject pointer, int offset, int type, long value) {
            PointerNodes.getPointer(pointer).putLong((long)offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_ULONG"})
        public long setAtOffsetULong(RubyBasicObject pointer, int offset, int type, long value) {
            PointerNodes.getPointer(pointer).putLong((long)offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_ULL"})
        public long setAtOffsetULL(RubyBasicObject pointer, int offset, int type, long value) {
            PointerNodes.getPointer(pointer).putLongLong((long)offset, value);
            return value;
        }
    }

    @RubiniusPrimitive(name="pointer_set_autorelease")
    public static abstract class PointerSetAutoreleasePrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerSetAutoreleasePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean setAutorelease(RubyBasicObject pointer, boolean autorelease) {
            return autorelease;
        }
    }

    @RubiniusPrimitive(name="pointer_read_string", lowerFixnumParameters={0})
    public static abstract class PointerReadStringPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerReadStringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject readString(RubyBasicObject pointer, int length) {
            byte[] bytes = new byte[length];
            PointerNodes.getPointer(pointer).get(0L, bytes, 0, length);
            return this.createString(bytes);
        }
    }

    @RubiniusPrimitive(name="pointer_read_int")
    public static abstract class PointerReadIntPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerReadIntPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSigned(signed)"})
        public int readInt(RubyBasicObject pointer, boolean signed) {
            return PointerNodes.getPointer(pointer).getInt(0L);
        }

        protected boolean isSigned(boolean signed) {
            return signed;
        }
    }

    @RubiniusPrimitive(name="pointer_add")
    public static abstract class PointerAddPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerAddPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject add(RubyBasicObject a, int b) {
            return this.add(a, (long)b);
        }

        @Specialization
        public RubyBasicObject add(RubyBasicObject a, long b) {
            return PointerNodes.createPointer(a.getLogicalClass(), this.getMemoryManager().newPointer(PointerNodes.getPointer(a).address() + b));
        }
    }

    @RubiniusPrimitive(name="pointer_set_address")
    public static abstract class PointerSetAddressPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerSetAddressPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long setAddress(RubyBasicObject pointer, int address) {
            return this.setAddress(pointer, (long)address);
        }

        @Specialization
        public long setAddress(RubyBasicObject pointer, long address) {
            PointerNodes.setPointer(pointer, this.getMemoryManager().newPointer(address));
            return address;
        }
    }

    @RubiniusPrimitive(name="pointer_free")
    public static abstract class PointerFreePrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerFreePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject free(RubyBasicObject pointer) {
            UnsafeHolder.U.freeMemory(PointerNodes.getPointer(pointer).address());
            return pointer;
        }
    }

    @RubiniusPrimitive(name="pointer_malloc")
    public static abstract class PointerMallocPrimitiveNode
    extends RubiniusPrimitiveNode {
        public PointerMallocPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject malloc(RubyClass pointerClass, int size) {
            return this.malloc(pointerClass, (long)size);
        }

        @Specialization
        public RubyBasicObject malloc(RubyClass pointerClass, long size) {
            return PointerNodes.createPointer(pointerClass, this.getMemoryManager().newPointer(UnsafeHolder.U.allocateMemory(size)));
        }
    }
}

