/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.object.BasicObjectType;
import org.jruby.util.ByteList;

@CoreClass(name="Rubinius::ByteArray")
public abstract class ByteArrayNodes {
    public static final ByteArrayType BYTE_ARRAY_TYPE = new ByteArrayType();
    private static final HiddenKey BYTES_IDENTIFIER = new HiddenKey("bytes");
    public static final Property BYTES_PROPERTY;
    private static final DynamicObjectFactory BYTE_ARRAY_FACTORY;

    public static RubyBasicObject createByteArray(RubyClass rubyClass, ByteList bytes) {
        return new RubyBasicObject(rubyClass, BYTE_ARRAY_FACTORY.newInstance(new Object[]{bytes}));
    }

    public static ByteList getBytes(RubyBasicObject byteArray) {
        assert (RubyGuards.isRubiniusByteArray(byteArray));
        assert (byteArray.getDynamicObject().getShape().hasProperty((Object)BYTES_IDENTIFIER));
        return (ByteList)BYTES_PROPERTY.get(byteArray.getDynamicObject(), true);
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        BYTES_PROPERTY = Property.create((Object)BYTES_IDENTIFIER, (Location)allocator.locationForType(ByteList.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), (int)0);
        Shape shape = RubyBasicObject.LAYOUT.createShape((ObjectType)BYTE_ARRAY_TYPE).addProperty(BYTES_PROPERTY);
        BYTE_ARRAY_FACTORY = shape.createFactory();
    }

    @CoreMethod(names={"locate"}, required=3, lowerFixnumParameters={1, 2})
    public static abstract class LocateNode
    extends CoreMethodArrayArgumentsNode {
        public LocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getByte(RubyBasicObject bytes, RubyString pattern, int start, int length) {
            int index = new ByteList(ByteArrayNodes.getBytes(bytes), start, length).indexOf(StringNodes.getByteList(pattern));
            if (index == -1) {
                return this.nil();
            }
            return start + index + StringNodes.length(pattern);
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size(RubyBasicObject bytes) {
            return ByteArrayNodes.getBytes(bytes).getRealSize();
        }
    }

    @CoreMethod(names={"set_byte"}, required=2, lowerFixnumParameters={0, 1})
    public static abstract class SetByteNode
    extends CoreMethodArrayArgumentsNode {
        public SetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setByte(RubyBasicObject bytes, int index, int value) {
            if (index < 0 || index >= ByteArrayNodes.getBytes(bytes).getRealSize()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError("index out of bounds", this));
            }
            ByteArrayNodes.getBytes(bytes).set(index, value);
            return ByteArrayNodes.getBytes(bytes).get(index);
        }
    }

    @CoreMethod(names={"prepend"}, required=1)
    public static abstract class PrependNode
    extends CoreMethodArrayArgumentsNode {
        public PrependNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject prepend(RubyBasicObject bytes, RubyString string) {
            int prependLength = StringNodes.getByteList(string).getUnsafeBytes().length;
            int originalLength = ByteArrayNodes.getBytes(bytes).getUnsafeBytes().length;
            int newLength = prependLength + originalLength;
            byte[] prependedBytes = new byte[newLength];
            System.arraycopy(StringNodes.getByteList(string).getUnsafeBytes(), 0, prependedBytes, 0, prependLength);
            System.arraycopy(ByteArrayNodes.getBytes(bytes).getUnsafeBytes(), 0, prependedBytes, prependLength, originalLength);
            return ByteArrayNodes.createByteArray(this.getContext().getCoreLibrary().getByteArrayClass(), new ByteList(prependedBytes));
        }
    }

    @CoreMethod(names={"get_byte"}, required=1, lowerFixnumParameters={0})
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        public GetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int getByte(RubyBasicObject bytes, int index) {
            return ByteArrayNodes.getBytes(bytes).get(index);
        }
    }

    public static class ByteArrayType
    extends BasicObjectType {
    }
}

