/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.fixnum;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.GeneralDivModNode;
import org.jruby.truffle.nodes.core.fixnum.FixnumNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@CoreClass(name="Fixnum")
public abstract class FixnumNodes {
    private static final int BITS = 64;

    @CoreMethod(names={"zero?"})
    public static abstract class ZeroNode
    extends CoreMethodArrayArgumentsNode {
        public ZeroNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean zero(int n) {
            return n == 0;
        }

        @Specialization
        public boolean zero(long n) {
            return n == 0L;
        }
    }

    @CoreMethod(names={"to_s"}, optional=1)
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject toS(int n, NotProvided base) {
            return this.createString(Integer.toString(n), (Encoding)USASCIIEncoding.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject toS(long n, NotProvided base) {
            return this.createString(Long.toString(n), (Encoding)USASCIIEncoding.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject toS(long n, int base) {
            if (base < 2 || base > 36) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorInvalidRadix(base, this));
            }
            return this.createString(Long.toString(n, base), (Encoding)USASCIIEncoding.INSTANCE);
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double toF(int n) {
            return n;
        }

        @Specialization
        public double toF(long n) {
            return n;
        }
    }

    @CoreMethod(names={"size"}, needsSelf=false)
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size() {
            return 8;
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodArrayArgumentsNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject inspect(int n) {
            return this.createString(Integer.toString(n), (Encoding)USASCIIEncoding.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject inspect(long n) {
            return this.createString(Long.toString(n), (Encoding)USASCIIEncoding.INSTANCE);
        }
    }

    @CoreMethod(names={"floor"})
    public static abstract class FloorNode
    extends CoreMethodArrayArgumentsNode {
        public FloorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int floor(int n) {
            return n;
        }

        @Specialization
        public long floor(long n) {
            return n;
        }
    }

    @CoreMethod(names={"bit_length"})
    public static abstract class BitLengthNode
    extends CoreMethodArrayArgumentsNode {
        private static final int INT_BITS = Integer.numberOfLeadingZeros(0);
        private static final int LONG_BITS = Long.numberOfLeadingZeros(0L);

        public BitLengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int bitLength(int n) {
            if (n < 0) {
                n ^= 0xFFFFFFFF;
            }
            return INT_BITS - Integer.numberOfLeadingZeros(n);
        }

        @Specialization
        public int bitLength(long n) {
            if (n < 0L) {
                n ^= 0xFFFFFFFFFFFFFFFFL;
            }
            return LONG_BITS - Long.numberOfLeadingZeros(n);
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends CoreMethodArrayArgumentsNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int absIntInBounds(int n) {
            return n < 0 ? ExactMath.subtractExact((int)0, (int)n) : n;
        }

        @Specialization(contains={"absIntInBounds"})
        public Object abs(int n) {
            if (n == Integer.MIN_VALUE) {
                return -((long)n);
            }
            return n < 0 ? -n : n;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long absInBounds(long n) {
            return n < 0L ? ExactMath.subtractExact((long)0L, (long)n) : n;
        }

        @Specialization(contains={"absInBounds"})
        public Object abs(long n) {
            if (n == Long.MIN_VALUE) {
                return BignumNodes.createRubyBignum(this.getContext().getCoreLibrary().getBignumClass(), BigInteger.valueOf(n).abs());
            }
            return n < 0L ? -n : n;
        }
    }

    @CoreMethod(names={">>"}, required=1, lowerFixnumParameters={0})
    public static abstract class RightShiftNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;
        @Node.Child
        private LeftShiftNode leftShiftNode;

        public RightShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        protected abstract Object executeRightShift(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public Object rightShift(VirtualFrame frame, int a, int b) {
            if (b > 0) {
                if (b >= 63) {
                    if (a < 0) {
                        return -1;
                    }
                    return 0;
                }
                return a >> b;
            }
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = (LeftShiftNode)this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, -b);
        }

        @Specialization
        public Object rightShift(VirtualFrame frame, int a, long b) {
            if (b > 0L) {
                if (b >= 63L) {
                    if (a < 0) {
                        return -1;
                    }
                    return 0;
                }
                return a >> (int)b;
            }
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = (LeftShiftNode)this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, -b);
        }

        @Specialization
        public Object rightShift(VirtualFrame frame, long a, int b) {
            if (b > 0) {
                if (b >= 63) {
                    if (a < 0L) {
                        return -1;
                    }
                    return 0;
                }
                return a >> b;
            }
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = (LeftShiftNode)this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, -b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int rightShift(int a, RubyBasicObject b) {
            return 0;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int rightShift(long a, RubyBasicObject b) {
            return 0;
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)"})
        public Object rightShiftFallback(VirtualFrame frame, Object a, Object b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            return this.fallbackCallNode.call(frame, a, "right_shift_fallback", null, b);
        }
    }

    @CoreMethod(names={"<<"}, required=1, lowerFixnumParameters={0})
    public static abstract class LeftShiftNode
    extends BignumNodes.BignumCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        protected Object lower(BigInteger value) {
            return this.fixnumOrBignum(value);
        }

        public abstract Object executeLeftShift(VirtualFrame var1, Object var2, Object var3);

        @Specialization(guards={"isPositive(b)", "canShiftIntoInt(a, b)"})
        public int leftShift(int a, int b) {
            return a << b;
        }

        @Specialization(guards={"isPositive(b)", "canShiftIntoInt(a, b)"})
        public int leftShift(int a, long b) {
            return a << (int)b;
        }

        @Specialization(guards={"isStrictlyNegative(b)"})
        public int leftShiftNeg(int a, int b) {
            if (-b >= 32) {
                return 0;
            }
            if (b == Integer.MIN_VALUE) {
                return 0;
            }
            return a >> -b;
        }

        @Specialization(guards={"isPositive(b)", "canShiftIntoLong(a, b)"})
        public long leftShiftToLong(long a, int b) {
            return a << b;
        }

        @Specialization(guards={"isPositive(b)"})
        public Object leftShiftWithOverflow(long a, int b) {
            if (LeftShiftNode.canShiftIntoLong(a, b)) {
                return this.leftShiftToLong(a, b);
            }
            return this.lower(BigInteger.valueOf(a).shiftLeft(b));
        }

        @Specialization(guards={"isStrictlyNegative(b)"})
        public long leftShiftNeg(long a, int b) {
            if (-b >= 32) {
                return 0L;
            }
            return a >> -b;
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)"})
        public Object leftShiftFallback(VirtualFrame frame, Object a, Object b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            return this.fallbackCallNode.call(frame, a, "left_shift_fallback", null, b);
        }

        static boolean canShiftIntoInt(int a, int b) {
            return Integer.numberOfLeadingZeros(a) - b > 0;
        }

        static boolean canShiftIntoInt(int a, long b) {
            return (long)Integer.numberOfLeadingZeros(a) - b > 0L;
        }

        static boolean canShiftIntoLong(int a, int b) {
            return LeftShiftNode.canShiftIntoLong((long)a, b);
        }

        static boolean canShiftIntoLong(long a, int b) {
            return Long.numberOfLeadingZeros(a) - b > 0;
        }

        static boolean isPositive(int value) {
            return value >= 0;
        }

        static boolean isPositive(long value) {
            return value >= 0L;
        }

        static boolean isStrictlyNegative(int value) {
            return value < 0;
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends BignumNodes.BignumCoreMethodNode {
        public BitXOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int bitXOr(int a, int b) {
            return a ^ b;
        }

        @Specialization
        public long bitXOr(long a, long b) {
            return a ^ b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitXOr(long a, RubyBasicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).xor(BignumNodes.getBigIntegerValue(b)));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object bitXOr(VirtualFrame frame, Object a, RubyBasicObject b) {
            return this.ruby(frame, "a ^ Rubinius::Type.coerce_to_bitwise_operand(b)", "a", a, "b", b);
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends BignumNodes.BignumCoreMethodNode {
        public BitOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int bitOr(int a, int b) {
            return a | b;
        }

        @Specialization
        public long bitOr(long a, long b) {
            return a | b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitOr(long a, RubyBasicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).or(BignumNodes.getBigIntegerValue(b)));
        }
    }

    @CoreMethod(names={"&"}, required=1)
    public static abstract class BitAndNode
    extends BignumNodes.BignumCoreMethodNode {
        public BitAndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int bitAnd(int a, int b) {
            return a & b;
        }

        @Specialization
        public long bitAnd(long a, long b) {
            return a & b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object bitAnd(long a, RubyBasicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).and(BignumNodes.getBigIntegerValue(b)));
        }
    }

    @CoreMethod(names={"~"})
    public static abstract class ComplementNode
    extends CoreMethodArrayArgumentsNode {
        public ComplementNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int complement(int n) {
            return ~n;
        }

        @Specialization
        public long complement(long n) {
            return n ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @CoreMethod(names={">"}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class GreaterNode
    extends CoreMethodArrayArgumentsNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean greater(int a, int b) {
            return a > b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greater(int a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b)) > 0;
        }

        @Specialization
        public boolean greater(long a, long b) {
            return a > b;
        }

        @Specialization
        public boolean greater(long a, double b) {
            return (double)a > b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greater(long a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b)) > 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterCoerced(VirtualFrame frame, long a, Object b) {
            return this.ruby(frame, "b, a = math_coerce(other, :compare_error); a > b", "other", b);
        }
    }

    @CoreMethod(names={">="}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class GreaterEqualNode
    extends CoreMethodArrayArgumentsNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean greaterEqual(int a, int b) {
            return a >= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greaterEqual(int a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b)) >= 0;
        }

        @Specialization
        public boolean greaterEqual(long a, long b) {
            return a >= b;
        }

        @Specialization
        public boolean greaterEqual(long a, double b) {
            return (double)a >= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean greaterEqual(long a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b)) >= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object greaterEqualCoerced(VirtualFrame frame, long a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a >= b", "other", b);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int compare(int a, int b) {
            return Integer.compare(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int compare(int a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b));
        }

        @Specialization
        public int compare(long a, long b) {
            return Long.compare(a, b);
        }

        @Specialization
        public int compare(long a, double b) {
            return Double.compare(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int compare(long a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b));
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isDouble(b)", "!isRubyBignum(b)"})
        public Object compare(VirtualFrame frame, Object a, Object b) {
            return this.ruby(frame, "begin; b, a = math_coerce(other, :compare_error); a <=> b; rescue ArgumentError; nil; end", "other", b);
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode reverseCallNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.reverseCallNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public boolean equal(int a, int b) {
            return a == b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean equal(int a, RubyBasicObject b) {
            return false;
        }

        @Specialization
        public boolean equal(long a, long b) {
            return a == b;
        }

        @Specialization
        public boolean equal(long a, double b) {
            return (double)a == b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean equal(long a, RubyBasicObject b) {
            return false;
        }

        @Specialization(guards={"!isInteger(b)", "!isLong(b)", "!isRubyBignum(b)"})
        public Object equal(VirtualFrame frame, Object a, Object b) {
            return this.reverseCallNode.call(frame, b, "==", null, a);
        }
    }

    @CoreMethod(names={"<="}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class LessEqualNode
    extends CoreMethodArrayArgumentsNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean lessEqual(int a, int b) {
            return a <= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessEqual(int a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b)) <= 0;
        }

        @Specialization
        public boolean lessEqual(long a, long b) {
            return a <= b;
        }

        @Specialization
        public boolean lessEqual(long a, double b) {
            return (double)a <= b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean lessEqual(long a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b)) <= 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessEqualCoerced(VirtualFrame frame, long a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a <= b", "other", b);
        }
    }

    @CoreMethod(names={"<"}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class LessNode
    extends CoreMethodArrayArgumentsNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean less(int a, int b) {
            return a < b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean less(int a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b)) < 0;
        }

        @Specialization
        public boolean less(long a, long b) {
            return a < b;
        }

        @Specialization
        public boolean less(long a, double b) {
            return (double)a < b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public boolean less(long a, RubyBasicObject b) {
            return BigInteger.valueOf(a).compareTo(BignumNodes.getBigIntegerValue(b)) < 0;
        }

        @Specialization(guards={"!isRubyBignum(b)", "!isInteger(b)", "!isLong(b)", "!isDouble(b)"})
        public Object lessCoerced(VirtualFrame frame, long a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a < b", "other", b);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject divMod(long a, long b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public RubyBasicObject divMod(long a, RubyBasicObject b) {
            return this.divModNode.execute(a, BignumNodes.getBigIntegerValue(b));
        }

        @Specialization
        public RubyBasicObject divMod(long a, double b) {
            return this.divModNode.execute(a, b);
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends BignumNodes.BignumCoreMethodNode {
        private final BranchProfile adjustProfile = BranchProfile.create();

        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int mod(int a, int b) {
            int mod = a % b;
            if (mod < 0 && b > 0 || mod > 0 && b < 0) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization
        public double mod(long a, double b) {
            if (b == 0.0) {
                throw new ArithmeticException("divide by zero");
            }
            double mod = (double)a % b;
            if (mod < 0.0 && b > 0.0 || mod > 0.0 && b < 0.0) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization
        public long mod(long a, long b) {
            long mod = a % b;
            if (mod < 0L && b > 0L || mod > 0L && b < 0L) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object mod(long a, RubyBasicObject b) {
            CompilerDirectives.transferToInterpreter();
            long mod = BigInteger.valueOf(a).mod(BignumNodes.getBigIntegerValue(b)).longValue();
            if (mod < 0L && BignumNodes.getBigIntegerValue(b).compareTo(BigInteger.ZERO) > 0 || mod > 0L && BignumNodes.getBigIntegerValue(b).compareTo(BigInteger.ZERO) < 0) {
                this.adjustProfile.enter();
                return BignumNodes.createRubyBignum(this.getContext().getCoreLibrary().getBignumClass(), BigInteger.valueOf(mod).add(BignumNodes.getBigIntegerValue(b)));
            }
            return mod;
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends CoreMethodArrayArgumentsNode {
        private final BranchProfile bGreaterZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroAGreaterEqualZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroALessZero = BranchProfile.create();
        private final BranchProfile aGreaterZero = BranchProfile.create();
        private final BranchProfile bMinusOne = BranchProfile.create();
        private final BranchProfile bMinusOneAMinimum = BranchProfile.create();
        private final BranchProfile bMinusOneANotMinimum = BranchProfile.create();
        private final BranchProfile finalCase = BranchProfile.create();

        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public int div(int a, int b) throws UnexpectedResultException {
            if (b > 0) {
                this.bGreaterZero.enter();
                if (a >= 0) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1) / b - 1;
            }
            if (a > 0) {
                this.aGreaterZero.enter();
                return (a - 1) / b - 1;
            }
            if (b == -1) {
                this.bMinusOne.enter();
                if (a == Integer.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    throw new UnexpectedResultException((Object)BigInteger.valueOf(a).negate());
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        public Object divEdgeCase(int a, int b) {
            if (b > 0) {
                this.bGreaterZero.enter();
                if (a >= 0) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1) / b - 1;
            }
            if (a > 0) {
                this.aGreaterZero.enter();
                return (a - 1) / b - 1;
            }
            if (b == -1) {
                this.bMinusOne.enter();
                if (a == Integer.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return BigInteger.valueOf(a).negate();
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object divCoerced(VirtualFrame frame, int a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :/, b", "b", b);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public long div(long a, long b) throws UnexpectedResultException {
            if (b > 0L) {
                this.bGreaterZero.enter();
                if (a >= 0L) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1L) / b - 1L;
            }
            if (a > 0L) {
                this.aGreaterZero.enter();
                return (a - 1L) / b - 1L;
            }
            if (b == -1L) {
                this.bMinusOne.enter();
                if (a == Long.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    throw new UnexpectedResultException((Object)BigInteger.valueOf(a).negate());
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        public Object divEdgeCase(long a, long b) {
            if (b > 0L) {
                this.bGreaterZero.enter();
                if (a >= 0L) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1L) / b - 1L;
            }
            if (a > 0L) {
                this.aGreaterZero.enter();
                return (a - 1L) / b - 1L;
            }
            if (b == -1L) {
                this.bMinusOne.enter();
                if (a == Long.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return BigInteger.valueOf(a).negate();
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        public double div(long a, double b) {
            return (double)a / b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public int div(long a, RubyBasicObject b) {
            return 0;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object divCoerced(VirtualFrame frame, long a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :/, b", "b", b);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends BignumNodes.BignumCoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int mul(int a, int b) {
            return ExactMath.multiplyExact((int)a, (int)b);
        }

        @Specialization
        public long mulWithOverflow(int a, int b) {
            return (long)a * (long)b;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object mulCoerced(VirtualFrame frame, int a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :*, b", "b", b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long mul(long a, long b) {
            return ExactMath.multiplyExact((long)a, (long)b);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mulWithOverflow(long a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).multiply(BigInteger.valueOf(b)));
        }

        @Specialization
        public double mul(long a, double b) {
            return (double)a * b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBignum(b)"})
        public Object mul(long a, RubyBasicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).multiply(BignumNodes.getBigIntegerValue(b)));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object mulCoerced(VirtualFrame frame, long a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :*, b", "b", b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends BignumNodes.BignumCoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int sub(int a, int b) {
            return ExactMath.subtractExact((int)a, (int)b);
        }

        @Specialization
        public long subWithOverflow(int a, int b) {
            return (long)a - (long)b;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object subCoerced(VirtualFrame frame, int a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :-, b", "b", b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long sub(long a, long b) {
            return ExactMath.subtractExact((long)a, (long)b);
        }

        @Specialization
        public Object subWithOverflow(long a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).subtract(BigInteger.valueOf(b)));
        }

        @Specialization
        public double sub(long a, double b) {
            return (double)a - b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object sub(long a, RubyBasicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).subtract(BignumNodes.getBigIntegerValue(b)));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object subCoerced(VirtualFrame frame, long a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :-, b", "b", b);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends BignumNodes.BignumCoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int add(int a, int b) {
            return ExactMath.addExact((int)a, (int)b);
        }

        @Specialization
        public long addWithOverflow(int a, int b) {
            return (long)a + (long)b;
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object addCoerced(VirtualFrame frame, int a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :+, b", "b", b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long add(long a, long b) {
            return ExactMath.addExact((long)a, (long)b);
        }

        @Specialization
        public Object addWithOverflow(long a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).add(BigInteger.valueOf(b)));
        }

        @Specialization
        public double add(long a, double b) {
            return (double)a + b;
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Object add(long a, RubyBasicObject b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).add(BignumNodes.getBigIntegerValue(b)));
        }

        @Specialization(guards={"!isRubyBignum(b)"})
        public Object addCoerced(VirtualFrame frame, long a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :+, b", "b", b);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignumNode;

        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int neg(int value) {
            return ExactMath.subtractExact((int)0, (int)value);
        }

        @Specialization(contains={"neg"})
        public Object negWithOverflow(int value) {
            if (value == Integer.MIN_VALUE) {
                return -((long)value);
            }
            return -value;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long neg(long value) {
            return ExactMath.subtractExact((long)0L, (long)value);
        }

        @Specialization
        public Object negWithOverflow(long value) {
            if (this.fixnumOrBignumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fixnumOrBignumNode = (FixnumOrBignumNode)this.insert(new FixnumOrBignumNode(this.getContext(), this.getSourceSection()));
            }
            return this.fixnumOrBignumNode.fixnumOrBignum(BigInteger.valueOf(value).negate());
        }
    }
}

