/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayWriteNormalizedNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=ArrayWriteNormalizedNode.class)
public final class ArrayWriteNormalizedNodeGen
extends ArrayWriteNormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @CompilerDirectives.CompilationFinal
    private Class<?> valueType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayWriteNormalizedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        super(context, sourceSection);
        this.array_ = array;
        this.index_ = index;
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeWrite(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
        return this.specialization_.execute1(frameValue, arrayValue, indexValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeRubyBasicObject(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeBoolean(frameValue);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeDouble(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeInt(frameValue);
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeLong(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static RubyBasicObject expectRubyBasicObject(Object value) throws UnexpectedResultException {
        if (value instanceof RubyBasicObject) {
            return (RubyBasicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ArrayWriteNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        return new ArrayWriteNormalizedNodeGen(context, sourceSection, array, index, value);
    }

    @GeneratedBy(methodName="writeBeyondObject(VirtualFrame, RubyBasicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteBeyondObjectNode_
    extends BaseNode_ {
        WriteBeyondObjectNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 25);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeBeyondObject(frameValue, arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue) && !ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                return this.root.writeBeyondObject(frameValue, arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeBeyondObject(frameValue, arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteBeyondObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="writeBeyondPrimitive(VirtualFrame, RubyBasicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteBeyondPrimitiveNode_
    extends BaseNode_ {
        WriteBeyondPrimitiveNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 24);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (RubyGuards.isRubyArray(arrayValue_) && !ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeBeyondPrimitive(frameValue, arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyGuards.isRubyArray(arrayValue) && !ArrayGuards.isObjectArray(arrayValue) && !ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                return this.root.writeBeyondPrimitive(frameValue, arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeBeyondPrimitive(frameValue, arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteBeyondPrimitiveNode_(root);
        }
    }

    @GeneratedBy(methodName="writeObjectExtendByOne(VirtualFrame, RubyBasicObject, int, int)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteObjectExtendByOneNode_
    extends BaseNode_ {
        WriteObjectExtendByOneNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 23);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeObjectExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeObjectExtendByOne(frameValue, arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeObjectExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteObjectExtendByOneNode_(root);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(VirtualFrame, RubyBasicObject, int, RubyBasicObject)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOne4Node_
    extends BaseNode_ {
        WriteExtendByOne4Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 22);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBasicObject valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof RubyBasicObject) {
                RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof RubyBasicObject) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteExtendByOne4Node_(root);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(VirtualFrame, RubyBasicObject, int, double)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOne3Node_
    extends BaseNode_ {
        WriteExtendByOne3Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 21);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Double) {
                double valueValue_ = (Double)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Double) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                double valueValue_ = (Double)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteExtendByOne3Node_(root);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(VirtualFrame, RubyBasicObject, int, long)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOne2Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        WriteExtendByOne2Node_(ArrayWriteNormalizedNodeGen root, Object valueValue) {
            super(root, 20);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((WriteExtendByOne2Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object valueValue) {
            return new WriteExtendByOne2Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="writeExtendByOneIntIntoLong(VirtualFrame, RubyBasicObject, int, int)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOneIntIntoLongNode_
    extends BaseNode_ {
        WriteExtendByOneIntIntoLongNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 19);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOneIntIntoLong(frameValue, arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeExtendByOneIntIntoLong(frameValue, arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOneIntIntoLong(frameValue, arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteExtendByOneIntIntoLongNode_(root);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(VirtualFrame, RubyBasicObject, int, int)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOne1Node_
    extends BaseNode_ {
        WriteExtendByOne1Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 18);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteExtendByOne1Node_(root);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(VirtualFrame, RubyBasicObject, int, boolean)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOne0Node_
    extends BaseNode_ {
        WriteExtendByOne0Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 17);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Boolean) {
                boolean valueValue_ = (Boolean)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Boolean) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                boolean valueValue_ = (Boolean)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOne(frameValue, arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteExtendByOne0Node_(root);
        }
    }

    @GeneratedBy(methodName="writeWithinDouble(RubyBasicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinDoubleNode_
    extends BaseNode_ {
        WriteWithinDoubleNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 16);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isDouble(valueValue_)) {
                return this.root.writeWithinDouble(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !RubyGuards.isDouble(valueValue)) {
                return this.root.writeWithinDouble(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isDouble(valueValue)) {
                    return this.root.writeWithinDouble(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteWithinDoubleNode_(root);
        }
    }

    @GeneratedBy(methodName="writeWithinLong(RubyBasicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinLongNode_
    extends BaseNode_ {
        WriteWithinLongNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 15);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue_) && !RubyGuards.isLong(valueValue_)) {
                return this.root.writeWithinLong(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                return this.root.writeWithinLong(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                    return this.root.writeWithinLong(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteWithinLongNode_(root);
        }
    }

    @GeneratedBy(methodName="writeWithinInt(RubyBasicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinInt1Node_
    extends BaseNode_ {
        WriteWithinInt1Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 14);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue_) && !RubyGuards.isLong(valueValue_)) {
                return this.root.writeWithinInt(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                return this.root.writeWithinInt(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                    return this.root.writeWithinInt(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteWithinInt1Node_(root);
        }
    }

    @GeneratedBy(methodName="writeWithinInt(RubyBasicObject, int, long)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinInt0Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        WriteWithinInt0Node_(ArrayWriteNormalizedNodeGen root, Object valueValue) {
            super(root, 13);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((WriteWithinInt0Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithinInt(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithinInt(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithinInt(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object valueValue) {
            return new WriteWithinInt0Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="writeWithin(RubyBasicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithin4Node_
    extends BaseNode_ {
        WriteWithin4Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 12);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                return this.root.writeWithin(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithin(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteWithin4Node_(root);
        }
    }

    @GeneratedBy(methodName="writeWithin(RubyBasicObject, int, double)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithin3Node_
    extends BaseNode_ {
        WriteWithin3Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 11);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Double) {
                double valueValue_ = (Double)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithin(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Double) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                double valueValue_ = (Double)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteWithin3Node_(root);
        }
    }

    @GeneratedBy(methodName="writeWithin(RubyBasicObject, int, long)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithin2Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        WriteWithin2Node_(ArrayWriteNormalizedNodeGen root, Object valueValue) {
            super(root, 10);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((WriteWithin2Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithin(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object valueValue) {
            return new WriteWithin2Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="writeWithinIntIntoLong(RubyBasicObject, int, int)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinIntIntoLongNode_
    extends BaseNode_ {
        WriteWithinIntIntoLongNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 9);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithinIntIntoLong(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithinIntIntoLong(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithinIntIntoLong(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteWithinIntIntoLongNode_(root);
        }
    }

    @GeneratedBy(methodName="writeWithin(RubyBasicObject, int, int)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithin1Node_
    extends BaseNode_ {
        WriteWithin1Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 8);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithin(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteWithin1Node_(root);
        }
    }

    @GeneratedBy(methodName="writeWithin(RubyBasicObject, int, boolean)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithin0Node_
    extends BaseNode_ {
        WriteWithin0Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 7);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Boolean) {
                boolean valueValue_ = (Boolean)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithin(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Boolean) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                boolean valueValue_ = (Boolean)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteWithin0Node_(root);
        }
    }

    @GeneratedBy(methodName="writeNullBeyond(RubyBasicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNullBeyondNode_
    extends BaseNode_ {
        WriteNullBeyondNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue);
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ != 0) {
                return this.root.writeNullBeyond(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isNullArray(arrayValue) && indexValue != 0) {
                return this.root.writeNullBeyond(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ != 0) {
                    return this.root.writeNullBeyond(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteNullBeyondNode_(root);
        }
    }

    @GeneratedBy(methodName="writeNull0(RubyBasicObject, int, RubyBasicObject)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull04Node_
    extends BaseNode_ {
        WriteNull04Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBasicObject valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectRubyBasicObject(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof RubyBasicObject) {
                RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof RubyBasicObject) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                RubyBasicObject valueValue_ = (RubyBasicObject)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteNull04Node_(root);
        }
    }

    @GeneratedBy(methodName="writeNull0(RubyBasicObject, int, double)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull03Node_
    extends BaseNode_ {
        WriteNull03Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Double) {
                double valueValue_ = (Double)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Double) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                double valueValue_ = (Double)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteNull03Node_(root);
        }
    }

    @GeneratedBy(methodName="writeNull0(RubyBasicObject, int, long)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull02Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        WriteNull02Node_(ArrayWriteNormalizedNodeGen root, Object valueValue) {
            super(root, 3);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((WriteNull02Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object valueValue) {
            return new WriteNull02Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="writeNull0(RubyBasicObject, int, int)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull01Node_
    extends BaseNode_ {
        WriteNull01Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                int valueValue_ = (Integer)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteNull01Node_(root);
        }
    }

    @GeneratedBy(methodName="writeNull0(RubyBasicObject, int, boolean)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull00Node_
    extends BaseNode_ {
        WriteNull00Node_(ArrayWriteNormalizedNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean valueValue_;
            int indexValue_;
            RubyBasicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult(), indexValue, valueValue));
            }
            try {
                indexValue_ = this.root.index_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, arrayValue_, indexValue_, ex.getResult()));
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(frameValue, arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Boolean) {
                boolean valueValue_ = (Boolean)valueValue;
                if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer && valueValue instanceof Boolean) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                boolean valueValue_ = (Boolean)valueValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new WriteNull00Node_(root);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue, valueValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.getNext().execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.uninitialized((Frame)frameValue, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final ArrayWriteNormalizedNodeGen root;

        BaseNode_(ArrayWriteNormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_, this.root.value_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.execute_((VirtualFrame)frameValue, arrayValue, indexValue, valueValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

        public Object execute1(VirtualFrame frameValue, RubyBasicObject arrayValue, int indexValue, Object valueValue) {
            return this.execute_(frameValue, arrayValue, indexValue, valueValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_((Frame)frameValue);
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return this.execute_(frameValue, arrayValue_, indexValue_, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectRubyBasicObject(this.execute0(frameValue));
        }

        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectBoolean(this.execute0(frameValue));
        }

        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectDouble(this.execute0(frameValue));
        }

        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectInteger(this.execute0(frameValue));
        }

        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectLong(this.execute0(frameValue));
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof RubyBasicObject && indexValue instanceof Integer) {
                RubyBasicObject arrayValue_ = (RubyBasicObject)arrayValue;
                int indexValue_ = (Integer)indexValue;
                if (valueValue instanceof Boolean && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull00Node_.create(this.root);
                }
                if (valueValue instanceof Integer && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull01Node_.create(this.root);
                }
                if (RubyTypesGen.isImplicitLong(valueValue) && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull02Node_.create(this.root, valueValue);
                }
                if (valueValue instanceof Double && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull03Node_.create(this.root);
                }
                if (valueValue instanceof RubyBasicObject && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull04Node_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ != 0) {
                    return WriteNullBeyondNode_.create(this.root);
                }
                if (valueValue instanceof Boolean && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithin0Node_.create(this.root);
                }
                if (valueValue instanceof Integer) {
                    if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                        return WriteWithin1Node_.create(this.root);
                    }
                    if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                        return WriteWithinIntIntoLongNode_.create(this.root);
                    }
                }
                if (RubyTypesGen.isImplicitLong(valueValue) && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithin2Node_.create(this.root, valueValue);
                }
                if (valueValue instanceof Double && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithin3Node_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithin4Node_.create(this.root);
                }
                if (RubyTypesGen.isImplicitLong(valueValue) && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithinInt0Node_.create(this.root, valueValue);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                    return WriteWithinInt1Node_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                    return WriteWithinLongNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isDouble(valueValue)) {
                    return WriteWithinDoubleNode_.create(this.root);
                }
                if (valueValue instanceof Boolean && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteExtendByOne0Node_.create(this.root);
                }
                if (valueValue instanceof Integer) {
                    if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                        return WriteExtendByOne1Node_.create(this.root);
                    }
                    if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                        return WriteExtendByOneIntIntoLongNode_.create(this.root);
                    }
                }
                if (RubyTypesGen.isImplicitLong(valueValue) && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteExtendByOne2Node_.create(this.root, valueValue);
                }
                if (valueValue instanceof Double && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteExtendByOne3Node_.create(this.root);
                }
                if (valueValue instanceof RubyBasicObject && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteExtendByOne4Node_.create(this.root);
                }
                if (valueValue instanceof Integer && RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteObjectExtendByOneNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && !ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteBeyondPrimitiveNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteBeyondObjectNode_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeValue_(Frame frameValue) {
            Object object;
            Class valueType_ = this.root.valueType_;
            if (valueType_ == Boolean.TYPE) {
                return this.root.value_.executeBoolean((VirtualFrame)frameValue);
            }
            if (valueType_ == Double.TYPE) {
                return this.root.value_.executeDouble((VirtualFrame)frameValue);
            }
            if (valueType_ == Integer.TYPE) {
                return this.root.value_.executeInteger((VirtualFrame)frameValue);
            }
            if (valueType_ == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.valueType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.valueType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.valueType_ = _type;
            return object;
        }

        protected final long executeValueLong_(Frame frameValue, Class<?> valueImplicitType) throws UnexpectedResultException {
            if (valueImplicitType == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueImplicitType == Integer.TYPE) {
                return RubyTypes.int2long(this.root.value_.executeInteger((VirtualFrame)frameValue));
            }
            Object valueValue_ = this.executeValue_(frameValue);
            throw new UnexpectedResultException(valueValue_);
        }
    }
}

