/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="length", type=RubyNode.class)})
public abstract class ArrayReadSliceDenormalizedNode
extends RubyNode {
    @Node.Child
    private ArrayReadSliceNormalizedNode readNode;

    public ArrayReadSliceDenormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeReadSlice(VirtualFrame var1, RubyBasicObject var2, int var3, int var4);

    @Specialization(guards={"isRubyArray(array)"})
    public Object read(VirtualFrame frame, RubyBasicObject array, int index, int length) {
        if (this.readNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.readNode = (ArrayReadSliceNormalizedNode)this.insert(ArrayReadSliceNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
        }
        int normalizedIndex = ArrayNodes.normalizeIndex(array, index);
        return this.readNode.executeReadSlice(frame, array, normalizedIndex, length);
    }
}

