/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.CmpIntNode;
import org.jruby.truffle.nodes.cast.CmpIntNodeGen;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeGen;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.fixnum.FixnumLowerNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.nodes.rubinius.ByteArrayNodes;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.StringCodeRangeableWrapper;
import org.jruby.truffle.runtime.object.BasicObjectType;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertDouble;
import org.jruby.util.Pack;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

@CoreClass(name="String")
public abstract class StringNodes {
    public static final StringType STRING_TYPE = new StringType();
    private static final DynamicObjectFactory STRING_FACTORY;

    public static ByteList getByteList(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return ((org.jruby.truffle.runtime.core.RubyString)string).bytes;
    }

    public static void setByteList(RubyBasicObject string, ByteList bytes) {
        assert (RubyGuards.isRubyString(string));
        ((org.jruby.truffle.runtime.core.RubyString)string).bytes = bytes;
    }

    public static int getCodeRange(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return ((org.jruby.truffle.runtime.core.RubyString)string).codeRange;
    }

    public static void setCodeRange(RubyBasicObject string, int newCodeRange) {
        assert (RubyGuards.isRubyString(string));
        ((org.jruby.truffle.runtime.core.RubyString)string).codeRange = newCodeRange;
    }

    public static StringCodeRangeableWrapper getCodeRangeable(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        if (((org.jruby.truffle.runtime.core.RubyString)string).codeRangeableWrapper == null) {
            ((org.jruby.truffle.runtime.core.RubyString)string).codeRangeableWrapper = new StringCodeRangeableWrapper((org.jruby.truffle.runtime.core.RubyString)string);
        }
        return ((org.jruby.truffle.runtime.core.RubyString)string).codeRangeableWrapper;
    }

    @CompilerDirectives.TruffleBoundary
    public static int scanForCodeRange(RubyBasicObject string) {
        int cr = StringNodes.getCodeRange(string);
        if (cr == 0) {
            cr = StringNodes.slowCodeRangeScan(string);
            StringNodes.setCodeRange(string, cr);
        }
        return cr;
    }

    public static boolean isCodeRangeValid(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        return ((org.jruby.truffle.runtime.core.RubyString)string).codeRange == 32;
    }

    public static void clearCodeRange(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        ((org.jruby.truffle.runtime.core.RubyString)string).codeRange = 0;
    }

    public static void keepCodeRange(RubyBasicObject string) {
        if (StringNodes.getCodeRange(string) == 48) {
            StringNodes.clearCodeRange(string);
        }
    }

    public static void modify(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        ((org.jruby.truffle.runtime.core.RubyString)string).bytes.invalidate();
    }

    public static void modify(RubyBasicObject string, int length) {
        assert (RubyGuards.isRubyString(string));
        ((org.jruby.truffle.runtime.core.RubyString)string).bytes.ensure(length);
        ((org.jruby.truffle.runtime.core.RubyString)string).bytes.invalidate();
    }

    public static void modifyAndKeepCodeRange(RubyBasicObject string) {
        StringNodes.modify(string);
        StringNodes.keepCodeRange(string);
    }

    @CompilerDirectives.TruffleBoundary
    public static Encoding checkEncoding(RubyBasicObject string, CodeRangeable other) {
        Encoding encoding = StringSupport.areCompatible((CodeRangeable)StringNodes.getCodeRangeable(string), (CodeRangeable)other);
        if (encoding == null) {
            throw string.getContext().getRuntime().newEncodingCompatibilityError(String.format("incompatible character encodings: %s and %s", StringNodes.getByteList(string).getEncoding().toString(), other.getByteList().getEncoding().toString()));
        }
        return encoding;
    }

    @CompilerDirectives.TruffleBoundary
    private static int slowCodeRangeScan(RubyBasicObject string) {
        ByteList byteList = StringNodes.getByteList(string);
        return StringSupport.codeRangeScan((Encoding)byteList.getEncoding(), (ByteList)byteList);
    }

    public static void forceEncoding(RubyBasicObject string, Encoding encoding) {
        StringNodes.modify(string);
        StringNodes.clearCodeRange(string);
        StringSupport.associateEncoding((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)encoding);
        StringNodes.clearCodeRange(string);
    }

    public static int length(RubyBasicObject string) {
        if (CompilerDirectives.injectBranchProbability((double)0.9999, (boolean)StringSupport.isSingleByteOptimizable((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)StringNodes.getByteList(string).getEncoding()))) {
            return StringNodes.getByteList(string).getRealSize();
        }
        return StringSupport.strLengthFromRubyString((CodeRangeable)StringNodes.getCodeRangeable(string));
    }

    public static int normalizeIndex(int length, int index) {
        return ArrayNodes.normalizeIndex(length, index);
    }

    public static int normalizeIndex(RubyBasicObject rubyString, int index) {
        return StringNodes.normalizeIndex(StringNodes.length(rubyString), index);
    }

    public static int clampExclusiveIndex(RubyBasicObject string, int index) {
        assert (RubyGuards.isRubyString(string));
        return ArrayNodes.clampExclusiveIndex(((org.jruby.truffle.runtime.core.RubyString)string).bytes.length(), index);
    }

    @CompilerDirectives.TruffleBoundary
    public static Encoding checkEncoding(RubyBasicObject string, CodeRangeable other, Node node) {
        Encoding encoding = StringSupport.areCompatible((CodeRangeable)StringNodes.getCodeRangeable(string), (CodeRangeable)other);
        if (encoding == null) {
            throw new org.jruby.truffle.runtime.control.RaiseException(string.getContext().getCoreLibrary().encodingCompatibilityErrorIncompatible(StringNodes.getByteList(string).getEncoding().toString(), other.getByteList().getEncoding().toString(), node));
        }
        return encoding;
    }

    public static boolean singleByteOptimizable(RubyBasicObject string) {
        return StringSupport.isSingleByteOptimizable((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)EncodingUtils.STR_ENC_GET((ByteListHolder)StringNodes.getCodeRangeable(string)));
    }

    public static RubyBasicObject createEmptyString(RubyClass stringClass) {
        return StringNodes.createString(stringClass, new ByteList());
    }

    public static RubyBasicObject createString(RubyClass stringClass, String string) {
        return StringNodes.createString(stringClass, string, (Encoding)UTF8Encoding.INSTANCE);
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyBasicObject createString(RubyClass stringClass, String string, Encoding encoding) {
        return StringNodes.createString(stringClass, RubyString.encodeBytelist((CharSequence)string, (Encoding)encoding));
    }

    public static RubyBasicObject createString(RubyClass stringClass, byte[] bytes) {
        return StringNodes.createString(stringClass, new ByteList(bytes));
    }

    public static RubyBasicObject createString(RubyClass stringClass, ByteBuffer bytes) {
        return StringNodes.createString(stringClass, new ByteList(bytes.array()));
    }

    public static RubyBasicObject createString(RubyClass stringClass, ByteList bytes) {
        return new org.jruby.truffle.runtime.core.RubyString(stringClass, bytes, STRING_FACTORY.newInstance(new Object[0]));
    }

    static {
        Shape shape = RubyBasicObject.LAYOUT.createShape((ObjectType)STRING_TYPE);
        STRING_FACTORY = shape.createFactory();
    }

    public static class StringAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return StringNodes.createString(rubyClass, new ByteList());
        }
    }

    public static class StringNodesHelper {
        @CompilerDirectives.TruffleBoundary
        public static ByteList upcase(Ruby runtime, ByteList string) {
            return runtime.newString(string).upcase(runtime.getCurrentContext()).getByteList();
        }

        @CompilerDirectives.TruffleBoundary
        public static ByteList downcase(Ruby runtime, ByteList string) {
            return runtime.newString(string).downcase(runtime.getCurrentContext()).getByteList();
        }

        public static int checkIndex(org.jruby.truffle.runtime.core.RubyString string, int index, RubyNode node) {
            if (index > StringNodes.length(string)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > StringNodes.length(string)) {
                    CompilerDirectives.transferToInterpreter();
                    throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
                }
                index += StringNodes.length(string);
            }
            return index;
        }

        public static int checkIndexForRef(org.jruby.truffle.runtime.core.RubyString string, int index, RubyNode node) {
            int length = StringNodes.getByteList(string).getRealSize();
            if (index >= length) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > length) {
                    CompilerDirectives.transferToInterpreter();
                    throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
                }
                index += length;
            }
            return index;
        }

        @CompilerDirectives.TruffleBoundary
        public static void replaceInternal(org.jruby.truffle.runtime.core.RubyString string, int start, int length, org.jruby.truffle.runtime.core.RubyString replacement) {
            StringSupport.replaceInternal19((int)start, (int)length, (CodeRangeable)StringNodes.getCodeRangeable(string), (CodeRangeable)StringNodes.getCodeRangeable(replacement));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object trTransHelper(RubyContext context, org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString fromStr, org.jruby.truffle.runtime.core.RubyString toStr, boolean sFlag) {
            CodeRangeable ret = StringSupport.trTransHelper((Ruby)context.getRuntime(), (CodeRangeable)StringNodes.getCodeRangeable(self), (CodeRangeable)StringNodes.getCodeRangeable(fromStr), (CodeRangeable)StringNodes.getCodeRangeable(toStr), (boolean)sFlag);
            if (ret == null) {
                return context.getCoreLibrary().getNilObject();
            }
            return self;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject clear(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList empty = ByteList.EMPTY_BYTELIST;
            empty.setEncoding(StringNodes.getByteList(string).getEncoding());
            StringNodes.setByteList(string, empty);
            return string;
        }
    }

    @CoreMethod(names={"capitalize"}, taintFromSelf=true)
    public static abstract class CapitalizeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        CallDispatchHeadNode capitalizeBangNode;
        @Node.Child
        CallDispatchHeadNode dupNode;

        public CapitalizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.capitalizeBangNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.dupNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object capitalize(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string) {
            Object duped = this.dupNode.call(frame, string, "dup", null, new Object[0]);
            this.capitalizeBangNode.call(frame, duped, "capitalize!", null, new Object[0]);
            return duped;
        }
    }

    @CoreMethod(names={"capitalize!"}, raiseIfFrozenSelf=true)
    public static abstract class CapitalizeBangNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile dummyEncodingProfile = ConditionProfile.createBinaryProfile();

        public CapitalizeBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public RubyBasicObject capitalizeBang(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList value = StringNodes.getByteList(string);
            Encoding enc = value.getEncoding();
            if (this.dummyEncodingProfile.profile(enc.isDummy())) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (value.getRealSize() == 0) {
                return this.nil();
            }
            StringNodes.modifyAndKeepCodeRange(string);
            int s = value.getBegin();
            int end = s + value.getRealSize();
            byte[] bytes = value.getUnsafeBytes();
            boolean modify = false;
            int c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end);
            if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper((Encoding)enc, (int)c), bytes, s);
                modify = true;
            }
            s += StringSupport.codeLength((Encoding)enc, (int)c);
            while (s < end) {
                c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end);
                if (enc.isUpper(c)) {
                    enc.codeToMbc(StringSupport.toLower((Encoding)enc, (int)c), bytes, s);
                    modify = true;
                }
                s += StringSupport.codeLength((Encoding)enc, (int)c);
            }
            return modify ? string : this.nil();
        }
    }

    @CoreMethod(names={"valid_encoding?"})
    public static abstract class ValidEncodingQueryNode
    extends CoreMethodArrayArgumentsNode {
        public ValidEncodingQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean validEncodingQuery(org.jruby.truffle.runtime.core.RubyString string) {
            return StringNodes.scanForCodeRange(string) != 48;
        }
    }

    @CoreMethod(names={"upcase!"}, raiseIfFrozenSelf=true)
    public static abstract class UpcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        public UpcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject upcaseBang(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList byteListString = StringNodesHelper.upcase(this.getContext().getRuntime(), StringNodes.getByteList(string));
            if (byteListString.equal(StringNodes.getByteList(string))) {
                return this.nil();
            }
            StringNodes.setByteList(string, byteListString);
            return string;
        }
    }

    @CoreMethod(names={"upcase"}, taintFromSelf=true)
    public static abstract class UpcaseNode
    extends CoreMethodArrayArgumentsNode {
        public UpcaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject upcase(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList byteListString = StringNodesHelper.upcase(this.getContext().getRuntime(), StringNodes.getByteList(string));
            return StringNodes.createString(string.getLogicalClass(), byteListString);
        }
    }

    @CoreMethod(names={"unpack"}, required=1)
    public static abstract class UnpackNode
    extends ArrayCoreMethodNode {
        public UnpackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject unpack(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString format) {
            RubyArray jrubyArray = Pack.unpack((Ruby)this.getContext().getRuntime(), (ByteList)StringNodes.getByteList(string), (ByteList)StringNodes.getByteList(format));
            return this.getContext().toTruffle(jrubyArray);
        }
    }

    @CoreMethod(names={"tr_s!"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrSBangNode
    extends CoreMethodNode {
        @Node.Child
        private DeleteBangNode deleteBangNode;

        public TrSBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), toStr);
        }

        @Specialization
        public Object trSBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString fromStr, org.jruby.truffle.runtime.core.RubyString toStr) {
            if (StringNodes.getByteList(self).getRealSize() == 0) {
                return this.nil();
            }
            if (StringNodes.getByteList(toStr).getRealSize() == 0) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.deleteBangNode = (DeleteBangNode)this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.deleteBang(frame, self, fromStr);
            }
            return StringNodesHelper.trTransHelper(this.getContext(), self, fromStr, toStr, true);
        }
    }

    @CoreMethod(names={"tr!"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="fromStr"), @NodeChild(type=RubyNode.class, value="toStrNode")})
    public static abstract class TrBangNode
    extends CoreMethodNode {
        @Node.Child
        private DeleteBangNode deleteBangNode;

        public TrBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), toStr);
        }

        @Specialization
        public Object trBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString fromStr, org.jruby.truffle.runtime.core.RubyString toStr) {
            if (StringNodes.getByteList(self).getRealSize() == 0) {
                return this.nil();
            }
            if (StringNodes.getByteList(toStr).getRealSize() == 0) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.deleteBangNode = (DeleteBangNode)this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.deleteBang(frame, self, fromStr);
            }
            return StringNodesHelper.trTransHelper(this.getContext(), self, fromStr, toStr, false);
        }
    }

    @CoreMethod(names={"reverse!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class ReverseBangNode
    extends CoreMethodArrayArgumentsNode {
        public ReverseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"reverseIsEqualToSelf(string)"})
        public RubyBasicObject reverseNoOp(org.jruby.truffle.runtime.core.RubyString string) {
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "isSingleByteOptimizable(string)"})
        public RubyBasicObject reverseSingleByteOptimizable(org.jruby.truffle.runtime.core.RubyString string) {
            StringNodes.modify(string);
            byte[] bytes = StringNodes.getByteList(string).getUnsafeBytes();
            int p = StringNodes.getByteList(string).getBegin();
            int len = StringNodes.getByteList(string).getRealSize();
            for (int i = 0; i < len >> 1; ++i) {
                byte b = bytes[p + i];
                bytes[p + i] = bytes[p + len - i - 1];
                bytes[p + len - i - 1] = b;
            }
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf(string)", "!isSingleByteOptimizable(string)"})
        public RubyBasicObject reverse(org.jruby.truffle.runtime.core.RubyString string) {
            StringNodes.modify(string);
            byte[] bytes = StringNodes.getByteList(string).getUnsafeBytes();
            int p = StringNodes.getByteList(string).getBegin();
            int len = StringNodes.getByteList(string).getRealSize();
            Encoding enc = StringNodes.getByteList(string).getEncoding();
            int end = p + len;
            int op = len;
            byte[] obytes = new byte[len];
            boolean single = true;
            while (p < end) {
                int cl = StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
                if (cl > 1 || (bytes[p] & 0x80) != 0) {
                    single = false;
                    System.arraycopy(bytes, p, obytes, op -= cl, cl);
                    p += cl;
                    continue;
                }
                obytes[--op] = bytes[p++];
            }
            StringNodes.getByteList(string).setUnsafeBytes(obytes);
            if (StringNodes.getCodeRange(string) == 0) {
                StringNodes.setCodeRange(string, single ? 16 : 32);
            }
            return string;
        }

        public static boolean reverseIsEqualToSelf(org.jruby.truffle.runtime.core.RubyString string) {
            return StringNodes.getByteList(string).getRealSize() <= 1;
        }
    }

    @CoreMethod(names={"to_sym", "intern"})
    public static abstract class ToSymNode
    extends CoreMethodArrayArgumentsNode {
        public ToSymNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toSym(org.jruby.truffle.runtime.core.RubyString string) {
            return this.getSymbol(StringNodes.getByteList(string));
        }
    }

    @CoreMethod(names={"to_s", "to_str"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isStringSubclass(string)"})
        public RubyBasicObject toS(org.jruby.truffle.runtime.core.RubyString string) {
            return string;
        }

        @Specialization(guards={"isStringSubclass(string)"})
        public Object toSOnSubclass(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string) {
            return this.ruby(frame, "''.replace(self)", "self", string);
        }

        public boolean isStringSubclass(org.jruby.truffle.runtime.core.RubyString string) {
            return string.getLogicalClass() != this.getContext().getCoreLibrary().getStringClass();
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double toF(org.jruby.truffle.runtime.core.RubyString string) {
            try {
                return this.convertToDouble(string);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private double convertToDouble(org.jruby.truffle.runtime.core.RubyString string) {
            return ConvertDouble.byteListToDouble19((ByteList)StringNodes.getByteList(string), (boolean)false);
        }
    }

    @CoreMethod(names={"sum"}, optional=1)
    public static abstract class SumNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode addNode;
        @Node.Child
        private CallDispatchHeadNode subNode;
        @Node.Child
        private CallDispatchHeadNode shiftNode;
        @Node.Child
        private CallDispatchHeadNode andNode;

        public SumNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.addNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.subNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.shiftNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.andNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object sum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int bits) {
            return this.sum(frame, string, (long)bits);
        }

        @Specialization
        public Object sum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, long bits) {
            byte[] bytes = StringNodes.getByteList(string).getUnsafeBytes();
            int p = StringNodes.getByteList(string).getBegin();
            int len = StringNodes.getByteList(string).getRealSize();
            int end = p + len;
            if (bits >= 64L) {
                Object sum = 0;
                while (p < end) {
                    sum = this.addNode.call(frame, sum, "+", null, bytes[p++] & 0xFF);
                }
                if (bits != 0L) {
                    Object mod = this.shiftNode.call(frame, 1, "<<", null, bits);
                    sum = this.andNode.call(frame, sum, "&", null, this.subNode.call(frame, mod, "-", null, 1));
                }
                return sum;
            }
            long sum = 0L;
            while (p < end) {
                sum += (long)(bytes[p++] & 0xFF);
            }
            return bits == 0L ? sum : sum & (1L << (int)bits) - 1L;
        }

        @Specialization
        public Object sum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, NotProvided bits) {
            return this.sum(frame, string, 16);
        }

        @Specialization(guards={"!isInteger(bits)", "!isLong(bits)", "wasProvided(bits)"})
        public Object sum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object bits) {
            return this.ruby(frame, "sum Rubinius::Type.coerce_to(bits, Fixnum, :to_int)", "bits", bits);
        }
    }

    @CoreMethod(names={"succ!"}, raiseIfFrozenSelf=true)
    public static abstract class SuccBangNode
    extends CoreMethodArrayArgumentsNode {
        public SuccBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject succBang(org.jruby.truffle.runtime.core.RubyString string) {
            if (StringNodes.getByteList(string).getRealSize() > 0) {
                StringNodes.setByteList(string, StringSupport.succCommon((Ruby)this.getContext().getRuntime(), (ByteList)StringNodes.getByteList(string)));
            }
            return string;
        }
    }

    @CoreMethod(names={"succ"}, taintFromSelf=true)
    public static abstract class SuccNode
    extends CoreMethodArrayArgumentsNode {
        public SuccNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject succ(org.jruby.truffle.runtime.core.RubyString string) {
            if (StringNodes.length(string) > 0) {
                return StringNodes.createString(string.getLogicalClass(), StringSupport.succCommon((Ruby)this.getContext().getRuntime(), (ByteList)StringNodes.getByteList(string)));
            }
            return StringNodes.createEmptyString(string.getLogicalClass());
        }
    }

    @CoreMethod(names={"squeeze!"}, argumentsAsArray=true, raiseIfFrozenSelf=true)
    public static abstract class SqueezeBangNode
    extends CoreMethodArrayArgumentsNode {
        private ConditionProfile singleByteOptimizableProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private ToStrNode toStrNode;

        public SqueezeBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"zeroArgs(string, args)"})
        public Object squeezeBangZeroArgs(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object ... args) {
            if (StringNodes.getByteList(string).length() == 0) {
                return this.nil();
            }
            boolean[] squeeze = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
            StringNodes.modifyAndKeepCodeRange(string);
            if (this.singleByteOptimizableProfile.profile(StringNodes.singleByteOptimizable(string)) ? !StringSupport.singleByteSqueeze((ByteList)StringNodes.getByteList(string), (boolean[])squeeze) : !this.squeezeCommonMultiByte(StringNodes.getByteList(string), squeeze, null, StringNodes.getByteList(string).getEncoding(), false)) {
                return this.nil();
            }
            return string;
        }

        @Specialization(guards={"!zeroArgs(string, args)"})
        public Object squeezeBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object ... args) {
            if (StringNodes.getByteList(string).length() == 0) {
                return this.nil();
            }
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            org.jruby.truffle.runtime.core.RubyString[] otherStrings = new org.jruby.truffle.runtime.core.RubyString[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStrNode.executeRubyString(frame, args[i]);
            }
            org.jruby.truffle.runtime.core.RubyString otherStr = otherStrings[0];
            Encoding enc = StringNodes.checkEncoding(string, StringNodes.getCodeRangeable(otherStr), this);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringNodes.getByteList(otherStr), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            boolean singlebyte = StringNodes.singleByteOptimizable(string) && StringNodes.singleByteOptimizable(otherStr);
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                enc = StringNodes.checkEncoding(string, StringNodes.getCodeRangeable(otherStr));
                singlebyte = singlebyte && StringNodes.singleByteOptimizable(otherStr);
                tables = StringSupport.trSetupTable((ByteList)StringNodes.getByteList(otherStr), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            StringNodes.modifyAndKeepCodeRange(string);
            if (this.singleByteOptimizableProfile.profile(singlebyte) ? !StringSupport.singleByteSqueeze((ByteList)StringNodes.getByteList(string), (boolean[])squeeze) : !StringSupport.multiByteSqueeze((Ruby)this.getContext().getRuntime(), (ByteList)StringNodes.getByteList(string), (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)true)) {
                return this.nil();
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean squeezeCommonMultiByte(ByteList value, boolean[] squeeze, StringSupport.TrTables tables, Encoding enc, boolean isArg) {
            return StringSupport.multiByteSqueeze((Ruby)this.getContext().getRuntime(), (ByteList)value, (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)isArg);
        }

        public static boolean zeroArgs(org.jruby.truffle.runtime.core.RubyString string, Object ... args) {
            return args.length == 0;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportStatic(value={StringGuards.class})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract int executeInteger(VirtualFrame var1, org.jruby.truffle.runtime.core.RubyString var2);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int sizeSingleByte(org.jruby.truffle.runtime.core.RubyString string) {
            return StringNodes.getByteList(string).getRealSize();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public int size(org.jruby.truffle.runtime.core.RubyString string) {
            return StringSupport.strLengthFromRubyString((CodeRangeable)StringNodes.getCodeRangeable(string));
        }
    }

    @CoreMethod(names={"setbyte"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class SetByteNode
    extends CoreMethodNode {
        public SetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return new FixnumLowerNode(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), index));
        }

        @CreateCast(value={"value"})
        public RubyNode coerceValueToInt(RubyNode value) {
            return new FixnumLowerNode(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), value));
        }

        @Specialization
        public int setByte(org.jruby.truffle.runtime.core.RubyString string, int index, int value) {
            int normalizedIndex = StringNodesHelper.checkIndexForRef(string, index, this);
            StringNodes.modify(string);
            StringNodes.clearCodeRange(string);
            StringNodes.getByteList((RubyBasicObject)string).getUnsafeBytes()[normalizedIndex] = (byte)value;
            return value;
        }
    }

    @CoreMethod(names={"dump"}, taintFromSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class DumpNode
    extends CoreMethodArrayArgumentsNode {
        public DumpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isAsciiCompatible(string)"})
        public RubyBasicObject dumpAsciiCompatible(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList outputBytes = this.dumpCommon(string);
            RubyBasicObject result = StringNodes.createString(string.getLogicalClass(), outputBytes);
            StringNodes.getByteList(result).setEncoding(StringNodes.getByteList(string).getEncoding());
            StringNodes.setCodeRange(result, 16);
            return result;
        }

        @Specialization(guards={"!isAsciiCompatible(string)"})
        public RubyBasicObject dump(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList outputBytes = this.dumpCommon(string);
            try {
                outputBytes.append(".force_encoding(\"".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
            outputBytes.append(StringNodes.getByteList(string).getEncoding().getName());
            outputBytes.append((byte)34);
            outputBytes.append((byte)41);
            RubyBasicObject result = StringNodes.createString(string.getLogicalClass(), outputBytes);
            StringNodes.getByteList(result).setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            StringNodes.setCodeRange(result, 16);
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private ByteList dumpCommon(org.jruby.truffle.runtime.core.RubyString string) {
            return StringSupport.dumpCommon((Ruby)this.getContext().getRuntime(), (ByteList)StringNodes.getByteList(string));
        }
    }

    @CoreMethod(names={"swapcase!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class SwapcaseBangNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile dummyEncodingProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile singleByteOptimizableProfile = ConditionProfile.createBinaryProfile();

        public SwapcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject swapcaseSingleByte(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList value = StringNodes.getByteList(string);
            Encoding enc = value.getEncoding();
            if (this.dummyEncodingProfile.profile(enc.isDummy())) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (value.getRealSize() == 0) {
                return this.nil();
            }
            StringNodes.modifyAndKeepCodeRange(string);
            int s = value.getBegin();
            int end = s + value.getRealSize();
            byte[] bytes = value.getUnsafeBytes();
            if (this.singleByteOptimizableProfile.profile(StringSupport.isSingleByteOptimizable((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)enc)) ? StringSupport.singleByteSwapcase((byte[])bytes, (int)s, (int)end) : StringSupport.multiByteSwapcase((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end)) {
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"rstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class RstripBangNode
    extends CoreMethodArrayArgumentsNode {
        public RstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public Object rstripBangSingleByte(org.jruby.truffle.runtime.core.RubyString string) {
            int endp;
            if (StringNodes.getByteList(string).getRealSize() == 0) {
                return this.nil();
            }
            byte[] bytes = StringNodes.getByteList(string).getUnsafeBytes();
            int start = StringNodes.getByteList(string).getBegin();
            int end = start + StringNodes.getByteList(string).getRealSize();
            for (endp = end - 1; endp >= start && (bytes[endp] == 0 || ASCIIEncoding.INSTANCE.isSpace(bytes[endp] & 0xFF)); --endp) {
            }
            if (endp < end - 1) {
                StringNodes.getByteList(string).view(0, endp - start + 1);
                StringNodes.keepCodeRange(string);
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public Object rstripBang(org.jruby.truffle.runtime.core.RubyString string) {
            int point;
            int prev;
            int end;
            if (StringNodes.getByteList(string).getRealSize() == 0) {
                return this.nil();
            }
            Encoding enc = EncodingUtils.STR_ENC_GET((ByteListHolder)StringNodes.getCodeRangeable(string));
            byte[] bytes = StringNodes.getByteList(string).getUnsafeBytes();
            int start = StringNodes.getByteList(string).getBegin();
            int endp = end = start + StringNodes.getByteList(string).getRealSize();
            while ((prev = this.prevCharHead(enc, bytes, start, endp, end)) != -1 && ((point = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)prev, (int)end)) == 0 || ASCIIEncoding.INSTANCE.isSpace(point))) {
                endp = prev;
            }
            if (endp < end) {
                StringNodes.getByteList(string).view(0, endp - start);
                StringNodes.keepCodeRange(string);
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        private int prevCharHead(Encoding enc, byte[] bytes, int p, int s, int end) {
            return enc.prevCharHead(bytes, p, s, end);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true, taintFromParameter=0)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ReplaceNode
    extends CoreMethodNode {
        public ReplaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization
        public RubyBasicObject replace(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            if (string == other) {
                return string;
            }
            StringNodes.getByteList(string).replace(StringNodes.getByteList(other).bytes());
            StringNodes.getByteList(string).setEncoding(StringNodes.getByteList(other).getEncoding());
            StringNodes.setCodeRange(string, StringNodes.getCodeRange(other));
            return string;
        }
    }

    @CoreMethod(names={"ord"})
    public static abstract class OrdNode
    extends CoreMethodArrayArgumentsNode {
        public OrdNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int ord(org.jruby.truffle.runtime.core.RubyString string) {
            return ((RubyFixnum)this.getContext().toJRuby(string).ord(this.getContext().getRuntime().getCurrentContext())).getIntValue();
        }
    }

    @CoreMethod(names={"num_bytes="}, lowerFixnumParameters={0}, required=1)
    public static abstract class SetNumBytesNode
    extends CoreMethodArrayArgumentsNode {
        public SetNumBytesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject setNumBytes(org.jruby.truffle.runtime.core.RubyString string, int count) {
            StringNodes.getByteList(string).view(0, count);
            return string;
        }
    }

    @CoreMethod(names={"modify!"}, raiseIfFrozenSelf=true)
    public static abstract class ModifyBangNode
    extends CoreMethodArrayArgumentsNode {
        public ModifyBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject modifyBang(org.jruby.truffle.runtime.core.RubyString string) {
            StringNodes.modify(string);
            return string;
        }
    }

    @CoreMethod(names={"lstrip!"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class LstripBangNode
    extends CoreMethodArrayArgumentsNode {
        public LstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public Object lstripBangSingleByte(org.jruby.truffle.runtime.core.RubyString string) {
            int p;
            if (StringNodes.getByteList(string).getRealSize() == 0) {
                return this.nil();
            }
            int s = StringNodes.getByteList(string).getBegin();
            int end = s + StringNodes.getByteList(string).getRealSize();
            byte[] bytes = StringNodes.getByteList(string).getUnsafeBytes();
            for (p = s; p < end && ASCIIEncoding.INSTANCE.isSpace(bytes[p] & 0xFF); ++p) {
            }
            if (p > s) {
                StringNodes.getByteList(string).view(p - s, end - p);
                StringNodes.keepCodeRange(string);
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public Object lstripBang(org.jruby.truffle.runtime.core.RubyString string) {
            int p;
            int c;
            if (StringNodes.getByteList(string).getRealSize() == 0) {
                return this.nil();
            }
            Encoding enc = EncodingUtils.STR_ENC_GET((ByteListHolder)StringNodes.getCodeRangeable(string));
            int s = StringNodes.getByteList(string).getBegin();
            int end = s + StringNodes.getByteList(string).getRealSize();
            byte[] bytes = StringNodes.getByteList(string).getUnsafeBytes();
            for (p = s; p < end && ASCIIEncoding.INSTANCE.isSpace(c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)p, (int)end)); p += StringSupport.codeLength((Encoding)enc, (int)c)) {
            }
            if (p > s) {
                StringNodes.getByteList(string).view(p - s, end - p);
                StringNodes.keepCodeRange(string);
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"insert"}, required=2, lowerFixnumParameters={0}, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="index"), @NodeChild(type=RubyNode.class, value="otherString")})
    public static abstract class InsertNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode concatNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.concatNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return ToIntNodeGen.create(this.getContext(), this.getSourceSection(), index);
        }

        @CreateCast(value={"otherString"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization
        public Object insert(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int index, org.jruby.truffle.runtime.core.RubyString otherString) {
            if (index == -1) {
                return this.concatNode.call(frame, string, "<<", null, otherString);
            }
            if (index < 0) {
                ++index;
            }
            StringNodesHelper.replaceInternal(string, StringNodesHelper.checkIndex(string, index, this), 0, otherString);
            return this.taintResultNode.maybeTaint(otherString, string);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object initializeCopy(org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString from) {
            if (self == from) {
                return self;
            }
            StringNodes.getByteList(self).replace(StringNodes.getByteList(from).bytes());
            StringNodes.getByteList(self).setEncoding(StringNodes.getByteList(from).getEncoding());
            StringNodes.setCodeRange(self, StringNodes.getCodeRange(from));
            return self;
        }
    }

    @CoreMethod(names={"initialize"}, optional=1, taintFromParameter=0)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private ToStrNode toStrNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject initialize(org.jruby.truffle.runtime.core.RubyString self, NotProvided from) {
            return self;
        }

        @Specialization
        public RubyBasicObject initialize(org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString from) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if (this.isFrozenNode.executeIsFrozen(self)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().frozenError(self.getLogicalClass().getName(), this));
            }
            StringNodes.setByteList(self, StringNodes.getByteList(from).dup());
            StringNodes.setCodeRange(self, StringNodes.getCodeRange(from));
            return self;
        }

        @Specialization(guards={"!isRubyString(from)", "wasProvided(from)"})
        public RubyBasicObject initialize(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString self, Object from) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.initialize(self, this.toStrNode.executeRubyString(frame, from));
        }
    }

    @CoreMethod(names={"inspect"}, taintFromSelf=true)
    public static abstract class InspectNode
    extends CoreMethodArrayArgumentsNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject inspect(org.jruby.truffle.runtime.core.RubyString string) {
            RubyString inspected = (RubyString)RubyString.inspect19((Ruby)this.getContext().getRuntime(), (ByteList)StringNodes.getByteList(string));
            return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), inspected.getByteList());
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(org.jruby.truffle.runtime.core.RubyString string) {
            return StringNodes.getByteList(string).hashCode();
        }
    }

    @CoreMethod(names={"getbyte"}, required=1)
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile negativeIndexProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile indexOutOfBoundsProfile = ConditionProfile.createBinaryProfile();

        public GetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getByte(org.jruby.truffle.runtime.core.RubyString string, int index) {
            ByteList bytes = StringNodes.getByteList(string);
            if (this.negativeIndexProfile.profile(index < 0)) {
                index += bytes.getRealSize();
            }
            if (this.indexOutOfBoundsProfile.profile(index < 0 || index >= bytes.getRealSize())) {
                return this.nil();
            }
            return StringNodes.getByteList(string).get(index) & 0xFF;
        }
    }

    @CoreMethod(names={"force_encoding"}, required=1)
    public static abstract class ForceEncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        public ForceEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject forceEncoding(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString encodingName) {
            RubyEncoding encoding = RubyEncoding.getEncoding(encodingName.toString());
            return this.forceEncoding(string, encoding);
        }

        @Specialization
        public RubyBasicObject forceEncoding(org.jruby.truffle.runtime.core.RubyString string, RubyEncoding encoding) {
            StringNodes.forceEncoding(string, encoding.getEncoding());
            return string;
        }

        @Specialization(guards={"!isRubyString(encoding)", "!isRubyEncoding(encoding)"})
        public RubyBasicObject forceEncoding(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object encoding) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.forceEncoding(string, this.toStrNode.executeRubyString(frame, encoding));
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodArrayArgumentsNode {
        public EncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyEncoding encoding(org.jruby.truffle.runtime.core.RubyString string) {
            return RubyEncoding.getEncoding(StringNodes.getByteList(string).getEncoding());
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean empty(org.jruby.truffle.runtime.core.RubyString string) {
            return StringNodes.getByteList(string).length() == 0;
        }
    }

    @CoreMethod(names={"each_char"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={StringGuards.class})
    public static abstract class EachCharNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public EachCharNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isValidOr7BitEncoding(string)"})
        public RubyBasicObject eachChar(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyProc block) {
            int n;
            ByteList strByteList = StringNodes.getByteList(string);
            byte[] ptrBytes = strByteList.unsafeBytes();
            int ptr = strByteList.begin();
            int len = strByteList.getRealSize();
            Encoding enc = StringNodes.getByteList(string).getEncoding();
            for (int i = 0; i < len; i += n) {
                n = StringSupport.encFastMBCLen((byte[])ptrBytes, (int)(ptr + i), (int)(ptr + len), (Encoding)enc);
                this.yield(frame, block, this.substr(string, i, n));
            }
            return string;
        }

        @Specialization(guards={"!isValidOr7BitEncoding(string)"})
        public RubyBasicObject eachCharMultiByteEncoding(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyProc block) {
            int n;
            ByteList strByteList = StringNodes.getByteList(string);
            byte[] ptrBytes = strByteList.unsafeBytes();
            int ptr = strByteList.begin();
            int len = strByteList.getRealSize();
            Encoding enc = StringNodes.getByteList(string).getEncoding();
            for (int i = 0; i < len; i += n) {
                n = this.multiByteStringLength(enc, ptrBytes, ptr + i, ptr + len);
                this.yield(frame, block, this.substr(string, i, n));
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteStringLength(Encoding enc, byte[] bytes, int p, int end) {
            return StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
        }

        private Object substr(org.jruby.truffle.runtime.core.RubyString string, int beg, int len) {
            ByteList bytes = StringNodes.getByteList(string);
            int length = bytes.length();
            if (len < 0 || beg > length) {
                return this.nil();
            }
            if (beg < 0 && (beg += length) < 0) {
                return this.nil();
            }
            int end = Math.min(length, beg + len);
            ByteList substringBytes = new ByteList(bytes, beg, end - beg);
            substringBytes.setEncoding(bytes.getEncoding());
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            RubyBasicObject ret = StringNodes.createString(string.getLogicalClass(), substringBytes);
            return this.taintResultNode.maybeTaint(string, ret);
        }
    }

    @CoreMethod(names={"each_byte"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachByteNode
    extends YieldingCoreMethodNode {
        public EachByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject eachByte(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyProc block) {
            ByteList bytes = StringNodes.getByteList(string);
            for (int i = 0; i < bytes.getRealSize(); ++i) {
                this.yield(frame, block, bytes.get(i) & 0xFF);
            }
            return string;
        }
    }

    @CoreMethod(names={"downcase!"}, raiseIfFrozenSelf=true)
    public static abstract class DowncaseBangNode
    extends CoreMethodArrayArgumentsNode {
        public DowncaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject downcase(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList newByteList = StringNodesHelper.downcase(this.getContext().getRuntime(), StringNodes.getByteList(string));
            if (newByteList.equal(StringNodes.getByteList(string))) {
                return this.nil();
            }
            StringNodes.setByteList(string, newByteList);
            return string;
        }
    }

    @CoreMethod(names={"downcase"}, taintFromSelf=true)
    public static abstract class DowncaseNode
    extends CoreMethodArrayArgumentsNode {
        public DowncaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject downcase(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList newByteList = StringNodesHelper.downcase(this.getContext().getRuntime(), StringNodes.getByteList(string));
            return StringNodes.createString(string.getLogicalClass(), newByteList);
        }
    }

    @CoreMethod(names={"delete!"}, argumentsAsArray=true, raiseIfFrozenSelf=true)
    public static abstract class DeleteBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStr;

        public DeleteBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = ToStrNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public Object deleteBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object ... args) {
            if (StringNodes.getByteList(string).length() == 0) {
                return this.nil();
            }
            if (args.length == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentErrorEmptyVarargs(this));
            }
            org.jruby.truffle.runtime.core.RubyString[] otherStrings = new org.jruby.truffle.runtime.core.RubyString[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeRubyString(frame, args[i]);
            }
            return this.deleteBangSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private Object deleteBangSlow(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString ... otherStrings) {
            org.jruby.truffle.runtime.core.RubyString otherString = otherStrings[0];
            Encoding enc = StringNodes.checkEncoding(string, StringNodes.getCodeRangeable(otherString), this);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringNodes.getByteList(otherString), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                enc = StringNodes.checkEncoding(string, StringNodes.getCodeRangeable(otherStrings[i]), this);
                tables = StringSupport.trSetupTable((ByteList)StringNodes.getByteList(otherStrings[i]), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            if (StringSupport.delete_bangCommon19((CodeRangeable)StringNodes.getCodeRangeable(string), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc) == null) {
                return this.nil();
            }
            return string;
        }
    }

    @CoreMethod(names={"data"})
    public static abstract class DataNode
    extends CoreMethodArrayArgumentsNode {
        public DataNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject data(org.jruby.truffle.runtime.core.RubyString string) {
            return ByteArrayNodes.createByteArray(this.getContext().getCoreLibrary().getByteArrayClass(), StringNodes.getByteList(string));
        }
    }

    @CoreMethod(names={"crypt"}, required=1, taintFromSelf=true, taintFromParameter=0)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="salt")})
    public static abstract class CryptNode
    extends CoreMethodNode {
        public CryptNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"salt"})
        public RubyNode coerceSaltToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization
        public Object crypt(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString salt) {
            ByteList value = StringNodes.getByteList(string);
            Encoding ascii8bit = this.getContext().getRuntime().getEncodingService().getAscii8bitEncoding();
            ByteList otherBL = StringNodes.getByteList(salt).dup();
            RubyBasicObject otherStr = StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), otherBL);
            StringNodes.modify(otherStr);
            StringSupport.associateEncoding((CodeRangeable)StringNodes.getCodeRangeable(otherStr), (Encoding)ascii8bit);
            if (otherBL.length() < 2) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("salt too short (need >= 2 bytes)", this));
            }
            POSIX posix = this.posix();
            byte[] keyBytes = Arrays.copyOfRange(value.unsafeBytes(), value.begin(), value.realSize());
            byte[] saltBytes = Arrays.copyOfRange(otherBL.unsafeBytes(), otherBL.begin(), otherBL.realSize());
            if (saltBytes[0] == 0 || saltBytes[1] == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("salt too short (need >= 2 bytes)", this));
            }
            byte[] cryptedString = posix.crypt(keyBytes, saltBytes);
            if (cryptedString == null) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().errnoError(posix.errno(), this));
            }
            RubyBasicObject result = StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(cryptedString, 0, cryptedString.length - 1));
            StringSupport.associateEncoding((CodeRangeable)StringNodes.getCodeRangeable(result), (Encoding)ascii8bit);
            return result;
        }
    }

    @CoreMethod(names={"count"}, argumentsAsArray=true)
    public static abstract class CountNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStr;

        public CountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = ToStrNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public int count(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object[] args) {
            if (StringNodes.getByteList(string).getRealSize() == 0) {
                return 0;
            }
            if (args.length == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentErrorEmptyVarargs(this));
            }
            org.jruby.truffle.runtime.core.RubyString[] otherStrings = new org.jruby.truffle.runtime.core.RubyString[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeRubyString(frame, args[i]);
            }
            return this.countSlow(string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private int countSlow(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString[] otherStrings) {
            org.jruby.truffle.runtime.core.RubyString otherStr = otherStrings[0];
            Encoding enc = StringNodes.getByteList(otherStr).getEncoding();
            boolean[] table = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)StringNodes.getByteList(otherStr), (Ruby)this.getContext().getRuntime(), (boolean[])table, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                enc = StringNodes.checkEncoding(string, StringNodes.getCodeRangeable(otherStr), this);
                tables = StringSupport.trSetupTable((ByteList)StringNodes.getByteList(otherStr), (Ruby)this.getContext().getRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            return StringSupport.countCommon19((ByteList)StringNodes.getByteList(string), (Ruby)this.getContext().getRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (Encoding)enc);
        }
    }

    @CoreMethod(names={"chop!"}, raiseIfFrozenSelf=true)
    public static abstract class ChopBangNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SizeNode sizeNode;

        public ChopBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.sizeNode = StringNodesFactory.SizeNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        @Specialization
        public Object chopBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string) {
            if (this.sizeNode.executeInteger(frame, string) == 0) {
                return this.nil();
            }
            int newLength = this.choppedLength(string);
            StringNodes.getByteList(string).view(0, newLength);
            if (StringNodes.getCodeRange(string) != 16) {
                StringNodes.clearCodeRange(string);
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private int choppedLength(org.jruby.truffle.runtime.core.RubyString string) {
            return StringSupport.choppedLength19((CodeRangeable)StringNodes.getCodeRangeable(string), (Ruby)this.getContext().getRuntime());
        }
    }

    @CoreMethod(names={"casecmp"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class CaseCmpNode
    extends CoreMethodNode {
        public CaseCmpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"bothSingleByteOptimizable(string, other)"})
        public Object caseCmpSingleByte(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            if (StringSupport.areCompatible((CodeRangeable)StringNodes.getCodeRangeable(string), (CodeRangeable)StringNodes.getCodeRangeable(other)) == null) {
                return this.nil();
            }
            return StringNodes.getByteList(string).caseInsensitiveCmp(StringNodes.getByteList(other));
        }

        @Specialization(guards={"!bothSingleByteOptimizable(string, other)"})
        public Object caseCmp(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            Encoding encoding = StringSupport.areCompatible((CodeRangeable)StringNodes.getCodeRangeable(string), (CodeRangeable)StringNodes.getCodeRangeable(other));
            if (encoding == null) {
                return this.nil();
            }
            return this.multiByteCasecmp(encoding, StringNodes.getByteList(string), StringNodes.getByteList(other));
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteCasecmp(Encoding enc, ByteList value, ByteList otherValue) {
            return StringSupport.multiByteCasecmp((Encoding)enc, (ByteList)value, (ByteList)otherValue);
        }

        public static boolean bothSingleByteOptimizable(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            boolean stringSingleByteOptimizable = StringSupport.isSingleByteOptimizable((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)StringNodes.getByteList(string).getEncoding());
            boolean otherSingleByteOptimizable = StringSupport.isSingleByteOptimizable((CodeRangeable)StringNodes.getCodeRangeable(other), (Encoding)StringNodes.getByteList(other).getEncoding());
            return stringSingleByteOptimizable && otherSingleByteOptimizable;
        }
    }

    @CoreMethod(names={"bytesize"})
    public static abstract class ByteSizeNode
    extends CoreMethodArrayArgumentsNode {
        public ByteSizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int byteSize(org.jruby.truffle.runtime.core.RubyString string) {
            return StringNodes.getByteList(string).length();
        }
    }

    @CoreMethod(names={"bytes"})
    public static abstract class BytesNode
    extends CoreMethodArrayArgumentsNode {
        public BytesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject bytes(org.jruby.truffle.runtime.core.RubyString string) {
            byte[] bytes = StringNodes.getByteList(string).bytes();
            int[] store = new int[bytes.length];
            for (int n = 0; n < store.length; ++n) {
                store[n] = bytes[n] & 0xFF;
            }
            return this.createArray(store, bytes.length);
        }
    }

    @CoreMethod(names={"b"}, taintFromSelf=true)
    public static abstract class BNode
    extends CoreMethodArrayArgumentsNode {
        public BNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject b(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList bytes = StringNodes.getByteList(string).dup();
            bytes.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), bytes);
        }
    }

    @CoreMethod(names={"ascii_only?"})
    public static abstract class ASCIIOnlyNode
    extends CoreMethodArrayArgumentsNode {
        public ASCIIOnlyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean asciiOnly(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList byteList = StringNodes.getByteList(string);
            if (!byteList.getEncoding().isAsciiCompatible()) {
                return false;
            }
            for (int i = 0; i < byteList.length(); ++i) {
                if ((byteList.get(i) & 0x80) == 0) continue;
                return false;
            }
            return true;
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1}, taintFromSelf=true)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private CallDispatchHeadNode includeNode;
        @Node.Child
        private CallDispatchHeadNode dupNode;
        @Node.Child
        private SizeNode sizeNode;
        @Node.Child
        private StringPrimitiveNodes.StringSubstringPrimitiveNode substringNode;
        private final BranchProfile outOfBounds = BranchProfile.create();

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object getIndex(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int index, Object length) {
            int normalizedIndex = StringNodes.normalizeIndex(string, index);
            ByteList bytes = StringNodes.getByteList(string);
            if (normalizedIndex < 0 || normalizedIndex >= bytes.length()) {
                this.outOfBounds.enter();
                return this.nil();
            }
            return this.getSubstringNode().execute(frame, string, index, 1);
        }

        @Specialization(guards={"!isRubyRange(index)", "!isRubyRegexp(index)", "!isRubyString(index)", "wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object getIndex(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object index, Object length) {
            return this.getIndex(frame, string, this.getToIntNode().doInt(frame, index), length);
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceIntegerRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRange.IntegerFixnumRange range, Object length) {
            return this.sliceRange(frame, string, range.getBegin(), range.getEnd(), range.doesExcludeEnd());
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceLongRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRange.LongFixnumRange range, Object length) {
            return this.sliceRange(frame, string, (int)range.getBegin(), (int)range.getEnd(), range.doesExcludeEnd());
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object sliceObjectRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRange.ObjectRange range, Object length) {
            int coercedBegin = this.getToIntNode().doInt(frame, range.getBegin());
            int coercedEnd = this.getToIntNode().doInt(frame, range.getEnd());
            return this.sliceRange(frame, string, coercedBegin, coercedEnd, range.doesExcludeEnd());
        }

        private Object sliceRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int begin, int end, boolean doesExcludeEnd) {
            int stringLength;
            if (this.sizeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.sizeNode = (SizeNode)this.insert(StringNodesFactory.SizeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
            }
            if ((begin = StringNodes.normalizeIndex(stringLength = this.sizeNode.executeInteger(frame, string), begin)) < 0 || begin > stringLength) {
                this.outOfBounds.enter();
                return this.nil();
            }
            if (begin == stringLength) {
                ByteList byteList = new ByteList();
                byteList.setEncoding(StringNodes.getByteList(string).getEncoding());
                return StringNodes.createString(string.getLogicalClass(), byteList);
            }
            end = StringNodes.normalizeIndex(stringLength, end);
            int length = StringNodes.clampExclusiveIndex(string, doesExcludeEnd ? end : end + 1);
            if (length > stringLength) {
                length = stringLength;
            }
            if ((length -= begin) < 0) {
                length = 0;
            }
            return this.getSubstringNode().execute(frame, string, begin, length);
        }

        @Specialization
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int start, int length) {
            return this.getSubstringNode().execute(frame, string, start, length);
        }

        @Specialization(guards={"wasProvided(length)"})
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int start, Object length) {
            return this.slice(frame, string, start, this.getToIntNode().doInt(frame, length));
        }

        @Specialization(guards={"!isRubyRange(start)", "!isRubyRegexp(start)", "!isRubyString(start)", "wasProvided(length)"})
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object start, Object length) {
            return this.slice(frame, string, this.getToIntNode().doInt(frame, start), this.getToIntNode().doInt(frame, length));
        }

        @Specialization(guards={"wasNotProvided(capture) || isRubiniusUndefined(capture)"})
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRegexp regexp, Object capture) {
            return this.sliceCapture(frame, string, regexp, 0);
        }

        @Specialization(guards={"wasProvided(capture)"})
        public Object sliceCapture(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRegexp regexp, Object capture) {
            return this.ruby(frame, "match, str = subpattern(index, other); Regexp.last_match = match; str", "index", regexp, "other", capture);
        }

        @Specialization(guards={"wasNotProvided(length) || isRubiniusUndefined(length)"})
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString matchStr, Object length) {
            boolean result;
            if (this.includeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.includeNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (result = this.includeNode.callBoolean(frame, string, "include?", null, matchStr)) {
                if (this.dupNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.dupNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                throw new TaintResultNode.DoNotTaint(this.dupNode.call(frame, matchStr, "dup", null, new Object[0]));
            }
            return this.nil();
        }

        private ToIntNode getToIntNode() {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.toIntNode;
        }

        private StringPrimitiveNodes.StringSubstringPrimitiveNode getSubstringNode() {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.substringNode = (StringPrimitiveNodes.StringSubstringPrimitiveNode)this.insert(StringPrimitiveNodesFactory.StringSubstringPrimitiveNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            return this.substringNode;
        }

        @Override
        protected boolean isRubiniusUndefined(Object object) {
            return object == this.getContext().getCoreLibrary().getRubiniusUndefined();
        }
    }

    @CoreMethod(names={"<<", "concat"}, required=1, taintFromParameter=0, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ConcatNode
    extends CoreMethodNode {
        public ConcatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject concat(org.jruby.truffle.runtime.core.RubyString string, int other) {
            if (other < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(other));
            }
            return this.concatNumeric(string, other);
        }

        @Specialization
        public RubyBasicObject concat(org.jruby.truffle.runtime.core.RubyString string, long other) {
            if (other < 0L) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(other));
            }
            return this.concatNumeric(string, (int)other);
        }

        @Specialization(guards={"isRubyBignum(other)"})
        public RubyBasicObject concat(org.jruby.truffle.runtime.core.RubyString string, RubyBasicObject other) {
            if (BignumNodes.getBigIntegerValue(other).signum() < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError("bignum out of char range", (Node)this));
            }
            return this.concatNumeric(string, BignumNodes.getBigIntegerValue(other).intValue());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject concat(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            int codeRange = StringNodes.getCodeRange(other);
            int[] ptr_cr_ret = new int[]{codeRange};
            try {
                EncodingUtils.encCrStrBufCat((Ruby)this.getContext().getRuntime(), (CodeRangeable)StringNodes.getCodeRangeable(string), (ByteList)StringNodes.getByteList(other), (Encoding)StringNodes.getByteList(other).getEncoding(), (int)codeRange, (int[])ptr_cr_ret);
            }
            catch (RaiseException e) {
                if (e.getException().getMetaClass() == this.getContext().getRuntime().getEncodingCompatibilityError()) {
                    CompilerDirectives.transferToInterpreter();
                    throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(e.getException().message.asJavaString(), this));
                }
                throw e;
            }
            StringNodes.setCodeRange(other, ptr_cr_ret[0]);
            return string;
        }

        @Specialization(guards={"!isInteger(other)", "!isLong(other)", "!isRubyBignum(other)", "!isRubyString(other)"})
        public Object concat(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object other) {
            return this.ruby(frame, "concat StringValue(other)", "other", other);
        }

        @CompilerDirectives.TruffleBoundary
        private RubyBasicObject concatNumeric(org.jruby.truffle.runtime.core.RubyString string, int c) {
            int cl;
            ByteList value = StringNodes.getByteList(string);
            Encoding enc = value.getEncoding();
            try {
                cl = StringSupport.codeLength((Encoding)enc, (int)c);
                StringNodes.modify(string, value.getRealSize() + cl);
                StringNodes.clearCodeRange(string);
                if (enc == USASCIIEncoding.INSTANCE) {
                    if (c > 255) {
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(c));
                    }
                    if (c > 121) {
                        value.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
                        enc = value.getEncoding();
                    }
                }
                enc.codeToMbc(c, value.getUnsafeBytes(), value.getBegin() + value.getRealSize());
            }
            catch (EncodingException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(c));
            }
            value.setRealSize(value.getRealSize() + cl);
            return string;
        }

        private RubyException charRangeException(Number value) {
            return this.getContext().getCoreLibrary().rangeError(String.format("%d out of char range", value), (Node)this);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode cmpNode;
        @Node.Child
        private CmpIntNode cmpIntNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToCmpNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToStrNode toStrNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int compare(org.jruby.truffle.runtime.core.RubyString a, org.jruby.truffle.runtime.core.RubyString b) {
            int ret = StringNodes.getByteList(a).cmp(StringNodes.getByteList(b));
            if (ret == 0 && !StringSupport.areComparable((CodeRangeable)StringNodes.getCodeRangeable(a), (CodeRangeable)StringNodes.getCodeRangeable(b))) {
                return StringNodes.getByteList(a).getEncoding().getIndex() > StringNodes.getByteList(b).getEncoding().getIndex() ? 1 : -1;
            }
            return ret;
        }

        @Specialization(guards={"!isRubyString(b)"})
        public Object compare(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString a, Object b) {
            CompilerDirectives.transferToInterpreter();
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToStrNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToToStrNode.doesRespondToString(frame, b, (org.jruby.truffle.runtime.core.RubyString)StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), "to_str"), false)) {
                if (this.toStrNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
                }
                try {
                    org.jruby.truffle.runtime.core.RubyString coerced = this.toStrNode.executeRubyString(frame, b);
                    return this.compare(a, coerced);
                }
                catch (org.jruby.truffle.runtime.control.RaiseException e) {
                    if (e.getRubyException().getLogicalClass() == this.getContext().getCoreLibrary().getTypeErrorClass()) {
                        return this.nil();
                    }
                    throw e;
                }
            }
            if (this.respondToCmpNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToCmpNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToCmpNode.doesRespondToString(frame, b, (org.jruby.truffle.runtime.core.RubyString)StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), "<=>"), false)) {
                Object cmpResult;
                if (this.cmpNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.cmpNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                if ((cmpResult = this.cmpNode.call(frame, b, "<=>", null, a)) == this.nil()) {
                    return this.nil();
                }
                if (this.cmpIntNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.cmpIntNode = (CmpIntNode)this.insert(CmpIntNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                return -this.cmpIntNode.executeCmpInt(frame, cmpResult, a, b);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "===", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private StringPrimitiveNodes.StringEqualPrimitiveNode stringEqualNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToNode;
        @Node.Child
        private CallDispatchHeadNode objectEqualNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.stringEqualNode = StringPrimitiveNodesFactory.StringEqualPrimitiveNodeFactory.create(context, sourceSection, new RubyNode[0]);
        }

        @Specialization
        public boolean equal(org.jruby.truffle.runtime.core.RubyString a, org.jruby.truffle.runtime.core.RubyString b) {
            return this.stringEqualNode.stringEqual(a, b);
        }

        @Specialization(guards={"!isRubyString(b)"})
        public boolean equal(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString a, Object b) {
            if (this.respondToNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToNode.doesRespondToString(frame, b, (org.jruby.truffle.runtime.core.RubyString)StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), "to_str"), false)) {
                if (this.objectEqualNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.objectEqualNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                return this.objectEqualNode.callBoolean(frame, b, "==", null, a);
            }
            return false;
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class MulNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile negativeTimesProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private ToIntNode toIntNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject multiply(org.jruby.truffle.runtime.core.RubyString string, int times) {
            if (this.negativeTimesProfile.profile(times < 0)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            ByteList inputBytes = StringNodes.getByteList(string);
            ByteList outputBytes = new ByteList(StringNodes.getByteList(string).length() * times);
            for (int n = 0; n < times; ++n) {
                outputBytes.append(inputBytes);
            }
            outputBytes.setEncoding(inputBytes.getEncoding());
            RubyBasicObject ret = StringNodes.createString(string.getLogicalClass(), outputBytes);
            StringNodes.setCodeRange(ret, StringNodes.getCodeRange(string));
            return ret;
        }

        @Specialization(guards={"isRubyBignum(times)"})
        public RubyBasicObject multiply(org.jruby.truffle.runtime.core.RubyString string, RubyBasicObject times) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError("bignum too big to convert into `long'", (Node)this));
        }

        @Specialization(guards={"!isRubyBignum(times)", "!isInteger(times)"})
        public RubyBasicObject multiply(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object times) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.multiply(string, this.toIntNode.doInt(frame, times));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="string"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class AddNode
    extends CoreMethodNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization
        public RubyBasicObject add(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            Encoding enc = StringNodes.checkEncoding(string, StringNodes.getCodeRangeable(other), this);
            RubyBasicObject ret = this.createString(StringSupport.addByteLists((ByteList)StringNodes.getByteList(string), (ByteList)StringNodes.getByteList(other)));
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            StringNodes.getByteList(ret).setEncoding(enc);
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(other, ret);
            return ret;
        }
    }

    public static class StringType
    extends BasicObjectType {
    }
}

