/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;

@CoreClass(name="Range")
public abstract class RangeNodes {

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="excludeEnd")})
    public static abstract class InternalSetExcludeEndNode
    extends RubyNode {
        public InternalSetExcludeEndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"excludeEnd"})
        public RubyNode castToBoolean(RubyNode excludeEnd) {
            return BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), excludeEnd);
        }

        @Specialization
        public boolean setExcludeEnd(RubyRange.ObjectRange range, boolean excludeEnd) {
            range.setExcludeEnd(excludeEnd);
            return excludeEnd;
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="end")})
    public static abstract class InternalSetEndNode
    extends RubyNode {
        public InternalSetEndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setEnd(RubyRange.ObjectRange range, Object end) {
            range.setEnd(end);
            return end;
        }
    }

    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="begin")})
    public static abstract class InternalSetBeginNode
    extends RubyNode {
        public InternalSetBeginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setBegin(RubyRange.ObjectRange range, Object begin) {
            range.setBegin(begin);
            return begin;
        }
    }

    @CoreMethod(names={"to_a"}, lowerFixnumSelf=true)
    public static abstract class ToANode
    extends CoreMethodArrayArgumentsNode {
        public ToANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toA(RubyRange.IntegerFixnumRange range) {
            int begin = range.getBegin();
            int length = range.getExclusiveEnd() - begin;
            if (length < 0) {
                return this.createEmptyArray();
            }
            int[] values = new int[length];
            for (int n = 0; n < length; ++n) {
                values[n] = begin + n;
            }
            return this.createArray(values, length);
        }

        @Specialization
        public Object toA(VirtualFrame frame, RubyRange.ObjectRange range) {
            return this.ruby(frame, "to_a_internal", new Object[0]);
        }
    }

    @CoreMethod(names={"step"}, needsBlock=true, optional=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class StepNode
    extends YieldingCoreMethodNode {
        public StepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isStepValid(range, step, block)"})
        public Object step(VirtualFrame frame, RubyRange.IntegerFixnumRange range, int step, RubyProc block) {
            int count = 0;
            try {
                for (int n = range.getBegin(); n < range.getExclusiveEnd(); n += step) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isStepValid(range, step, block)"})
        public Object step(VirtualFrame frame, RubyRange.LongFixnumRange range, int step, RubyProc block) {
            int count = 0;
            try {
                for (long n = range.getBegin(); n < range.getExclusiveEnd(); n += (long)step) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        @Specialization(guards={"!isStepValidInt(range, step, block)", "wasProvided(step)"})
        public Object stepFallback(VirtualFrame frame, RubyRange.IntegerFixnumRange range, Object step, RubyProc block) {
            return this.ruby(frame, "step_internal(step, &block)", "step", step, "block", block);
        }

        @Specialization(guards={"!isStepValidInt(range, step, block)", "wasProvided(step)"})
        public Object stepFallback(VirtualFrame frame, RubyRange.LongFixnumRange range, Object step, RubyProc block) {
            return this.ruby(frame, "step_internal(step, &block)", "step", step, "block", block);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.IntegerFixnumRange range, NotProvided step, NotProvided block) {
            return this.ruby(frame, "step_internal", new Object[0]);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.IntegerFixnumRange range, NotProvided step, RubyProc block) {
            return this.ruby(frame, "step_internal(&block)", "block", block);
        }

        @Specialization(guards={"!isInteger(step)", "!isLong(step)", "wasProvided(step)"})
        public Object step(VirtualFrame frame, RubyRange.IntegerFixnumRange range, Object step, NotProvided block) {
            return this.ruby(frame, "step_internal(step)", "step", step);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.LongFixnumRange range, NotProvided step, NotProvided block) {
            return this.ruby(frame, "step_internal", new Object[0]);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.LongFixnumRange range, NotProvided step, RubyProc block) {
            return this.ruby(frame, "step_internal(&block)", "block", block);
        }

        @Specialization(guards={"wasProvided(step)"})
        public Object step(VirtualFrame frame, RubyRange.LongFixnumRange range, Object step, NotProvided block) {
            return this.ruby(frame, "step_internal(step)", "step", step);
        }

        @Specialization(guards={"wasProvided(step)"})
        public Object step(VirtualFrame frame, RubyRange.ObjectRange range, Object step, RubyProc block) {
            return this.ruby(frame, "step_internal(step, &block)", "step", step, "block", block);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.ObjectRange range, NotProvided step, NotProvided block) {
            return this.ruby(frame, "step_internal", new Object[0]);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.ObjectRange range, NotProvided step, RubyProc block) {
            return this.ruby(frame, "step_internal(&block)", "block", block);
        }

        @Specialization(guards={"wasProvided(step)"})
        public Object step(VirtualFrame frame, RubyRange.ObjectRange range, Object step, NotProvided block) {
            return this.ruby(frame, "step_internal(step)", "step", step);
        }

        public static boolean isStepValidInt(RubyRange.IntegerFixnumRange fixnumRange, Object step, RubyProc proc) {
            return step instanceof Integer && (Integer)step > 0;
        }

        public static boolean isStepValidInt(RubyRange.LongFixnumRange fixnumRange, Object step, RubyProc proc) {
            return step instanceof Integer && (Integer)step > 0;
        }

        public static boolean isStepValid(RubyRange.IntegerFixnumRange fixnumRange, int step, RubyProc proc) {
            return step > 0;
        }

        public static boolean isStepValid(RubyRange.LongFixnumRange fixnumRange, int step, RubyProc proc) {
            return step > 0;
        }
    }

    @CoreMethod(names={"end"})
    public static abstract class EndNode
    extends CoreMethodArrayArgumentsNode {
        public EndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int last(RubyRange.IntegerFixnumRange range) {
            return range.getEnd();
        }

        @Specialization
        public long last(RubyRange.LongFixnumRange range) {
            return range.getEnd();
        }

        @Specialization
        public Object last(RubyRange.ObjectRange range) {
            return range.getEnd();
        }
    }

    @CoreMethod(names={"initialize_internal"}, required=2, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyRange.ObjectRange initialize(RubyRange.ObjectRange range, Object begin, Object end, NotProvided excludeEnd) {
            return this.initialize(range, begin, end, false);
        }

        @Specialization
        public RubyRange.ObjectRange initialize(RubyRange.ObjectRange range, Object begin, Object end, boolean excludeEnd) {
            range.initialize(begin, end, excludeEnd);
            return range;
        }
    }

    @CoreMethod(names={"begin"})
    public static abstract class BeginNode
    extends CoreMethodArrayArgumentsNode {
        public BeginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int each(RubyRange.IntegerFixnumRange range) {
            return range.getBegin();
        }

        @Specialization
        public long each(RubyRange.LongFixnumRange range) {
            return range.getBegin();
        }

        @Specialization
        public Object each(RubyRange.ObjectRange range) {
            return range.getBegin();
        }
    }

    @CoreMethod(names={"exclude_end?"})
    public static abstract class ExcludeEndNode
    extends CoreMethodArrayArgumentsNode {
        public ExcludeEndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean excludeEnd(RubyRange range) {
            return range.doesExcludeEnd();
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true, lowerFixnumSelf=true, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object each(VirtualFrame frame, RubyRange.IntegerFixnumRange range, RubyProc block) {
            int exclusiveEnd = range.getExclusiveEnd();
            int count = 0;
            try {
                for (int n = range.getBegin(); n < exclusiveEnd; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object each(VirtualFrame frame, RubyRange.LongFixnumRange range, RubyProc block) {
            long exclusiveEnd = range.getExclusiveEnd();
            int count = 0;
            try {
                for (long n = range.getBegin(); n < exclusiveEnd; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        @Specialization
        public Object each(VirtualFrame frame, RubyRange.LongFixnumRange range, NotProvided proc) {
            return this.ruby(frame, "each_internal(&block)", "block", this.nil());
        }

        @Specialization
        public Object each(VirtualFrame frame, RubyRange.ObjectRange range, NotProvided proc) {
            return this.ruby(frame, "each_internal(&block)", "block", this.nil());
        }

        @Specialization
        public Object each(VirtualFrame frame, RubyRange.ObjectRange range, RubyProc proc) {
            return this.ruby(frame, "each_internal(&block)", "block", proc);
        }
    }

    @CoreMethod(names={"collect", "map"}, needsBlock=true, lowerFixnumSelf=true)
    public static abstract class CollectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public CollectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public RubyBasicObject collect(VirtualFrame frame, RubyRange.IntegerFixnumRange range, RubyProc block) {
            int begin = range.getBegin();
            int exclusiveEnd = range.getExclusiveEnd();
            int length = exclusiveEnd - begin;
            Object store = this.arrayBuilder.start(length);
            int count = 0;
            try {
                for (int n = 0; n < length; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    store = this.arrayBuilder.appendValue(store, n, this.yield(frame, block, n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return ArrayNodes.createGeneralArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(store, length), length);
        }
    }
}

