/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;

@GeneratedBy(value=KernelNodes.class)
public final class KernelNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(BacktickNodeFactory.getInstance(), SameOrEqualNodeFactory.getInstance(), MatchNodeFactory.getInstance(), NotMatchNodeFactory.getInstance(), CompareNodeFactory.getInstance(), AbortNodeFactory.getInstance(), BindingNodeFactory.getInstance(), BlockGivenNodeFactory.getInstance(), CalleeNameNodeFactory.getInstance(), CallerLocationsNodeFactory.getInstance(), KernelClassNodeFactory.getInstance(), CopyNodeFactory.getInstance(), CloneNodeFactory.getInstance(), DupNodeFactory.getInstance(), EvalNodeFactory.getInstance(), ExecNodeFactory.getInstance(), ExitNodeFactory.getInstance(), ExitBangNodeFactory.getInstance(), ForkNodeFactory.getInstance(), KernelFreezeNodeFactory.getInstance(), KernelFrozenNodeFactory.getInstance(), GetsNodeFactory.getInstance(), HashNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InitializeDupCloneNodeFactory.getInstance(), InstanceOfNodeFactory.getInstance(), InstanceVariableDefinedNodeFactory.getInstance(), InstanceVariableGetNodeFactory.getInstance(), InstanceVariableSetNodeFactory.getInstance(), InstanceVariablesNodeFactory.getInstance(), IsANodeFactory.getInstance(), LambdaNodeFactory.getInstance(), LoadNodeFactory.getInstance(), LocalVariablesNodeFactory.getInstance(), MethodNameNodeFactory.getInstance(), MethodNodeFactory.getInstance(), MethodsNodeFactory.getInstance(), NilNodeFactory.getInstance(), PrivateMethodsNodeFactory.getInstance(), ProcNodeFactory.getInstance(), ProtectedMethodsNodeFactory.getInstance(), PublicMethodsNodeFactory.getInstance(), RandNodeFactory.getInstance(), RequireNodeFactory.getInstance(), RequireRelativeNodeFactory.getInstance(), RespondToNodeFactory.getInstance(), RespondToMissingNodeFactory.getInstance(), SetTraceFuncNodeFactory.getInstance(), SingletonClassMethodNodeFactory.getInstance(), SingletonMethodsNodeFactory.getInstance(), StringNodeFactory.getInstance(), SleepNodeFactory.getInstance(), FormatNodeFactory.getInstance(), SystemNodeFactory.getInstance(), KernelTaintNodeFactory.getInstance(), KernelIsTaintedNodeFactory.getInstance(), ToHexStringNodeFactory.getInstance(), ToSNodeFactory.getInstance(), UntaintNodeFactory.getInstance());
    }

    @GeneratedBy(value=KernelNodes.UntaintNode.class)
    public static final class UntaintNodeFactory
    extends NodeFactoryBase<KernelNodes.UntaintNode> {
        private static UntaintNodeFactory untaintNodeFactoryInstance;

        private UntaintNodeFactory() {
            super(KernelNodes.UntaintNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.UntaintNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UntaintNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.UntaintNode> getInstance() {
            if (untaintNodeFactoryInstance == null) {
                untaintNodeFactoryInstance = new UntaintNodeFactory();
            }
            return untaintNodeFactoryInstance;
        }

        public static KernelNodes.UntaintNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UntaintNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        public static final class UntaintNodeGen
        extends KernelNodes.UntaintNode {
            @Node.Child
            private RubyNode arguments0_;

            private UntaintNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.taint(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<KernelNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(KernelNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static KernelNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToSNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends KernelNodes.ToSNode {
            @Node.Child
            private RubyNode arguments0_;

            private ToSNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public RubyBasicObject executeToS(VirtualFrame frameValue, Object arguments0Value) {
                return this.toS(frameValue, arguments0Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.toS(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
    public static final class ToHexStringNodeFactory
    extends NodeFactoryBase<KernelNodes.ToHexStringNode> {
        private static ToHexStringNodeFactory toHexStringNodeFactoryInstance;

        private ToHexStringNodeFactory() {
            super(KernelNodes.ToHexStringNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ToHexStringNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToHexStringNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ToHexStringNode> getInstance() {
            if (toHexStringNodeFactoryInstance == null) {
                toHexStringNodeFactoryInstance = new ToHexStringNodeFactory();
            }
            return toHexStringNodeFactoryInstance;
        }

        public static KernelNodes.ToHexStringNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToHexStringNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
        public static final class ToHexStringNodeGen
        extends KernelNodes.ToHexStringNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToHexStringNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public String executeToHexString(VirtualFrame frameValue, Object arguments0Value) {
                return this.specialization_.executeString(frameValue, arguments0Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="toHexString(RubyBasicObject)", value=KernelNodes.ToHexStringNode.class)
            private static final class ToHexString2Node_
            extends BaseNode_ {
                ToHexString2Node_(ToHexStringNodeGen root) {
                    super(root, 3);
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.toHexString(arguments0Value_);
                    }
                    return this.getNext().executeString(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root) {
                    return new ToHexString2Node_(root);
                }
            }

            @GeneratedBy(methodName="toHexString(long)", value=KernelNodes.ToHexStringNode.class)
            private static final class ToHexString1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                ToHexString1Node_(ToHexStringNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ToHexString1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeString(frameValue, ex.getResult());
                        }
                    }
                    return this.root.toHexString(arguments0Value_);
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.toHexString(arguments0Value_);
                    }
                    return this.getNext().executeString(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root, Object arguments0Value) {
                    return new ToHexString1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="toHexString(int)", value=KernelNodes.ToHexStringNode.class)
            private static final class ToHexString0Node_
            extends BaseNode_ {
                ToHexString0Node_(ToHexStringNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeString(frameValue, ex.getResult());
                    }
                    return this.root.toHexString(arguments0Value_);
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.toHexString(arguments0Value_);
                    }
                    return this.getNext().executeString(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root) {
                    return new ToHexString0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToHexStringNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeString(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToHexStringNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    return (String)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ToHexStringNodeGen root;

                BaseNode_(ToHexStringNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeString((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract String executeString(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeString(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof Integer) {
                        return ToHexString0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return ToHexString1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyBignum(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return ToHexString2Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelIsTaintedNode.class)
    public static final class KernelIsTaintedNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelIsTaintedNode> {
        private static KernelIsTaintedNodeFactory kernelIsTaintedNodeFactoryInstance;

        private KernelIsTaintedNodeFactory() {
            super(KernelNodes.KernelIsTaintedNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelIsTaintedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelIsTaintedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelIsTaintedNode> getInstance() {
            if (kernelIsTaintedNodeFactoryInstance == null) {
                kernelIsTaintedNodeFactoryInstance = new KernelIsTaintedNodeFactory();
            }
            return kernelIsTaintedNodeFactoryInstance;
        }

        public static KernelNodes.KernelIsTaintedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelIsTaintedNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelIsTaintedNode.class)
        public static final class KernelIsTaintedNodeGen
        extends KernelNodes.KernelIsTaintedNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelIsTaintedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.isTainted(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelTaintNode.class)
    public static final class KernelTaintNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelTaintNode> {
        private static KernelTaintNodeFactory kernelTaintNodeFactoryInstance;

        private KernelTaintNodeFactory() {
            super(KernelNodes.KernelTaintNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelTaintNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelTaintNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelTaintNode> getInstance() {
            if (kernelTaintNodeFactoryInstance == null) {
                kernelTaintNodeFactoryInstance = new KernelTaintNodeFactory();
            }
            return kernelTaintNodeFactoryInstance;
        }

        public static KernelNodes.KernelTaintNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelTaintNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelTaintNode.class)
        public static final class KernelTaintNodeGen
        extends KernelNodes.KernelTaintNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelTaintNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.taint(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SystemNode.class)
    public static final class SystemNodeFactory
    extends NodeFactoryBase<KernelNodes.SystemNode> {
        private static SystemNodeFactory systemNodeFactoryInstance;

        private SystemNodeFactory() {
            super(KernelNodes.SystemNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SystemNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SystemNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SystemNode> getInstance() {
            if (systemNodeFactoryInstance == null) {
                systemNodeFactoryInstance = new SystemNodeFactory();
            }
            return systemNodeFactoryInstance;
        }

        public static KernelNodes.SystemNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SystemNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SystemNode.class)
        public static final class SystemNodeGen
        extends KernelNodes.SystemNode {
            @Node.Child
            private RubyNode arguments0_;

            private SystemNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyString arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.system(frameValue, arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.FormatNode.class)
    public static final class FormatNodeFactory
    extends NodeFactoryBase<KernelNodes.FormatNode> {
        private static FormatNodeFactory formatNodeFactoryInstance;

        private FormatNodeFactory() {
            super(KernelNodes.FormatNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.FormatNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FormatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.FormatNode> getInstance() {
            if (formatNodeFactoryInstance == null) {
                formatNodeFactoryInstance = new FormatNodeFactory();
            }
            return formatNodeFactoryInstance;
        }

        public static KernelNodes.FormatNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new FormatNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.FormatNode.class)
        public static final class FormatNodeGen
        extends KernelNodes.FormatNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeFormatCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private FormatNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="formatUncached(VirtualFrame, Object[], IndirectCallNode)", value=KernelNodes.FormatNode.class)
            private static final class FormatUncachedNode_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callPackNode;

                FormatUncachedNode_(FormatNodeGen root, IndirectCallNode callPackNode) {
                    super(root, 2);
                    this.callPackNode = callPackNode;
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    Object[] arguments0Value_;
                    if (arguments0Value instanceof Object[] && RubyGuards.isRubyString(this.root.firstArgument(arguments0Value_ = (Object[])arguments0Value))) {
                        return this.root.formatUncached(frameValue, arguments0Value_, this.callPackNode);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FormatNodeGen root, IndirectCallNode callPackNode) {
                    return new FormatUncachedNode_(root, callPackNode);
                }
            }

            @GeneratedBy(methodName="formatCached(VirtualFrame, Object[], ByteList, DirectCallNode)", value=KernelNodes.FormatNode.class)
            private static final class FormatCachedNode_
            extends BaseNode_ {
                private final ByteList cachedFormat;
                @Node.Child
                private DirectCallNode callPackNode;

                FormatCachedNode_(FormatNodeGen root, ByteList cachedFormat, DirectCallNode callPackNode) {
                    super(root, 1);
                    this.cachedFormat = cachedFormat;
                    this.callPackNode = callPackNode;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    if (newNode.getClass() == FormatUncachedNode_.class) {
                        this.removeSame("Contained by formatUncached(VirtualFrame, Object[], IndirectCallNode)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value) {
                    Object[] arguments0Value_;
                    return arguments0Value instanceof Object[] && RubyGuards.isRubyString(this.root.firstArgument(arguments0Value_ = (Object[])arguments0Value)) && this.root.byteListsEqual(this.root.asRubyString(this.root.firstArgument(arguments0Value_)), this.cachedFormat);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    Object[] arguments0Value_;
                    if (arguments0Value instanceof Object[] && RubyGuards.isRubyString(this.root.firstArgument(arguments0Value_ = (Object[])arguments0Value)) && this.root.byteListsEqual(this.root.asRubyString(this.root.firstArgument(arguments0Value_)), this.cachedFormat)) {
                        return this.root.formatCached(frameValue, arguments0Value_, this.cachedFormat, this.callPackNode);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FormatNodeGen root, ByteList cachedFormat, DirectCallNode callPackNode) {
                    return new FormatCachedNode_(root, cachedFormat, callPackNode);
                }
            }

            @GeneratedBy(value=KernelNodes.FormatNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FormatNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FormatNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.FormatNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FormatNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(FormatNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.FormatNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final FormatNodeGen root;

                BaseNode_(FormatNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Object[]) {
                        DirectCallNode callPackNode1;
                        BaseNode_ s;
                        Object[] arguments0Value_ = (Object[])arguments0Value;
                        ByteList cachedFormat1 = this.root.privatizeByteList(this.root.asRubyString(this.root.firstArgument(arguments0Value_)));
                        if (RubyGuards.isRubyString(this.root.firstArgument(arguments0Value_)) && this.root.byteListsEqual(this.root.asRubyString(this.root.firstArgument(arguments0Value_)), cachedFormat1) && !this.root.excludeFormatCached_ && this.countSame(s = FormatCachedNode_.create(this.root, cachedFormat1, callPackNode1 = DirectCallNode.create((CallTarget)this.root.compileFormat(this.root.asRubyString(this.root.firstArgument(arguments0Value_)))))) < 3) {
                            return s;
                        }
                        if (RubyGuards.isRubyString(this.root.firstArgument(arguments0Value_))) {
                            IndirectCallNode callPackNode2 = IndirectCallNode.create();
                            this.root.excludeFormatCached_ = true;
                            return FormatUncachedNode_.create(this.root, callPackNode2);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SleepNode.class)
    public static final class SleepNodeFactory
    extends NodeFactoryBase<KernelNodes.SleepNode> {
        private static SleepNodeFactory sleepNodeFactoryInstance;

        private SleepNodeFactory() {
            super(KernelNodes.SleepNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SleepNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SleepNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SleepNode> getInstance() {
            if (sleepNodeFactoryInstance == null) {
                sleepNodeFactoryInstance = new SleepNodeFactory();
            }
            return sleepNodeFactoryInstance;
        }

        public static KernelNodes.SleepNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SleepNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        public static final class SleepNodeGen
        extends KernelNodes.SleepNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SleepNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="sleep(VirtualFrame, RubyBasicObject)", value=KernelNodes.SleepNode.class)
            private static final class Sleep5Node_
            extends BaseNode_ {
                Sleep5Node_(SleepNodeGen root) {
                    super(root, 6);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    if (!this.root.isRubiniusUndefined(arguments0Value_)) {
                        return this.root.sleep(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && !this.root.isRubiniusUndefined(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.sleep(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep5Node_(root);
                }
            }

            @GeneratedBy(methodName="sleep(RubyBasicObject)", value=KernelNodes.SleepNode.class)
            private static final class Sleep4Node_
            extends BaseNode_ {
                Sleep4Node_(SleepNodeGen root) {
                    super(root, 5);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    if (this.root.isRubiniusUndefined(arguments0Value_)) {
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && this.root.isRubiniusUndefined(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep4Node_(root);
                }
            }

            @GeneratedBy(methodName="sleep(double)", value=KernelNodes.SleepNode.class)
            private static final class Sleep3Node_
            extends BaseNode_ {
                Sleep3Node_(SleepNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep3Node_(root);
                }
            }

            @GeneratedBy(methodName="sleep(long)", value=KernelNodes.SleepNode.class)
            private static final class Sleep2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Sleep2Node_(SleepNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Sleep2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeLong_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.sleep(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root, Object arguments0Value) {
                    return new Sleep2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="sleep(int)", value=KernelNodes.SleepNode.class)
            private static final class Sleep1Node_
            extends BaseNode_ {
                Sleep1Node_(SleepNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep1Node_(root);
                }
            }

            @GeneratedBy(methodName="sleep(NotProvided)", value=KernelNodes.SleepNode.class)
            private static final class Sleep0Node_
            extends BaseNode_ {
                Sleep0Node_(SleepNodeGen root) {
                    super(root, 1);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    NotProvided arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SleepNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SleepNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeLong_(frameValue, arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SleepNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SleepNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Long)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SleepNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SleepNodeGen root;

                BaseNode_(SleepNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeLong_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract long executeLong_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeLong_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public long executeLong(VirtualFrame frameValue) {
                    return (Long)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        return Sleep0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Integer) {
                        return Sleep1Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Sleep2Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof Double) {
                        return Sleep3Node_.create(this.root);
                    }
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (this.root.isRubiniusUndefined(arguments0Value_)) {
                            return Sleep4Node_.create(this.root);
                        }
                        return Sleep5Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.StringNode.class)
    public static final class StringNodeFactory
    extends NodeFactoryBase<KernelNodes.StringNode> {
        private static StringNodeFactory stringNodeFactoryInstance;

        private StringNodeFactory() {
            super(KernelNodes.StringNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.StringNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.StringNode> getInstance() {
            if (stringNodeFactoryInstance == null) {
                stringNodeFactoryInstance = new StringNodeFactory();
            }
            return stringNodeFactoryInstance;
        }

        public static KernelNodes.StringNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new StringNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.StringNode.class)
        public static final class StringNodeGen
        extends KernelNodes.StringNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private StringNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="string(VirtualFrame, Object)", value=KernelNodes.StringNode.class)
            private static final class String1Node_
            extends BaseNode_ {
                String1Node_(StringNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (!RubyGuards.isRubyString(arguments0Value)) {
                        return this.root.string(frameValue, arguments0Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(StringNodeGen root) {
                    return new String1Node_(root);
                }
            }

            @GeneratedBy(methodName="string(RubyString)", value=KernelNodes.StringNode.class)
            private static final class String0Node_
            extends BaseNode_ {
                String0Node_(StringNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyString) {
                        RubyString arguments0Value_ = (RubyString)arguments0Value;
                        return this.root.string(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(StringNodeGen root) {
                    return new String0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.StringNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(StringNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(StringNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.StringNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(StringNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(StringNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.StringNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final StringNodeGen root;

                BaseNode_(StringNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyString) {
                        return String0Node_.create(this.root);
                    }
                    if (!RubyGuards.isRubyString(arguments0Value)) {
                        return String1Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
    public static final class SingletonMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.SingletonMethodsNode> {
        private static SingletonMethodsNodeFactory singletonMethodsNodeFactoryInstance;

        private SingletonMethodsNodeFactory() {
            super(KernelNodes.SingletonMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public KernelNodes.SingletonMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return SingletonMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SingletonMethodsNode> getInstance() {
            if (singletonMethodsNodeFactoryInstance == null) {
                singletonMethodsNodeFactoryInstance = new SingletonMethodsNodeFactory();
            }
            return singletonMethodsNodeFactoryInstance;
        }

        public static KernelNodes.SingletonMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
            return new SingletonMethodsNodeGen(context, sourceSection, object, includeAncestors);
        }

        @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
        public static final class SingletonMethodsNodeGen
        extends KernelNodes.SingletonMethodsNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode includeAncestors_;

            private SingletonMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.object_ = object;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public RubyBasicObject executeSingletonMethods(VirtualFrame frameValue, Object objectValue, boolean includeAncestorsValue) {
                return this.singletonMethods(frameValue, objectValue, includeAncestorsValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeRubyBasicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeRubyBasicObject(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.singletonMethods(frameValue, objectValue_, includeAncestorsValue_);
            }

            protected UnsupportedSpecializationException unsupported(Object objectValue, Object includeAncestorsValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.object_, this.includeAncestors_}, new Object[]{objectValue, includeAncestorsValue});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SingletonClassMethodNode.class)
    public static final class SingletonClassMethodNodeFactory
    extends NodeFactoryBase<KernelNodes.SingletonClassMethodNode> {
        private static SingletonClassMethodNodeFactory singletonClassMethodNodeFactoryInstance;

        private SingletonClassMethodNodeFactory() {
            super(KernelNodes.SingletonClassMethodNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SingletonClassMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SingletonClassMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SingletonClassMethodNode> getInstance() {
            if (singletonClassMethodNodeFactoryInstance == null) {
                singletonClassMethodNodeFactoryInstance = new SingletonClassMethodNodeFactory();
            }
            return singletonClassMethodNodeFactoryInstance;
        }

        public static KernelNodes.SingletonClassMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SingletonClassMethodNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SingletonClassMethodNode.class)
        public static final class SingletonClassMethodNodeGen
        extends KernelNodes.SingletonClassMethodNode {
            @Node.Child
            private RubyNode arguments0_;

            private SingletonClassMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.singletonClass(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
    public static final class SetTraceFuncNodeFactory
    extends NodeFactoryBase<KernelNodes.SetTraceFuncNode> {
        private static SetTraceFuncNodeFactory setTraceFuncNodeFactoryInstance;

        private SetTraceFuncNodeFactory() {
            super(KernelNodes.SetTraceFuncNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SetTraceFuncNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetTraceFuncNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SetTraceFuncNode> getInstance() {
            if (setTraceFuncNodeFactoryInstance == null) {
                setTraceFuncNodeFactoryInstance = new SetTraceFuncNodeFactory();
            }
            return setTraceFuncNodeFactoryInstance;
        }

        public static KernelNodes.SetTraceFuncNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SetTraceFuncNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
        public static final class SetTraceFuncNodeGen
        extends KernelNodes.SetTraceFuncNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetTraceFuncNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="setTraceFunc(RubyProc)", value=KernelNodes.SetTraceFuncNode.class)
            private static final class SetTraceFunc1Node_
            extends BaseNode_ {
                SetTraceFunc1Node_(SetTraceFuncNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyProc) {
                        RubyProc arguments0Value_ = (RubyProc)arguments0Value;
                        return this.root.setTraceFunc(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetTraceFuncNodeGen root) {
                    return new SetTraceFunc1Node_(root);
                }
            }

            @GeneratedBy(methodName="setTraceFunc(Object)", value=KernelNodes.SetTraceFuncNode.class)
            private static final class SetTraceFunc0Node_
            extends BaseNode_ {
                SetTraceFunc0Node_(SetTraceFuncNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.root.isNil(arguments0Value)) {
                        return this.root.setTraceFunc(arguments0Value);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetTraceFuncNodeGen root) {
                    return new SetTraceFunc0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetTraceFuncNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetTraceFuncNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetTraceFuncNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SetTraceFuncNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final SetTraceFuncNodeGen root;

                BaseNode_(SetTraceFuncNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (this.root.isNil(arguments0Value)) {
                        return SetTraceFunc0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof RubyProc) {
                        return SetTraceFunc1Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
    public static final class RespondToMissingNodeFactory
    extends NodeFactoryBase<KernelNodes.RespondToMissingNode> {
        private static RespondToMissingNodeFactory respondToMissingNodeFactoryInstance;

        private RespondToMissingNodeFactory() {
            super(KernelNodes.RespondToMissingNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.RespondToMissingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RespondToMissingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RespondToMissingNode> getInstance() {
            if (respondToMissingNodeFactoryInstance == null) {
                respondToMissingNodeFactoryInstance = new RespondToMissingNodeFactory();
            }
            return respondToMissingNodeFactoryInstance;
        }

        public static KernelNodes.RespondToMissingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RespondToMissingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
        public static final class RespondToMissingNodeGen
        extends KernelNodes.RespondToMissingNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private RespondToMissingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="doesRespondToMissingSymbol(Object, RubyBasicObject, Object)", value=KernelNodes.RespondToMissingNode.class)
            private static final class EsRespondToMissingSymbolNode_
            extends BaseNode_ {
                EsRespondToMissingSymbolNode_(RespondToMissingNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    if (RubyGuards.isRubySymbol(arguments1Value_)) {
                        return this.root.doesRespondToMissingSymbol(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubySymbol(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                        return this.root.doesRespondToMissingSymbol(arguments0Value, arguments1Value_, arguments2Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RespondToMissingNodeGen root) {
                    return new EsRespondToMissingSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="doesRespondToMissingString(Object, RubyBasicObject, Object)", value=KernelNodes.RespondToMissingNode.class)
            private static final class EsRespondToMissingStringNode_
            extends BaseNode_ {
                EsRespondToMissingStringNode_(RespondToMissingNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.doesRespondToMissingString(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    RubyBasicObject arguments1Value_;
                    if (arguments1Value instanceof RubyBasicObject && RubyGuards.isRubyString(arguments1Value_ = (RubyBasicObject)arguments1Value)) {
                        return this.root.doesRespondToMissingString(arguments0Value, arguments1Value_, arguments2Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RespondToMissingNodeGen root) {
                    return new EsRespondToMissingStringNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RespondToMissingNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RespondToMissingNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RespondToMissingNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RespondToMissingNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RespondToMissingNodeGen root;

                BaseNode_(RespondToMissingNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return EsRespondToMissingStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return EsRespondToMissingSymbolNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RespondToNode.class)
    public static final class RespondToNodeFactory
    extends NodeFactoryBase<KernelNodes.RespondToNode> {
        private static RespondToNodeFactory respondToNodeFactoryInstance;

        private RespondToNodeFactory() {
            super(KernelNodes.RespondToNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public KernelNodes.RespondToNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return RespondToNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RespondToNode> getInstance() {
            if (respondToNodeFactoryInstance == null) {
                respondToNodeFactoryInstance = new RespondToNodeFactory();
            }
            return respondToNodeFactoryInstance;
        }

        public static KernelNodes.RespondToNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name, RubyNode includeProtectedAndPrivate) {
            return new RespondToNodeGen(context, sourceSection, object, name, includeProtectedAndPrivate);
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        public static final class RespondToNodeGen
        extends KernelNodes.RespondToNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode includeProtectedAndPrivate_;
            @CompilerDirectives.CompilationFinal
            private Class<?> includeProtectedAndPrivateType_;
            @Node.Child
            private BaseNode_ specialization_;

            private RespondToNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name, RubyNode includeProtectedAndPrivate) {
                super(context, sourceSection);
                this.object_ = object;
                this.name_ = name;
                this.includeProtectedAndPrivate_ = this.coerceToBoolean(includeProtectedAndPrivate);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                return this.specialization_.executeBoolean1(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean0(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="doesRespondToSymbol(VirtualFrame, Object, RubyBasicObject, boolean)", value=KernelNodes.RespondToNode.class)
            private static final class EsRespondToSymbolNode_
            extends BaseNode_ {
                EsRespondToSymbolNode_(RespondToNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    boolean includeProtectedAndPrivateValue_;
                    RubyBasicObject nameValue_;
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    try {
                        nameValue_ = this.root.name_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object includeProtectedAndPrivateValue = this.executeIncludeProtectedAndPrivate_((Frame)frameValue);
                        return this.getNext().executeBoolean_(frameValue, objectValue_, ex.getResult(), includeProtectedAndPrivateValue);
                    }
                    try {
                        includeProtectedAndPrivateValue_ = this.root.includeProtectedAndPrivate_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubySymbol(nameValue_)) {
                        return this.root.doesRespondToSymbol(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                    }
                    return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                    RubyBasicObject nameValue_;
                    if (nameValue instanceof RubyBasicObject && RubyGuards.isRubySymbol(nameValue_ = (RubyBasicObject)nameValue)) {
                        return this.root.doesRespondToSymbol(frameValue, objectValue, nameValue_, includeProtectedAndPrivateValue);
                    }
                    return this.getNext().executeBoolean1(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    if (nameValue instanceof RubyBasicObject && includeProtectedAndPrivateValue instanceof Boolean) {
                        RubyBasicObject nameValue_ = (RubyBasicObject)nameValue;
                        boolean includeProtectedAndPrivateValue_ = (Boolean)includeProtectedAndPrivateValue;
                        if (RubyGuards.isRubySymbol(nameValue_)) {
                            return this.root.doesRespondToSymbol(frameValue, objectValue, nameValue_, includeProtectedAndPrivateValue_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                static BaseNode_ create(RespondToNodeGen root) {
                    return new EsRespondToSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="doesRespondToString(VirtualFrame, Object, RubyBasicObject, boolean)", value=KernelNodes.RespondToNode.class)
            private static final class EsRespondToStringNode_
            extends BaseNode_ {
                EsRespondToStringNode_(RespondToNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    boolean includeProtectedAndPrivateValue_;
                    RubyBasicObject nameValue_;
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    try {
                        nameValue_ = this.root.name_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object includeProtectedAndPrivateValue = this.executeIncludeProtectedAndPrivate_((Frame)frameValue);
                        return this.getNext().executeBoolean_(frameValue, objectValue_, ex.getResult(), includeProtectedAndPrivateValue);
                    }
                    try {
                        includeProtectedAndPrivateValue_ = this.root.includeProtectedAndPrivate_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(nameValue_)) {
                        return this.root.doesRespondToString(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                    }
                    return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                    RubyBasicObject nameValue_;
                    if (nameValue instanceof RubyBasicObject && RubyGuards.isRubyString(nameValue_ = (RubyBasicObject)nameValue)) {
                        return this.root.doesRespondToString(frameValue, objectValue, nameValue_, includeProtectedAndPrivateValue);
                    }
                    return this.getNext().executeBoolean1(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    if (nameValue instanceof RubyBasicObject && includeProtectedAndPrivateValue instanceof Boolean) {
                        RubyBasicObject nameValue_ = (RubyBasicObject)nameValue;
                        boolean includeProtectedAndPrivateValue_ = (Boolean)includeProtectedAndPrivateValue;
                        if (RubyGuards.isRubyString(nameValue_)) {
                            return this.root.doesRespondToString(frameValue, objectValue, nameValue_, includeProtectedAndPrivateValue_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                static BaseNode_ create(RespondToNodeGen root) {
                    return new EsRespondToStringNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RespondToNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue, nameValue, includeProtectedAndPrivateValue));
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    Object includeProtectedAndPrivateValue_ = this.executeIncludeProtectedAndPrivate_((Frame)frameValue);
                    return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                    return this.getNext().executeBoolean1(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    return this.getNext().executeBoolean_(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                static BaseNode_ create(RespondToNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RespondToNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    return (Boolean)this.uninitialized((Frame)frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                static BaseNode_ create(RespondToNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RespondToNodeGen root;

                BaseNode_(RespondToNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.object_, this.root.name_, this.root.includeProtectedAndPrivate_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    return this.executeBoolean_((VirtualFrame)frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public boolean executeBoolean1(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                    return this.executeBoolean_(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                public Object execute(VirtualFrame frameValue) {
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    Object includeProtectedAndPrivateValue_ = this.executeIncludeProtectedAndPrivate_((Frame)frameValue);
                    return this.executeBoolean_(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean0(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    if (nameValue instanceof RubyBasicObject && includeProtectedAndPrivateValue instanceof Boolean) {
                        RubyBasicObject nameValue_ = (RubyBasicObject)nameValue;
                        if (RubyGuards.isRubyString(nameValue_)) {
                            return EsRespondToStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(nameValue_)) {
                            return EsRespondToSymbolNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeIncludeProtectedAndPrivate_(Frame frameValue) {
                    Object object;
                    Class includeProtectedAndPrivateType_ = this.root.includeProtectedAndPrivateType_;
                    if (includeProtectedAndPrivateType_ == Boolean.TYPE) {
                        return this.root.includeProtectedAndPrivate_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (includeProtectedAndPrivateType_ != null) return this.root.includeProtectedAndPrivate_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.includeProtectedAndPrivate_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.includeProtectedAndPrivateType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.includeProtectedAndPrivateType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.includeProtectedAndPrivateType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RequireRelativeNode.class)
    public static final class RequireRelativeNodeFactory
    extends NodeFactoryBase<KernelNodes.RequireRelativeNode> {
        private static RequireRelativeNodeFactory requireRelativeNodeFactoryInstance;

        private RequireRelativeNodeFactory() {
            super(KernelNodes.RequireRelativeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.RequireRelativeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RequireRelativeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RequireRelativeNode> getInstance() {
            if (requireRelativeNodeFactoryInstance == null) {
                requireRelativeNodeFactoryInstance = new RequireRelativeNodeFactory();
            }
            return requireRelativeNodeFactoryInstance;
        }

        public static KernelNodes.RequireRelativeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RequireRelativeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.RequireRelativeNode.class)
        public static final class RequireRelativeNodeGen
        extends KernelNodes.RequireRelativeNode {
            @Node.Child
            private RubyNode arguments0_;

            private RequireRelativeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyString arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.requireRelative(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RequireNode.class)
    public static final class RequireNodeFactory
    extends NodeFactoryBase<KernelNodes.RequireNode> {
        private static RequireNodeFactory requireNodeFactoryInstance;

        private RequireNodeFactory() {
            super(KernelNodes.RequireNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.RequireNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RequireNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RequireNode> getInstance() {
            if (requireNodeFactoryInstance == null) {
                requireNodeFactoryInstance = new RequireNodeFactory();
            }
            return requireNodeFactoryInstance;
        }

        public static KernelNodes.RequireNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RequireNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.RequireNode.class)
        public static final class RequireNodeGen
        extends KernelNodes.RequireNode {
            @Node.Child
            private RubyNode arguments0_;

            private RequireNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyString arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.require(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RandNode.class)
    public static final class RandNodeFactory
    extends NodeFactoryBase<KernelNodes.RandNode> {
        private static RandNodeFactory randNodeFactoryInstance;

        private RandNodeFactory() {
            super(KernelNodes.RandNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.RandNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RandNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RandNode> getInstance() {
            if (randNodeFactoryInstance == null) {
                randNodeFactoryInstance = new RandNodeFactory();
            }
            return randNodeFactoryInstance;
        }

        public static KernelNodes.RandNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RandNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        public static final class RandNodeGen
        extends KernelNodes.RandNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private RandNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="randNonZero(long)", value=KernelNodes.RandNode.class)
            private static final class RandNonZero1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                RandNonZero1Node_(RandNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((RandNonZero1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (this.root.isNonZero(arguments0Value_)) {
                        return this.root.randNonZero(arguments0Value_);
                    }
                    return RandNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && this.root.isNonZero(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType))) {
                        return this.root.randNonZero(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root, Object arguments0Value) {
                    return new RandNonZero1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="randZero(long)", value=KernelNodes.RandNode.class)
            private static final class RandZero1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                RandZero1Node_(RandNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((RandZero1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (this.root.isZero(arguments0Value_)) {
                        return this.root.randZero(arguments0Value_);
                    }
                    return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && this.root.isZero(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType))) {
                        return this.root.randZero(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root, Object arguments0Value) {
                    return new RandZero1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="randNonZero(int)", value=KernelNodes.RandNode.class)
            private static final class RandNonZero0Node_
            extends BaseNode_ {
                RandNonZero0Node_(RandNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (this.root.isNonZero(arguments0Value_)) {
                        return this.root.randNonZero(arguments0Value_);
                    }
                    return RandNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    int arguments0Value_;
                    if (arguments0Value instanceof Integer && this.root.isNonZero(arguments0Value_ = ((Integer)arguments0Value).intValue())) {
                        return this.root.randNonZero(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root) {
                    return new RandNonZero0Node_(root);
                }
            }

            @GeneratedBy(methodName="randZero(int)", value=KernelNodes.RandNode.class)
            private static final class RandZero0Node_
            extends BaseNode_ {
                RandZero0Node_(RandNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (this.root.isZero(arguments0Value_)) {
                        return this.root.randZero(arguments0Value_);
                    }
                    return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    int arguments0Value_;
                    if (arguments0Value instanceof Integer && this.root.isZero(arguments0Value_ = ((Integer)arguments0Value).intValue())) {
                        return this.root.randZero(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root) {
                    return new RandZero0Node_(root);
                }
            }

            @GeneratedBy(methodName="rand(NotProvided)", value=KernelNodes.RandNode.class)
            private static final class RandNode_
            extends BaseNode_ {
                RandNode_(RandNodeGen root) {
                    super(root, 1);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.rand(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.rand(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root) {
                    return new RandNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RandNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RandNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RandNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RandNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RandNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final RandNodeGen root;

                BaseNode_(RandNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return RandNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return RandNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return RandNodeGen.expectLong(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        return RandNode_.create(this.root);
                    }
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        if (this.root.isZero(arguments0Value_)) {
                            return RandZero0Node_.create(this.root);
                        }
                        if (this.root.isNonZero(arguments0Value_)) {
                            return RandNonZero0Node_.create(this.root);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (this.root.isZero(arguments0Value_)) {
                            return RandZero1Node_.create(this.root, arguments0Value);
                        }
                        if (this.root.isNonZero(arguments0Value_)) {
                            return RandNonZero1Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.int2long(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    throw new UnexpectedResultException(arguments0Value_);
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
    public static final class PublicMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.PublicMethodsNode> {
        private static PublicMethodsNodeFactory publicMethodsNodeFactoryInstance;

        private PublicMethodsNodeFactory() {
            super(KernelNodes.PublicMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public KernelNodes.PublicMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PublicMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.PublicMethodsNode> getInstance() {
            if (publicMethodsNodeFactoryInstance == null) {
                publicMethodsNodeFactoryInstance = new PublicMethodsNodeFactory();
            }
            return publicMethodsNodeFactoryInstance;
        }

        public static KernelNodes.PublicMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
            return new PublicMethodsNodeGen(context, sourceSection, object, includeAncestors);
        }

        @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
        public static final class PublicMethodsNodeGen
        extends KernelNodes.PublicMethodsNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode includeAncestors_;

            private PublicMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.object_ = object;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeRubyBasicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeRubyBasicObject(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.publicMethods(frameValue, objectValue_, includeAncestorsValue_);
            }

            protected UnsupportedSpecializationException unsupported(Object objectValue, Object includeAncestorsValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.object_, this.includeAncestors_}, new Object[]{objectValue, includeAncestorsValue});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ProtectedMethodsNode.class)
    public static final class ProtectedMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.ProtectedMethodsNode> {
        private static ProtectedMethodsNodeFactory protectedMethodsNodeFactoryInstance;

        private ProtectedMethodsNodeFactory() {
            super(KernelNodes.ProtectedMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public KernelNodes.ProtectedMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ProtectedMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ProtectedMethodsNode> getInstance() {
            if (protectedMethodsNodeFactoryInstance == null) {
                protectedMethodsNodeFactoryInstance = new ProtectedMethodsNodeFactory();
            }
            return protectedMethodsNodeFactoryInstance;
        }

        public static KernelNodes.ProtectedMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
            return new ProtectedMethodsNodeGen(context, sourceSection, object, includeAncestors);
        }

        @GeneratedBy(value=KernelNodes.ProtectedMethodsNode.class)
        public static final class ProtectedMethodsNodeGen
        extends KernelNodes.ProtectedMethodsNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode includeAncestors_;

            private ProtectedMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.object_ = object;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeRubyBasicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeRubyBasicObject(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.protectedMethods(frameValue, objectValue_, includeAncestorsValue_);
            }

            protected UnsupportedSpecializationException unsupported(Object objectValue, Object includeAncestorsValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.object_, this.includeAncestors_}, new Object[]{objectValue, includeAncestorsValue});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ProcNode.class)
    public static final class ProcNodeFactory
    extends NodeFactoryBase<KernelNodes.ProcNode> {
        private static ProcNodeFactory procNodeFactoryInstance;

        private ProcNodeFactory() {
            super(KernelNodes.ProcNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ProcNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ProcNode> getInstance() {
            if (procNodeFactoryInstance == null) {
                procNodeFactoryInstance = new ProcNodeFactory();
            }
            return procNodeFactoryInstance;
        }

        public static KernelNodes.ProcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ProcNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ProcNode.class)
        public static final class ProcNodeGen
        extends KernelNodes.ProcNode {
            @Node.Child
            private RubyNode arguments0_;

            private ProcNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.proc(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
    public static final class PrivateMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.PrivateMethodsNode> {
        private static PrivateMethodsNodeFactory privateMethodsNodeFactoryInstance;

        private PrivateMethodsNodeFactory() {
            super(KernelNodes.PrivateMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public KernelNodes.PrivateMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PrivateMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.PrivateMethodsNode> getInstance() {
            if (privateMethodsNodeFactoryInstance == null) {
                privateMethodsNodeFactoryInstance = new PrivateMethodsNodeFactory();
            }
            return privateMethodsNodeFactoryInstance;
        }

        public static KernelNodes.PrivateMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
            return new PrivateMethodsNodeGen(context, sourceSection, object, includeAncestors);
        }

        @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
        public static final class PrivateMethodsNodeGen
        extends KernelNodes.PrivateMethodsNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode includeAncestors_;

            private PrivateMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.object_ = object;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeRubyBasicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeRubyBasicObject(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.privateMethods(frameValue, objectValue_, includeAncestorsValue_);
            }

            protected UnsupportedSpecializationException unsupported(Object objectValue, Object includeAncestorsValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.object_, this.includeAncestors_}, new Object[]{objectValue, includeAncestorsValue});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.NilNode.class)
    public static final class NilNodeFactory
    extends NodeFactoryBase<KernelNodes.NilNode> {
        private static NilNodeFactory nilNodeFactoryInstance;

        private NilNodeFactory() {
            super(KernelNodes.NilNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.NilNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NilNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.NilNode> getInstance() {
            if (nilNodeFactoryInstance == null) {
                nilNodeFactoryInstance = new NilNodeFactory();
            }
            return nilNodeFactoryInstance;
        }

        public static KernelNodes.NilNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NilNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.NilNode.class)
        public static final class NilNodeGen
        extends KernelNodes.NilNode {
            private NilNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.isNil();
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException((Node)this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MethodsNode.class)
    public static final class MethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.MethodsNode> {
        private static MethodsNodeFactory methodsNodeFactoryInstance;

        private MethodsNodeFactory() {
            super(KernelNodes.MethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public KernelNodes.MethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return MethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.MethodsNode> getInstance() {
            if (methodsNodeFactoryInstance == null) {
                methodsNodeFactoryInstance = new MethodsNodeFactory();
            }
            return methodsNodeFactoryInstance;
        }

        public static KernelNodes.MethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode regular) {
            return new MethodsNodeGen(context, sourceSection, object, regular);
        }

        @GeneratedBy(value=KernelNodes.MethodsNode.class)
        public static final class MethodsNodeGen
        extends KernelNodes.MethodsNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode regular_;
            @CompilerDirectives.CompilationFinal
            private Class<?> regularType_;
            @Node.Child
            private BaseNode_ specialization_;

            private MethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode regular) {
                super(context, sourceSection);
                this.object_ = object;
                this.regular_ = this.coerceToBoolean(regular);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="methodsSingleton(VirtualFrame, Object, boolean, SingletonMethodsNode)", value=KernelNodes.MethodsNode.class)
            private static final class MethodsSingletonNode_
            extends BaseNode_ {
                @Node.Child
                private KernelNodes.SingletonMethodsNode singletonMethodsNode;

                MethodsSingletonNode_(MethodsNodeGen root, KernelNodes.SingletonMethodsNode singletonMethodsNode) {
                    super(root, 2);
                    this.singletonMethodsNode = singletonMethodsNode;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    boolean regularValue_;
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    try {
                        regularValue_ = this.root.regular_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, objectValue_, ex.getResult());
                    }
                    if (!regularValue_) {
                        return this.root.methodsSingleton(frameValue, objectValue_, regularValue_, this.singletonMethodsNode);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, objectValue_, regularValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object objectValue, Object regularValue) {
                    boolean regularValue_;
                    if (regularValue instanceof Boolean && !(regularValue_ = ((Boolean)regularValue).booleanValue())) {
                        return this.root.methodsSingleton(frameValue, objectValue, regularValue_, this.singletonMethodsNode);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, objectValue, regularValue);
                }

                static BaseNode_ create(MethodsNodeGen root, KernelNodes.SingletonMethodsNode singletonMethodsNode) {
                    return new MethodsSingletonNode_(root, singletonMethodsNode);
                }
            }

            @GeneratedBy(methodName="methodsRegular(VirtualFrame, Object, boolean, MetaClassNode)", value=KernelNodes.MethodsNode.class)
            private static final class MethodsRegularNode_
            extends BaseNode_ {
                @Node.Child
                private MetaClassNode metaClassNode;

                MethodsRegularNode_(MethodsNodeGen root, MetaClassNode metaClassNode) {
                    super(root, 1);
                    this.metaClassNode = metaClassNode;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    boolean regularValue_;
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    try {
                        regularValue_ = this.root.regular_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, objectValue_, ex.getResult());
                    }
                    if (regularValue_) {
                        return this.root.methodsRegular(frameValue, objectValue_, regularValue_, this.metaClassNode);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, objectValue_, regularValue_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object objectValue, Object regularValue) {
                    boolean regularValue_;
                    if (regularValue instanceof Boolean && (regularValue_ = ((Boolean)regularValue).booleanValue())) {
                        return this.root.methodsRegular(frameValue, objectValue, regularValue_, this.metaClassNode);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, objectValue, regularValue);
                }

                static BaseNode_ create(MethodsNodeGen root, MetaClassNode metaClassNode) {
                    return new MethodsRegularNode_(root, metaClassNode);
                }
            }

            @GeneratedBy(value=KernelNodes.MethodsNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MethodsNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue, Object regularValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue, regularValue));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object objectValue, Object regularValue) {
                    return this.getNext().executeRubyBasicObject_(frameValue, objectValue, regularValue);
                }

                static BaseNode_ create(MethodsNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.MethodsNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MethodsNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object objectValue, Object regularValue) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, objectValue, regularValue);
                }

                static BaseNode_ create(MethodsNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.MethodsNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final MethodsNodeGen root;

                BaseNode_(MethodsNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.object_, this.root.regular_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object objectValue, Object regularValue) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, objectValue, regularValue);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    Object regularValue_ = this.executeRegular_((Frame)frameValue);
                    return this.executeRubyBasicObject_(frameValue, objectValue_, regularValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object objectValue, Object regularValue) {
                    if (regularValue instanceof Boolean) {
                        boolean regularValue_ = (Boolean)regularValue;
                        if (regularValue_) {
                            MetaClassNode metaClassNode1 = this.root.createMetaClassNode();
                            return MethodsRegularNode_.create(this.root, metaClassNode1);
                        }
                        KernelNodes.SingletonMethodsNode singletonMethodsNode2 = this.root.createSingletonMethodsNode();
                        return MethodsSingletonNode_.create(this.root, singletonMethodsNode2);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeRegular_(Frame frameValue) {
                    Object object;
                    Class regularType_ = this.root.regularType_;
                    if (regularType_ == Boolean.TYPE) {
                        return this.root.regular_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (regularType_ != null) return this.root.regular_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.regular_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.regularType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.regularType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.regularType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MethodNode.class)
    public static final class MethodNodeFactory
    extends NodeFactoryBase<KernelNodes.MethodNode> {
        private static MethodNodeFactory methodNodeFactoryInstance;

        private MethodNodeFactory() {
            super(KernelNodes.MethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public KernelNodes.MethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return MethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.MethodNode> getInstance() {
            if (methodNodeFactoryInstance == null) {
                methodNodeFactoryInstance = new MethodNodeFactory();
            }
            return methodNodeFactoryInstance;
        }

        public static KernelNodes.MethodNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
            return new MethodNodeGen(context, sourceSection, object, name);
        }

        @GeneratedBy(value=KernelNodes.MethodNode.class)
        public static final class MethodNodeGen
        extends KernelNodes.MethodNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode name_;

            private MethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
                super(context, sourceSection);
                this.object_ = object;
                this.name_ = this.coerceToString(name);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    nameValue_ = MethodNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.methodCached(frameValue, objectValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object objectValue, Object nameValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.object_, this.name_}, new Object[]{objectValue, nameValue});
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MethodNameNode.class)
    public static final class MethodNameNodeFactory
    extends NodeFactoryBase<KernelNodes.MethodNameNode> {
        private static MethodNameNodeFactory methodNameNodeFactoryInstance;

        private MethodNameNodeFactory() {
            super(KernelNodes.MethodNameNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.MethodNameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MethodNameNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.MethodNameNode> getInstance() {
            if (methodNameNodeFactoryInstance == null) {
                methodNameNodeFactoryInstance = new MethodNameNodeFactory();
            }
            return methodNameNodeFactoryInstance;
        }

        public static KernelNodes.MethodNameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MethodNameNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.MethodNameNode.class)
        public static final class MethodNameNodeGen
        extends KernelNodes.MethodNameNode {
            private MethodNameNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.methodName();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException((Node)this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.LocalVariablesNode.class)
    public static final class LocalVariablesNodeFactory
    extends NodeFactoryBase<KernelNodes.LocalVariablesNode> {
        private static LocalVariablesNodeFactory localVariablesNodeFactoryInstance;

        private LocalVariablesNodeFactory() {
            super(KernelNodes.LocalVariablesNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.LocalVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LocalVariablesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.LocalVariablesNode> getInstance() {
            if (localVariablesNodeFactoryInstance == null) {
                localVariablesNodeFactoryInstance = new LocalVariablesNodeFactory();
            }
            return localVariablesNodeFactoryInstance;
        }

        public static KernelNodes.LocalVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LocalVariablesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.LocalVariablesNode.class)
        public static final class LocalVariablesNodeGen
        extends KernelNodes.LocalVariablesNode {
            private LocalVariablesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.localVariables();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException((Node)this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.LoadNode.class)
    public static final class LoadNodeFactory
    extends NodeFactoryBase<KernelNodes.LoadNode> {
        private static LoadNodeFactory loadNodeFactoryInstance;

        private LoadNodeFactory() {
            super(KernelNodes.LoadNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.LoadNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LoadNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.LoadNode> getInstance() {
            if (loadNodeFactoryInstance == null) {
                loadNodeFactoryInstance = new LoadNodeFactory();
            }
            return loadNodeFactoryInstance;
        }

        public static KernelNodes.LoadNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LoadNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.LoadNode.class)
        public static final class LoadNodeGen
        extends KernelNodes.LoadNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LoadNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="load(RubyString, NotProvided)", value=KernelNodes.LoadNode.class)
            private static final class Load1Node_
            extends BaseNode_ {
                Load1Node_(LoadNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    RubyString arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyString(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.load(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyString && arguments1Value instanceof NotProvided) {
                        RubyString arguments0Value_ = (RubyString)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.load(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LoadNodeGen root) {
                    return new Load1Node_(root);
                }
            }

            @GeneratedBy(methodName="load(RubyString, boolean)", value=KernelNodes.LoadNode.class)
            private static final class Load0Node_
            extends BaseNode_ {
                Load0Node_(LoadNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    boolean arguments1Value_;
                    RubyString arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyString(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.load(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyString && arguments1Value instanceof Boolean) {
                        RubyString arguments0Value_ = (RubyString)arguments0Value;
                        boolean arguments1Value_ = (Boolean)arguments1Value;
                        return this.root.load(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LoadNodeGen root) {
                    return new Load0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.LoadNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LoadNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LoadNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.LoadNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LoadNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LoadNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.LoadNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LoadNodeGen root;

                BaseNode_(LoadNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyString) {
                        if (arguments1Value instanceof Boolean) {
                            return Load0Node_.create(this.root);
                        }
                        if (arguments1Value instanceof NotProvided) {
                            return Load1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Boolean.TYPE) {
                        return this.root.arguments1_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.LambdaNode.class)
    public static final class LambdaNodeFactory
    extends NodeFactoryBase<KernelNodes.LambdaNode> {
        private static LambdaNodeFactory lambdaNodeFactoryInstance;

        private LambdaNodeFactory() {
            super(KernelNodes.LambdaNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.LambdaNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LambdaNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.LambdaNode> getInstance() {
            if (lambdaNodeFactoryInstance == null) {
                lambdaNodeFactoryInstance = new LambdaNodeFactory();
            }
            return lambdaNodeFactoryInstance;
        }

        public static KernelNodes.LambdaNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LambdaNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.LambdaNode.class)
        public static final class LambdaNodeGen
        extends KernelNodes.LambdaNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private LambdaNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="proc(RubyProc)", value=KernelNodes.LambdaNode.class)
            private static final class Proc1Node_
            extends BaseNode_ {
                Proc1Node_(LambdaNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyProc executeRubyProc_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyProc) {
                        RubyProc arguments0Value_ = (RubyProc)arguments0Value;
                        return this.root.proc(arguments0Value_);
                    }
                    return this.getNext().executeRubyProc_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LambdaNodeGen root) {
                    return new Proc1Node_(root);
                }
            }

            @GeneratedBy(methodName="proc(NotProvided)", value=KernelNodes.LambdaNode.class)
            private static final class Proc0Node_
            extends BaseNode_ {
                Proc0Node_(LambdaNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyProc executeRubyProc_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.proc(arguments0Value_);
                    }
                    return this.getNext().executeRubyProc_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LambdaNodeGen root) {
                    return new Proc0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.LambdaNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LambdaNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyProc executeRubyProc_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyProc_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LambdaNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.LambdaNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LambdaNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyProc executeRubyProc_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyProc)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(LambdaNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.LambdaNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final LambdaNodeGen root;

                BaseNode_(LambdaNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyProc_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyProc executeRubyProc_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeRubyProc_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        return Proc0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof RubyProc) {
                        return Proc1Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.IsANode.class)
    public static final class IsANodeFactory
    extends NodeFactoryBase<KernelNodes.IsANode> {
        private static IsANodeFactory isANodeFactoryInstance;

        private IsANodeFactory() {
            super(KernelNodes.IsANode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.IsANode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsANodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.IsANode> getInstance() {
            if (isANodeFactoryInstance == null) {
                isANodeFactoryInstance = new IsANodeFactory();
            }
            return isANodeFactoryInstance;
        }

        public static KernelNodes.IsANode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsANodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.IsANode.class)
        public static final class IsANodeGen
        extends KernelNodes.IsANode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private IsANodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public boolean executeIsA(VirtualFrame frameValue, Object arguments0Value, RubyModule arguments1Value) {
                return this.specialization_.executeBoolean1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean0(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="isATypeError(VirtualFrame, Object, Object)", value=KernelNodes.IsANode.class)
            private static final class IsATypeErrorNode_
            extends BaseNode_ {
                IsATypeErrorNode_(IsANodeGen root) {
                    super(root, 4);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (!RubyGuards.isRubyModule(arguments1Value_)) {
                        return this.root.isATypeError(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, RubyModule arguments1Value) {
                    if (!RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isATypeError(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (!RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isATypeError(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsANodeGen root) {
                    return new IsATypeErrorNode_(root);
                }
            }

            @GeneratedBy(methodName="isAUncached(VirtualFrame, Object, RubyModule)", value=KernelNodes.IsANode.class)
            private static final class IsAUncachedNode_
            extends BaseNode_ {
                IsAUncachedNode_(IsANodeGen root) {
                    super(root, 3);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    RubyModule arguments1Value_;
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyModule(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.isAUncached(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, RubyModule arguments1Value) {
                    return this.root.isAUncached(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof RubyModule) {
                        RubyModule arguments1Value_ = (RubyModule)arguments1Value;
                        return this.root.isAUncached(frameValue, arguments0Value, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsANodeGen root) {
                    return new IsAUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isACached(VirtualFrame, Object, RubyModule, RubyClass, RubyModule, boolean)", value=KernelNodes.IsANode.class)
            private static final class IsACachedNode_
            extends BaseNode_ {
                private final RubyClass cachedMetaClass;
                private final RubyModule cachedModule;
                private final boolean result;
                @CompilerDirectives.CompilationFinal
                private final Assumption assumption0_;

                IsACachedNode_(IsANodeGen root, RubyClass cachedMetaClass, RubyModule cachedModule, boolean result, Assumption assumption0_) {
                    super(root, 2);
                    this.cachedMetaClass = cachedMetaClass;
                    this.cachedModule = cachedModule;
                    this.result = result;
                    this.assumption0_ = assumption0_;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof RubyModule) {
                        RubyModule arguments1Value_ = (RubyModule)arguments1Value;
                        if (this.root.getMetaClass((VirtualFrame)frameValue, arguments0Value) == this.cachedMetaClass && arguments1Value_ == this.cachedModule) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    RubyModule arguments1Value_;
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyModule(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (this.root.getMetaClass(frameValue, arguments0Value_) == this.cachedMetaClass && arguments1Value_ == this.cachedModule) {
                        try {
                            IsACachedNode_.check((Assumption)this.assumption0_);
                        }
                        catch (InvalidAssumptionException ae) {
                            return (Boolean)this.removeThis("Assumption [assumption0] invalidated", (Frame)frameValue, arguments0Value_, arguments1Value_);
                        }
                        return this.root.isACached(frameValue, arguments0Value_, arguments1Value_, this.cachedMetaClass, this.cachedModule, this.result);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, RubyModule arguments1Value) {
                    if (this.root.getMetaClass(frameValue, arguments0Value) == this.cachedMetaClass && arguments1Value == this.cachedModule) {
                        try {
                            IsACachedNode_.check((Assumption)this.assumption0_);
                        }
                        catch (InvalidAssumptionException ae) {
                            return (Boolean)this.removeThis("Assumption [assumption0] invalidated", (Frame)frameValue, arguments0Value, arguments1Value);
                        }
                        return this.root.isACached(frameValue, arguments0Value, arguments1Value, this.cachedMetaClass, this.cachedModule, this.result);
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof RubyModule) {
                        RubyModule arguments1Value_ = (RubyModule)arguments1Value;
                        if (this.root.getMetaClass(frameValue, arguments0Value) == this.cachedMetaClass && arguments1Value_ == this.cachedModule) {
                            try {
                                IsACachedNode_.check((Assumption)this.assumption0_);
                            }
                            catch (InvalidAssumptionException ae) {
                                return (Boolean)this.removeThis("Assumption [assumption0] invalidated", (Frame)frameValue, arguments0Value, arguments1Value_);
                            }
                            return this.root.isACached(frameValue, arguments0Value, arguments1Value_, this.cachedMetaClass, this.cachedModule, this.result);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsANodeGen root, RubyClass cachedMetaClass, RubyModule cachedModule, boolean result, Assumption assumption0_) {
                    return new IsACachedNode_(root, cachedMetaClass, cachedModule, result, assumption0_);
                }
            }

            @GeneratedBy(methodName="isANil(RubyBasicObject, Object)", value=KernelNodes.IsANode.class)
            private static final class IsANilNode_
            extends BaseNode_ {
                IsANilNode_(IsANodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (this.root.isNil(arguments1Value_) && !RubyGuards.isRubyModule(arguments1Value_)) {
                        return this.root.isANil(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, RubyModule arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (this.root.isNil(arguments1Value) && !RubyGuards.isRubyModule(arguments1Value)) {
                            return this.root.isANil(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        if (this.root.isNil(arguments1Value) && !RubyGuards.isRubyModule(arguments1Value)) {
                            return this.root.isANil(arguments0Value_, arguments1Value);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsANodeGen root) {
                    return new IsANilNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.IsANode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(IsANodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, RubyModule arguments1Value) {
                    return this.getNext().executeBoolean1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsANodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.IsANode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IsANodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(IsANodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.IsANode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final IsANodeGen root;

                BaseNode_(IsANodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public boolean executeBoolean1(VirtualFrame frameValue, Object arguments0Value, RubyModule arguments1Value) {
                    return this.executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean0(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && this.root.isNil(arguments1Value) && !RubyGuards.isRubyModule(arguments1Value)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return IsANilNode_.create(this.root);
                    }
                    if (arguments1Value instanceof RubyModule) {
                        RubyModule arguments1Value_ = (RubyModule)arguments1Value;
                        RubyClass cachedMetaClass2 = this.root.getMetaClass((VirtualFrame)frameValue, arguments0Value);
                        RubyModule cachedModule2 = arguments1Value_;
                        if (this.root.getMetaClass((VirtualFrame)frameValue, arguments0Value) == cachedMetaClass2 && arguments1Value_ == cachedModule2) {
                            BaseNode_ s;
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            boolean result2 = this.root.isA(cachedMetaClass2, cachedModule2);
                            Assumption assumption0_2 = cachedModule2.getUnmodifiedAssumption();
                            if (BaseNode_.isValid((Assumption)assumption0_2) && this.countSame(s = IsACachedNode_.create(this.root, cachedMetaClass2, cachedModule2, result2, assumption0_2)) < IsANodeGen.getCacheLimit()) {
                                return s;
                            }
                        }
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return IsAUncachedNode_.create(this.root);
                    }
                    if (!RubyGuards.isRubyModule(arguments1Value)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return IsATypeErrorNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariablesNode.class)
    public static final class InstanceVariablesNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariablesNode> {
        private static InstanceVariablesNodeFactory instanceVariablesNodeFactoryInstance;

        private InstanceVariablesNodeFactory() {
            super(KernelNodes.InstanceVariablesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceVariablesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceVariablesNode> getInstance() {
            if (instanceVariablesNodeFactoryInstance == null) {
                instanceVariablesNodeFactoryInstance = new InstanceVariablesNodeFactory();
            }
            return instanceVariablesNodeFactoryInstance;
        }

        public static KernelNodes.InstanceVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceVariablesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InstanceVariablesNode.class)
        public static final class InstanceVariablesNodeGen
        extends KernelNodes.InstanceVariablesNode {
            @Node.Child
            private RubyNode arguments0_;

            private InstanceVariablesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.instanceVariables(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
    public static final class InstanceVariableSetNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariableSetNode> {
        private static InstanceVariableSetNodeFactory instanceVariableSetNodeFactoryInstance;

        private InstanceVariableSetNodeFactory() {
            super(KernelNodes.InstanceVariableSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceVariableSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceVariableSetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceVariableSetNode> getInstance() {
            if (instanceVariableSetNodeFactoryInstance == null) {
                instanceVariableSetNodeFactoryInstance = new InstanceVariableSetNodeFactory();
            }
            return instanceVariableSetNodeFactoryInstance;
        }

        public static KernelNodes.InstanceVariableSetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceVariableSetNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
        public static final class InstanceVariableSetNodeGen
        extends KernelNodes.InstanceVariableSetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private InstanceVariableSetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="instanceVariableSetSymbol(RubyBasicObject, RubyBasicObject, Object)", value=KernelNodes.InstanceVariableSetNode.class)
            private static final class InstanceVariableSetSymbolNode_
            extends BaseNode_ {
                InstanceVariableSetSymbolNode_(InstanceVariableSetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.instanceVariableSetSymbol(arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceVariableSetNodeGen root) {
                    return new InstanceVariableSetSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="instanceVariableSetString(RubyBasicObject, RubyBasicObject, Object)", value=KernelNodes.InstanceVariableSetNode.class)
            private static final class InstanceVariableSetStringNode_
            extends BaseNode_ {
                InstanceVariableSetStringNode_(InstanceVariableSetNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.instanceVariableSetString(arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceVariableSetNodeGen root) {
                    return new InstanceVariableSetStringNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InstanceVariableSetNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceVariableSetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InstanceVariableSetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InstanceVariableSetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InstanceVariableSetNodeGen root;

                BaseNode_(InstanceVariableSetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return InstanceVariableSetStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return InstanceVariableSetSymbolNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
    public static final class InstanceVariableGetNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariableGetNode> {
        private static InstanceVariableGetNodeFactory instanceVariableGetNodeFactoryInstance;

        private InstanceVariableGetNodeFactory() {
            super(KernelNodes.InstanceVariableGetNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceVariableGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceVariableGetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceVariableGetNode> getInstance() {
            if (instanceVariableGetNodeFactoryInstance == null) {
                instanceVariableGetNodeFactoryInstance = new InstanceVariableGetNodeFactory();
            }
            return instanceVariableGetNodeFactoryInstance;
        }

        public static KernelNodes.InstanceVariableGetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceVariableGetNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
        public static final class InstanceVariableGetNodeGen
        extends KernelNodes.InstanceVariableGetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private InstanceVariableGetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="instanceVariableGetSymbol(RubyBasicObject, RubyBasicObject)", value=KernelNodes.InstanceVariableGetNode.class)
            private static final class InstanceVariableGetSymbolNode_
            extends BaseNode_ {
                InstanceVariableGetSymbolNode_(InstanceVariableGetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.instanceVariableGetSymbol(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InstanceVariableGetNodeGen root) {
                    return new InstanceVariableGetSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="instanceVariableGetString(RubyBasicObject, RubyBasicObject)", value=KernelNodes.InstanceVariableGetNode.class)
            private static final class InstanceVariableGetStringNode_
            extends BaseNode_ {
                InstanceVariableGetStringNode_(InstanceVariableGetNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.instanceVariableGetString(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InstanceVariableGetNodeGen root) {
                    return new InstanceVariableGetStringNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InstanceVariableGetNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InstanceVariableGetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InstanceVariableGetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InstanceVariableGetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InstanceVariableGetNodeGen root;

                BaseNode_(InstanceVariableGetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return InstanceVariableGetStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return InstanceVariableGetSymbolNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
    public static final class InstanceVariableDefinedNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariableDefinedNode> {
        private static InstanceVariableDefinedNodeFactory instanceVariableDefinedNodeFactoryInstance;

        private InstanceVariableDefinedNodeFactory() {
            super(KernelNodes.InstanceVariableDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceVariableDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceVariableDefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceVariableDefinedNode> getInstance() {
            if (instanceVariableDefinedNodeFactoryInstance == null) {
                instanceVariableDefinedNodeFactoryInstance = new InstanceVariableDefinedNodeFactory();
            }
            return instanceVariableDefinedNodeFactoryInstance;
        }

        public static KernelNodes.InstanceVariableDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceVariableDefinedNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
        public static final class InstanceVariableDefinedNodeGen
        extends KernelNodes.InstanceVariableDefinedNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private InstanceVariableDefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="isInstanceVariableDefinedSymbol(RubyBasicObject, RubyBasicObject)", value=KernelNodes.InstanceVariableDefinedNode.class)
            private static final class IsInstanceVariableDefinedSymbolNode_
            extends BaseNode_ {
                IsInstanceVariableDefinedSymbolNode_(InstanceVariableDefinedNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubySymbol(arguments1Value_)) {
                        return this.root.isInstanceVariableDefinedSymbol(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.isInstanceVariableDefinedSymbol(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InstanceVariableDefinedNodeGen root) {
                    return new IsInstanceVariableDefinedSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="isInstanceVariableDefinedString(RubyBasicObject, RubyBasicObject)", value=KernelNodes.InstanceVariableDefinedNode.class)
            private static final class IsInstanceVariableDefinedStringNode_
            extends BaseNode_ {
                IsInstanceVariableDefinedStringNode_(InstanceVariableDefinedNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.isInstanceVariableDefinedString(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.isInstanceVariableDefinedString(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InstanceVariableDefinedNodeGen root) {
                    return new IsInstanceVariableDefinedStringNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InstanceVariableDefinedNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InstanceVariableDefinedNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InstanceVariableDefinedNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InstanceVariableDefinedNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final InstanceVariableDefinedNodeGen root;

                BaseNode_(InstanceVariableDefinedNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return IsInstanceVariableDefinedStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return IsInstanceVariableDefinedSymbolNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceOfNode.class)
    public static final class InstanceOfNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceOfNode> {
        private static InstanceOfNodeFactory instanceOfNodeFactoryInstance;

        private InstanceOfNodeFactory() {
            super(KernelNodes.InstanceOfNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceOfNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceOfNode> getInstance() {
            if (instanceOfNodeFactoryInstance == null) {
                instanceOfNodeFactoryInstance = new InstanceOfNodeFactory();
            }
            return instanceOfNodeFactoryInstance;
        }

        public static KernelNodes.InstanceOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceOfNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InstanceOfNode.class)
        public static final class InstanceOfNodeGen
        extends KernelNodes.InstanceOfNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private InstanceOfNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                RubyClass arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = InstanceOfNodeGen.expectRubyClass(this.arguments1_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.instanceOf(frameValue, arguments0Value_, arguments1Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }

            private static RubyClass expectRubyClass(Object value) throws UnexpectedResultException {
                if (value instanceof RubyClass) {
                    return (RubyClass)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InitializeDupCloneNode.class)
    public static final class InitializeDupCloneNodeFactory
    extends NodeFactoryBase<KernelNodes.InitializeDupCloneNode> {
        private static InitializeDupCloneNodeFactory initializeDupCloneNodeFactoryInstance;

        private InitializeDupCloneNodeFactory() {
            super(KernelNodes.InitializeDupCloneNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InitializeDupCloneNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeDupCloneNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InitializeDupCloneNode> getInstance() {
            if (initializeDupCloneNodeFactoryInstance == null) {
                initializeDupCloneNodeFactoryInstance = new InitializeDupCloneNodeFactory();
            }
            return initializeDupCloneNodeFactoryInstance;
        }

        public static KernelNodes.InitializeDupCloneNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeDupCloneNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InitializeDupCloneNode.class)
        public static final class InitializeDupCloneNodeGen
        extends KernelNodes.InitializeDupCloneNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private InitializeDupCloneNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.initializeDup(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<KernelNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(KernelNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        public static KernelNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeCopyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InitializeCopyNode.class)
        public static final class InitializeCopyNodeGen
        extends KernelNodes.InitializeCopyNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private InitializeCopyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value_;
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.initializeCopy(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<KernelNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(KernelNodes.HashNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        public static KernelNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new HashNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        public static final class HashNodeGen
        extends KernelNodes.HashNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private HashNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="hash(RubyBasicObject)", value=KernelNodes.HashNode.class)
            private static final class Hash4Node_
            extends BaseNode_ {
                Hash4Node_(HashNodeGen root) {
                    super(root, 5);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new Hash4Node_(root);
                }
            }

            @GeneratedBy(methodName="hash(boolean)", value=KernelNodes.HashNode.class)
            private static final class Hash3Node_
            extends BaseNode_ {
                Hash3Node_(HashNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    boolean arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Boolean) {
                        boolean arguments0Value_ = (Boolean)arguments0Value;
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new Hash3Node_(root);
                }
            }

            @GeneratedBy(methodName="hash(double)", value=KernelNodes.HashNode.class)
            private static final class Hash2Node_
            extends BaseNode_ {
                Hash2Node_(HashNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Double) {
                        double arguments0Value_ = (Double)arguments0Value;
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new Hash2Node_(root);
                }
            }

            @GeneratedBy(methodName="hash(long)", value=KernelNodes.HashNode.class)
            private static final class Hash1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Hash1Node_(HashNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Hash1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    long arguments0Value_;
                    block4: {
                        try {
                            if (this.arguments0ImplicitType == Long.TYPE) {
                                arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                                break block4;
                            }
                            if (this.arguments0ImplicitType == Integer.TYPE) {
                                arguments0Value_ = RubyTypes.int2long(this.root.arguments0_.executeInteger(frameValue));
                                break block4;
                            }
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            throw new UnexpectedResultException(arguments0Value__);
                        }
                        catch (UnexpectedResultException ex) {
                            return this.getNext().executeInt_(frameValue, ex.getResult());
                        }
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root, Object arguments0Value) {
                    return new Hash1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="hash(int)", value=KernelNodes.HashNode.class)
            private static final class Hash0Node_
            extends BaseNode_ {
                Hash0Node_(HashNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new Hash0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.HashNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(HashNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.HashNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(HashNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.HashNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final HashNodeGen root;

                BaseNode_(HashNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        return Hash0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Hash1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof Double) {
                        return Hash2Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Boolean) {
                        return Hash3Node_.create(this.root);
                    }
                    if (arguments0Value instanceof RubyBasicObject) {
                        return Hash4Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Boolean.TYPE) {
                        return this.root.arguments0_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.GetsNode.class)
    public static final class GetsNodeFactory
    extends NodeFactoryBase<KernelNodes.GetsNode> {
        private static GetsNodeFactory getsNodeFactoryInstance;

        private GetsNodeFactory() {
            super(KernelNodes.GetsNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.GetsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.GetsNode> getInstance() {
            if (getsNodeFactoryInstance == null) {
                getsNodeFactoryInstance = new GetsNodeFactory();
            }
            return getsNodeFactoryInstance;
        }

        public static KernelNodes.GetsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.GetsNode.class)
        public static final class GetsNodeGen
        extends KernelNodes.GetsNode {
            private GetsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.gets(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException((Node)this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelFrozenNode.class)
    public static final class KernelFrozenNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelFrozenNode> {
        private static KernelFrozenNodeFactory kernelFrozenNodeFactoryInstance;

        private KernelFrozenNodeFactory() {
            super(KernelNodes.KernelFrozenNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelFrozenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelFrozenNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelFrozenNode> getInstance() {
            if (kernelFrozenNodeFactoryInstance == null) {
                kernelFrozenNodeFactoryInstance = new KernelFrozenNodeFactory();
            }
            return kernelFrozenNodeFactoryInstance;
        }

        public static KernelNodes.KernelFrozenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelFrozenNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelFrozenNode.class)
        public static final class KernelFrozenNodeGen
        extends KernelNodes.KernelFrozenNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelFrozenNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.isFrozen(arguments0Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelFreezeNode.class)
    public static final class KernelFreezeNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelFreezeNode> {
        private static KernelFreezeNodeFactory kernelFreezeNodeFactoryInstance;

        private KernelFreezeNodeFactory() {
            super(KernelNodes.KernelFreezeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelFreezeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelFreezeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelFreezeNode> getInstance() {
            if (kernelFreezeNodeFactoryInstance == null) {
                kernelFreezeNodeFactoryInstance = new KernelFreezeNodeFactory();
            }
            return kernelFreezeNodeFactoryInstance;
        }

        public static KernelNodes.KernelFreezeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelFreezeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelFreezeNode.class)
        public static final class KernelFreezeNodeGen
        extends KernelNodes.KernelFreezeNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelFreezeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.freeze(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ForkNode.class)
    public static final class ForkNodeFactory
    extends NodeFactoryBase<KernelNodes.ForkNode> {
        private static ForkNodeFactory forkNodeFactoryInstance;

        private ForkNodeFactory() {
            super(KernelNodes.ForkNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ForkNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ForkNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ForkNode> getInstance() {
            if (forkNodeFactoryInstance == null) {
                forkNodeFactoryInstance = new ForkNodeFactory();
            }
            return forkNodeFactoryInstance;
        }

        public static KernelNodes.ForkNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ForkNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ForkNode.class)
        public static final class ForkNodeGen
        extends KernelNodes.ForkNode {
            @Node.Child
            private RubyNode arguments0_;

            private ForkNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.fork(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ExitBangNode.class)
    public static final class ExitBangNodeFactory
    extends NodeFactoryBase<KernelNodes.ExitBangNode> {
        private static ExitBangNodeFactory exitBangNodeFactoryInstance;

        private ExitBangNodeFactory() {
            super(KernelNodes.ExitBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ExitBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExitBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ExitBangNode> getInstance() {
            if (exitBangNodeFactoryInstance == null) {
                exitBangNodeFactoryInstance = new ExitBangNodeFactory();
            }
            return exitBangNodeFactoryInstance;
        }

        public static KernelNodes.ExitBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExitBangNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ExitBangNode.class)
        public static final class ExitBangNodeGen
        extends KernelNodes.ExitBangNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ExitBangNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="exit(int)", value=KernelNodes.ExitBangNode.class)
            private static final class Exit1Node_
            extends BaseNode_ {
                Exit1Node_(ExitBangNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult());
                    }
                    return this.root.exit(arguments0Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.exit(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExitBangNodeGen root) {
                    return new Exit1Node_(root);
                }
            }

            @GeneratedBy(methodName="exit(NotProvided)", value=KernelNodes.ExitBangNode.class)
            private static final class Exit0Node_
            extends BaseNode_ {
                Exit0Node_(ExitBangNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.exit(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExitBangNodeGen root) {
                    return new Exit0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ExitBangNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ExitBangNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExitBangNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ExitBangNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ExitBangNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ExitBangNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ExitBangNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ExitBangNodeGen root;

                BaseNode_(ExitBangNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        return Exit0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Integer) {
                        return Exit1Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ExitNode.class)
    public static final class ExitNodeFactory
    extends NodeFactoryBase<KernelNodes.ExitNode> {
        private static ExitNodeFactory exitNodeFactoryInstance;

        private ExitNodeFactory() {
            super(KernelNodes.ExitNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ExitNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExitNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ExitNode> getInstance() {
            if (exitNodeFactoryInstance == null) {
                exitNodeFactoryInstance = new ExitNodeFactory();
            }
            return exitNodeFactoryInstance;
        }

        public static KernelNodes.ExitNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExitNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ExitNode.class)
        public static final class ExitNodeGen
        extends KernelNodes.ExitNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ExitNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="exit(boolean)", value=KernelNodes.ExitNode.class)
            private static final class Exit2Node_
            extends BaseNode_ {
                Exit2Node_(ExitNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    return this.root.exit(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Boolean) {
                        boolean arguments0Value_ = (Boolean)arguments0Value;
                        return this.root.exit(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExitNodeGen root) {
                    return new Exit2Node_(root);
                }
            }

            @GeneratedBy(methodName="exit(int)", value=KernelNodes.ExitNode.class)
            private static final class Exit1Node_
            extends BaseNode_ {
                Exit1Node_(ExitNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    return this.root.exit(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        return this.root.exit(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExitNodeGen root) {
                    return new Exit1Node_(root);
                }
            }

            @GeneratedBy(methodName="exit(NotProvided)", value=KernelNodes.ExitNode.class)
            private static final class Exit0Node_
            extends BaseNode_ {
                Exit0Node_(ExitNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.exit(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExitNodeGen root) {
                    return new Exit0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ExitNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ExitNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExitNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ExitNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ExitNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ExitNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ExitNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final ExitNodeGen root;

                BaseNode_(ExitNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        return Exit0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Integer) {
                        return Exit1Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Boolean) {
                        return Exit2Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Boolean.TYPE) {
                        return this.root.arguments0_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Integer ? Integer.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ExecNode.class)
    public static final class ExecNodeFactory
    extends NodeFactoryBase<KernelNodes.ExecNode> {
        private static ExecNodeFactory execNodeFactoryInstance;

        private ExecNodeFactory() {
            super(KernelNodes.ExecNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ExecNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExecNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ExecNode> getInstance() {
            if (execNodeFactoryInstance == null) {
                execNodeFactoryInstance = new ExecNodeFactory();
            }
            return execNodeFactoryInstance;
        }

        public static KernelNodes.ExecNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExecNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ExecNode.class)
        public static final class ExecNodeGen
        extends KernelNodes.ExecNode {
            @Node.Child
            private RubyNode arguments0_;

            private ExecNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.exec(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.EvalNode.class)
    public static final class EvalNodeFactory
    extends NodeFactoryBase<KernelNodes.EvalNode> {
        private static EvalNodeFactory evalNodeFactoryInstance;

        private EvalNodeFactory() {
            super(KernelNodes.EvalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public KernelNodes.EvalNode createNode(Object ... arguments) {
            if (!(arguments.length != 6 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode) || arguments[5] != null && !(arguments[5] instanceof RubyNode))) {
                return EvalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]), (RubyNode)((Object)arguments[5]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.EvalNode> getInstance() {
            if (evalNodeFactoryInstance == null) {
                evalNodeFactoryInstance = new EvalNodeFactory();
            }
            return evalNodeFactoryInstance;
        }

        public static KernelNodes.EvalNode create(RubyContext context, SourceSection sourceSection, RubyNode source, RubyNode binding, RubyNode filename, RubyNode lineNumber) {
            return new EvalNodeGen(context, sourceSection, source, binding, filename, lineNumber);
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        public static final class EvalNodeGen
        extends KernelNodes.EvalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode source_;
            @Node.Child
            private RubyNode binding_;
            @Node.Child
            private RubyNode filename_;
            @Node.Child
            private RubyNode lineNumber_;
            @CompilerDirectives.CompilationFinal
            private Class<?> lineNumberType_;
            @Node.Child
            private BaseNode_ specialization_;

            private EvalNodeGen(RubyContext context, SourceSection sourceSection, RubyNode source, RubyNode binding, RubyNode filename, RubyNode lineNumber) {
                super(context, sourceSection);
                this.source_ = this.coerceSourceToString(source);
                this.binding_ = binding;
                this.filename_ = filename;
                this.lineNumber_ = lineNumber;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static RubyBinding expectRubyBinding(Object value) throws UnexpectedResultException {
                if (value instanceof RubyBinding) {
                    return (RubyBinding)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="eval(RubyString, RubyBasicObject, NotProvided, NotProvided)", value=KernelNodes.EvalNode.class)
            private static final class Eval5Node_
            extends BaseNode_ {
                Eval5Node_(EvalNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof RubyString && bindingValue instanceof RubyBasicObject && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided) {
                        RubyString sourceValue_ = (RubyString)sourceValue;
                        RubyBasicObject bindingValue_ = (RubyBasicObject)bindingValue;
                        NotProvided filenameValue_ = (NotProvided)filenameValue;
                        NotProvided lineNumberValue_ = (NotProvided)lineNumberValue;
                        if (!RubyGuards.isRubyBinding(bindingValue_)) {
                            return this.root.eval(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new Eval5Node_(root);
                }
            }

            @GeneratedBy(methodName="eval(RubyString, RubyBinding, RubyString, int)", value=KernelNodes.EvalNode.class)
            private static final class Eval4Node_
            extends BaseNode_ {
                Eval4Node_(EvalNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int lineNumberValue_;
                    RubyString filenameValue_;
                    RubyBinding bindingValue_;
                    RubyString sourceValue_;
                    try {
                        sourceValue_ = this.root.source_.executeRubyString(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bindingValue = this.root.binding_.execute(frameValue);
                        Object filenameValue = this.root.filename_.execute(frameValue);
                        Object lineNumberValue = this.executeLineNumber_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bindingValue, filenameValue, lineNumberValue);
                    }
                    try {
                        bindingValue_ = EvalNodeGen.expectRubyBinding(this.root.binding_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        Object filenameValue = this.root.filename_.execute(frameValue);
                        Object lineNumberValue = this.executeLineNumber_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, sourceValue_, ex.getResult(), filenameValue, lineNumberValue);
                    }
                    try {
                        filenameValue_ = this.root.filename_.executeRubyString(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object lineNumberValue = this.executeLineNumber_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, ex.getResult(), lineNumberValue);
                    }
                    try {
                        lineNumberValue_ = this.root.lineNumber_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, filenameValue_, ex.getResult());
                    }
                    return this.root.eval(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof RubyString && bindingValue instanceof RubyBinding && filenameValue instanceof RubyString && lineNumberValue instanceof Integer) {
                        RubyString sourceValue_ = (RubyString)sourceValue;
                        RubyBinding bindingValue_ = (RubyBinding)bindingValue;
                        RubyString filenameValue_ = (RubyString)filenameValue;
                        int lineNumberValue_ = (Integer)lineNumberValue;
                        return this.root.eval(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new Eval4Node_(root);
                }
            }

            @GeneratedBy(methodName="eval(RubyString, RubyBinding, RubyString, NotProvided)", value=KernelNodes.EvalNode.class)
            private static final class Eval3Node_
            extends BaseNode_ {
                Eval3Node_(EvalNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof RubyString && bindingValue instanceof RubyBinding && filenameValue instanceof RubyString && lineNumberValue instanceof NotProvided) {
                        RubyString sourceValue_ = (RubyString)sourceValue;
                        RubyBinding bindingValue_ = (RubyBinding)bindingValue;
                        RubyString filenameValue_ = (RubyString)filenameValue;
                        NotProvided lineNumberValue_ = (NotProvided)lineNumberValue;
                        return this.root.eval(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new Eval3Node_(root);
                }
            }

            @GeneratedBy(methodName="eval(RubyString, RubyBinding, NotProvided, NotProvided)", value=KernelNodes.EvalNode.class)
            private static final class Eval2Node_
            extends BaseNode_ {
                Eval2Node_(EvalNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof RubyString && bindingValue instanceof RubyBinding && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided) {
                        RubyString sourceValue_ = (RubyString)sourceValue;
                        RubyBinding bindingValue_ = (RubyBinding)bindingValue;
                        NotProvided filenameValue_ = (NotProvided)filenameValue;
                        NotProvided lineNumberValue_ = (NotProvided)lineNumberValue;
                        return this.root.eval(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new Eval2Node_(root);
                }
            }

            @GeneratedBy(methodName="eval(VirtualFrame, RubyString, Object, RubyString, int)", value=KernelNodes.EvalNode.class)
            private static final class Eval1Node_
            extends BaseNode_ {
                Eval1Node_(EvalNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int lineNumberValue_;
                    RubyString filenameValue_;
                    RubyString sourceValue_;
                    try {
                        sourceValue_ = this.root.source_.executeRubyString(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bindingValue = this.root.binding_.execute(frameValue);
                        Object filenameValue = this.root.filename_.execute(frameValue);
                        Object lineNumberValue = this.executeLineNumber_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bindingValue, filenameValue, lineNumberValue);
                    }
                    Object bindingValue_ = this.root.binding_.execute(frameValue);
                    try {
                        filenameValue_ = this.root.filename_.executeRubyString(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object lineNumberValue = this.executeLineNumber_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, ex.getResult(), lineNumberValue);
                    }
                    try {
                        lineNumberValue_ = this.root.lineNumber_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, filenameValue_, ex.getResult());
                    }
                    if (this.root.isNil(bindingValue_)) {
                        return this.root.eval(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                    }
                    return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof RubyString && filenameValue instanceof RubyString && lineNumberValue instanceof Integer) {
                        RubyString sourceValue_ = (RubyString)sourceValue;
                        RubyString filenameValue_ = (RubyString)filenameValue;
                        int lineNumberValue_ = (Integer)lineNumberValue;
                        if (this.root.isNil(bindingValue)) {
                            return this.root.eval(frameValue, sourceValue_, bindingValue, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new Eval1Node_(root);
                }
            }

            @GeneratedBy(methodName="eval(VirtualFrame, RubyString, NotProvided, NotProvided, NotProvided)", value=KernelNodes.EvalNode.class)
            private static final class Eval0Node_
            extends BaseNode_ {
                Eval0Node_(EvalNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof RubyString && bindingValue instanceof NotProvided && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided) {
                        RubyString sourceValue_ = (RubyString)sourceValue;
                        NotProvided bindingValue_ = (NotProvided)bindingValue;
                        NotProvided filenameValue_ = (NotProvided)filenameValue;
                        NotProvided lineNumberValue_ = (NotProvided)lineNumberValue;
                        return this.root.eval(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new Eval0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.EvalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EvalNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.EvalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EvalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    return this.uninitialized((Frame)frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.EvalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final EvalNodeGen root;

                BaseNode_(EvalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.source_, this.root.binding_, this.root.filename_, this.root.lineNumber_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    return this.execute_((VirtualFrame)frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object sourceValue_ = this.root.source_.execute(frameValue);
                    Object bindingValue_ = this.root.binding_.execute(frameValue);
                    Object filenameValue_ = this.root.filename_.execute(frameValue);
                    Object lineNumberValue_ = this.executeLineNumber_((Frame)frameValue);
                    return this.execute_(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof RubyString) {
                        RubyBasicObject bindingValue_;
                        if (bindingValue instanceof NotProvided && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided) {
                            return Eval0Node_.create(this.root);
                        }
                        if (filenameValue instanceof RubyString && lineNumberValue instanceof Integer && this.root.isNil(bindingValue)) {
                            return Eval1Node_.create(this.root);
                        }
                        if (bindingValue instanceof RubyBinding) {
                            if (lineNumberValue instanceof NotProvided) {
                                if (filenameValue instanceof NotProvided) {
                                    return Eval2Node_.create(this.root);
                                }
                                if (filenameValue instanceof RubyString) {
                                    return Eval3Node_.create(this.root);
                                }
                            }
                            if (filenameValue instanceof RubyString && lineNumberValue instanceof Integer) {
                                return Eval4Node_.create(this.root);
                            }
                        }
                        if (bindingValue instanceof RubyBasicObject && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided && !RubyGuards.isRubyBinding(bindingValue_ = (RubyBasicObject)bindingValue)) {
                            return Eval5Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeLineNumber_(Frame frameValue) {
                    Object object;
                    Class lineNumberType_ = this.root.lineNumberType_;
                    if (lineNumberType_ == Integer.TYPE) {
                        return this.root.lineNumber_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (lineNumberType_ != null) return this.root.lineNumber_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.lineNumber_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.lineNumberType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.lineNumberType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.lineNumberType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.DupNode.class)
    public static final class DupNodeFactory
    extends NodeFactoryBase<KernelNodes.DupNode> {
        private static DupNodeFactory dupNodeFactoryInstance;

        private DupNodeFactory() {
            super(KernelNodes.DupNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.DupNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DupNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.DupNode> getInstance() {
            if (dupNodeFactoryInstance == null) {
                dupNodeFactoryInstance = new DupNodeFactory();
            }
            return dupNodeFactoryInstance;
        }

        public static KernelNodes.DupNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DupNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.DupNode.class)
        public static final class DupNodeGen
        extends KernelNodes.DupNode {
            @Node.Child
            private RubyNode arguments0_;

            private DupNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.dup(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CloneNode.class)
    public static final class CloneNodeFactory
    extends NodeFactoryBase<KernelNodes.CloneNode> {
        private static CloneNodeFactory cloneNodeFactoryInstance;

        private CloneNodeFactory() {
            super(KernelNodes.CloneNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.CloneNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CloneNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CloneNode> getInstance() {
            if (cloneNodeFactoryInstance == null) {
                cloneNodeFactoryInstance = new CloneNodeFactory();
            }
            return cloneNodeFactoryInstance;
        }

        public static KernelNodes.CloneNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CloneNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.CloneNode.class)
        public static final class CloneNodeGen
        extends KernelNodes.CloneNode {
            @Node.Child
            private RubyNode arguments0_;

            private CloneNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.clone(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CopyNode.class)
    public static final class CopyNodeFactory
    extends NodeFactoryBase<KernelNodes.CopyNode> {
        private static CopyNodeFactory copyNodeFactoryInstance;

        private CopyNodeFactory() {
            super(KernelNodes.CopyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public KernelNodes.CopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return CopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CopyNode> getInstance() {
            if (copyNodeFactoryInstance == null) {
                copyNodeFactoryInstance = new CopyNodeFactory();
            }
            return copyNodeFactoryInstance;
        }

        public static KernelNodes.CopyNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new CopyNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=KernelNodes.CopyNode.class)
        public static final class CopyNodeGen
        extends KernelNodes.CopyNode {
            @Node.Child
            private RubyNode operand_;

            private CopyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public RubyBasicObject executeCopy(VirtualFrame frameValue, RubyBasicObject operandValue) {
                return this.copy(frameValue, operandValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.copy(frameValue, operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object operandValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelClassNode.class)
    public static final class KernelClassNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelClassNode> {
        private static KernelClassNodeFactory kernelClassNodeFactoryInstance;

        private KernelClassNodeFactory() {
            super(KernelNodes.KernelClassNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelClassNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelClassNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelClassNode> getInstance() {
            if (kernelClassNodeFactoryInstance == null) {
                kernelClassNodeFactoryInstance = new KernelClassNodeFactory();
            }
            return kernelClassNodeFactoryInstance;
        }

        public static KernelNodes.KernelClassNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelClassNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelClassNode.class)
        public static final class KernelClassNodeGen
        extends KernelNodes.KernelClassNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelClassNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.getClass(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
    public static final class CallerLocationsNodeFactory
    extends NodeFactoryBase<KernelNodes.CallerLocationsNode> {
        private static CallerLocationsNodeFactory callerLocationsNodeFactoryInstance;

        private CallerLocationsNodeFactory() {
            super(KernelNodes.CallerLocationsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.CallerLocationsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CallerLocationsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CallerLocationsNode> getInstance() {
            if (callerLocationsNodeFactoryInstance == null) {
                callerLocationsNodeFactoryInstance = new CallerLocationsNodeFactory();
            }
            return callerLocationsNodeFactoryInstance;
        }

        public static KernelNodes.CallerLocationsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CallerLocationsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
        public static final class CallerLocationsNodeGen
        extends KernelNodes.CallerLocationsNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CallerLocationsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="callerLocations(int, int)", value=KernelNodes.CallerLocationsNode.class)
            private static final class CallerLocations2Node_
            extends BaseNode_ {
                CallerLocations2Node_(CallerLocationsNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.callerLocations(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.root.callerLocations(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root) {
                    return new CallerLocations2Node_(root);
                }
            }

            @GeneratedBy(methodName="callerLocations(int, NotProvided)", value=KernelNodes.CallerLocationsNode.class)
            private static final class CallerLocations1Node_
            extends BaseNode_ {
                CallerLocations1Node_(CallerLocationsNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    int arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.callerLocations(arguments0Value_, arguments1Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof Integer && arguments1Value instanceof NotProvided) {
                        int arguments0Value_ = (Integer)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.callerLocations(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root) {
                    return new CallerLocations1Node_(root);
                }
            }

            @GeneratedBy(methodName="callerLocations(NotProvided, NotProvided)", value=KernelNodes.CallerLocationsNode.class)
            private static final class CallerLocations0Node_
            extends BaseNode_ {
                CallerLocations0Node_(CallerLocationsNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof NotProvided && arguments1Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.callerLocations(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root) {
                    return new CallerLocations0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CallerLocationsNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CallerLocationsNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final CallerLocationsNodeGen root;

                BaseNode_(CallerLocationsNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        if (arguments0Value instanceof NotProvided) {
                            return CallerLocations0Node_.create(this.root);
                        }
                        if (arguments0Value instanceof Integer) {
                            return CallerLocations1Node_.create(this.root);
                        }
                    }
                    if (arguments0Value instanceof Integer && arguments1Value instanceof Integer) {
                        return CallerLocations2Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CalleeNameNode.class)
    public static final class CalleeNameNodeFactory
    extends NodeFactoryBase<KernelNodes.CalleeNameNode> {
        private static CalleeNameNodeFactory calleeNameNodeFactoryInstance;

        private CalleeNameNodeFactory() {
            super(KernelNodes.CalleeNameNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.CalleeNameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CalleeNameNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CalleeNameNode> getInstance() {
            if (calleeNameNodeFactoryInstance == null) {
                calleeNameNodeFactoryInstance = new CalleeNameNodeFactory();
            }
            return calleeNameNodeFactoryInstance;
        }

        public static KernelNodes.CalleeNameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CalleeNameNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.CalleeNameNode.class)
        public static final class CalleeNameNodeGen
        extends KernelNodes.CalleeNameNode {
            private CalleeNameNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.calleeName();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException((Node)this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
    public static final class BlockGivenNodeFactory
    extends NodeFactoryBase<KernelNodes.BlockGivenNode> {
        private static BlockGivenNodeFactory blockGivenNodeFactoryInstance;

        private BlockGivenNodeFactory() {
            super(KernelNodes.BlockGivenNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.BlockGivenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BlockGivenNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.BlockGivenNode> getInstance() {
            if (blockGivenNodeFactoryInstance == null) {
                blockGivenNodeFactoryInstance = new BlockGivenNodeFactory();
            }
            return blockGivenNodeFactoryInstance;
        }

        public static KernelNodes.BlockGivenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BlockGivenNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
        public static final class BlockGivenNodeGen
        extends KernelNodes.BlockGivenNode {
            private BlockGivenNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.blockGiven();
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException((Node)this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.BindingNode.class)
    public static final class BindingNodeFactory
    extends NodeFactoryBase<KernelNodes.BindingNode> {
        private static BindingNodeFactory bindingNodeFactoryInstance;

        private BindingNodeFactory() {
            super(KernelNodes.BindingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.BindingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BindingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.BindingNode> getInstance() {
            if (bindingNodeFactoryInstance == null) {
                bindingNodeFactoryInstance = new BindingNodeFactory();
            }
            return bindingNodeFactoryInstance;
        }

        public static KernelNodes.BindingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BindingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.BindingNode.class)
        public static final class BindingNodeGen
        extends KernelNodes.BindingNode {
            private BindingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeRubyBinding(frameValue);
            }

            @Override
            public RubyBinding executeRubyBinding(VirtualFrame frameValue) {
                return this.binding();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeRubyBinding(frameValue);
            }

            protected UnsupportedSpecializationException unsupported() {
                return new UnsupportedSpecializationException((Node)this, new Node[0], new Object[0]);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.AbortNode.class)
    public static final class AbortNodeFactory
    extends NodeFactoryBase<KernelNodes.AbortNode> {
        private static AbortNodeFactory abortNodeFactoryInstance;

        private AbortNodeFactory() {
            super(KernelNodes.AbortNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.AbortNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbortNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.AbortNode> getInstance() {
            if (abortNodeFactoryInstance == null) {
                abortNodeFactoryInstance = new AbortNodeFactory();
            }
            return abortNodeFactoryInstance;
        }

        public static KernelNodes.AbortNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AbortNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.AbortNode.class)
        public static final class AbortNodeGen
        extends KernelNodes.AbortNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private AbortNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="abort(NotProvided)", value=KernelNodes.AbortNode.class)
            private static final class Abort1Node_
            extends BaseNode_ {
                Abort1Node_(AbortNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.abort(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbortNodeGen root) {
                    return new Abort1Node_(root);
                }
            }

            @GeneratedBy(methodName="abort(RubyBasicObject)", value=KernelNodes.AbortNode.class)
            private static final class Abort0Node_
            extends BaseNode_ {
                Abort0Node_(AbortNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyString(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return this.root.abort(arguments0Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbortNodeGen root) {
                    return new Abort0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.AbortNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AbortNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AbortNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.AbortNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AbortNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(AbortNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.AbortNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final AbortNodeGen root;

                BaseNode_(AbortNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    RubyBasicObject arguments0Value_;
                    if (arguments0Value instanceof RubyBasicObject && RubyGuards.isRubyString(arguments0Value_ = (RubyBasicObject)arguments0Value)) {
                        return Abort0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof NotProvided) {
                        return Abort1Node_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<KernelNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(KernelNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        public static KernelNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompareNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.CompareNode.class)
        public static final class CompareNodeGen
        extends KernelNodes.CompareNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private CompareNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.compare(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.NotMatchNode.class)
    public static final class NotMatchNodeFactory
    extends NodeFactoryBase<KernelNodes.NotMatchNode> {
        private static NotMatchNodeFactory notMatchNodeFactoryInstance;

        private NotMatchNodeFactory() {
            super(KernelNodes.NotMatchNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.NotMatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NotMatchNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.NotMatchNode> getInstance() {
            if (notMatchNodeFactoryInstance == null) {
                notMatchNodeFactoryInstance = new NotMatchNodeFactory();
            }
            return notMatchNodeFactoryInstance;
        }

        public static KernelNodes.NotMatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NotMatchNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.NotMatchNode.class)
        public static final class NotMatchNodeGen
        extends KernelNodes.NotMatchNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private NotMatchNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.notMatch(frameValue, arguments0Value_, arguments1Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MatchNode.class)
    public static final class MatchNodeFactory
    extends NodeFactoryBase<KernelNodes.MatchNode> {
        private static MatchNodeFactory matchNodeFactoryInstance;

        private MatchNodeFactory() {
            super(KernelNodes.MatchNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.MatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MatchNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.MatchNode> getInstance() {
            if (matchNodeFactoryInstance == null) {
                matchNodeFactoryInstance = new MatchNodeFactory();
            }
            return matchNodeFactoryInstance;
        }

        public static KernelNodes.MatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MatchNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.MatchNode.class)
        public static final class MatchNodeGen
        extends KernelNodes.MatchNode {
            @Node.Child
            private RubyNode arguments0_;

            private MatchNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.equal(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SameOrEqualNode.class)
    public static final class SameOrEqualNodeFactory
    extends NodeFactoryBase<KernelNodes.SameOrEqualNode> {
        private static SameOrEqualNodeFactory sameOrEqualNodeFactoryInstance;

        private SameOrEqualNodeFactory() {
            super(KernelNodes.SameOrEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SameOrEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SameOrEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SameOrEqualNode> getInstance() {
            if (sameOrEqualNodeFactoryInstance == null) {
                sameOrEqualNodeFactoryInstance = new SameOrEqualNodeFactory();
            }
            return sameOrEqualNodeFactoryInstance;
        }

        public static KernelNodes.SameOrEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SameOrEqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SameOrEqualNode.class)
        public static final class SameOrEqualNodeGen
        extends KernelNodes.SameOrEqualNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private SameOrEqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public boolean executeSameOrEqual(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.sameOrEqual(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.sameOrEqual(frameValue, arguments0Value_, arguments1Value_);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=KernelNodes.BacktickNode.class)
    public static final class BacktickNodeFactory
    extends NodeFactoryBase<KernelNodes.BacktickNode> {
        private static BacktickNodeFactory backtickNodeFactoryInstance;

        private BacktickNodeFactory() {
            super(KernelNodes.BacktickNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.BacktickNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BacktickNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.BacktickNode> getInstance() {
            if (backtickNodeFactoryInstance == null) {
                backtickNodeFactoryInstance = new BacktickNodeFactory();
            }
            return backtickNodeFactoryInstance;
        }

        public static KernelNodes.BacktickNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BacktickNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.BacktickNode.class)
        public static final class BacktickNodeGen
        extends KernelNodes.BacktickNode {
            @Node.Child
            private RubyNode arguments0_;

            private BacktickNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.backtick(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object arguments0Value) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }
}

