/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.ToSNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public final class InterpolatedStringNode
extends RubyNode {
    @Node.Children
    private final ToSNode[] children;
    @Node.Child
    private IsTaintedNode isTaintedNode;
    @Node.Child
    private TaintNode taintNode;
    private final ConditionProfile taintProfile = ConditionProfile.createCountingProfile();

    public InterpolatedStringNode(RubyContext context, SourceSection sourceSection, ToSNode[] children) {
        super(context, sourceSection);
        this.children = children;
        this.isTaintedNode = IsTaintedNodeGen.create(context, sourceSection, null);
        this.taintNode = TaintNodeGen.create(context, sourceSection, null);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        org.jruby.truffle.runtime.core.RubyString[] strings = new org.jruby.truffle.runtime.core.RubyString[this.children.length];
        boolean tainted = false;
        for (int n = 0; n < this.children.length; ++n) {
            org.jruby.truffle.runtime.core.RubyString toInterpolate;
            strings[n] = toInterpolate = this.children[n].executeRubyString(frame);
            tainted |= this.isTaintedNode.isTainted(toInterpolate);
        }
        RubyBasicObject string = this.concat(strings);
        if (this.taintProfile.profile(tainted)) {
            this.taintNode.taint(string);
        }
        return string;
    }

    @CompilerDirectives.TruffleBoundary
    private RubyBasicObject concat(org.jruby.truffle.runtime.core.RubyString[] strings) {
        RubyString builder = null;
        for (org.jruby.truffle.runtime.core.RubyString string : strings) {
            if (builder == null) {
                builder = this.getContext().toJRuby(string);
                continue;
            }
            try {
                builder.append19((IRubyObject)this.getContext().toJRuby(string));
            }
            catch (RaiseException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityErrorIncompatible(builder.getEncoding().getCharsetName(), StringNodes.getByteList(string).getEncoding().getCharsetName(), this));
            }
        }
        return this.getContext().toTruffle(builder);
    }
}

