/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ConditionVariableNodes;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=ConditionVariableNodes.class)
public final class ConditionVariableNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(BroadcastNodeFactory.getInstance(), SignalNodeFactory.getInstance(), WaitNodeFactory.getInstance());
    }

    @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
    public static final class WaitNodeFactory
    extends NodeFactoryBase<ConditionVariableNodes.WaitNode> {
        private static WaitNodeFactory waitNodeFactoryInstance;

        private WaitNodeFactory() {
            super(ConditionVariableNodes.WaitNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ConditionVariableNodes.WaitNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return WaitNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ConditionVariableNodes.WaitNode> getInstance() {
            if (waitNodeFactoryInstance == null) {
                waitNodeFactoryInstance = new WaitNodeFactory();
            }
            return waitNodeFactoryInstance;
        }

        public static ConditionVariableNodes.WaitNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new WaitNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
        public static final class WaitNodeGen
        extends ConditionVariableNodes.WaitNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private WaitNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                return this.specialization_.executeRubyBasicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="wait(RubyBasicObject, RubyBasicObject, double)", value=ConditionVariableNodes.WaitNode.class)
            private static final class Wait3Node_
            extends BaseNode_ {
                Wait3Node_(WaitNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    double arguments2Value_;
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyMutex(arguments1Value_)) {
                        return this.root.wait(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof Double) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        double arguments2Value_ = (Double)arguments2Value;
                        if (RubyGuards.isRubyMutex(arguments1Value_)) {
                            return this.root.wait(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WaitNodeGen root) {
                    return new Wait3Node_(root);
                }
            }

            @GeneratedBy(methodName="wait(RubyBasicObject, RubyBasicObject, int)", value=ConditionVariableNodes.WaitNode.class)
            private static final class Wait2Node_
            extends BaseNode_ {
                Wait2Node_(WaitNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeRubyBasicObject(frameValue);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    int arguments2Value_;
                    RubyBasicObject arguments1Value_;
                    RubyBasicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeRubyBasicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_((Frame)frameValue);
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyMutex(arguments1Value_)) {
                        return this.root.wait(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof Integer) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        int arguments2Value_ = (Integer)arguments2Value;
                        if (RubyGuards.isRubyMutex(arguments1Value_)) {
                            return this.root.wait(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WaitNodeGen root) {
                    return new Wait2Node_(root);
                }
            }

            @GeneratedBy(methodName="wait(RubyBasicObject, RubyBasicObject, RubyBasicObject)", value=ConditionVariableNodes.WaitNode.class)
            private static final class Wait1Node_
            extends BaseNode_ {
                Wait1Node_(WaitNodeGen root) {
                    super(root, 2);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                        if (RubyGuards.isRubyMutex(arguments1Value_) && this.root.isNil(arguments2Value_)) {
                            return this.root.wait(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WaitNodeGen root) {
                    return new Wait1Node_(root);
                }
            }

            @GeneratedBy(methodName="wait(RubyBasicObject, RubyBasicObject, NotProvided)", value=ConditionVariableNodes.WaitNode.class)
            private static final class Wait0Node_
            extends BaseNode_ {
                Wait0Node_(WaitNodeGen root) {
                    super(root, 1);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject && arguments2Value instanceof NotProvided) {
                        RubyBasicObject arguments0Value_ = (RubyBasicObject)arguments0Value;
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isRubyMutex(arguments1Value_)) {
                            return this.root.wait(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WaitNodeGen root) {
                    return new Wait0Node_(root);
                }
            }

            @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(WaitNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().executeRubyBasicObject_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WaitNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(WaitNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public RubyBasicObject executeRubyBasicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return (RubyBasicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WaitNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ConditionVariableNodes.WaitNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                protected final WaitNodeGen root;

                BaseNode_(WaitNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.executeRubyBasicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract RubyBasicObject executeRubyBasicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.executeArguments2_((Frame)frameValue);
                    return this.executeRubyBasicObject_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
                    return (RubyBasicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof RubyBasicObject && arguments1Value instanceof RubyBasicObject) {
                        RubyBasicObject arguments1Value_ = (RubyBasicObject)arguments1Value;
                        if (arguments2Value instanceof NotProvided && RubyGuards.isRubyMutex(arguments1Value_)) {
                            return Wait0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof RubyBasicObject) {
                            RubyBasicObject arguments2Value_ = (RubyBasicObject)arguments2Value;
                            if (RubyGuards.isRubyMutex(arguments1Value_) && this.root.isNil(arguments2Value_)) {
                                return Wait1Node_.create(this.root);
                            }
                        }
                        if (arguments2Value instanceof Integer && RubyGuards.isRubyMutex(arguments1Value_)) {
                            return Wait2Node_.create(this.root);
                        }
                        if (arguments2Value instanceof Double && RubyGuards.isRubyMutex(arguments1Value_)) {
                            return Wait3Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Double.TYPE) {
                        return this.root.arguments2_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ConditionVariableNodes.SignalNode.class)
    public static final class SignalNodeFactory
    extends NodeFactoryBase<ConditionVariableNodes.SignalNode> {
        private static SignalNodeFactory signalNodeFactoryInstance;

        private SignalNodeFactory() {
            super(ConditionVariableNodes.SignalNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public ConditionVariableNodes.SignalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return SignalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ConditionVariableNodes.SignalNode> getInstance() {
            if (signalNodeFactoryInstance == null) {
                signalNodeFactoryInstance = new SignalNodeFactory();
            }
            return signalNodeFactoryInstance;
        }

        public static ConditionVariableNodes.SignalNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new SignalNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=ConditionVariableNodes.SignalNode.class)
        public static final class SignalNodeGen
        extends ConditionVariableNodes.SignalNode {
            @Node.Child
            private RubyNode operand_;

            private SignalNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.signal(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object operandValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=ConditionVariableNodes.BroadcastNode.class)
    public static final class BroadcastNodeFactory
    extends NodeFactoryBase<ConditionVariableNodes.BroadcastNode> {
        private static BroadcastNodeFactory broadcastNodeFactoryInstance;

        private BroadcastNodeFactory() {
            super(ConditionVariableNodes.BroadcastNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public ConditionVariableNodes.BroadcastNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return BroadcastNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ConditionVariableNodes.BroadcastNode> getInstance() {
            if (broadcastNodeFactoryInstance == null) {
                broadcastNodeFactoryInstance = new BroadcastNodeFactory();
            }
            return broadcastNodeFactoryInstance;
        }

        public static ConditionVariableNodes.BroadcastNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new BroadcastNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=ConditionVariableNodes.BroadcastNode.class)
        public static final class BroadcastNodeGen
        extends ConditionVariableNodes.BroadcastNode {
            @Node.Child
            private RubyNode operand_;

            private BroadcastNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.broadcast(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected UnsupportedSpecializationException unsupported(Object operandValue) {
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }
}

