/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.MutexNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.object.BasicObjectType;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

@CoreClass(name="ConditionVariable")
public abstract class ConditionVariableNodes {
    public static final ConditionVariableType CONDITION_VARIABLE_TYPE = new ConditionVariableType();
    private static final HiddenKey ASSOCIATED_MUTEX_IDENTIFIER = new HiddenKey("associated_mutex");
    private static final Property ASSOCIATED_MUTEX_PROPERTY;
    private static final HiddenKey CONDITION_IDENTIFIER;
    private static final Property CONDITION_PROPERTY;
    private static final DynamicObjectFactory CONDITION_VARIABLE_FACTORY;

    protected static AtomicReference<RubyBasicObject> getAssociatedMutex(RubyBasicObject mutex) {
        assert (mutex.getDynamicObject().getShape().hasProperty((Object)ASSOCIATED_MUTEX_IDENTIFIER));
        return (AtomicReference)ASSOCIATED_MUTEX_PROPERTY.get(mutex.getDynamicObject(), true);
    }

    protected static AtomicReference<Condition> getCondition(RubyBasicObject conditionVariable) {
        assert (conditionVariable.getDynamicObject().getShape().hasProperty((Object)CONDITION_IDENTIFIER));
        return (AtomicReference)CONDITION_PROPERTY.get(conditionVariable.getDynamicObject(), true);
    }

    static {
        CONDITION_IDENTIFIER = new HiddenKey("condition");
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        ASSOCIATED_MUTEX_PROPERTY = Property.create((Object)ASSOCIATED_MUTEX_IDENTIFIER, (Location)allocator.locationForType(AtomicReference.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), (int)0);
        CONDITION_PROPERTY = Property.create((Object)CONDITION_IDENTIFIER, (Location)allocator.locationForType(AtomicReference.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), (int)0);
        Shape shape = RubyBasicObject.LAYOUT.createShape((ObjectType)CONDITION_VARIABLE_TYPE).addProperty(ASSOCIATED_MUTEX_PROPERTY).addProperty(CONDITION_PROPERTY);
        CONDITION_VARIABLE_FACTORY = shape.createFactory();
    }

    @CoreMethod(names={"wait"}, required=1, optional=1)
    public static abstract class WaitNode
    extends CoreMethodArrayArgumentsNode {
        public WaitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyMutex(mutex)"})
        RubyBasicObject wait(RubyBasicObject conditionVariable, RubyBasicObject mutex, NotProvided timeout) {
            return this.wait(conditionVariable, mutex, this.nil());
        }

        @Specialization(guards={"isRubyMutex(mutex)", "isNil(timeout)"})
        RubyBasicObject wait(RubyBasicObject conditionVariable, RubyBasicObject mutex, RubyBasicObject timeout) {
            return this.waitOn(conditionVariable, mutex, new WaitAction(){

                @Override
                public void wait(Condition condition) throws InterruptedException {
                    condition.await();
                }
            });
        }

        @Specialization(guards={"isRubyMutex(mutex)"})
        RubyBasicObject wait(RubyBasicObject conditionVariable, RubyBasicObject mutex, int timeout) {
            return this.wait(conditionVariable, mutex, (double)timeout);
        }

        @Specialization(guards={"isRubyMutex(mutex)"})
        RubyBasicObject wait(RubyBasicObject conditionVariable, RubyBasicObject mutex, double timeout) {
            final long timeoutInNanos = (long)(timeout * 1.0E9);
            return this.waitOn(conditionVariable, mutex, new WaitAction(){
                private long remaining;
                {
                    this.remaining = timeoutInNanos;
                }

                @Override
                public void wait(Condition condition) throws InterruptedException {
                    while (this.remaining > 0L) {
                        this.remaining = condition.awaitNanos(this.remaining);
                    }
                }
            });
        }

        private RubyBasicObject waitOn(RubyBasicObject conditionVariable, RubyBasicObject mutex, final WaitAction waitAction) {
            Condition condition;
            AtomicReference<RubyBasicObject> associatedMutexReference = ConditionVariableNodes.getAssociatedMutex(conditionVariable);
            AtomicReference<Condition> conditionReference = ConditionVariableNodes.getCondition(conditionVariable);
            if (associatedMutexReference.compareAndSet(null, mutex)) {
                ReentrantLock lock = MutexNodes.getLock(mutex);
                condition = lock.newCondition();
                conditionReference.set(condition);
            } else if (associatedMutexReference.get() == mutex) {
                condition = conditionReference.get();
            } else {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("Attempt to associate a ConditionVariable which already has a Mutex", this));
            }
            if (!MutexNodes.getLock(associatedMutexReference.get()).isHeldByCurrentThread()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("Called ConditionVariable#wait without holding associated Mutex", this));
            }
            this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    waitAction.wait(condition);
                    return true;
                }
            });
            return conditionVariable;
        }

        private static interface WaitAction {
            public void wait(Condition var1) throws InterruptedException;
        }
    }

    @CoreMethod(names={"signal"})
    public static abstract class SignalNode
    extends UnaryCoreMethodNode {
        public SignalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject signal(RubyBasicObject conditionVariable) {
            Condition condition = ConditionVariableNodes.getCondition(conditionVariable).get();
            RubyBasicObject associatedMutex = ConditionVariableNodes.getAssociatedMutex(conditionVariable).get();
            if (condition == null) {
                return conditionVariable;
            }
            if (!MutexNodes.getLock(associatedMutex).isHeldByCurrentThread()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("Called ConditionVariable#signal without holding associated Mutex", this));
            }
            condition.signal();
            return conditionVariable;
        }
    }

    @CoreMethod(names={"broadcast"})
    public static abstract class BroadcastNode
    extends UnaryCoreMethodNode {
        public BroadcastNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject broadcast(RubyBasicObject conditionVariable) {
            Condition condition = ConditionVariableNodes.getCondition(conditionVariable).get();
            RubyBasicObject associatedMutex = ConditionVariableNodes.getAssociatedMutex(conditionVariable).get();
            if (condition == null) {
                return conditionVariable;
            }
            if (!MutexNodes.getLock(associatedMutex).isHeldByCurrentThread()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("Called ConditionVariable#broadcast without holding associated Mutex", this));
            }
            condition.signalAll();
            return conditionVariable;
        }
    }

    public static class ConditionVariableAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyBasicObject(rubyClass, CONDITION_VARIABLE_FACTORY.newInstance(new Object[]{new AtomicReference(), new AtomicReference()}));
        }
    }

    private static class ConditionVariableType
    extends BasicObjectType {
        private ConditionVariableType() {
        }
    }
}

