/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.truffle.runtime.core.RubyFiber;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

public class FiberManager {
    private final RubyFiber rootFiber;
    private RubyFiber currentFiber;
    private final Set<RubyFiber> runningFibers = Collections.newSetFromMap(new ConcurrentHashMap());

    public FiberManager(RubyThread rubyThread, ThreadManager threadManager) {
        this.currentFiber = this.rootFiber = RubyFiber.newRootFiber(rubyThread, this, threadManager);
    }

    public RubyFiber getRootFiber() {
        return this.rootFiber;
    }

    public RubyFiber getCurrentFiber() {
        return this.currentFiber;
    }

    public void setCurrentFiber(RubyFiber fiber) {
        this.currentFiber = fiber;
    }

    public void registerFiber(RubyFiber fiber) {
        this.runningFibers.add(fiber);
    }

    public void unregisterFiber(RubyFiber fiber) {
        this.runningFibers.remove(fiber);
    }

    public void shutdown() {
        for (RubyFiber fiber : this.runningFibers) {
            if (fiber.isRootFiber()) continue;
            fiber.shutdown();
        }
    }
}

