/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.signal;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.RubySignal;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SignalOperations {
    private static final ConcurrentMap<Signal, SignalHandler> ORIGINAL_HANDLERS = new ConcurrentHashMap<Signal, SignalHandler>();
    public static final Map<String, Integer> SIGNALS_LIST = Collections.unmodifiableMap(RubySignal.list());
    public static final SignalHandler IGNORE_HANDLER = new SignalHandler(){

        @Override
        public void handle(Signal arg0) {
        }
    };

    public static void watchSignal(Signal signal, SignalHandler newHandler) {
        SignalHandler oldHandler = Signal.handle(signal, newHandler);
        ORIGINAL_HANDLERS.putIfAbsent(signal, oldHandler);
    }

    public static void watchDefaultForSignal(Signal signal) {
        SignalHandler defaultHandler = (SignalHandler)ORIGINAL_HANDLERS.get(signal);
        if (defaultHandler != null) {
            Signal.handle(signal, defaultHandler);
        }
    }

    public static void raise(Signal signal) {
        Signal.raise(signal);
    }
}

