/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.hash;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;
import org.jruby.RubyHash;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashOperations;

public abstract class BucketsStrategy {
    public static final double LOAD_FACTOR = 0.75;
    public static final int SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int[] CAPACITIES = Arrays.copyOf(RubyHash.MRI_PRIMES, RubyHash.MRI_PRIMES.length - 1);

    public static int capacityGreaterThan(int size) {
        for (int capacity : CAPACITIES) {
            if (capacity <= size) continue;
            return capacity;
        }
        return CAPACITIES[CAPACITIES.length - 1];
    }

    public static int getBucketIndex(int hashed, int bucketsCount) {
        return (hashed & Integer.MAX_VALUE) % bucketsCount;
    }

    public static void addNewEntry(RubyBasicObject hash, int hashed, Object key, Object value) {
        assert (HashNodes.getStore(hash) instanceof Entry[]);
        Entry[] buckets = (Entry[])HashNodes.getStore(hash);
        Entry entry = new Entry(hashed, key, value);
        if (HashNodes.getFirstInSequence(hash) == null) {
            HashNodes.setFirstInSequence(hash, entry);
        } else {
            HashNodes.getLastInSequence(hash).setNextInSequence(entry);
            entry.setPreviousInSequence(HashNodes.getLastInSequence(hash));
        }
        HashNodes.setLastInSequence(hash, entry);
        int bucketIndex = BucketsStrategy.getBucketIndex(hashed, buckets.length);
        Entry previousInLookup = buckets[bucketIndex];
        if (previousInLookup == null) {
            buckets[bucketIndex] = entry;
        } else {
            while (previousInLookup.getNextInLookup() != null) {
                previousInLookup = previousInLookup.getNextInLookup();
            }
            previousInLookup.setNextInLookup(entry);
        }
        HashNodes.setSize(hash, HashNodes.getSize(hash) + 1);
        assert (HashOperations.verifyStore(hash));
    }

    @CompilerDirectives.TruffleBoundary
    public static void resize(RubyBasicObject hash) {
        assert (HashOperations.verifyStore(hash));
        int bucketsCount = BucketsStrategy.capacityGreaterThan(HashNodes.getSize(hash)) * 2;
        Entry[] newEntries = new Entry[bucketsCount];
        for (Entry entry = HashNodes.getFirstInSequence(hash); entry != null; entry = entry.getNextInSequence()) {
            int bucketIndex = BucketsStrategy.getBucketIndex(entry.getHashed(), bucketsCount);
            Entry previousInLookup = newEntries[bucketIndex];
            if (previousInLookup == null) {
                newEntries[bucketIndex] = entry;
            } else {
                while (previousInLookup.getNextInLookup() != null) {
                    previousInLookup = previousInLookup.getNextInLookup();
                }
                previousInLookup.setNextInLookup(entry);
            }
            entry.setNextInLookup(null);
        }
        HashNodes.setStore(hash, newEntries, HashNodes.getSize(hash), HashNodes.getFirstInSequence(hash), HashNodes.getLastInSequence(hash));
        assert (HashOperations.verifyStore(hash));
    }
}

