/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import java.util.Arrays;
import org.joni.Region;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.util.ByteList;

public class RubyMatchData
extends RubyBasicObject {
    private final RubyBasicObject source;
    private final RubyRegexp regexp;
    private final Region region;
    private final Object[] values;
    private final RubyBasicObject pre;
    private final RubyBasicObject post;
    private final RubyBasicObject global;

    public RubyMatchData(RubyClass rubyClass, RubyBasicObject source, RubyRegexp regexp, Region region, Object[] values, RubyBasicObject pre, RubyBasicObject post, RubyBasicObject global) {
        super(rubyClass);
        this.source = source;
        this.regexp = regexp;
        this.region = region;
        this.values = values;
        this.pre = pre;
        this.post = post;
        this.global = global;
    }

    public Object[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public Object[] getCaptures() {
        return ArrayUtils.extractRange(this.values, 1, this.values.length);
    }

    public Object begin(int index) {
        if (this.region == null) {
            throw new UnsupportedOperationException("begin is not yet working when no grouping data is available");
        }
        int begin = this.region.beg[index];
        if (begin < 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return begin;
    }

    public Object end(int index) {
        if (this.region == null) {
            throw new UnsupportedOperationException("end is not yet working when no grouping data is available");
        }
        int end = this.region.end[index];
        if (end < 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return end;
    }

    public int getNumberOfRegions() {
        return this.region.numRegs;
    }

    public int getBackrefNumber(ByteList value) {
        return this.regexp.getRegex().nameToBackrefNumber(value.getUnsafeBytes(), value.getBegin(), value.getBegin() + value.getRealSize(), this.region);
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        for (Object object : this.values) {
            if (!(object instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)object).visitObjectGraph(visitor);
        }
    }

    public RubyBasicObject getPre() {
        return this.pre;
    }

    public RubyBasicObject getPost() {
        return this.post;
    }

    public RubyBasicObject getGlobal() {
        return this.global;
    }

    public Region getRegion() {
        return this.region;
    }

    public RubyBasicObject getSource() {
        return this.source;
    }

    public RubyBasicObject getRegexp() {
        return this.regexp;
    }
}

