/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyModule;

public class RubyClass
extends RubyModule {
    @CompilerDirectives.CompilationFinal
    private Allocator allocator;
    private final boolean isSingleton;
    private final RubyModule attached;

    public static RubyClass createClassClass(RubyContext context, Allocator allocator) {
        return new RubyClass(context, null, null, null, "Class", false, null, allocator);
    }

    public static RubyClass createBootClass(RubyClass classClass, RubyClass superclass, String name, Allocator allocator) {
        return new RubyClass(classClass.getContext(), classClass, null, superclass, name, false, null, allocator);
    }

    public RubyClass(RubyContext context, RubyModule lexicalParent, RubyClass superclass, String name, Allocator allocator) {
        this(context, superclass.getLogicalClass(), lexicalParent, superclass, name, false, null, allocator);
        this.ensureSingletonConsistency();
    }

    public static RubyClass createSingletonClassOfObject(RubyContext context, RubyClass superclass, RubyModule attached, String name) {
        return new RubyClass(context, superclass.getLogicalClass(), null, superclass, name, true, attached, null).ensureSingletonConsistency();
    }

    private RubyClass(RubyContext context, RubyClass classClass, RubyModule lexicalParent, RubyClass superclass, String name, boolean isSingleton, RubyModule attached, Allocator allocator) {
        super(context, classClass, lexicalParent, name, null);
        assert (isSingleton || attached == null);
        this.unsafeSetAllocator(allocator);
        this.isSingleton = isSingleton;
        this.attached = attached;
        if (superclass != null) {
            this.unsafeSetSuperclass(superclass);
        }
    }

    public void initialize(RubyClass superclass) {
        this.unsafeSetSuperclass(superclass);
        this.ensureSingletonConsistency();
        this.unsafeSetAllocator(superclass.getAllocator());
    }

    protected void unsafeSetSuperclass(RubyClass superClass) {
        assert (this.parentModule == null);
        this.parentModule = superClass;
        superClass.addDependent(this);
        this.newVersion();
    }

    public void initCopy(RubyClass from) {
        super.initCopy(from);
        this.unsafeSetAllocator(from.getAllocator());
    }

    private RubyClass ensureSingletonConsistency() {
        this.createOneSingletonClass();
        return this;
    }

    public RubyClass getSingletonClass() {
        return this.createOneSingletonClass().ensureSingletonConsistency();
    }

    private RubyClass createOneSingletonClass() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getMetaClass().isSingleton()) {
            return this.getMetaClass();
        }
        RubyClass singletonSuperclass = this.getSuperClass() == null ? this.getLogicalClass() : this.getSuperClass().createOneSingletonClass();
        String name = String.format("#<Class:%s>", this.getName());
        this.setMetaClass(new RubyClass(this.getContext(), this.getLogicalClass(), null, singletonSuperclass, name, true, this, null));
        return this.getMetaClass();
    }

    public RubyBasicObject allocate(Node currentNode) {
        return this.getAllocator().allocate(this.getContext(), this, currentNode);
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public RubyModule getAttached() {
        return this.attached;
    }

    public RubyClass getSuperClass() {
        CompilerAsserts.neverPartOfCompilation();
        for (RubyModule ancestor : this.parentAncestors()) {
            if (!(ancestor instanceof RubyClass)) continue;
            return (RubyClass)ancestor;
        }
        return null;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }

    public void unsafeSetAllocator(Allocator allocator) {
        this.allocator = allocator;
    }

    public static class ClassAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyClass(context, context.getCoreLibrary().getClassClass(), null, null, null, false, null, null);
        }
    }
}

