/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;

public class RubyBinding
extends RubyBasicObject {
    @CompilerDirectives.CompilationFinal
    private Object self;
    @CompilerDirectives.CompilationFinal
    private MaterializedFrame frame;

    public RubyBinding(RubyClass bindingClass) {
        super(bindingClass);
    }

    public RubyBinding(RubyClass bindingClass, Object self, MaterializedFrame frame) {
        super(bindingClass);
        this.initialize(self, frame);
    }

    public void initialize(Object self, MaterializedFrame frame) {
        assert (self != null);
        assert (frame != null);
        this.self = self;
        this.frame = frame;
    }

    public Object getSelf() {
        return this.self;
    }

    public MaterializedFrame getFrame() {
        return this.frame;
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        this.getContext().getObjectSpaceManager().visitFrame((Frame)this.frame, visitor);
    }

    public static class BindingAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyBinding(rubyClass);
        }
    }
}

