/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.HashMap;
import java.util.Map;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.util.IdUtil;

public abstract class ModuleOperations {
    public static boolean includesModule(RubyModule module, RubyModule other) {
        for (RubyModule ancestor : module.ancestors()) {
            if (ancestor != other) continue;
            return true;
        }
        return false;
    }

    public static boolean assignableTo(RubyClass thisClass, RubyModule otherClass) {
        return ModuleOperations.includesModule(thisClass, otherClass);
    }

    public static boolean canBindMethodTo(RubyModule origin, RubyModule module) {
        if (!(origin instanceof RubyClass)) {
            return true;
        }
        return module instanceof RubyClass && ModuleOperations.assignableTo((RubyClass)module, origin);
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, RubyConstant> getAllConstants(RubyModule module) {
        CompilerAsserts.neverPartOfCompilation();
        HashMap<String, RubyConstant> constants = new HashMap<String, RubyConstant>();
        constants.putAll(module.getConstants());
        for (RubyModule ancestor : module.includedModules()) {
            for (Map.Entry<String, RubyConstant> constant : ancestor.getConstants().entrySet()) {
                if (constants.containsKey(constant.getKey())) continue;
                constants.put(constant.getKey(), constant.getValue());
            }
        }
        return constants;
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyConstant lookupConstant(RubyContext context, LexicalScope lexicalScope, RubyModule module, String name) {
        CompilerAsserts.neverPartOfCompilation();
        assert (lexicalScope == null || lexicalScope.getLiveModule() == module);
        RubyConstant constant = module.getConstants().get(name);
        if (constant != null) {
            return constant;
        }
        if (lexicalScope != null) {
            if (lexicalScope != context.getRootLexicalScope()) {
                lexicalScope = lexicalScope.getParent();
            }
            while (lexicalScope != context.getRootLexicalScope()) {
                constant = lexicalScope.getLiveModule().getConstants().get(name);
                if (constant != null) {
                    return constant;
                }
                lexicalScope = lexicalScope.getParent();
            }
        }
        for (RubyModule ancestor : module.parentAncestors()) {
            constant = ancestor.getConstants().get(name);
            if (constant == null) continue;
            return constant;
        }
        if (module.isOnlyAModule()) {
            RubyClass objectClass = context.getCoreLibrary().getObjectClass();
            constant = objectClass.getConstants().get(name);
            if (constant != null) {
                return constant;
            }
            for (RubyModule ancestor : objectClass.includedModules()) {
                constant = ancestor.getConstants().get(name);
                if (constant == null) continue;
                return constant;
            }
        }
        return null;
    }

    public static RubyConstant lookupScopedConstant(RubyContext context, RubyModule module, String fullName, boolean inherit, Node currentNode) {
        int next;
        CompilerAsserts.neverPartOfCompilation();
        int start = 0;
        if (fullName.startsWith("::")) {
            module = context.getCoreLibrary().getObjectClass();
            start += 2;
        }
        while ((next = fullName.indexOf("::", start)) != -1) {
            String segment = fullName.substring(start, next);
            RubyConstant constant = ModuleOperations.lookupConstantWithInherit(context, module, segment, inherit, currentNode);
            if (constant == null) {
                return null;
            }
            if (!(constant.getValue() instanceof RubyModule)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(context.getCoreLibrary().typeError(fullName.substring(0, next) + " does not refer to class/module", currentNode));
            }
            module = (RubyModule)constant.getValue();
            start = next + 2;
        }
        String lastSegment = fullName.substring(start);
        return ModuleOperations.lookupConstantWithInherit(context, module, lastSegment, inherit, currentNode);
    }

    public static RubyConstant lookupConstantWithInherit(RubyContext context, RubyModule module, String name, boolean inherit, Node currentNode) {
        if (!IdUtil.isValidConstantName19((String)name)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(context.getCoreLibrary().nameError(String.format("wrong constant name %s", name), name, currentNode));
        }
        if (inherit) {
            return ModuleOperations.lookupConstant(context, LexicalScope.NONE, module, name);
        }
        return module.getConstants().get(name);
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> getAllMethods(RubyModule module) {
        HashMap<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
        for (RubyModule ancestor : module.ancestors()) {
            for (InternalMethod method : ancestor.getMethods().values()) {
                if (methods.containsKey(method.getName())) continue;
                methods.put(method.getName(), method);
            }
        }
        return methods;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> getMethodsBeforeLogicalClass(RubyModule module) {
        HashMap<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
        for (RubyModule ancestor : module.ancestors()) {
            if (ancestor instanceof RubyClass && !((RubyClass)ancestor).isSingleton()) break;
            for (InternalMethod method : ancestor.getMethods().values()) {
                if (methods.containsKey(method.getName())) continue;
                methods.put(method.getName(), method);
            }
        }
        return methods;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> getMethodsUntilLogicalClass(RubyModule module) {
        HashMap<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
        for (RubyModule ancestor : module.ancestors()) {
            for (InternalMethod method : ancestor.getMethods().values()) {
                if (methods.containsKey(method.getName())) continue;
                methods.put(method.getName(), method);
            }
            if (!(ancestor instanceof RubyClass) || ((RubyClass)ancestor).isSingleton()) continue;
            break;
        }
        return methods;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> withoutUndefinedMethods(Map<String, InternalMethod> methods) {
        HashMap<String, InternalMethod> definedMethods = new HashMap<String, InternalMethod>();
        for (Map.Entry<String, InternalMethod> method : methods.entrySet()) {
            if (method.getValue().isUndefined()) continue;
            definedMethods.put(method.getKey(), method.getValue());
        }
        return definedMethods;
    }

    @CompilerDirectives.TruffleBoundary
    public static InternalMethod lookupMethod(RubyModule module, String name) {
        CompilerAsserts.neverPartOfCompilation();
        InternalMethod method = module.getMethods().get(name);
        if (method != null) {
            return method;
        }
        for (RubyModule ancestor : module.parentAncestors()) {
            method = ancestor.getMethods().get(name);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static InternalMethod lookupSuperMethod(RubyModule declaringModule, String name, RubyClass objectMetaClass) {
        CompilerAsserts.neverPartOfCompilation();
        boolean foundDeclaringModule = false;
        for (RubyModule module : objectMetaClass.ancestors()) {
            InternalMethod method;
            if (module == declaringModule) {
                foundDeclaringModule = true;
                continue;
            }
            if (!foundDeclaringModule || (method = module.getMethods().get(name)) == null) continue;
            return method;
        }
        assert (foundDeclaringModule) : "Did not find the declaring module in " + objectMetaClass.getName() + " ancestors";
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, Object> getAllClassVariables(RubyModule module) {
        CompilerAsserts.neverPartOfCompilation();
        HashMap<String, Object> classVariables = new HashMap<String, Object>();
        classVariables.putAll(module.getClassVariables());
        for (RubyModule ancestor : module.parentAncestors()) {
            for (Map.Entry<String, Object> classVariable : ancestor.getClassVariables().entrySet()) {
                if (classVariables.containsKey(classVariable.getKey())) continue;
                classVariables.put(classVariable.getKey(), classVariable.getValue());
            }
        }
        return classVariables;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object lookupClassVariable(RubyModule module, String name) {
        RubyClass klass;
        CompilerAsserts.neverPartOfCompilation();
        Object value = module.getClassVariables().get(name);
        if (value != null) {
            return value;
        }
        if (module instanceof RubyClass && (klass = (RubyClass)module).isSingleton() && klass.getAttached() != null && (value = (module = klass.getAttached()).getClassVariables().get(name)) != null) {
            return value;
        }
        for (RubyModule ancestor : module.parentAncestors()) {
            value = ancestor.getClassVariables().get(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setClassVariable(RubyModule module, String name, Object value, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (module.getClassVariables().containsKey(name)) {
            module.setClassVariable(currentNode, name, value);
            return;
        }
        for (RubyModule ancestor : module.parentAncestors()) {
            if (!ancestor.getClassVariables().containsKey(name)) continue;
            ancestor.setClassVariable(currentNode, name, value);
            return;
        }
        module.setClassVariable(currentNode, name, value);
    }

    public static boolean isMethodPrivateFromName(String name) {
        CompilerAsserts.neverPartOfCompilation();
        return name.equals("initialize") || name.equals("initialize_copy") || name.equals("initialize_clone") || name.equals("initialize_dup") || name.equals("respond_to_missing?");
    }
}

