/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class AbstractGeneralSuperCallNode
extends RubyNode {
    @Node.Child
    protected MetaClassNode metaClassNode;
    @Node.Child
    protected DirectCallNode callNode;
    @CompilerDirectives.CompilationFinal
    private InternalMethod currentMethod;
    @CompilerDirectives.CompilationFinal
    private RubyClass selfMetaClass;
    @CompilerDirectives.CompilationFinal
    private Assumption unmodifiedAssumption;
    @CompilerDirectives.CompilationFinal
    protected InternalMethod superMethod;

    public AbstractGeneralSuperCallNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
    }

    protected boolean guard(VirtualFrame frame, Object self) {
        InternalMethod method = RubyArguments.getMethod(frame.getArguments());
        return this.superMethod != null && method == this.currentMethod && this.metaClassNode.executeMetaClass(frame, self) == this.selfMetaClass && this.unmodifiedAssumption.isValid();
    }

    protected void lookup(VirtualFrame frame) {
        this.lookup(frame, false);
    }

    private void lookup(VirtualFrame frame, boolean checkIfDefined) {
        CompilerAsserts.neverPartOfCompilation();
        this.currentMethod = RubyArguments.getMethod(frame.getArguments());
        String name = this.currentMethod.getSharedMethodInfo().getName();
        RubyModule declaringModule = this.currentMethod.getDeclaringModule();
        this.selfMetaClass = this.getContext().getCoreLibrary().getMetaClass(RubyArguments.getSelf(frame.getArguments()));
        this.superMethod = ModuleOperations.lookupSuperMethod(declaringModule, name, this.selfMetaClass);
        if (this.superMethod == null || this.superMethod.isUndefined()) {
            this.superMethod = null;
            if (checkIfDefined) {
                return;
            }
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(String.format("super: no superclass method `%s'", name), name, this));
        }
        this.unmodifiedAssumption = declaringModule.getUnmodifiedAssumption();
        DirectCallNode newCallNode = Truffle.getRuntime().createDirectCallNode(this.superMethod.getCallTarget());
        if (this.callNode == null) {
            this.callNode = (DirectCallNode)this.insert((Node)newCallNode);
        } else {
            this.callNode.replace((Node)newCallNode);
        }
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        Object self = RubyArguments.getSelf(frame.getArguments());
        if (!this.guard(frame, self)) {
            this.lookup(frame, true);
        }
        if (this.superMethod == null) {
            return this.nil();
        }
        return this.createString("super");
    }
}

