/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.Ruby;
import org.jruby.RubyTime;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.time.ReadTimeZoneNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.RubyDateFormatter;

public abstract class TimePrimitiveNodes {

    @RubiniusPrimitive(name="time_utc_offset")
    public static abstract class TimeUTCOffsetPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeUTCOffsetPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object timeUTCOffset(org.jruby.truffle.runtime.core.RubyTime time) {
            Object offset = time.getOffset();
            if (offset != this.nil()) {
                return offset;
            }
            return time.getDateTime().getZone().getOffset(time.getDateTime().getMillis()) / 1000;
        }
    }

    @RubiniusPrimitive(name="time_env_zone")
    public static abstract class TimeEnvZonePrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeEnvZonePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object timeEnvZone(org.jruby.truffle.runtime.core.RubyTime time) {
            throw new UnsupportedOperationException("time_env_zone");
        }
    }

    @RubiniusPrimitive(name="time_set_nseconds")
    public static abstract class TimeSetNSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSetNSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long timeSetNSeconds(org.jruby.truffle.runtime.core.RubyTime time, int nanoseconds) {
            time.setDateTime(time.getDateTime().withMillisOfSecond(nanoseconds / 1000000));
            return nanoseconds;
        }
    }

    @RubiniusPrimitive(name="time_nseconds")
    public static abstract class TimeNSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeNSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long timeNSeconds(org.jruby.truffle.runtime.core.RubyTime time) {
            return (long)time.getDateTime().getMillisOfSecond() * 1000000L;
        }
    }

    @RubiniusPrimitive(name="time_s_from_array", needsSelf=true, lowerFixnumParameters={0, 6, 7})
    public static abstract class TimeSFromArrayPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSFromArrayPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArray(VirtualFrame frame, RubyClass timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset) {
            return this.buildTime(frame, timeClass, sec, min, hour, mday, month, year, nsec, isdst, fromutc, utcoffset);
        }

        @Specialization(guards={"!isInteger(sec) || !isInteger(nsec)"})
        public org.jruby.truffle.runtime.core.RubyTime timeSFromArrayFallback(VirtualFrame frame, RubyClass timeClass, Object sec, int min, int hour, int mday, int month, int year, Object nsec, int isdst, boolean fromutc, Object utcoffset) {
            return null;
        }

        private org.jruby.truffle.runtime.core.RubyTime buildTime(VirtualFrame frame, RubyClass timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset) {
            DateTimeZone zone;
            CompilerDirectives.transferToInterpreter();
            if (sec < 0 || sec > 59 || min < 0 || min > 59 || hour < 0 || hour > 23 || mday < 1 || mday > 31 || month < 1 || month > 12) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorOutOfRange(this));
            }
            if (fromutc) {
                zone = DateTimeZone.UTC;
            } else if (utcoffset == this.nil()) {
                String tz = DebugOperations.send(this.getContext(), this.getContext().getCoreLibrary().getENV(), "[]", null, this.createString("TZ")).toString();
                zone = RubyTime.getTimeZoneFromTZString((Ruby)this.getContext().getRuntime(), (String)tz);
            } else if (utcoffset instanceof Integer) {
                zone = DateTimeZone.forOffsetMillis((int)((Integer)utcoffset * 1000));
            } else if (utcoffset instanceof Long) {
                zone = DateTimeZone.forOffsetMillis((int)((int)((Long)utcoffset).longValue() * 1000));
            } else if (utcoffset instanceof RubyBasicObject) {
                int millis = TimeSFromArrayPrimitiveNode.cast(this.ruby(frame, "(offset * 1000).to_i", "offset", utcoffset));
                zone = DateTimeZone.forOffsetMillis((int)millis);
            } else {
                throw new UnsupportedOperationException(String.format("%s %s %s %s", isdst, fromutc, utcoffset, utcoffset.getClass()));
            }
            if (isdst == -1) {
                DateTime dateTime = new DateTime(year, month, mday, hour, min, sec, nsec / 1000000, zone);
                return new org.jruby.truffle.runtime.core.RubyTime(timeClass, dateTime, utcoffset);
            }
            throw new UnsupportedOperationException(String.format("%s %s %s %s", isdst, fromutc, utcoffset, utcoffset.getClass()));
        }

        private static int cast(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Long) {
                return (int)((Long)value).longValue();
            }
            throw new UnsupportedOperationException("Can't cast " + value.getClass());
        }
    }

    @RubiniusPrimitive(name="time_strftime")
    public static abstract class TimeStrftimePrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeStrftimePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject timeStrftime(org.jruby.truffle.runtime.core.RubyTime time, RubyString format) {
            RubyDateFormatter rdf = this.getContext().getRuntime().getCurrentContext().getRubyDateFormatter();
            return this.createString(rdf.formatToByteList(rdf.compilePattern(StringNodes.getByteList(format), false), time.getDateTime(), 0L, null));
        }
    }

    @RubiniusPrimitive(name="time_decompose")
    public static abstract class TimeDecomposePrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeDecomposePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject timeDecompose(org.jruby.truffle.runtime.core.RubyTime time) {
            DateTime dateTime = time.getDateTime();
            int sec = dateTime.getSecondOfMinute();
            int min = dateTime.getMinuteOfHour();
            int hour = dateTime.getHourOfDay();
            int day = dateTime.getDayOfMonth();
            int month = dateTime.getMonthOfYear();
            int year = dateTime.getYear();
            int wday = dateTime.getDayOfWeek();
            if (wday == 7) {
                wday = 0;
            }
            int yday = dateTime.getDayOfYear();
            boolean isdst = false;
            String envTimeZoneString = DebugOperations.send(this.getContext(), this.getContext().getCoreLibrary().getENV(), "[]", null, this.createString("TZ")).toString();
            String zoneString = RubyTime.zoneHelper((String)envTimeZoneString, (DateTime)dateTime, (boolean)false);
            RubyBasicObject zone = zoneString.matches(".*-\\d+") ? this.nil() : this.createString(zoneString);
            Object[] decomposed = new Object[]{sec, min, hour, day, month, year, wday, yday, false, zone};
            return this.createArray(decomposed, decomposed.length);
        }
    }

    @RubiniusPrimitive(name="time_useconds")
    public static abstract class TimeUSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeUSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long timeUSeconds(org.jruby.truffle.runtime.core.RubyTime time) {
            return (long)time.getDateTime().getMillisOfSecond() * 1000L;
        }
    }

    @RubiniusPrimitive(name="time_seconds")
    public static abstract class TimeSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long timeSeconds(org.jruby.truffle.runtime.core.RubyTime time) {
            return time.getDateTime().getMillis() / 1000L;
        }
    }

    @RubiniusPrimitive(name="time_s_specific", needsSelf=false, lowerFixnumParameters={1})
    public static abstract class TimeSSpecificPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadTimeZoneNode readTimeZoneNode;

        public TimeSSpecificPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readTimeZoneNode = new ReadTimeZoneNode(context, sourceSection);
        }

        @Specialization(guards={"isUTC", "isNil(offset)"})
        public org.jruby.truffle.runtime.core.RubyTime timeSSpecificUTC(long seconds, int nanoseconds, boolean isUTC, Object offset) {
            long milliseconds = this.getMillis(seconds, nanoseconds);
            return new org.jruby.truffle.runtime.core.RubyTime(this.getContext().getCoreLibrary().getTimeClass(), this.time(milliseconds), this.nil());
        }

        @Specialization(guards={"!isUTC", "isNil(offset)"})
        public org.jruby.truffle.runtime.core.RubyTime timeSSpecific(VirtualFrame frame, long seconds, int nanoseconds, boolean isUTC, Object offset) {
            long milliseconds = this.getMillis(seconds, nanoseconds);
            return new org.jruby.truffle.runtime.core.RubyTime(this.getContext().getCoreLibrary().getTimeClass(), this.localtime(milliseconds, this.readTimeZoneNode.executeRubyString(frame)), offset);
        }

        private long getMillis(long seconds, int nanoseconds) {
            try {
                return ExactMath.addExact((long)ExactMath.multiplyExact((long)seconds, (long)1000L), (long)(nanoseconds / 1000000));
            }
            catch (ArithmeticException e) {
                CompilerDirectives.transferToInterpreter();
                String message = String.format("UNIX epoch + %d seconds out of range for Time (Joda-Time limitation)", seconds);
                throw new RaiseException(this.getContext().getCoreLibrary().rangeError(message, (Node)this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime time(long milliseconds) {
            return new DateTime(milliseconds, DateTimeZone.UTC);
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime localtime(long milliseconds, RubyString timeZone) {
            return new DateTime(milliseconds, RubyTime.getTimeZoneFromTZString((Ruby)this.getContext().getRuntime(), (String)timeZone.toString()));
        }
    }

    @RubiniusPrimitive(name="time_s_dup", needsSelf=false)
    public static abstract class TimeSDupPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSDupPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSDup(org.jruby.truffle.runtime.core.RubyTime other) {
            org.jruby.truffle.runtime.core.RubyTime time = new org.jruby.truffle.runtime.core.RubyTime(this.getContext().getCoreLibrary().getTimeClass(), other.getDateTime(), other.getOffset());
            return time;
        }
    }

    @RubiniusPrimitive(name="time_s_now")
    public static abstract class TimeSNowPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadTimeZoneNode readTimeZoneNode;

        public TimeSNowPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readTimeZoneNode = new ReadTimeZoneNode(context, sourceSection);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyTime timeSNow(VirtualFrame frame, RubyClass timeClass) {
            return new org.jruby.truffle.runtime.core.RubyTime(timeClass, this.now(this.readTimeZoneNode.executeRubyString(frame)), this.nil());
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime now(RubyString timeZone) {
            return DateTime.now((DateTimeZone)RubyTime.getTimeZoneFromTZString((Ruby)this.getContext().getRuntime(), (String)timeZone.toString()));
        }
    }
}

