/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.source.SourceSection;
import jnr.posix.FileStat;
import org.jruby.RubyEncoding;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyString;

public abstract class StatPrimitiveNodes {
    public static final HiddenKey STAT_IDENTIFIER = new HiddenKey("stat");

    @RubiniusPrimitive(name="stat_uid")
    public static abstract class StatUIDPrimitiveNode
    extends StatReadPrimitiveNode {
        public StatUIDPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int uid(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).uid();
        }
    }

    @RubiniusPrimitive(name="stat_gid")
    public static abstract class StatGIDPrimitiveNode
    extends StatReadPrimitiveNode {
        public StatGIDPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int gid(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).gid();
        }
    }

    @RubiniusPrimitive(name="stat_mode")
    public static abstract class StatModePrimitiveNode
    extends StatReadPrimitiveNode {
        public StatModePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int mode(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).mode();
        }
    }

    @RubiniusPrimitive(name="stat_size")
    public static abstract class StatSizePrimitiveNode
    extends StatReadPrimitiveNode {
        public StatSizePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long size(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).st_size();
        }
    }

    public static abstract class StatReadPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadHeadObjectFieldNode readStatNode = new ReadHeadObjectFieldNode(STAT_IDENTIFIER);

        public StatReadPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FileStat getStat(RubyBasicObject rubyStat) {
            return (FileStat)this.readStatNode.execute(rubyStat);
        }
    }

    @RubiniusPrimitive(name="stat_lstat")
    public static abstract class StatLStatPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeStatNode = new WriteHeadObjectFieldNode(STAT_IDENTIFIER);

        public StatLStatPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int lstat(RubyBasicObject rubyStat, RubyString path) {
            FileStat stat = this.posix().allocateStat();
            int code = this.posix().lstat(path.toString(), stat);
            if (code == 0) {
                this.writeStatNode.execute(rubyStat, stat);
            }
            return code;
        }

        @Specialization(guards={"!isRubyString(path)"})
        public Object stat(RubyBasicObject rubyStat, Object path) {
            return null;
        }
    }

    @RubiniusPrimitive(name="stat_fstat")
    public static abstract class StatFStatPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeStatNode = new WriteHeadObjectFieldNode(STAT_IDENTIFIER);

        public StatFStatPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int fstat(RubyBasicObject rubyStat, int fd) {
            FileStat stat = this.posix().allocateStat();
            int code = this.posix().fstat(fd, stat);
            if (code == 0) {
                this.writeStatNode.execute(rubyStat, stat);
            }
            return code;
        }
    }

    @RubiniusPrimitive(name="stat_stat")
    public static abstract class StatStatPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeStatNode = new WriteHeadObjectFieldNode(STAT_IDENTIFIER);

        public StatStatPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int stat(RubyBasicObject rubyStat, RubyString path) {
            FileStat stat = this.posix().allocateStat();
            String pathString = RubyEncoding.decodeUTF8((byte[])StringNodes.getByteList(path).getUnsafeBytes(), (int)StringNodes.getByteList(path).getBegin(), (int)StringNodes.getByteList(path).getRealSize());
            int code = this.posix().stat(pathString, stat);
            if (code == 0) {
                this.writeStatNode.execute(rubyStat, stat);
            }
            return code;
        }

        @Specialization(guards={"!isRubyString(path)"})
        public Object stat(RubyBasicObject rubyStat, Object path) {
            return null;
        }
    }

    @RubiniusPrimitive(name="stat_ino")
    public static abstract class StatInoPrimitiveNode
    extends StatReadPrimitiveNode {
        public StatInoPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long ino(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).ino();
        }
    }

    @RubiniusPrimitive(name="stat_dev")
    public static abstract class StatDevPrimitiveNode
    extends StatReadPrimitiveNode {
        public StatDevPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long dev(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).dev();
        }
    }

    @RubiniusPrimitive(name="stat_blocks")
    public static abstract class StatBlocksPrimitiveNode
    extends StatReadPrimitiveNode {
        public StatBlocksPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long blocks(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).blocks();
        }
    }

    @RubiniusPrimitive(name="stat_blksize")
    public static abstract class StatBlksizePrimitiveNode
    extends StatReadPrimitiveNode {
        public StatBlksizePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long blksize(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).blockSize();
        }
    }

    @RubiniusPrimitive(name="stat_rdev")
    public static abstract class RdevPrimitiveNode
    extends StatReadPrimitiveNode {
        public RdevPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long rdev(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).rdev();
        }
    }

    @RubiniusPrimitive(name="stat_nlink")
    public static abstract class NlinkPrimitiveNode
    extends StatReadPrimitiveNode {
        public NlinkPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int nlink(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).nlink();
        }
    }

    @RubiniusPrimitive(name="stat_mtime")
    public static abstract class StatMtimePrimitiveNode
    extends StatReadPrimitiveNode {
        public StatMtimePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object mtime(VirtualFrame frame, RubyBasicObject rubyStat) {
            long time = this.getStat(rubyStat).mtime();
            return this.ruby(frame, "Time.at(time)", "time", time);
        }
    }

    @RubiniusPrimitive(name="stat_ctime")
    public static abstract class StatCtimePrimitiveNode
    extends StatReadPrimitiveNode {
        public StatCtimePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object ctime(VirtualFrame frame, RubyBasicObject rubyStat) {
            long time = this.getStat(rubyStat).ctime();
            return this.ruby(frame, "Time.at(time)", "time", time);
        }
    }

    @RubiniusPrimitive(name="stat_atime")
    public static abstract class StatAtimePrimitiveNode
    extends StatReadPrimitiveNode {
        public StatAtimePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object atime(VirtualFrame frame, RubyBasicObject rubyStat) {
            long time = this.getStat(rubyStat).atime();
            return this.ruby(frame, "Time.at(time)", "time", time);
        }
    }
}

