/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import jnr.constants.platform.Errno;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyString;

public abstract class DirPrimitiveNodes {
    private static final HiddenKey contentsKey = new HiddenKey("contents");
    private static final HiddenKey positionKey = new HiddenKey("position");

    static /* synthetic */ HiddenKey access$000() {
        return contentsKey;
    }

    static /* synthetic */ HiddenKey access$100() {
        return positionKey;
    }

    @RubiniusPrimitive(name="dir_close")
    public static abstract class DirClosePrimitiveNode
    extends RubiniusPrimitiveNode {
        public DirClosePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject open(RubyBasicObject dir) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="dir_control")
    public static abstract class DirControlPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadHeadObjectFieldNode readPositionNode = new ReadHeadObjectFieldNode(DirPrimitiveNodes.access$100());
        @Node.Child
        private WriteHeadObjectFieldNode writePositionNode = new WriteHeadObjectFieldNode(DirPrimitiveNodes.access$100());

        public DirControlPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object control(RubyBasicObject dir, int kind, int position) {
            switch (kind) {
                case 0: {
                    this.writePositionNode.execute(dir, position);
                    return true;
                }
                case 1: {
                    this.writePositionNode.execute(dir, -2);
                    return true;
                }
                case 2: {
                    try {
                        return this.readPositionNode.executeInteger(dir);
                    }
                    catch (UnexpectedResultException e) {
                        throw new IllegalStateException();
                    }
                }
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="dir_read")
    public static abstract class DirReadPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadHeadObjectFieldNode readContentsNode = new ReadHeadObjectFieldNode(DirPrimitiveNodes.access$000());
        @Node.Child
        private ReadHeadObjectFieldNode readPositionNode = new ReadHeadObjectFieldNode(DirPrimitiveNodes.access$100());
        @Node.Child
        private WriteHeadObjectFieldNode writePositionNode = new WriteHeadObjectFieldNode(DirPrimitiveNodes.access$100());

        public DirReadPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object read(RubyBasicObject dir) {
            int position;
            try {
                position = this.readPositionNode.executeInteger(dir);
            }
            catch (UnexpectedResultException e) {
                throw new IllegalStateException();
            }
            this.writePositionNode.execute(dir, position + 1);
            if (position == -2) {
                return this.createString(".");
            }
            if (position == -1) {
                return this.createString("..");
            }
            String[] contents = (String[])this.readContentsNode.execute(dir);
            if (position < contents.length) {
                return this.createString(contents[position]);
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="dir_open")
    public static abstract class DirOpenPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeContentsNode = new WriteHeadObjectFieldNode(DirPrimitiveNodes.access$000());
        @Node.Child
        private WriteHeadObjectFieldNode writePositionNode = new WriteHeadObjectFieldNode(DirPrimitiveNodes.access$100());

        public DirOpenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(encoding)"})
        public RubyBasicObject open(RubyBasicObject dir, RubyString path, RubyBasicObject encoding) {
            File file = new File(path.toString());
            if (!file.isDirectory()) {
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(Errno.ENOTDIR.intValue(), this));
            }
            String[] contents = file.list();
            if (contents == null) {
                throw new UnsupportedOperationException();
            }
            this.writeContentsNode.execute(dir, contents);
            this.writePositionNode.execute(dir, -2);
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject open(RubyBasicObject dir, RubyString path, RubyEncoding encoding) {
            return this.open(dir, path, this.nil());
        }
    }

    @RubiniusPrimitive(name="dir_allocate")
    public static abstract class DirAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public DirAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject allocate(RubyClass dirClass) {
            return new RubyBasicObject(dirClass);
        }
    }
}

