/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.util.ByteList;

public class StringLiteralNode
extends RubyNode {
    private final ByteList bytes;
    private final int codeRange;

    public StringLiteralNode(RubyContext context, SourceSection sourceSection, ByteList bytes, int codeRange) {
        super(context, sourceSection);
        assert (bytes != null);
        this.bytes = bytes;
        this.codeRange = codeRange;
    }

    @Override
    public RubyBasicObject execute(VirtualFrame frame) {
        RubyBasicObject string = this.createString(this.bytes.dup());
        StringNodes.setCodeRange(string, this.codeRange);
        return string;
    }
}

