/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.OptionalKeywordArgMissingNode;
import org.jruby.truffle.nodes.arguments.UnknownArgumentErrorNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.cast.ProcOrNullNode;
import org.jruby.truffle.nodes.cast.ProcOrNullNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.hash.HashLiteralNode;
import org.jruby.truffle.nodes.dispatch.CachedBoxedDispatchNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.nodes.methods.MarkerNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class RubyCallNode
extends RubyNode {
    private final String methodName;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private ProcOrNullNode block;
    @Node.Children
    private final RubyNode[] arguments;
    @Node.Children
    private final RubyNode[] keywordOptimizedArguments;
    @CompilerDirectives.CompilationFinal
    private int keywordOptimizedArgumentsLength;
    private final boolean isSplatted;
    private final boolean isVCall;
    @Node.Child
    private CallDispatchHeadNode dispatchHead;
    @CompilerDirectives.CompilationFinal
    private boolean seenNullInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenIntegerFixnumInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenLongFixnumInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenFloatInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenObjectInUnsplat = false;
    @Node.Child
    private CallDispatchHeadNode respondToMissing;
    @Node.Child
    private BooleanCastNode respondToMissingCast;
    private final boolean ignoreVisibility;
    @CompilerDirectives.CompilationFinal
    private boolean cannotOptimize;

    public RubyCallNode(RubyContext context, SourceSection section, String methodName, RubyNode receiver, RubyNode block, boolean isSplatted, RubyNode ... arguments) {
        this(context, section, methodName, receiver, block, isSplatted, false, arguments);
    }

    public RubyCallNode(RubyContext context, SourceSection section, String methodName, RubyNode receiver, RubyNode block, boolean isSplatted, boolean ignoreVisibility, RubyNode ... arguments) {
        this(context, section, methodName, receiver, block, isSplatted, ignoreVisibility, false, arguments);
    }

    public RubyCallNode(RubyContext context, SourceSection section, String methodName, RubyNode receiver, RubyNode block, boolean isSplatted, boolean ignoreVisibility, boolean isVCall, RubyNode ... arguments) {
        super(context, section);
        this.methodName = methodName;
        this.receiver = receiver;
        this.block = block == null ? null : ProcOrNullNodeGen.create(context, section, block);
        this.arguments = arguments;
        this.isSplatted = isSplatted;
        this.isVCall = isVCall;
        this.dispatchHead = DispatchHeadNodeFactory.createMethodCall(context, ignoreVisibility);
        this.respondToMissing = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        this.respondToMissingCast = BooleanCastNodeGen.create(context, section, null);
        this.ignoreVisibility = ignoreVisibility;
        this.keywordOptimizedArguments = new RubyNode[arguments.length + 32];
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] argumentsObjects;
        Object receiverObject = this.receiver.execute(frame);
        if (this.dispatchHead.getFirstDispatchNode().couldOptimizeKeywordArguments() && !this.cannotOptimize) {
            CachedBoxedDispatchNode dispatchNode = (CachedBoxedDispatchNode)this.dispatchHead.getFirstDispatchNode();
            if (this.keywordOptimizedArguments[0] == null) {
                CompilerDirectives.transferToInterpreter();
                System.err.println("optimizing for keyword arguments!");
                RubyNode[] optimized = this.expandedArgumentNodes(dispatchNode.getMethod(), this.arguments, this.isSplatted);
                if (optimized == null || optimized.length > this.keywordOptimizedArguments.length) {
                    System.err.println("couldn't optimize :(");
                    this.cannotOptimize = true;
                } else {
                    this.keywordOptimizedArgumentsLength = optimized.length;
                    for (int n = 0; n < this.keywordOptimizedArgumentsLength; ++n) {
                        this.keywordOptimizedArguments[n] = (RubyNode)this.insert(NodeUtil.cloneNode((Node)optimized[n]));
                    }
                }
            }
            argumentsObjects = dispatchNode.guard(this.methodName, receiverObject) && dispatchNode.getUnmodifiedAssumption().isValid() ? this.executeKeywordOptimizedArguments(frame) : this.executeArguments(frame);
        } else {
            argumentsObjects = this.executeArguments(frame);
        }
        RubyProc blockObject = this.executeBlock(frame);
        return this.dispatchHead.call(frame, receiverObject, this.methodName, blockObject, argumentsObjects);
    }

    private RubyProc executeBlock(VirtualFrame frame) {
        if (this.block != null) {
            return this.block.executeRubyProc(frame);
        }
        return null;
    }

    @ExplodeLoop
    private Object[] executeArguments(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        if (this.isSplatted) {
            return this.splat(argumentsObjects[0]);
        }
        return argumentsObjects;
    }

    @ExplodeLoop
    private Object[] executeKeywordOptimizedArguments(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.keywordOptimizedArgumentsLength];
        for (int i = 0; i < this.keywordOptimizedArgumentsLength; ++i) {
            argumentsObjects[i] = this.keywordOptimizedArguments[i].execute(frame);
        }
        if (this.isSplatted) {
            return this.splat(argumentsObjects[0]);
        }
        return argumentsObjects;
    }

    private Object[] splat(Object argument) {
        if (!(argument instanceof RubyArray)) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException(argument.toString());
        }
        RubyArray array = (RubyArray)argument;
        int size = ArrayNodes.getSize(array);
        Object store = ArrayNodes.getStore(array);
        if (this.seenNullInUnsplat && store == null) {
            return new Object[0];
        }
        if (this.seenIntegerFixnumInUnsplat && store instanceof int[]) {
            return ArrayUtils.boxUntil((int[])store, size);
        }
        if (this.seenLongFixnumInUnsplat && store instanceof long[]) {
            return ArrayUtils.boxUntil((long[])store, size);
        }
        if (this.seenFloatInUnsplat && store instanceof double[]) {
            return ArrayUtils.boxUntil((double[])store, size);
        }
        if (this.seenObjectInUnsplat && store instanceof Object[]) {
            return ArrayUtils.extractRange((Object[])store, 0, size);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (store == null) {
            this.seenNullInUnsplat = true;
            return new Object[0];
        }
        if (store instanceof int[]) {
            this.seenIntegerFixnumInUnsplat = true;
            return ArrayUtils.boxUntil((int[])store, size);
        }
        if (store instanceof long[]) {
            this.seenLongFixnumInUnsplat = true;
            return ArrayUtils.boxUntil((long[])store, size);
        }
        if (store instanceof double[]) {
            this.seenFloatInUnsplat = true;
            return ArrayUtils.boxUntil((double[])store, size);
        }
        if (store instanceof Object[]) {
            this.seenObjectInUnsplat = true;
            return ArrayUtils.extractRange((Object[])store, 0, size);
        }
        throw new UnsupportedOperationException();
    }

    public RubyNode[] expandedArgumentNodes(InternalMethod method, RubyNode[] argumentNodes, boolean isSplatted) {
        RubyNode[] result;
        boolean shouldExpand = true;
        if (method == null || method.getSharedMethodInfo().getArity().getKeywordArguments() == null) {
            shouldExpand = false;
        } else if (argumentNodes.length != 0 && !(argumentNodes[argumentNodes.length - 1] instanceof HashLiteralNode)) {
            shouldExpand = false;
        } else if (method.getSharedMethodInfo().getArity() == null || method.getSharedMethodInfo().getArity().getRequired() >= argumentNodes.length) {
            shouldExpand = false;
        } else if (isSplatted || method.getSharedMethodInfo().getArity().allowsMore()) {
            shouldExpand = false;
        }
        if (shouldExpand) {
            String label;
            int i;
            List<String> kwargs = method.getSharedMethodInfo().getArity().getKeywordArguments();
            int countArgNodes = argumentNodes.length + kwargs.size() + 1;
            if (argumentNodes.length == 0) {
                ++countArgNodes;
            }
            result = new RubyNode[countArgNodes];
            for (i = 0; i < argumentNodes.length - 1; ++i) {
                result[i] = argumentNodes[i];
            }
            int firstMarker = i++;
            result[firstMarker] = new MarkerNode(this.getContext(), null);
            HashLiteralNode hashNode = argumentNodes.length > 0 ? (HashLiteralNode)argumentNodes[argumentNodes.length - 1] : HashLiteralNode.create(this.getContext(), null, new RubyNode[0]);
            ArrayList<String> restKeywordLabels = new ArrayList<String>();
            for (int j = 0; j < hashNode.size(); ++j) {
                boolean keyIsSymbol;
                RubyNode key = hashNode.getKey(j);
                boolean bl = keyIsSymbol = key instanceof LiteralNode && ((LiteralNode)key).getObject() instanceof RubySymbol;
                if (!keyIsSymbol) {
                    this.cannotOptimize = true;
                    return null;
                }
                label = ((LiteralNode)hashNode.getKey(j)).getObject().toString();
                restKeywordLabels.add(label);
            }
            for (String kwarg : kwargs) {
                result[i] = new OptionalKeywordArgMissingNode(this.getContext(), null);
                for (int j = 0; j < hashNode.size(); ++j) {
                    label = ((LiteralNode)hashNode.getKey(j)).getObject().toString();
                    if (!label.equals(kwarg)) continue;
                    result[i] = hashNode.getValue(j);
                    restKeywordLabels.remove(label);
                    break;
                }
                ++i;
            }
            result[i++] = new MarkerNode(this.getContext(), null);
            if (restKeywordLabels.size() > 0 && !method.getSharedMethodInfo().getArity().hasKeyRest()) {
                result[firstMarker] = new UnknownArgumentErrorNode(this.getContext(), null, (String)restKeywordLabels.get(0));
            } else if (restKeywordLabels.size() > 0) {
                i = 0;
                RubyNode[] keyValues = new RubyNode[2 * restKeywordLabels.size()];
                for (String label2 : restKeywordLabels) {
                    for (int j = 0; j < hashNode.size(); ++j) {
                        String argLabel = ((LiteralNode)hashNode.getKey(j)).getObject().toString();
                        if (!argLabel.equals(label2)) continue;
                        keyValues[i++] = hashNode.getKey(j);
                        keyValues[i++] = hashNode.getValue(j);
                    }
                }
                HashLiteralNode restHash = HashLiteralNode.create(this.getContext(), null, keyValues);
                result[firstMarker] = restHash;
            }
        } else {
            this.cannotOptimize = true;
            result = null;
        }
        return result;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object receiverObject;
        CompilerDirectives.transferToInterpreter();
        if (this.receiver.isDefined(frame) == this.nil()) {
            return this.nil();
        }
        for (RubyNode argument : this.arguments) {
            if (argument.isDefined(frame) != this.nil()) continue;
            return this.nil();
        }
        RubyContext context = this.getContext();
        try {
            CompilerAsserts.neverPartOfCompilation();
            receiverObject = this.receiver.execute(frame);
        }
        catch (Exception e) {
            return this.nil();
        }
        InternalMethod method = ModuleOperations.lookupMethod(context.getCoreLibrary().getMetaClass(receiverObject), this.methodName);
        Object self = RubyArguments.getSelf(frame.getArguments());
        if (method == null) {
            Object r = this.respondToMissing.call(frame, receiverObject, "respond_to_missing?", null, this.createString(this.methodName));
            if (r != DispatchNode.MISSING && !this.respondToMissingCast.executeBoolean(frame, r)) {
                return this.nil();
            }
        } else {
            if (method.isUndefined()) {
                return this.nil();
            }
            if (!this.ignoreVisibility && !method.isVisibleTo(this, context.getCoreLibrary().getMetaClass(self))) {
                return this.nil();
            }
        }
        return this.createString("method");
    }

    public String getName() {
        return this.methodName;
    }

    public boolean isVCall() {
        return this.isVCall;
    }
}

