/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="requiredCapacity", type=RubyNode.class)})
public abstract class GeneralizeArrayNode
extends RubyNode {
    public GeneralizeArrayNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeGeneralize(VirtualFrame var1, RubyArray var2, int var3);

    @Specialization(guards={"isNullArray(array)"})
    public RubyBasicObject generalizeNull(RubyArray array, int requiredCapacity) {
        ArrayNodes.setStore(array, new Object[requiredCapacity], ArrayNodes.getSize(array));
        return array;
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject generalizeInt(RubyArray array, int requiredCapacity) {
        int[] intStore = (int[])ArrayNodes.getStore(array);
        ArrayNodes.setStore(array, ArrayUtils.boxExtra(intStore, requiredCapacity - intStore.length), ArrayNodes.getSize(array));
        return array;
    }

    @Specialization(guards={"isLongArray(array)"})
    public RubyBasicObject generalizeLong(RubyArray array, int requiredCapacity) {
        long[] intStore = (long[])ArrayNodes.getStore(array);
        ArrayNodes.setStore(array, ArrayUtils.boxExtra(intStore, requiredCapacity - intStore.length), ArrayNodes.getSize(array));
        return array;
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public RubyBasicObject generalizeDouble(RubyArray array, int requiredCapacity) {
        double[] intStore = (double[])ArrayNodes.getStore(array);
        ArrayNodes.setStore(array, ArrayUtils.boxExtra(intStore, requiredCapacity - intStore.length), ArrayNodes.getSize(array));
        return array;
    }
}

