/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.util.Arrays;
import java.util.Random;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.coerce.ToAryNodeGen;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.core.array.AppendManyNode;
import org.jruby.truffle.nodes.core.array.AppendManyNodeGen;
import org.jruby.truffle.nodes.core.array.AppendOneNode;
import org.jruby.truffle.nodes.core.array.AppendOneNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.array.ArrayCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodesFactory;
import org.jruby.truffle.nodes.core.array.ArrayReadDenormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayReadDenormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceDenormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceDenormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayWriteDenormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayWriteDenormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.PopOneNode;
import org.jruby.truffle.nodes.core.array.PopOneNodeGen;
import org.jruby.truffle.nodes.core.fixnum.FixnumLowerNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.locals.ReadDeclarationVariableNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeGen;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.pack.parser.PackParser;
import org.jruby.truffle.pack.runtime.PackResult;
import org.jruby.truffle.pack.runtime.exceptions.CantCompressNegativeException;
import org.jruby.truffle.pack.runtime.exceptions.CantConvertException;
import org.jruby.truffle.pack.runtime.exceptions.FormatException;
import org.jruby.truffle.pack.runtime.exceptions.NoImplicitConversionException;
import org.jruby.truffle.pack.runtime.exceptions.OutsideOfStringException;
import org.jruby.truffle.pack.runtime.exceptions.PackException;
import org.jruby.truffle.pack.runtime.exceptions.RangeException;
import org.jruby.truffle.pack.runtime.exceptions.TooFewArgumentsException;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.control.NextException;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.RedoException;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.CoreSourceSection;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.object.BasicObjectType;
import org.jruby.util.ByteList;
import org.jruby.util.Memo;
import org.jruby.util.cli.Options;

@CoreClass(name="Array")
public abstract class ArrayNodes {
    public static final int ARRAYS_SMALL = (Integer)Options.TRUFFLE_ARRAYS_SMALL.load();
    public static final boolean RANDOMIZE_STORAGE_ARRAY = (Boolean)Options.TRUFFLE_RANDOMIZE_STORAGE_ARRAY.load();
    private static final Random random = new Random(((Integer)Options.TRUFFLE_RANDOMIZE_SEED.load()).intValue());

    public static Object getStore(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return ((RubyArray)array).store;
    }

    public static void setStore(RubyBasicObject array, Object store, int size) {
        assert (RubyGuards.isRubyArray(array));
        assert (ArrayNodes.verifyStore(store, size));
        if (RANDOMIZE_STORAGE_ARRAY) {
            store = ArrayNodes.randomizeStorageStrategy(array.getContext(), store, size);
            assert (ArrayNodes.verifyStore(store, size));
        }
        ((RubyArray)array).store = store;
        ((RubyArray)array).size = size;
    }

    public static void setSize(RubyBasicObject array, int size) {
        assert (RubyGuards.isRubyArray(array));
        ((RubyArray)array).size = size;
    }

    public static int getSize(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return ((RubyArray)array).size;
    }

    public static RubyBasicObject fromObject(RubyClass arrayClass, Object object) {
        Object[] store = object instanceof Integer ? new int[]{(Integer)object} : (object instanceof Long ? (Object[])new long[]{(Long)object} : (object instanceof Double ? (Object[])new double[]{(Double)object} : (Object[])new Object[]{object}));
        return ArrayNodes.createGeneralArray(arrayClass, store, 1);
    }

    public static RubyBasicObject fromObjects(RubyClass arrayClass, Object ... objects) {
        return ArrayNodes.createGeneralArray(arrayClass, ArrayNodes.storeFromObjects(arrayClass.getContext(), objects), objects.length);
    }

    private static Object storeFromObjects(RubyContext context, Object ... objects) {
        int n;
        Object[] store;
        if (objects.length == 0) {
            return null;
        }
        boolean canUseInteger = true;
        boolean canUseLong = true;
        boolean canUseDouble = true;
        for (Object object : objects) {
            if (object instanceof Integer) {
                canUseDouble = false;
                continue;
            }
            if (object instanceof Long) {
                canUseInteger = canUseInteger && CoreLibrary.fitsIntoInteger((Long)object);
                canUseDouble = false;
                continue;
            }
            if (object instanceof Double) {
                canUseInteger = false;
                canUseLong = false;
                continue;
            }
            canUseInteger = false;
            canUseLong = false;
            canUseDouble = false;
        }
        if (canUseInteger) {
            store = new int[objects.length];
            for (n = 0; n < objects.length; ++n) {
                Object object = objects[n];
                if (object instanceof Integer) {
                    store[n] = (Integer)object;
                    continue;
                }
                if (object instanceof Long) {
                    store[n] = (int)((Long)object).longValue();
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return store;
        }
        if (canUseLong) {
            store = new long[objects.length];
            for (n = 0; n < objects.length; ++n) {
                Object object = objects[n];
                if (object instanceof Integer) {
                    store[n] = (int)((long)((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Long) {
                    store[n] = (int)((Long)object).longValue();
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return store;
        }
        if (canUseDouble) {
            store = new double[objects.length];
            for (n = 0; n < objects.length; ++n) {
                store[n] = (int)CoreLibrary.toDouble(objects[n], context.getCoreLibrary().getNilObject());
            }
            return store;
        }
        return objects;
    }

    public static int normalizeIndex(int length, int index) {
        if (CompilerDirectives.injectBranchProbability((double)0.25, (index < 0 ? 1 : 0) != 0)) {
            return length + index;
        }
        return index;
    }

    public static int clampExclusiveIndex(int length, int index) {
        if (index < 0) {
            return 0;
        }
        if (index > length) {
            return length;
        }
        return index;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object randomizeStorageStrategy(RubyContext context, Object store, int size) {
        if (size == 0) {
            switch (random.nextInt(5)) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new int[0];
                }
                case 2: {
                    return new long[0];
                }
                case 3: {
                    return new double[0];
                }
                case 4: {
                    return new Object[0];
                }
            }
            throw new IllegalStateException();
        }
        Object[] boxedStore = ArrayUtils.box(store);
        Object canonicalStore = ArrayNodes.storeFromObjects(context, boxedStore);
        if (canonicalStore instanceof int[]) {
            switch (random.nextInt(3)) {
                case 0: {
                    return boxedStore;
                }
                case 1: {
                    return ArrayUtils.longCopyOf((int[])canonicalStore);
                }
                case 2: {
                    return canonicalStore;
                }
            }
            throw new IllegalStateException();
        }
        if (canonicalStore instanceof long[]) {
            if (random.nextBoolean()) {
                return boxedStore;
            }
            return canonicalStore;
        }
        if (canonicalStore instanceof double[]) {
            if (random.nextBoolean()) {
                return boxedStore;
            }
            return canonicalStore;
        }
        if (canonicalStore instanceof Object[]) {
            return canonicalStore;
        }
        throw new UnsupportedOperationException();
    }

    public static Object[] slowToArray(RubyBasicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return ArrayUtils.boxUntil(ArrayNodes.getStore(array), ArrayNodes.getSize(array));
    }

    public static void slowUnshift(RubyBasicObject array, Object ... values) {
        assert (RubyGuards.isRubyArray(array));
        Object[] newStore = new Object[ArrayNodes.getSize(array) + values.length];
        System.arraycopy(values, 0, newStore, 0, values.length);
        ArrayUtils.copy(ArrayNodes.getStore(array), newStore, values.length, ArrayNodes.getSize(array));
        ArrayNodes.setStore(array, newStore, newStore.length);
    }

    public static void slowPush(RubyBasicObject array, Object value) {
        assert (RubyGuards.isRubyArray(array));
        ArrayNodes.setStore(array, Arrays.copyOf(ArrayUtils.box(ArrayNodes.getStore(array)), ArrayNodes.getSize(array) + 1), ArrayNodes.getSize(array));
        ((Object[])ArrayNodes.getStore((RubyBasicObject)array))[ArrayNodes.getSize((RubyBasicObject)array)] = value;
        ArrayNodes.setSize(array, ArrayNodes.getSize(array) + 1);
    }

    public static int normalizeIndex(RubyBasicObject array, int index) {
        assert (RubyGuards.isRubyArray(array));
        return ArrayNodes.normalizeIndex(ArrayNodes.getSize(array), index);
    }

    public static int clampExclusiveIndex(RubyBasicObject array, int index) {
        assert (RubyGuards.isRubyArray(array));
        return ArrayNodes.clampExclusiveIndex(ArrayNodes.getSize(array), index);
    }

    private static boolean verifyStore(Object store, int size) {
        assert (size >= 0);
        assert (store == null || store instanceof Object[] || store instanceof int[] || store instanceof long[] || store instanceof double[]);
        assert (!(store instanceof Object[]) || size <= ((Object[])store).length);
        assert (!(store instanceof int[]) || size <= ((int[])store).length);
        assert (!(store instanceof long[]) || size <= ((long[])store).length);
        assert (!(store instanceof double[]) || size <= ((double[])store).length);
        if (store instanceof Object[]) {
            for (int n = 0; n < size; ++n) {
                assert (((Object[])store)[n] != null) : String.format("array of size %s had null at %d", size, n);
            }
        }
        return true;
    }

    public static RubyBasicObject createEmptyArray(RubyClass arrayClass) {
        return ArrayNodes.createGeneralArray(arrayClass, null, 0);
    }

    public static RubyBasicObject createArray(RubyClass arrayClass, int[] store, int size) {
        return ArrayNodes.createGeneralArray(arrayClass, store, size);
    }

    public static RubyBasicObject createArray(RubyClass arrayClass, long[] store, int size) {
        return ArrayNodes.createGeneralArray(arrayClass, store, size);
    }

    public static RubyBasicObject createArray(RubyClass arrayClass, double[] store, int size) {
        return ArrayNodes.createGeneralArray(arrayClass, store, size);
    }

    public static RubyBasicObject createArray(RubyClass arrayClass, Object[] store, int size) {
        return ArrayNodes.createGeneralArray(arrayClass, store, size);
    }

    public static RubyArray createGeneralArray(RubyClass arrayClass, Object store, int size) {
        return new RubyArray(arrayClass, store, size, RubyBasicObject.LAYOUT.newInstance(RubyBasicObject.EMPTY_SHAPE));
    }

    public static class ArrayAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return ArrayNodes.createEmptyArray(rubyClass);
        }
    }

    @CoreMethod(names={"zip"}, required=1, argumentsAsArray=true)
    public static abstract class ZipNode
    extends ArrayCoreMethodNode {
        public ZipNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isObjectArray(array)", "isSingleIntegerFixnumArray(others)"})
        public RubyBasicObject zipObjectIntegerFixnum(RubyArray array, Object[] others) {
            boolean areSameLength;
            RubyArray other = (RubyArray)others[0];
            Object[] a = (Object[])ArrayNodes.getStore(array);
            int[] b = (int[])ArrayNodes.getStore(other);
            int bLength = ArrayNodes.getSize(other);
            int zippedLength = ArrayNodes.getSize(array);
            Object[] zipped = new Object[zippedLength];
            boolean bl = areSameLength = bLength == zippedLength;
            if (areSameLength) {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = this.createArray(new Object[]{a[n], b[n]}, 2);
                }
            } else {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = n < bLength ? this.createArray(new Object[]{a[n], b[n]}, 2) : this.createArray(new Object[]{a[n], this.nil()}, 2);
                }
            }
            return this.createArray(zipped, zippedLength);
        }

        @Specialization(guards={"isObjectArray(array)", "isSingleObjectArray(others)"})
        public RubyBasicObject zipObjectObject(RubyArray array, Object[] others) {
            boolean areSameLength;
            RubyArray other = (RubyArray)others[0];
            Object[] a = (Object[])ArrayNodes.getStore(array);
            Object[] b = (Object[])ArrayNodes.getStore(other);
            int bLength = ArrayNodes.getSize(other);
            int zippedLength = ArrayNodes.getSize(array);
            Object[] zipped = new Object[zippedLength];
            boolean bl = areSameLength = bLength == zippedLength;
            if (areSameLength) {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = this.createArray(new Object[]{a[n], b[n]}, 2);
                }
            } else {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = n < bLength ? this.createArray(new Object[]{a[n], b[n]}, 2) : this.createArray(new Object[]{a[n], this.nil()}, 2);
                }
            }
            return this.createArray(zipped, zippedLength);
        }

        @Specialization(guards={"!isSingleObjectArray(others)"})
        public Object zipObjectObjectNotSingleObject(VirtualFrame frame, RubyArray array, Object[] others) {
            return this.zipRuby(frame, others);
        }

        @Specialization(guards={"!isSingleIntegerFixnumArray(others)"})
        public Object zipObjectObjectNotSingleInteger(VirtualFrame frame, RubyArray array, Object[] others) {
            return this.zipRuby(frame, others);
        }

        @Specialization(guards={"!isObjectArray(array)"})
        public Object zipObjectObjectNotObject(VirtualFrame frame, RubyArray array, Object[] others) {
            return this.zipRuby(frame, others);
        }

        private Object zipRuby(VirtualFrame frame, Object[] others) {
            RubyBasicObject proc = RubyArguments.getBlock(frame.getArguments());
            if (proc == null) {
                proc = this.nil();
            }
            return this.ruby(frame, "zip_internal(*others, &block)", "others", this.createArray(others, others.length), "block", proc);
        }

        protected static boolean isSingleIntegerFixnumArray(Object[] others) {
            return others.length == 1 && others[0] instanceof RubyArray && ArrayNodes.getStore((RubyArray)others[0]) instanceof int[];
        }

        protected static boolean isSingleObjectArray(Object[] others) {
            return others.length == 1 && others[0] instanceof RubyArray && ArrayNodes.getStore((RubyArray)others[0]) instanceof Object[];
        }
    }

    @CoreMethod(names={"unshift"}, argumentsAsArray=true, raiseIfFrozenSelf=true)
    public static abstract class UnshiftNode
    extends CoreMethodArrayArgumentsNode {
        public UnshiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject unshift(RubyArray array, Object ... args) {
            CompilerDirectives.transferToInterpreter();
            ArrayNodes.slowUnshift(array, args);
            return array;
        }
    }

    @CoreMethod(names={"sort"}, needsBlock=true)
    public static abstract class SortNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareDispatchNode;
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public SortNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareDispatchNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        @Specialization(guards={"isNullArray(array)"})
        public RubyBasicObject sortNull(RubyArray array, Object block) {
            return this.createEmptyArray();
        }

        @ExplodeLoop
        @Specialization(guards={"isIntArray(array)", "isSmall(array)"})
        public RubyBasicObject sortVeryShortIntegerFixnum(VirtualFrame frame, RubyArray array, NotProvided block) {
            int[] store = (int[])ArrayNodes.getStore(array);
            int[] newStore = new int[store.length];
            int size = ArrayNodes.getSize(array);
            for (int i = 0; i < ARRAYS_SMALL; ++i) {
                if (i >= size) continue;
                for (int j = i + 1; j < ARRAYS_SMALL; ++j) {
                    if (j >= size || this.castSortValue(this.compareDispatchNode.call(frame, store[j], "<=>", null, store[i])) >= 0) continue;
                    int temp = store[j];
                    store[j] = store[i];
                    store[i] = temp;
                }
                newStore[i] = store[i];
            }
            return this.createArray(newStore, size);
        }

        @ExplodeLoop
        @Specialization(guards={"isLongArray(array)", "isSmall(array)"})
        public RubyBasicObject sortVeryShortLongFixnum(VirtualFrame frame, RubyArray array, NotProvided block) {
            long[] store = (long[])ArrayNodes.getStore(array);
            long[] newStore = new long[store.length];
            int size = ArrayNodes.getSize(array);
            for (int i = 0; i < ARRAYS_SMALL; ++i) {
                if (i >= size) continue;
                for (int j = i + 1; j < ARRAYS_SMALL; ++j) {
                    if (j >= size || this.castSortValue(this.compareDispatchNode.call(frame, store[j], "<=>", null, store[i])) >= 0) continue;
                    long temp = store[j];
                    store[j] = store[i];
                    store[i] = temp;
                }
                newStore[i] = store[i];
            }
            return this.createArray(newStore, size);
        }

        @Specialization(guards={"isObjectArray(array)", "isSmall(array)"})
        public RubyBasicObject sortVeryShortObject(VirtualFrame frame, RubyArray array, NotProvided block) {
            Object[] oldStore = (Object[])ArrayNodes.getStore(array);
            Object[] store = Arrays.copyOf(oldStore, oldStore.length);
            int size = ArrayNodes.getSize(array);
            for (int i = 1; i < size; ++i) {
                Object x = store[i];
                for (int j = i; j > 0 && this.castSortValue(this.compareDispatchNode.call(frame, store[j - 1], "<=>", null, x)) > 0; --j) {
                    store[j] = store[j - 1];
                }
                store[j] = x;
            }
            return this.createArray(store, size);
        }

        @Specialization
        public Object sortUsingRubinius(VirtualFrame frame, RubyArray array, RubyProc block) {
            return this.sortUsingRubinius(frame, array, (Object)block);
        }

        @Specialization(guards={"!isNullArray(array)", "!isSmall(array)"})
        public Object sortUsingRubinius(VirtualFrame frame, RubyArray array, Object block) {
            if (block == NotProvided.INSTANCE) {
                return this.ruby(frame, "sorted = dup; Rubinius.privately { sorted.isort!(0, right) }; sorted", "right", ArrayNodes.getSize(array));
            }
            return this.ruby(frame, "sorted = dup; Rubinius.privately { sorted.isort_block!(0, right, block) }; sorted", "right", ArrayNodes.getSize(array), "block", block);
        }

        private int castSortValue(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("expecting a Fixnum to sort", this));
        }

        protected static boolean isSmall(RubyArray array) {
            return ArrayNodes.getSize(array) <= ARRAYS_SMALL;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends ArrayCoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size(RubyArray array) {
            return ArrayNodes.getSize(array);
        }
    }

    @CoreMethod(names={"shift"}, raiseIfFrozenSelf=true, optional=1)
    public static abstract class ShiftNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;

        public ShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeShift(VirtualFrame var1, RubyArray var2, Object var3);

        @Specialization(guards={"isEmptyArray(array)"})
        public Object shiftNil(VirtualFrame frame, RubyArray array, NotProvided n) {
            return this.nil();
        }

        @Specialization(guards={"isIntArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public int shiftIntegerFixnumInBounds(VirtualFrame frame, RubyArray array, NotProvided n) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int[] store = (int[])ArrayNodes.getStore(array);
            int value = store[0];
            System.arraycopy(store, 1, store, 0, ArrayNodes.getSize(array) - 1);
            int[] filler = new int[1];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - 1, 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"shiftIntegerFixnumInBounds"}, guards={"isIntArray(array)"})
        public Object shiftIntegerFixnum(VirtualFrame frame, RubyArray array, NotProvided n) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int[] store = (int[])ArrayNodes.getStore(array);
            int value = store[0];
            System.arraycopy(store, 1, store, 0, ArrayNodes.getSize(array) - 1);
            int[] filler = new int[1];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - 1, 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isLongArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public long shiftLongFixnumInBounds(VirtualFrame frame, RubyArray array, NotProvided n) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            long[] store = (long[])ArrayNodes.getStore(array);
            long value = store[0];
            System.arraycopy(store, 1, store, 0, ArrayNodes.getSize(array) - 1);
            long[] filler = new long[1];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - 1, 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"shiftLongFixnumInBounds"}, guards={"isLongArray(array)"})
        public Object shiftLongFixnum(VirtualFrame frame, RubyArray array, NotProvided n) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            long[] store = (long[])ArrayNodes.getStore(array);
            long value = store[0];
            System.arraycopy(store, 1, store, 0, ArrayNodes.getSize(array) - 1);
            long[] filler = new long[1];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - 1, 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isDoubleArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public double shiftFloatInBounds(VirtualFrame frame, RubyArray array, NotProvided n) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            double[] store = (double[])ArrayNodes.getStore(array);
            double value = store[0];
            System.arraycopy(store, 1, store, 0, ArrayNodes.getSize(array) - 1);
            double[] filler = new double[1];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - 1, 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"shiftFloatInBounds"}, guards={"isDoubleArray(array)"})
        public Object shiftFloat(VirtualFrame frame, RubyArray array, NotProvided n) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            double[] store = (double[])ArrayNodes.getStore(array);
            double value = store[0];
            System.arraycopy(store, 1, store, 0, ArrayNodes.getSize(array) - 1);
            double[] filler = new double[1];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - 1, 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object shiftObject(VirtualFrame frame, RubyArray array, NotProvided n) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            Object[] store = (Object[])ArrayNodes.getStore(array);
            Object value = store[0];
            System.arraycopy(store, 1, store, 0, ArrayNodes.getSize(array) - 1);
            Object[] filler = new Object[1];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - 1, 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isEmptyArray(array)", "wasProvided(object)"})
        public Object shiftNilWithNum(VirtualFrame frame, RubyArray array, Object object) {
            int n;
            if (object instanceof Integer && (Integer)object < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((n = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            return this.createEmptyArray();
        }

        @Specialization(guards={"isIntArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject popIntegerFixnumInBoundsWithNum(VirtualFrame frame, RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            int[] store = (int[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"popIntegerFixnumInBoundsWithNum"}, guards={"isIntArray(array)"})
        public Object popIntegerFixnumWithNum(VirtualFrame frame, RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            int[] store = (int[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isLongArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject shiftLongFixnumInBoundsWithNum(VirtualFrame frame, RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            long[] store = (long[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftLongFixnumInBoundsWithNum"}, guards={"isLongArray(array)"})
        public Object shiftLongFixnumWithNum(VirtualFrame frame, RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            long[] store = (long[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isDoubleArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject shiftFloatInBoundsWithNum(VirtualFrame frame, RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            double[] store = (double[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftFloatInBoundsWithNum"}, guards={"isDoubleArray(array)"})
        public Object shiftFloatWithNum(VirtualFrame frame, RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            double[] store = (double[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object shiftObjectWithNum(VirtualFrame frame, RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            Object[] filler = new Object[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isIntArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject shiftIntegerFixnumInBoundsWithNumObj(VirtualFrame frame, RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            int[] store = (int[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftIntegerFixnumInBoundsWithNumObj"}, guards={"isIntArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object shiftIntegerFixnumWithNumObj(VirtualFrame frame, RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            int[] store = (int[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isLongArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject shiftLongFixnumInBoundsWithNumObj(VirtualFrame frame, RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            long[] store = (long[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftLongFixnumInBoundsWithNumObj"}, guards={"isLongArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object shiftLongFixnumWithNumObj(VirtualFrame frame, RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            long[] store = (long[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isDoubleArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject shiftFloatInBoundsWithNumObj(VirtualFrame frame, RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            double[] store = (double[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, ArrayNodes.getSize(array) - numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftFloatInBoundsWithNumObj"}, guards={"isDoubleArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object shiftFloatWithNumObj(VirtualFrame frame, RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            double[] store = (double[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, ArrayNodes.getSize(array) - numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isObjectArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object shiftObjectWithNumObj(VirtualFrame frame, RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, 0, ArrayNodes.getSize(array) - numShift), numShift);
            Object[] filler = new Object[numShift];
            System.arraycopy(store, numShift, store, 0, ArrayNodes.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numShift, numShift);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numShift);
            return result;
        }
    }

    @CoreMethod(names={"select"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class SelectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public SelectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object selectNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return this.createEmptyArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)"})
        public Object selectObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])ArrayNodes.getStore(array);
            Object selectedStore = this.arrayBuilder.start(ArrayNodes.getSize(array));
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Object value = store[n];
                    if (!this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return ArrayNodes.createGeneralArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)"})
        public Object selectFixnumInteger(VirtualFrame frame, RubyArray array, RubyProc block) {
            int[] store = (int[])ArrayNodes.getStore(array);
            Object selectedStore = this.arrayBuilder.start(ArrayNodes.getSize(array));
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Integer value = store[n];
                    if (!this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return ArrayNodes.createGeneralArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ReplaceNode
    extends CoreMethodNode {
        public ReplaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToAry(RubyNode index) {
            return ToAryNodeGen.create(this.getContext(), this.getSourceSection(), index);
        }

        @Specialization(guards={"isNullArray(other)"})
        public RubyBasicObject replace(RubyArray array, RubyArray other) {
            CompilerDirectives.transferToInterpreter();
            ArrayNodes.setStore(array, null, 0);
            return array;
        }

        @Specialization(guards={"isIntArray(other)"})
        public RubyBasicObject replaceIntegerFixnum(RubyArray array, RubyArray other) {
            CompilerDirectives.transferToInterpreter();
            ArrayNodes.setStore(array, Arrays.copyOf((int[])ArrayNodes.getStore(other), ArrayNodes.getSize(other)), ArrayNodes.getSize(other));
            return array;
        }

        @Specialization(guards={"isLongArray(other)"})
        public RubyBasicObject replaceLongFixnum(RubyArray array, RubyArray other) {
            CompilerDirectives.transferToInterpreter();
            ArrayNodes.setStore(array, Arrays.copyOf((long[])ArrayNodes.getStore(other), ArrayNodes.getSize(other)), ArrayNodes.getSize(other));
            return array;
        }

        @Specialization(guards={"isDoubleArray(other)"})
        public RubyBasicObject replaceFloat(RubyArray array, RubyArray other) {
            CompilerDirectives.transferToInterpreter();
            ArrayNodes.setStore(array, Arrays.copyOf((double[])ArrayNodes.getStore(other), ArrayNodes.getSize(other)), ArrayNodes.getSize(other));
            return array;
        }

        @Specialization(guards={"isObjectArray(other)"})
        public RubyBasicObject replaceObject(RubyArray array, RubyArray other) {
            CompilerDirectives.transferToInterpreter();
            ArrayNodes.setStore(array, Arrays.copyOf((Object[])ArrayNodes.getStore(other), ArrayNodes.getSize(other)), ArrayNodes.getSize(other));
            return array;
        }
    }

    @CoreMethod(names={"reject!"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class RejectInPlaceNode
    extends YieldingCoreMethodNode {
        public RejectInPlaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object rejectInPlaceNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return this.nil();
        }

        @Specialization(guards={"isIntArray(array)"})
        public Object rejectInPlaceInt(VirtualFrame frame, RubyArray array, RubyProc block) {
            int n;
            int[] store = (int[])ArrayNodes.getStore(array);
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                int[] filler = new int[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                ArrayNodes.setStore(array, store, i);
                return array;
            }
            return this.nil();
        }

        @Specialization(guards={"isLongArray(array)"})
        public Object rejectInPlaceLong(VirtualFrame frame, RubyArray array, RubyProc block) {
            int n;
            long[] store = (long[])ArrayNodes.getStore(array);
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                long[] filler = new long[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                ArrayNodes.setStore(array, store, i);
                return array;
            }
            return this.nil();
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public Object rejectInPlaceDouble(VirtualFrame frame, RubyArray array, RubyProc block) {
            int n;
            double[] store = (double[])ArrayNodes.getStore(array);
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                double[] filler = new double[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                ArrayNodes.setStore(array, store, i);
                return array;
            }
            return this.nil();
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object rejectInPlaceObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            int n;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                Object[] filler = new Object[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                ArrayNodes.setStore(array, store, i);
                return array;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"delete_if"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class DeleteIfNode
    extends YieldingCoreMethodNode {
        public DeleteIfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object rejectInPlaceNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return array;
        }

        @Specialization(guards={"isIntArray(array)"})
        public Object rejectInPlaceInt(VirtualFrame frame, RubyArray array, RubyProc block) {
            int n;
            int[] store = (int[])ArrayNodes.getStore(array);
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                int[] filler = new int[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                ArrayNodes.setStore(array, store, i);
            }
            return array;
        }

        @Specialization(guards={"isLongArray(array)"})
        public Object rejectInPlaceLong(VirtualFrame frame, RubyArray array, RubyProc block) {
            int n;
            long[] store = (long[])ArrayNodes.getStore(array);
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                long[] filler = new long[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                ArrayNodes.setStore(array, store, i);
            }
            return array;
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public Object rejectInPlaceDouble(VirtualFrame frame, RubyArray array, RubyProc block) {
            int n;
            double[] store = (double[])ArrayNodes.getStore(array);
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                double[] filler = new double[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                ArrayNodes.setStore(array, store, i);
            }
            return array;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object rejectInPlaceObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            int n;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                Object[] filler = new Object[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                ArrayNodes.setStore(array, store, i);
            }
            return array;
        }
    }

    @CoreMethod(names={"reject"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class RejectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public RejectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object selectNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return this.createEmptyArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)"})
        public Object selectObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])ArrayNodes.getStore(array);
            Object selectedStore = this.arrayBuilder.start(ArrayNodes.getSize(array));
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Object value = store[n];
                    CompilerDirectives.transferToInterpreter();
                    if (this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return ArrayNodes.createGeneralArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)"})
        public Object selectFixnumInteger(VirtualFrame frame, RubyArray array, RubyProc block) {
            int[] store = (int[])ArrayNodes.getStore(array);
            Object selectedStore = this.arrayBuilder.start(ArrayNodes.getSize(array));
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Integer value = store[n];
                    CompilerDirectives.transferToInterpreter();
                    if (this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return ArrayNodes.createGeneralArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    public static abstract class PushOneNode
    extends ArrayCoreMethodNode {
        private final BranchProfile extendBranch = BranchProfile.create();

        public PushOneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public RubyBasicObject pushEmpty(RubyArray array, Object value) {
            ArrayNodes.setStore(array, new Object[]{value}, 1);
            return array;
        }

        @Specialization(guards={"isIntArray(array)"})
        public RubyBasicObject pushIntegerFixnumIntegerFixnum(RubyArray array, int value) {
            int oldSize = ArrayNodes.getSize(array);
            int newSize = oldSize + 1;
            int[] store = (int[])ArrayNodes.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                ArrayNodes.setStore(array, store, ArrayNodes.getSize(array));
            }
            store[oldSize] = value;
            ArrayNodes.setStore(array, store, newSize);
            return array;
        }

        @Specialization(guards={"isIntArray(array)", "!isInteger(value)"})
        public RubyBasicObject pushIntegerFixnumObject(RubyArray array, Object value) {
            Object[] newStore;
            int oldSize = ArrayNodes.getSize(array);
            int newSize = oldSize + 1;
            int[] oldStore = (int[])ArrayNodes.getStore(array);
            if (oldStore.length < newSize) {
                this.extendBranch.enter();
                newStore = ArrayUtils.boxExtra(oldStore, ArrayUtils.capacity(oldStore.length, newSize) - oldStore.length);
            } else {
                newStore = ArrayUtils.box(oldStore);
            }
            newStore[oldSize] = value;
            ArrayNodes.setStore(array, newStore, newSize);
            return array;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public RubyBasicObject pushObjectObject(RubyArray array, Object value) {
            int oldSize = ArrayNodes.getSize(array);
            int newSize = oldSize + 1;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                ArrayNodes.setStore(array, store, ArrayNodes.getSize(array));
            }
            store[oldSize] = value;
            ArrayNodes.setStore(array, store, newSize);
            return array;
        }
    }

    @CoreMethod(names={"push", "__append__"}, argumentsAsArray=true, raiseIfFrozenSelf=true)
    public static abstract class PushNode
    extends ArrayCoreMethodNode {
        private final BranchProfile extendBranch = BranchProfile.create();

        public PushNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)", "isSingleIntegerFixnum(array, values)"})
        public RubyBasicObject pushNullEmptySingleIntegerFixnum(RubyArray array, Object ... values) {
            ArrayNodes.setStore(array, new int[]{(Integer)values[0]}, 1);
            return array;
        }

        @Specialization(guards={"isNullArray(array)", "isSingleLongFixnum(array, values)"})
        public RubyBasicObject pushNullEmptySingleIntegerLong(RubyArray array, Object ... values) {
            ArrayNodes.setStore(array, new long[]{(Long)values[0]}, 1);
            return array;
        }

        @Specialization(guards={"isNullArray(array)"})
        public RubyBasicObject pushNullEmptyObjects(RubyArray array, Object ... values) {
            ArrayNodes.setStore(array, values, values.length);
            return array;
        }

        @Specialization(guards={"!isNullArray(array)", "isEmptyArray(array)"})
        public RubyBasicObject pushEmptySingleIntegerFixnum(RubyArray array, Object ... values) {
            ArrayNodes.setStore(array, values, values.length);
            return array;
        }

        @Specialization(guards={"isIntArray(array)", "isSingleIntegerFixnum(array, values)"})
        public RubyBasicObject pushIntegerFixnumSingleIntegerFixnum(RubyArray array, Object ... values) {
            int oldSize = ArrayNodes.getSize(array);
            int newSize = oldSize + 1;
            int[] store = (int[])ArrayNodes.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            store[oldSize] = (Integer)values[0];
            ArrayNodes.setStore(array, store, newSize);
            return array;
        }

        @Specialization(guards={"isIntArray(array)", "!isSingleIntegerFixnum(array, values)", "!isSingleLongFixnum(array, values)"})
        public RubyBasicObject pushIntegerFixnum(RubyArray array, Object ... values) {
            Object[] store;
            int oldSize = ArrayNodes.getSize(array);
            int newSize = oldSize + values.length;
            int[] oldStore = (int[])ArrayNodes.getStore(array);
            if (oldStore.length < newSize) {
                this.extendBranch.enter();
                store = ArrayUtils.boxExtra(oldStore, ArrayUtils.capacity(oldStore.length, newSize) - oldStore.length);
            } else {
                store = ArrayUtils.box(oldStore);
            }
            for (int n = 0; n < values.length; ++n) {
                store[oldSize + n] = values[n];
            }
            ArrayNodes.setStore(array, store, newSize);
            return array;
        }

        @Specialization(guards={"isLongArray(array)", "isSingleIntegerFixnum(array, values)"})
        public RubyBasicObject pushLongFixnumSingleIntegerFixnum(RubyArray array, Object ... values) {
            int oldSize = ArrayNodes.getSize(array);
            int newSize = oldSize + 1;
            long[] store = (long[])ArrayNodes.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            store[oldSize] = ((Integer)values[0]).intValue();
            ArrayNodes.setStore(array, store, newSize);
            return array;
        }

        @Specialization(guards={"isLongArray(array)", "isSingleLongFixnum(array, values)"})
        public RubyBasicObject pushLongFixnumSingleLongFixnum(RubyArray array, Object ... values) {
            int oldSize = ArrayNodes.getSize(array);
            int newSize = oldSize + 1;
            long[] store = (long[])ArrayNodes.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            store[oldSize] = (Long)values[0];
            ArrayNodes.setStore(array, store, newSize);
            return array;
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public RubyBasicObject pushFloat(RubyArray array, Object ... values) {
            if (ArrayNodes.getSize(array) != 0) {
                throw new UnsupportedOperationException();
            }
            ArrayNodes.setStore(array, values, values.length);
            return array;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public RubyBasicObject pushObject(RubyArray array, Object ... values) {
            int oldSize = ArrayNodes.getSize(array);
            int newSize = oldSize + values.length;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            for (int n = 0; n < values.length; ++n) {
                store[oldSize + n] = values[n];
            }
            ArrayNodes.setStore(array, store, newSize);
            return array;
        }

        protected boolean isSingleIntegerFixnum(RubyArray array, Object ... values) {
            return values.length == 1 && values[0] instanceof Integer;
        }

        protected boolean isSingleLongFixnum(RubyArray array, Object ... values) {
            return values.length == 1 && values[0] instanceof Long;
        }
    }

    @CoreMethod(names={"<<"}, raiseIfFrozenSelf=true, required=1)
    public static abstract class LeftShiftNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private AppendOneNode appendOneNode;

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.appendOneNode = AppendOneNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public RubyBasicObject leftShift(RubyArray array, Object value) {
            return this.appendOneNode.executeAppendOne(array, value);
        }
    }

    @CoreMethod(names={"pop"}, raiseIfFrozenSelf=true, optional=1)
    public static abstract class PopNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private PopOneNode popOneNode;

        public PopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object pop(RubyArray array, NotProvided n) {
            if (this.popOneNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.popOneNode = (PopOneNode)this.insert(PopOneNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.popOneNode.executePopOne(array);
        }

        @Specialization(guards={"isEmptyArray(array)", "wasProvided(object)"})
        public Object popNilWithNum(VirtualFrame frame, RubyArray array, Object object) {
            int n;
            if (object instanceof Integer && (Integer)object < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((n = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            return this.createEmptyArray();
        }

        @Specialization(guards={"isIntArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject popIntegerFixnumInBoundsWithNum(VirtualFrame frame, RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            int[] store = (int[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popIntegerFixnumInBoundsWithNum"}, guards={"isIntArray(array)"})
        public Object popIntegerFixnumWithNum(VirtualFrame frame, RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            int[] store = (int[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isLongArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject popLongFixnumInBoundsWithNum(VirtualFrame frame, RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            long[] store = (long[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popLongFixnumInBoundsWithNum"}, guards={"isLongArray(array)"})
        public Object popLongFixnumWithNum(VirtualFrame frame, RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            long[] store = (long[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isDoubleArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject popFloatInBoundsWithNum(VirtualFrame frame, RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            double[] store = (double[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popFloatInBoundsWithNum"}, guards={"isDoubleArray(array)"})
        public Object popFloatWithNum(VirtualFrame frame, RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            double[] store = (double[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object popObjectWithNum(VirtualFrame frame, RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            Object[] filler = new Object[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isIntArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject popIntegerFixnumInBoundsWithNumObj(VirtualFrame frame, RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            int[] store = (int[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popIntegerFixnumInBoundsWithNumObj"}, guards={"isIntArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object popIntegerFixnumWithNumObj(VirtualFrame frame, RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            int[] store = (int[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isLongArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject popLongFixnumInBoundsWithNumObj(VirtualFrame frame, RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            long[] store = (long[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popLongFixnumInBoundsWithNumObj"}, guards={"isLongArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object popLongFixnumWithNumObj(VirtualFrame frame, RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            long[] store = (long[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isDoubleArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public RubyBasicObject popFloatInBoundsWithNumObj(VirtualFrame frame, RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            double[] store = (double[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popFloatInBoundsWithNumObj"}, guards={"isDoubleArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object popFloatWithNumObj(VirtualFrame frame, RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            double[] store = (double[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isObjectArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object popObjectWithNumObj(VirtualFrame frame, RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (ArrayNodes.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = ArrayNodes.getSize(array) < num ? ArrayNodes.getSize(array) : num;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            RubyBasicObject result = this.createArray(Arrays.copyOfRange(store, ArrayNodes.getSize(array) - numPop, ArrayNodes.getSize(array)), numPop);
            Object[] filler = new Object[numPop];
            System.arraycopy(filler, 0, store, ArrayNodes.getSize(array) - numPop, numPop);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - numPop);
            return result;
        }
    }

    @CoreMethod(names={"pack"}, required=1, taintFromParameter=0)
    public static abstract class PackNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private TaintNode taintNode;

        public PackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"byteListsEqual(format, cachedFormat)"})
        public RubyBasicObject packCached(VirtualFrame frame, RubyArray array, RubyString format, @Cached(value="privatizeByteList(format)") ByteList cachedFormat, @Cached(value="create(compileFormat(format))") DirectCallNode callPackNode) {
            PackResult result;
            try {
                result = (PackResult)callPackNode.call(frame, new Object[]{ArrayNodes.getStore(array), ArrayNodes.getSize(array)});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishPack(cachedFormat, result);
        }

        @Specialization(contains={"packCached"})
        public RubyBasicObject packUncached(VirtualFrame frame, RubyArray array, RubyString format, @Cached(value="create()") IndirectCallNode callPackNode) {
            PackResult result;
            try {
                result = (PackResult)callPackNode.call(frame, this.compileFormat(format), new Object[]{ArrayNodes.getStore(array), ArrayNodes.getSize(array)});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishPack(StringNodes.getByteList(format), result);
        }

        private RuntimeException handleException(PackException exception) {
            try {
                throw exception;
            }
            catch (TooFewArgumentsException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("too few arguments", this));
            }
            catch (NoImplicitConversionException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(e.getObject(), e.getTarget(), this));
            }
            catch (OutsideOfStringException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("X outside of string", this));
            }
            catch (CantCompressNegativeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("can't compress negative numbers", this));
            }
            catch (RangeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().rangeError(e.getMessage(), (Node)this));
            }
            catch (CantConvertException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeError(e.getMessage(), this));
            }
        }

        private RubyBasicObject finishPack(ByteList format, PackResult result) {
            RubyBasicObject string = this.createString(new ByteList(result.getOutput(), 0, result.getOutputLength()));
            if (format.length() == 0) {
                StringNodes.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
            } else {
                switch (result.getEncoding()) {
                    case DEFAULT: 
                    case ASCII_8BIT: {
                        break;
                    }
                    case US_ASCII: {
                        StringNodes.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
                        break;
                    }
                    case UTF_8: {
                        StringNodes.forceEncoding(string, (Encoding)UTF8Encoding.INSTANCE);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
                }
                this.taintNode.executeTaint(string);
            }
            return string;
        }

        @Specialization
        public Object pack(VirtualFrame frame, RubyArray array, boolean format) {
            return this.ruby(frame, "raise TypeError", new Object[0]);
        }

        @Specialization
        public Object pack(VirtualFrame frame, RubyArray array, int format) {
            return this.ruby(frame, "raise TypeError", new Object[0]);
        }

        @Specialization
        public Object pack(VirtualFrame frame, RubyArray array, long format) {
            return this.ruby(frame, "raise TypeError", new Object[0]);
        }

        @Specialization(guards={"isNil(format)"})
        public Object packNil(VirtualFrame frame, RubyArray array, Object format) {
            return this.ruby(frame, "raise TypeError", new Object[0]);
        }

        @Specialization(guards={"!isRubyString(format)", "!isBoolean(format)", "!isInteger(format)", "!isLong(format)", "!isNil(format)"})
        public Object pack(VirtualFrame frame, RubyArray array, Object format) {
            return this.ruby(frame, "pack(format.to_str)", "format", format);
        }

        protected ByteList privatizeByteList(RubyString string) {
            return StringNodes.getByteList(string).dup();
        }

        protected boolean byteListsEqual(RubyString string, ByteList byteList) {
            return StringNodes.getByteList(string).equal(byteList);
        }

        protected CallTarget compileFormat(RubyString format) {
            try {
                return new PackParser(this.getContext()).parse(format.toString(), false);
            }
            catch (FormatException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(e.getMessage(), this));
            }
        }
    }

    public static class MinBlock {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MinBlock(RubyContext context) {
            CoreSourceSection sourceSection = new CoreSourceSection("Array", "min");
            this.frameDescriptor = new FrameDescriptor();
            this.frameSlot = this.frameDescriptor.addFrameSlot((Object)"minimum_memo");
            this.sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, Arity.NO_ARGUMENTS, "min", false, null, false);
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)new RubyRootNode(context, (SourceSection)sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MinBlockNodeFactory.create(context, (SourceSection)sourceSection, new RubyNode[]{new ReadDeclarationVariableNode(context, (SourceSection)sourceSection, 1, this.frameSlot), new ReadPreArgumentNode(context, (SourceSection)sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR)})));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MinBlockNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MinBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public RubyBasicObject min(VirtualFrame frame, Object minimumObject, Object value) {
            Memo minimum = (Memo)minimumObject;
            Object current = minimum.get();
            if (current == null || (Integer)this.compareNode.call(frame, value, "<=>", null, current) < 0) {
                minimum.set(value);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"min"})
    public static abstract class MinNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MinBlock minBlock;

        public MinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.minBlock = context.getCoreLibrary().getArrayMinBlock();
        }

        @Specialization
        public Object min(VirtualFrame frame, RubyArray array) {
            Memo minimum = new Memo();
            VirtualFrame minimumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(null, null, array, null, new Object[0]), this.minBlock.getFrameDescriptor());
            minimumClosureFrame.setObject(this.minBlock.getFrameSlot(), (Object)minimum);
            RubyProc block = new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, this.minBlock.getSharedMethodInfo(), this.minBlock.getCallTarget(), this.minBlock.getCallTarget(), this.minBlock.getCallTarget(), minimumClosureFrame.materialize(), null, array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (minimum.get() == null) {
                return this.nil();
            }
            return minimum.get();
        }
    }

    public static class MaxBlock {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MaxBlock(RubyContext context) {
            CoreSourceSection sourceSection = new CoreSourceSection("Array", "max");
            this.frameDescriptor = new FrameDescriptor();
            this.frameSlot = this.frameDescriptor.addFrameSlot((Object)"maximum_memo");
            this.sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, Arity.NO_ARGUMENTS, "max", false, null, false);
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)new RubyRootNode(context, (SourceSection)sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MaxBlockNodeFactory.create(context, (SourceSection)sourceSection, new RubyNode[]{new ReadDeclarationVariableNode(context, (SourceSection)sourceSection, 1, this.frameSlot), new ReadPreArgumentNode(context, (SourceSection)sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR)})));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MaxBlockNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MaxBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public RubyBasicObject max(VirtualFrame frame, Object maximumObject, Object value) {
            Memo maximum = (Memo)maximumObject;
            Object current = maximum.get();
            if (current == null || (Integer)this.compareNode.call(frame, value, "<=>", null, current) < 0) {
                maximum.set(value);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"max"})
    public static abstract class MaxNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MaxBlock maxBlock;

        public MaxNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.maxBlock = context.getCoreLibrary().getArrayMaxBlock();
        }

        @Specialization
        public Object max(VirtualFrame frame, RubyArray array) {
            Memo maximum = new Memo();
            VirtualFrame maximumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(null, null, array, null, new Object[0]), this.maxBlock.getFrameDescriptor());
            maximumClosureFrame.setObject(this.maxBlock.getFrameSlot(), (Object)maximum);
            RubyProc block = new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, this.maxBlock.getSharedMethodInfo(), this.maxBlock.getCallTarget(), this.maxBlock.getCallTarget(), this.maxBlock.getCallTarget(), maximumClosureFrame.materialize(), null, array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (maximum.get() == null) {
                return this.nil();
            }
            return maximum.get();
        }
    }

    @CoreMethod(names={"map!", "collect!"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class MapInPlaceNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayWriteDenormalizedNode writeNode;
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public MapInPlaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public RubyBasicObject mapInPlaceNull(RubyArray array, RubyProc block) {
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)"})
        public Object mapInPlaceFixnumInteger(VirtualFrame frame, RubyArray array, RubyProc block) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            int[] store = (int[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.writeNode.executeWrite(frame, array, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)"})
        public Object mapInPlaceObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            Object[] store = (Object[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.writeNode.executeWrite(frame, array, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public MapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        @Specialization(guards={"isNullArray(array)"})
        public RubyBasicObject mapNull(RubyArray array, RubyProc block) {
            return this.createEmptyArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)"})
        public Object mapIntegerFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            int[] store = (int[])ArrayNodes.getStore(array);
            int arraySize = ArrayNodes.getSize(array);
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return ArrayNodes.createGeneralArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongArray(array)"})
        public Object mapLongFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            long[] store = (long[])ArrayNodes.getStore(array);
            int arraySize = ArrayNodes.getSize(array);
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return ArrayNodes.createGeneralArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDoubleArray(array)"})
        public Object mapFloat(VirtualFrame frame, RubyArray array, RubyProc block) {
            double[] store = (double[])ArrayNodes.getStore(array);
            int arraySize = ArrayNodes.getSize(array);
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return ArrayNodes.createGeneralArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)"})
        public Object mapObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])ArrayNodes.getStore(array);
            int arraySize = ArrayNodes.getSize(array);
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return ArrayNodes.createGeneralArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }
    }

    @CoreMethod(names={"insert"}, required=1, raiseIfFrozenSelf=true, argumentsAsArray=true)
    public static abstract class InsertNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        private final BranchProfile tooSmallBranch = BranchProfile.create();

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)", "isIntIndexAndOtherSingleObjectArg(values)"})
        public Object insertNull(RubyArray array, Object[] values) {
            CompilerDirectives.transferToInterpreter();
            int index = (Integer)values[0];
            if (index < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            Object value = values[1];
            Object[] store = new Object[index + 1];
            Arrays.fill(store, this.nil());
            store[index] = value;
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) + 1);
            return array;
        }

        @Specialization(guards={"isArgsLengthTwo(values)"}, rewriteOn={ClassCastException.class, IndexOutOfBoundsException.class})
        public Object insert(RubyArray array, Object[] values) {
            int index = (Integer)values[0];
            int value = (Integer)values[1];
            int[] store = (int[])ArrayNodes.getStore(array);
            System.arraycopy(store, index, store, index + 1, ArrayNodes.getSize(array) - index);
            store[index] = value;
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) + 1);
            return array;
        }

        @Specialization(contains={"insert", "insertNull"})
        public Object insertBoxed(VirtualFrame frame, RubyArray array, Object[] values) {
            int normalizedIndex;
            int index;
            CompilerDirectives.transferToInterpreter();
            if (values.length == 1) {
                return array;
            }
            if (values[0] instanceof Integer) {
                index = (Integer)values[0];
            } else {
                if (this.toIntNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
                }
                index = this.toIntNode.doInt(frame, values[0]);
            }
            int valuesLength = values.length - 1;
            int n = normalizedIndex = index < 0 ? ArrayNodes.normalizeIndex(array, index) + 1 : ArrayNodes.normalizeIndex(array, index);
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "index " + index + " too small for array; minimum: " + Integer.toString(-ArrayNodes.getSize(array));
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            Object[] store = ArrayUtils.box(ArrayNodes.getStore(array));
            int newSize = normalizedIndex < ArrayNodes.getSize(array) ? ArrayNodes.getSize(array) + valuesLength : normalizedIndex + valuesLength;
            store = Arrays.copyOf(store, newSize);
            if (normalizedIndex >= ArrayNodes.getSize(array)) {
                for (int i = ArrayNodes.getSize(array); i < normalizedIndex; ++i) {
                    store[i] = this.nil();
                }
            }
            int dest = normalizedIndex + valuesLength;
            int len = ArrayNodes.getSize(array) - normalizedIndex;
            if (normalizedIndex < ArrayNodes.getSize(array)) {
                System.arraycopy(store, normalizedIndex, store, dest, len);
            }
            System.arraycopy(values, 1, store, normalizedIndex, valuesLength);
            ArrayNodes.setStore(array, store, newSize);
            return array;
        }

        protected static boolean isArgsLengthTwo(Object[] others) {
            return others.length == 2;
        }

        protected static boolean isIntIndexAndOtherSingleObjectArg(Object[] others) {
            return others.length == 2 && others[0] instanceof Integer && others[1] instanceof Object;
        }
    }

    @CoreMethod(names={"inject", "reduce"}, needsBlock=true, optional=1)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InjectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode dispatch;

        public InjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.CALL_METHOD_MISSING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)"})
        public Object injectIntegerFixnum(VirtualFrame frame, RubyArray array, Object initial, RubyProc block) {
            int count = 0;
            int[] store = (int[])ArrayNodes.getStore(array);
            Object accumulator = initial;
            try {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.yield(frame, block, accumulator, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongArray(array)"})
        public Object injectLongFixnum(VirtualFrame frame, RubyArray array, Object initial, RubyProc block) {
            int count = 0;
            long[] store = (long[])ArrayNodes.getStore(array);
            Object accumulator = initial;
            try {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.yield(frame, block, accumulator, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDoubleArray(array)"})
        public Object injectFloat(VirtualFrame frame, RubyArray array, Object initial, RubyProc block) {
            int count = 0;
            double[] store = (double[])ArrayNodes.getStore(array);
            Object accumulator = initial;
            try {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.yield(frame, block, accumulator, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)"})
        public Object injectObject(VirtualFrame frame, RubyArray array, Object initial, RubyProc block) {
            int count = 0;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            Object accumulator = initial;
            try {
                for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.yield(frame, block, accumulator, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object injectNull(VirtualFrame frame, RubyArray array, Object initial, RubyProc block) {
            return initial;
        }

        @Specialization
        public Object inject(VirtualFrame frame, RubyArray array, RubySymbol symbol, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            Object[] store = ArrayNodes.slowToArray(array);
            if (store.length < 2) {
                if (store.length == 1) {
                    return store[0];
                }
                return this.getContext().getCoreLibrary().getNilObject();
            }
            Object accumulator = this.dispatch.call(frame, store[0], symbol, null, store[1]);
            for (int n = 2; n < ArrayNodes.getSize(array); ++n) {
                accumulator = this.dispatch.call(frame, accumulator, symbol, null, store[n]);
            }
            return accumulator;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="from")})
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"from"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isNullArray(from)"})
        public RubyBasicObject initializeCopyNull(RubyArray self, RubyArray from) {
            if (self == from) {
                return self;
            }
            ArrayNodes.setStore(self, null, 0);
            return self;
        }

        @Specialization(guards={"isIntArray(from)"})
        public RubyBasicObject initializeCopyIntegerFixnum(RubyArray self, RubyArray from) {
            if (self == from) {
                return self;
            }
            ArrayNodes.setStore(self, Arrays.copyOf((int[])ArrayNodes.getStore(from), ArrayNodes.getSize(from)), ArrayNodes.getSize(from));
            return self;
        }

        @Specialization(guards={"isLongArray(from)"})
        public RubyBasicObject initializeCopyLongFixnum(RubyArray self, RubyArray from) {
            if (self == from) {
                return self;
            }
            ArrayNodes.setStore(self, Arrays.copyOf((long[])ArrayNodes.getStore(from), ArrayNodes.getSize(from)), ArrayNodes.getSize(from));
            return self;
        }

        @Specialization(guards={"isDoubleArray(from)"})
        public RubyBasicObject initializeCopyFloat(RubyArray self, RubyArray from) {
            if (self == from) {
                return self;
            }
            ArrayNodes.setStore(self, Arrays.copyOf((double[])ArrayNodes.getStore(from), ArrayNodes.getSize(from)), ArrayNodes.getSize(from));
            return self;
        }

        @Specialization(guards={"isObjectArray(from)"})
        public RubyBasicObject initializeCopyObject(RubyArray self, RubyArray from) {
            if (self == from) {
                return self;
            }
            ArrayNodes.setStore(self, Arrays.copyOf((Object[])ArrayNodes.getStore(from), ArrayNodes.getSize(from)), ArrayNodes.getSize(from));
            return self;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InitializeNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private CallDispatchHeadNode toAryNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToAryNode;
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        @Specialization(guards={"!isInteger(object)", "!isLong(object)", "wasProvided(object)", "!isRubyArray(object)"})
        public RubyBasicObject initialize(VirtualFrame frame, RubyArray array, Object object, NotProvided defaultValue, NotProvided block) {
            int size;
            RubyArray copy = null;
            if (this.respondToToAryNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToAryNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            if (this.respondToToAryNode.doesRespondTo(frame, object, (RubyString)this.createString("to_ary"), true)) {
                Object toAryResult;
                if (this.toAryNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toAryNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                }
                if ((toAryResult = this.toAryNode.call(frame, object, "to_ary", null, new Object[0])) instanceof RubyArray) {
                    copy = (RubyArray)toAryResult;
                }
            }
            if (copy != null) {
                return this.initialize(array, copy, NotProvided.INSTANCE, NotProvided.INSTANCE);
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((size = this.toIntNode.doInt(frame, object)) < 0) {
                return this.initializeNegative(array, size, NotProvided.INSTANCE, NotProvided.INSTANCE);
            }
            return this.initialize(array, size, NotProvided.INSTANCE, NotProvided.INSTANCE);
        }

        @Specialization
        public RubyBasicObject initialize(RubyArray array, NotProvided size, NotProvided defaultValue, NotProvided block) {
            return this.initialize(array, 0, this.nil(), block);
        }

        @Specialization
        public RubyBasicObject initialize(RubyArray array, NotProvided size, NotProvided defaultValue, RubyProc block) {
            return this.initialize(array, 0, this.nil(), NotProvided.INSTANCE);
        }

        @Specialization(guards={"size >= 0"})
        public RubyBasicObject initialize(RubyArray array, int size, NotProvided defaultValue, NotProvided block) {
            return this.initialize(array, size, this.nil(), block);
        }

        @Specialization(guards={"size < 0"})
        public RubyBasicObject initializeNegative(RubyArray array, int size, NotProvided defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"size >= 0"})
        public RubyBasicObject initialize(RubyArray array, long size, NotProvided defaultValue, NotProvided block) {
            if (size > Integer.MAX_VALUE) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("array size too big", this));
            }
            return this.initialize(array, (int)size, this.nil(), block);
        }

        @Specialization(guards={"size < 0"})
        public RubyBasicObject initializeNegative(RubyArray array, long size, NotProvided defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"size >= 0"})
        public RubyBasicObject initialize(RubyArray array, int size, int defaultValue, NotProvided block) {
            int[] store = new int[size];
            Arrays.fill(store, defaultValue);
            ArrayNodes.setStore(array, store, size);
            return array;
        }

        @Specialization(guards={"size < 0"})
        public RubyBasicObject initializeNegative(RubyArray array, int size, int defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"size >= 0"})
        public RubyBasicObject initialize(RubyArray array, int size, long defaultValue, NotProvided block) {
            long[] store = new long[size];
            Arrays.fill(store, defaultValue);
            ArrayNodes.setStore(array, store, size);
            return array;
        }

        @Specialization(guards={"size < 0"})
        public RubyBasicObject initializeNegative(RubyArray array, int size, long defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"size >= 0"})
        public RubyBasicObject initialize(RubyArray array, int size, double defaultValue, NotProvided block) {
            double[] store = new double[size];
            Arrays.fill(store, defaultValue);
            ArrayNodes.setStore(array, store, size);
            return array;
        }

        @Specialization(guards={"size < 0"})
        public RubyBasicObject initializeNegative(RubyArray array, int size, double defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"wasProvided(defaultValue)", "size >= 0"})
        public RubyBasicObject initialize(RubyArray array, int size, Object defaultValue, NotProvided block) {
            Object[] store = new Object[size];
            Arrays.fill(store, defaultValue);
            ArrayNodes.setStore(array, store, size);
            return array;
        }

        @Specialization(guards={"wasProvided(defaultValue)", "size < 0"})
        public RubyBasicObject initializeNegative(RubyArray array, int size, Object defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"!isInteger(sizeObject)", "wasProvided(defaultValue)"})
        public RubyBasicObject initialize(VirtualFrame frame, RubyArray array, Object sizeObject, Object defaultValue, NotProvided block) {
            int size;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((size = this.toIntNode.doInt(frame, sizeObject)) < 0) {
                return this.initializeNegative(array, size, defaultValue, NotProvided.INSTANCE);
            }
            return this.initialize(array, size, defaultValue, NotProvided.INSTANCE);
        }

        @Specialization(guards={"wasProvided(defaultValue)", "size >= 0"})
        public Object initialize(VirtualFrame frame, RubyArray array, int size, Object defaultValue, RubyProc block) {
            return this.initialize(frame, array, size, NotProvided.INSTANCE, block);
        }

        @Specialization(guards={"wasProvided(defaultValue)", "size < 0"})
        public Object initializeNegative(VirtualFrame frame, RubyArray array, int size, Object defaultValue, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"size >= 0"})
        public Object initialize(VirtualFrame frame, RubyArray array, int size, NotProvided defaultValue, RubyProc block) {
            int n;
            Object store = this.arrayBuilder.start();
            int count = 0;
            try {
                for (n = 0; n < size; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.arrayBuilder.ensure(store, n + 1);
                    store = this.arrayBuilder.append(store, n, this.yield(frame, block, n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
                ArrayNodes.setStore(array, this.arrayBuilder.finish(store, n), n);
            }
            return array;
        }

        @Specialization(guards={"size < 0"})
        public Object initializeNegative(VirtualFrame frame, RubyArray array, int size, NotProvided defaultValue, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization
        public RubyBasicObject initialize(RubyArray array, RubyArray copy, NotProvided defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            ArrayNodes.setStore(array, ArrayNodes.slowToArray(copy), ArrayNodes.getSize(copy));
            return array;
        }

        @Specialization
        public RubyBasicObject initialize(RubyArray array, RubyArray copy, NotProvided defaultValue, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            ArrayNodes.setStore(array, ArrayNodes.slowToArray(copy), ArrayNodes.getSize(copy));
            return array;
        }
    }

    @CoreMethod(names={"include?"}, required=1)
    public static abstract class IncludeNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode;

        public IncludeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        @Specialization(guards={"isNullArray(array)"})
        public boolean includeNull(VirtualFrame frame, RubyArray array, Object value) {
            return false;
        }

        @Specialization(guards={"isIntArray(array)"})
        public boolean includeIntegerFixnum(VirtualFrame frame, RubyArray array, Object value) {
            int[] store = (int[])ArrayNodes.getStore(array);
            for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                Integer stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isLongArray(array)"})
        public boolean includeLongFixnum(VirtualFrame frame, RubyArray array, Object value) {
            long[] store = (long[])ArrayNodes.getStore(array);
            for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                Long stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public boolean includeFloat(VirtualFrame frame, RubyArray array, Object value) {
            double[] store = (double[])ArrayNodes.getStore(array);
            for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                Double stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public boolean includeObject(VirtualFrame frame, RubyArray array, Object value) {
            Object[] store = (Object[])ArrayNodes.getStore(array);
            for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                Object stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"each_with_index"}, needsBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EachWithIndexNode
    extends YieldingCoreMethodNode {
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public EachWithIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public RubyBasicObject eachWithEmpty(VirtualFrame frame, RubyArray array, RubyProc block) {
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)"})
        public Object eachWithIndexInt(VirtualFrame frame, RubyArray array, RubyProc block) {
            int[] store = (int[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n], n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongArray(array)"})
        public Object eachWithIndexLong(VirtualFrame frame, RubyArray array, RubyProc block) {
            long[] store = (long[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n], n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDoubleArray(array)"})
        public Object eachWithIndexDouble(VirtualFrame frame, RubyArray array, RubyProc block) {
            double[] store = (double[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n], n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)"})
        public Object eachWithIndexObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n], n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        @Specialization
        public Object eachWithIndexObject(VirtualFrame frame, RubyArray array, NotProvided block) {
            return this.ruby(frame, "to_enum(:each_with_index)", new Object[0]);
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toEnumNode;
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();
        private final RubySymbol eachSymbol = this.getContext().getSymbol("each");

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object eachEnumerator(VirtualFrame frame, RubyArray array, NotProvided block) {
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toEnumNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.toEnumNode.call(frame, array, "to_enum", null, this.eachSymbol);
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object eachNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return this.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)"})
        public Object eachIntegerFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            int[] store = (int[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n]);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongArray(array)"})
        public Object eachLongFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            long[] store = (long[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n]);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDoubleArray(array)"})
        public Object eachFloat(VirtualFrame frame, RubyArray array, RubyProc block) {
            double[] store = (double[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n]);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)"})
        public Object eachObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])ArrayNodes.getStore(array);
            int count = 0;
            try {
                block6: for (int n = 0; n < ArrayNodes.getSize(array); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n]);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }
    }

    @CoreMethod(names={"delete_at"}, required=1, raiseIfFrozenSelf=true, lowerFixnumParameters={0})
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="index")})
    public static abstract class DeleteAtNode
    extends CoreMethodNode {
        private final BranchProfile tooSmallBranch = BranchProfile.create();
        private final BranchProfile beyondEndBranch = BranchProfile.create();

        public DeleteAtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceOtherToInt(RubyNode index) {
            return ToIntNodeGen.create(this.getContext(), this.getSourceSection(), index);
        }

        @Specialization(guards={"isIntArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public int deleteAtIntegerFixnumInBounds(RubyArray array, int index) throws UnexpectedResultException {
            int normalizedIndex = ArrayNodes.normalizeIndex(array, index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= ArrayNodes.getSize(array)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int[] store = (int[])ArrayNodes.getStore(array);
            int value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, ArrayNodes.getSize(array) - normalizedIndex - 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"deleteAtIntegerFixnumInBounds"}, guards={"isIntArray(array)"})
        public Object deleteAtIntegerFixnum(RubyArray array, int index) {
            CompilerDirectives.transferToInterpreter();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = ArrayNodes.getSize(array) + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= ArrayNodes.getSize(array)) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            int[] store = (int[])ArrayNodes.getStore(array);
            int value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, ArrayNodes.getSize(array) - normalizedIndex - 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isLongArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public long deleteAtLongFixnumInBounds(RubyArray array, int index) throws UnexpectedResultException {
            int normalizedIndex = ArrayNodes.normalizeIndex(array, index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= ArrayNodes.getSize(array)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            long[] store = (long[])ArrayNodes.getStore(array);
            long value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, ArrayNodes.getSize(array) - normalizedIndex - 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"deleteAtLongFixnumInBounds"}, guards={"isLongArray(array)"})
        public Object deleteAtLongFixnum(RubyArray array, int index) {
            CompilerDirectives.transferToInterpreter();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = ArrayNodes.getSize(array) + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= ArrayNodes.getSize(array)) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            long[] store = (long[])ArrayNodes.getStore(array);
            long value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, ArrayNodes.getSize(array) - normalizedIndex - 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isDoubleArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public double deleteAtFloatInBounds(RubyArray array, int index) throws UnexpectedResultException {
            int normalizedIndex = ArrayNodes.normalizeIndex(array, index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= ArrayNodes.getSize(array)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            double[] store = (double[])ArrayNodes.getStore(array);
            double value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, ArrayNodes.getSize(array) - normalizedIndex - 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"deleteAtFloatInBounds"}, guards={"isDoubleArray(array)"})
        public Object deleteAtFloat(RubyArray array, int index) {
            CompilerDirectives.transferToInterpreter();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = ArrayNodes.getSize(array) + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= ArrayNodes.getSize(array)) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            double[] store = (double[])ArrayNodes.getStore(array);
            double value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, ArrayNodes.getSize(array) - normalizedIndex - 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isObjectArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public Object deleteAtObjectInBounds(RubyArray array, int index) throws UnexpectedResultException {
            int normalizedIndex = ArrayNodes.normalizeIndex(array, index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= ArrayNodes.getSize(array)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            Object[] store = (Object[])ArrayNodes.getStore(array);
            Object value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, ArrayNodes.getSize(array) - normalizedIndex - 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"deleteAtObjectInBounds"}, guards={"isObjectArray(array)"})
        public Object deleteAtObject(RubyArray array, int index) {
            CompilerDirectives.transferToInterpreter();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = ArrayNodes.getSize(array) + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= ArrayNodes.getSize(array)) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            Object[] store = (Object[])ArrayNodes.getStore(array);
            Object value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, ArrayNodes.getSize(array) - normalizedIndex - 1);
            ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isEmptyArray(array)"})
        public Object deleteAtNullOrEmpty(RubyArray array, int index) {
            return this.nil();
        }
    }

    @CoreMethod(names={"delete"}, required=1)
    public static abstract class DeleteNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode;
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        @Specialization(guards={"isIntArray(array)"})
        public Object deleteIntegerFixnum(VirtualFrame frame, RubyArray array, Object value) {
            int n;
            int[] store = (int[])ArrayNodes.getStore(array);
            Object found = this.nil();
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                Integer stored = store[n];
                if (this.equalNode.executeSameOrEqual(frame, stored, value)) {
                    if (this.isFrozenNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
                    }
                    if (this.isFrozenNode.executeIsFrozen(array)) {
                        CompilerDirectives.transferToInterpreter();
                        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(array.getLogicalClass().getName(), this));
                    }
                    found = store[n];
                    continue;
                }
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                ArrayNodes.setStore(array, store, i);
            }
            return found;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object deleteObject(VirtualFrame frame, RubyArray array, Object value) {
            int n;
            Object[] store = (Object[])ArrayNodes.getStore(array);
            Object found = this.nil();
            int i = 0;
            for (n = 0; n < ArrayNodes.getSize(array); ++n) {
                Object stored = store[n];
                if (this.equalNode.executeSameOrEqual(frame, stored, value)) {
                    if (this.isFrozenNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
                    }
                    if (this.isFrozenNode.executeIsFrozen(array)) {
                        CompilerDirectives.transferToInterpreter();
                        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(array.getLogicalClass().getName(), this));
                    }
                    found = store[n];
                    continue;
                }
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                ArrayNodes.setStore(array, store, i);
            }
            return found;
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object deleteNull(VirtualFrame frame, RubyArray array, Object value) {
            return this.nil();
        }
    }

    @CoreMethod(names={"concat"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ConcatNode
    extends CoreMethodNode {
        @Node.Child
        private AppendManyNode appendManyNode;

        public ConcatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.appendManyNode = AppendManyNodeGen.create(context, sourceSection, null, null, null);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isNullArray(other)"})
        public RubyBasicObject concatNull(RubyArray array, RubyArray other) {
            return array;
        }

        @Specialization(guards={"!isNullArray(other)"})
        public RubyBasicObject concat(RubyArray array, RubyArray other) {
            this.appendManyNode.executeAppendMany(array, ArrayNodes.getSize(other), ArrayNodes.getStore(other));
            return array;
        }
    }

    @CoreMethod(names={"compact!"}, raiseIfFrozenSelf=true)
    public static abstract class CompactBangNode
    extends ArrayCoreMethodNode {
        public CompactBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isObjectArray(array)"})
        public RubyBasicObject compactNotObjects(RubyArray array) {
            return this.nil();
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object compactObjects(RubyArray array) {
            Object[] store = (Object[])ArrayNodes.getStore(array);
            int size = ArrayNodes.getSize(array);
            int m = 0;
            for (int n = 0; n < size; ++n) {
                if (store[n] == this.nil()) continue;
                store[m] = store[n];
                ++m;
            }
            ArrayNodes.setStore(array, store, m);
            if (m == size) {
                return this.nil();
            }
            return array;
        }
    }

    @CoreMethod(names={"compact"})
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class CompactNode
    extends ArrayCoreMethodNode {
        public CompactNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isIntArray(array)"})
        public RubyBasicObject compactInt(RubyArray array) {
            return this.createArray(Arrays.copyOf((int[])ArrayNodes.getStore(array), ArrayNodes.getSize(array)), ArrayNodes.getSize(array));
        }

        @Specialization(guards={"isLongArray(array)"})
        public RubyBasicObject compactLong(RubyArray array) {
            return this.createArray(Arrays.copyOf((long[])ArrayNodes.getStore(array), ArrayNodes.getSize(array)), ArrayNodes.getSize(array));
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public RubyBasicObject compactDouble(RubyArray array) {
            return this.createArray(Arrays.copyOf((double[])ArrayNodes.getStore(array), ArrayNodes.getSize(array)), ArrayNodes.getSize(array));
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object compactObjects(RubyArray array) {
            Object[] store = (Object[])ArrayNodes.getStore(array);
            Object[] newStore = new Object[store.length];
            int size = ArrayNodes.getSize(array);
            int m = 0;
            for (int n = 0; n < size; ++n) {
                if (store[n] == this.nil()) continue;
                newStore[m] = store[n];
                ++m;
            }
            return this.createArray(newStore, m);
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object compactNull(RubyArray array) {
            return this.createEmptyArray();
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends ArrayCoreMethodNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject clear(RubyArray array) {
            ArrayNodes.setStore(array, ArrayNodes.getStore(array), 0);
            return array;
        }
    }

    @CoreMethod(names={"at"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="index")})
    public static abstract class AtNode
    extends CoreMethodNode {
        @Node.Child
        private ArrayReadDenormalizedNode readNode;

        public AtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceOtherToInt(RubyNode index) {
            return new FixnumLowerNode(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), index));
        }

        @Specialization
        public Object at(VirtualFrame frame, RubyArray array, int index) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNode = (ArrayReadDenormalizedNode)this.insert(ArrayReadDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.readNode.executeRead(frame, array, index);
        }
    }

    @CoreMethod(names={"[]="}, required=2, optional=1, lowerFixnumParameters={0}, raiseIfFrozenSelf=true)
    public static abstract class IndexSetNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ArrayWriteDenormalizedNode writeNode;
        @Node.Child
        protected ArrayReadSliceDenormalizedNode readSliceNode;
        @Node.Child
        private PopOneNode popOneNode;
        @Node.Child
        private ToIntNode toIntNode;
        private final BranchProfile tooSmallBranch = BranchProfile.create();

        public IndexSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isInteger(indexObject)", "!isIntegerFixnumRange(indexObject)"})
        public Object set(VirtualFrame frame, RubyArray array, Object indexObject, Object value, NotProvided unused) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            int index = this.toIntNode.doInt(frame, indexObject);
            return this.set(frame, array, index, value, unused);
        }

        @Specialization
        public Object set(VirtualFrame frame, RubyArray array, int index, Object value, NotProvided unused) {
            int normalizedIndex = ArrayNodes.normalizeIndex(array, index);
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "index " + index + " too small for array; minimum: " + Integer.toString(-ArrayNodes.getSize(array));
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.writeNode.executeWrite(frame, array, index, value);
        }

        @Specialization(guards={"!isRubyArray(value)", "wasProvided(value)", "!isInteger(lengthObject)"})
        public Object setObject(VirtualFrame frame, RubyArray array, int start, Object lengthObject, Object value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            int length = this.toIntNode.doInt(frame, lengthObject);
            return this.setObject(frame, array, start, length, value);
        }

        @Specialization(guards={"!isRubyArray(value)", "wasProvided(value)", "!isInteger(startObject)"})
        public Object setObject(VirtualFrame frame, RubyArray array, Object startObject, int length, Object value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            int start = this.toIntNode.doInt(frame, startObject);
            return this.setObject(frame, array, start, length, value);
        }

        @Specialization(guards={"!isRubyArray(value)", "wasProvided(value)", "!isInteger(startObject)", "!isInteger(lengthObject)"})
        public Object setObject(VirtualFrame frame, RubyArray array, Object startObject, Object lengthObject, Object value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            int length = this.toIntNode.doInt(frame, lengthObject);
            int start = this.toIntNode.doInt(frame, startObject);
            return this.setObject(frame, array, start, length, value);
        }

        @Specialization(guards={"!isRubyArray(value)", "wasProvided(value)"})
        public Object setObject(VirtualFrame frame, RubyArray array, int start, int length, Object value) {
            CompilerDirectives.transferToInterpreter();
            if (length < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "negative length (" + length + ")";
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            int normalizedIndex = ArrayNodes.normalizeIndex(array, start);
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "index " + start + " too small for array; minimum: " + Integer.toString(-ArrayNodes.getSize(array));
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            int begin = ArrayNodes.normalizeIndex(array, start);
            if (begin < ArrayNodes.getSize(array) && length == 1) {
                if (this.writeNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                return this.writeNode.executeWrite(frame, array, begin, value);
            }
            if (ArrayNodes.getSize(array) > begin + length) {
                if (this.readSliceNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.readSliceNode = (ArrayReadSliceDenormalizedNode)this.insert(ArrayReadSliceDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                RubyArray endValues = (RubyArray)this.readSliceNode.executeReadSlice(frame, array, begin + length, ArrayNodes.getSize(array) - begin - length);
                if (this.writeNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                this.writeNode.executeWrite(frame, array, begin, value);
                Object[] endValuesStore = ArrayUtils.box(ArrayNodes.getStore(endValues));
                int i = begin + 1;
                for (Object obj : endValuesStore) {
                    this.writeNode.executeWrite(frame, array, i, obj);
                    ++i;
                }
            } else {
                this.writeNode.executeWrite(frame, array, begin, value);
            }
            if (this.popOneNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.popOneNode = (PopOneNode)this.insert(PopOneNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            int popLength = length - 1 < ArrayNodes.getSize(array) ? length - 1 : ArrayNodes.getSize(array) - 1;
            for (int i = 0; i < popLength; ++i) {
                this.popOneNode.executePopOne(array);
            }
            return value;
        }

        @Specialization(guards={"!isInteger(startObject)"})
        public Object setOtherArray(VirtualFrame frame, RubyArray array, Object startObject, int length, RubyArray value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            int start = this.toIntNode.doInt(frame, startObject);
            return this.setOtherArray(frame, array, start, length, value);
        }

        @Specialization(guards={"!isInteger(lengthObject)"})
        public Object setOtherArray(VirtualFrame frame, RubyArray array, int start, Object lengthObject, RubyArray value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            int length = this.toIntNode.doInt(frame, lengthObject);
            return this.setOtherArray(frame, array, start, length, value);
        }

        @Specialization(guards={"!isInteger(startObject)", "!isInteger(lengthObject)"})
        public Object setOtherArray(VirtualFrame frame, RubyArray array, Object startObject, Object lengthObject, RubyArray value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            int start = this.toIntNode.doInt(frame, startObject);
            int length = this.toIntNode.doInt(frame, lengthObject);
            return this.setOtherArray(frame, array, start, length, value);
        }

        @Specialization
        public Object setOtherArray(VirtualFrame frame, RubyArray array, int start, int length, RubyArray value) {
            block15: {
                Object[] endValuesStore;
                int popNum;
                Object[] values;
                int begin;
                block14: {
                    CompilerDirectives.transferToInterpreter();
                    if (length < 0) {
                        CompilerDirectives.transferToInterpreter();
                        String errMessage = "negative length (" + length + ")";
                        throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
                    }
                    int normalizedIndex = ArrayNodes.normalizeIndex(array, start);
                    if (normalizedIndex < 0) {
                        CompilerDirectives.transferToInterpreter();
                        String errMessage = "index " + start + " too small for array; minimum: " + Integer.toString(-ArrayNodes.getSize(array));
                        throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
                    }
                    begin = ArrayNodes.normalizeIndex(array, start);
                    if (ArrayNodes.getSize(value) == 0) {
                        int exclusiveEnd = begin + length;
                        Object[] store = ArrayUtils.box(ArrayNodes.getStore(array));
                        if (begin < 0) {
                            this.tooSmallBranch.enter();
                            CompilerDirectives.transferToInterpreter();
                            throw new RaiseException(this.getContext().getCoreLibrary().indexTooSmallError("array", start, ArrayNodes.getSize(array), this));
                        }
                        if (exclusiveEnd > ArrayNodes.getSize(array)) {
                            throw new UnsupportedOperationException();
                        }
                        System.arraycopy(store, exclusiveEnd, store, begin, ArrayNodes.getSize(array) - exclusiveEnd);
                        ArrayNodes.setStore(array, store, ArrayNodes.getSize(array) - length);
                        return value;
                    }
                    if (this.writeNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                    }
                    values = ArrayNodes.slowToArray(value);
                    if (ArrayNodes.getSize(value) != length && begin + length + 1 <= ArrayNodes.getSize(array)) break block14;
                    int i = begin;
                    for (Object obj : values) {
                        this.writeNode.executeWrite(frame, array, i, obj);
                        ++i;
                    }
                    break block15;
                }
                if (this.readSliceNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.readSliceNode = (ArrayReadSliceDenormalizedNode)this.insert(ArrayReadSliceDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                int newLength = length + begin > ArrayNodes.getSize(array) ? begin + values.length : ArrayNodes.getSize(array) + values.length - length;
                int n = popNum = newLength < ArrayNodes.getSize(array) ? ArrayNodes.getSize(array) - newLength : 0;
                if (popNum > 0) {
                    if (this.popOneNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.popOneNode = (PopOneNode)this.insert(PopOneNodeGen.create(this.getContext(), this.getSourceSection(), null));
                    }
                    for (int i = 0; i < popNum; ++i) {
                        this.popOneNode.executePopOne(array);
                    }
                }
                int readLen = newLength - values.length - begin;
                RubyArray endValues = null;
                if (readLen > 0) {
                    endValues = (RubyArray)this.readSliceNode.executeReadSlice(frame, array, ArrayNodes.getSize(array) - readLen, readLen);
                }
                int i = begin;
                for (Object obj : values) {
                    this.writeNode.executeWrite(frame, array, i, obj);
                    ++i;
                }
                if (readLen <= 0) break block15;
                for (Object obj : endValuesStore = ArrayUtils.box(ArrayNodes.getStore(endValues))) {
                    this.writeNode.executeWrite(frame, array, i, obj);
                    ++i;
                }
            }
            return value;
        }

        @Specialization(guards={"!isRubyArray(other)"})
        public Object setRange(VirtualFrame frame, RubyArray array, RubyRange.IntegerFixnumRange range, Object other, NotProvided unused) {
            int normalizedEnd;
            int normalizedStart = ArrayNodes.normalizeIndex(array, range.getBegin());
            int n = normalizedEnd = range.doesExcludeEnd() ? ArrayNodes.normalizeIndex(array, range.getEnd()) - 1 : ArrayNodes.normalizeIndex(array, range.getEnd());
            if (normalizedEnd < 0) {
                normalizedEnd = -1;
            }
            int length = normalizedEnd - normalizedStart + 1;
            if (normalizedStart < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().rangeError(range, (Node)this));
            }
            return this.setObject(frame, array, normalizedStart, length, other);
        }

        @Specialization(guards={"!isIntArray(array) || !isIntArray(other)"})
        public Object setRangeArray(VirtualFrame frame, RubyArray array, RubyRange.IntegerFixnumRange range, RubyArray other, NotProvided unused) {
            int normalizedEnd;
            int normalizedStart = ArrayNodes.normalizeIndex(array, range.getBegin());
            if (normalizedStart < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().rangeError(range, (Node)this));
            }
            int n = normalizedEnd = range.doesExcludeEnd() ? ArrayNodes.normalizeIndex(array, range.getEnd()) - 1 : ArrayNodes.normalizeIndex(array, range.getEnd());
            if (normalizedEnd < 0) {
                normalizedEnd = -1;
            }
            int length = normalizedEnd - normalizedStart + 1;
            return this.setOtherArray(frame, array, normalizedStart, length, other);
        }

        @Specialization(guards={"isIntArray(array)", "isIntArray(other)"})
        public Object setIntegerFixnumRange(VirtualFrame frame, RubyArray array, RubyRange.IntegerFixnumRange range, RubyArray other, NotProvided unused) {
            if (range.doesExcludeEnd()) {
                CompilerDirectives.transferToInterpreter();
                return this.setRangeArray(frame, array, range, other, unused);
            }
            int normalizedBegin = ArrayNodes.normalizeIndex(array, range.getBegin());
            int normalizedEnd = ArrayNodes.normalizeIndex(array, range.getEnd());
            if (normalizedEnd < 0) {
                normalizedEnd = -1;
            }
            if (normalizedBegin != 0 || normalizedEnd != ArrayNodes.getSize(array) - 1) {
                CompilerDirectives.transferToInterpreter();
                return this.setRangeArray(frame, array, range, other, unused);
            }
            ArrayNodes.setStore(array, Arrays.copyOf((int[])ArrayNodes.getStore(other), ArrayNodes.getSize(other)), ArrayNodes.getSize(other));
            return other;
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1})
    public static abstract class IndexNode
    extends ArrayCoreMethodNode {
        @Node.Child
        protected ArrayReadDenormalizedNode readNode;
        @Node.Child
        protected ArrayReadSliceDenormalizedNode readSliceNode;
        @Node.Child
        protected ArrayReadSliceNormalizedNode readNormalizedSliceNode;
        @Node.Child
        protected CallDispatchHeadNode fallbackNode;

        public IndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object index(VirtualFrame frame, RubyArray array, int index, NotProvided length) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNode = (ArrayReadDenormalizedNode)this.insert(ArrayReadDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.readNode.executeRead(frame, array, index);
        }

        @Specialization
        public Object slice(VirtualFrame frame, RubyArray array, int start, int length) {
            if (length < 0) {
                return this.nil();
            }
            if (this.readSliceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readSliceNode = (ArrayReadSliceDenormalizedNode)this.insert(ArrayReadSliceDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.readSliceNode.executeReadSlice(frame, array, start, length);
        }

        @Specialization
        public Object slice(VirtualFrame frame, RubyArray array, RubyRange.IntegerFixnumRange range, NotProvided len) {
            int normalizedIndex = ArrayNodes.normalizeIndex(array, range.getBegin());
            if (normalizedIndex < 0 || normalizedIndex > ArrayNodes.getSize(array)) {
                return this.nil();
            }
            int end = ArrayNodes.normalizeIndex(array, range.getEnd());
            int exclusiveEnd = ArrayNodes.clampExclusiveIndex(array, range.doesExcludeEnd() ? end : end + 1);
            if (exclusiveEnd <= normalizedIndex) {
                return ArrayNodes.createEmptyArray(array.getLogicalClass());
            }
            int length = exclusiveEnd - normalizedIndex;
            if (this.readNormalizedSliceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNormalizedSliceNode = (ArrayReadSliceNormalizedNode)this.insert(ArrayReadSliceNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.readNormalizedSliceNode.executeReadSlice(frame, array, normalizedIndex, length);
        }

        @Specialization(guards={"!isInteger(a)", "!isIntegerFixnumRange(a)"})
        public Object fallbackIndex(VirtualFrame frame, RubyArray array, Object a, NotProvided length) {
            return this.fallback(frame, array, ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), a));
        }

        @Specialization(guards={"!isIntegerFixnumRange(a)", "wasProvided(b)"})
        public Object fallbackSlice(VirtualFrame frame, RubyArray array, Object a, Object b) {
            return this.fallback(frame, array, ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), a, b));
        }

        public Object fallback(VirtualFrame frame, RubyBasicObject array, RubyBasicObject args) {
            if (this.fallbackNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            InternalMethod method = RubyArguments.getMethod(frame.getArguments());
            return this.fallbackNode.call(frame, array, "element_reference_fallback", null, this.createString(method.getName()), args);
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class MulNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToIntNode toIntNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public RubyBasicObject mulEmpty(RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            return ArrayNodes.createEmptyArray(array.getLogicalClass());
        }

        @Specialization(guards={"isIntArray(array)"})
        public RubyBasicObject mulIntegerFixnum(RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            int[] store = (int[])ArrayNodes.getStore(array);
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            int[] newStore = new int[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return ArrayNodes.createArray(array.getLogicalClass(), newStore, newStoreLength);
        }

        @Specialization(guards={"isLongArray(array)"})
        public RubyBasicObject mulLongFixnum(RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            long[] store = (long[])ArrayNodes.getStore(array);
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            long[] newStore = new long[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return ArrayNodes.createArray(array.getLogicalClass(), newStore, newStoreLength);
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public RubyBasicObject mulFloat(RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            double[] store = (double[])ArrayNodes.getStore(array);
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            double[] newStore = new double[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return ArrayNodes.createArray(array.getLogicalClass(), newStore, newStoreLength);
        }

        @Specialization(guards={"isObjectArray(array)"})
        public RubyBasicObject mulObject(RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            Object[] store = (Object[])ArrayNodes.getStore(array);
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            Object[] newStore = new Object[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return ArrayNodes.createArray(array.getLogicalClass(), newStore, newStoreLength);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object mulObject(VirtualFrame frame, RubyArray array, RubyString string) {
            CompilerDirectives.transferToInterpreter();
            return this.ruby(frame, "join(sep)", "sep", string);
        }

        @Specialization(guards={"!isRubyString(object)"})
        public Object mulObjectCount(VirtualFrame frame, RubyArray array, Object object) {
            int count;
            CompilerDirectives.transferToInterpreter();
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToStrNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            if (this.respondToToStrNode.doesRespondTo(frame, object, (RubyString)this.createString("to_str"), false)) {
                return this.ruby(frame, "join(sep.to_str)", "sep", object);
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((count = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            if (ArrayNodes.getStore(array) instanceof int[]) {
                return this.mulIntegerFixnum(array, count);
            }
            if (ArrayNodes.getStore(array) instanceof long[]) {
                return this.mulLongFixnum(array, count);
            }
            if (ArrayNodes.getStore(array) instanceof double[]) {
                return this.mulFloat(array, count);
            }
            if (ArrayNodes.getStore(array) == null) {
                return this.mulEmpty(array, count);
            }
            return this.mulObject(array, count);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="a"), @NodeChild(type=RubyNode.class, value="b")})
    public static abstract class AddNode
    extends CoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"b"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isNullArray(a)", "isNullArray(b)"})
        public RubyBasicObject addNull(RubyArray a, RubyArray b) {
            return this.createEmptyArray();
        }

        @Specialization(guards={"isObjectArray(a)", "isNullArray(b)"})
        public RubyBasicObject addObjectNull(RubyArray a, RubyArray b) {
            return this.createArray(Arrays.copyOf((Object[])ArrayNodes.getStore(a), ArrayNodes.getSize(a)), ArrayNodes.getSize(a));
        }

        @Specialization(guards={"isIntArray(a)", "isIntArray(b)"})
        public RubyBasicObject addBothIntegerFixnum(RubyArray a, RubyArray b) {
            int combinedSize = ArrayNodes.getSize(a) + ArrayNodes.getSize(b);
            int[] combined = new int[combinedSize];
            System.arraycopy(ArrayNodes.getStore(a), 0, combined, 0, ArrayNodes.getSize(a));
            System.arraycopy(ArrayNodes.getStore(b), 0, combined, ArrayNodes.getSize(a), ArrayNodes.getSize(b));
            return this.createArray(combined, combinedSize);
        }

        @Specialization(guards={"isLongArray(a)", "isLongArray(b)"})
        public RubyBasicObject addBothLongFixnum(RubyArray a, RubyArray b) {
            int combinedSize = ArrayNodes.getSize(a) + ArrayNodes.getSize(b);
            long[] combined = new long[combinedSize];
            System.arraycopy(ArrayNodes.getStore(a), 0, combined, 0, ArrayNodes.getSize(a));
            System.arraycopy(ArrayNodes.getStore(b), 0, combined, ArrayNodes.getSize(a), ArrayNodes.getSize(b));
            return this.createArray(combined, combinedSize);
        }

        @Specialization(guards={"isDoubleArray(a)", "isDoubleArray(b)"})
        public RubyBasicObject addBothFloat(RubyArray a, RubyArray b) {
            int combinedSize = ArrayNodes.getSize(a) + ArrayNodes.getSize(b);
            double[] combined = new double[combinedSize];
            System.arraycopy(ArrayNodes.getStore(a), 0, combined, 0, ArrayNodes.getSize(a));
            System.arraycopy(ArrayNodes.getStore(b), 0, combined, ArrayNodes.getSize(a), ArrayNodes.getSize(b));
            return this.createArray(combined, combinedSize);
        }

        @Specialization(guards={"isObjectArray(a)", "isObjectArray(b)"})
        public RubyBasicObject addBothObject(RubyArray a, RubyArray b) {
            int combinedSize = ArrayNodes.getSize(a) + ArrayNodes.getSize(b);
            Object[] combined = new Object[combinedSize];
            System.arraycopy(ArrayNodes.getStore(a), 0, combined, 0, ArrayNodes.getSize(a));
            System.arraycopy(ArrayNodes.getStore(b), 0, combined, ArrayNodes.getSize(a), ArrayNodes.getSize(b));
            return this.createArray(combined, combinedSize);
        }

        @Specialization(guards={"isNullArray(a)", "isIntArray(b)"})
        public RubyBasicObject addNullIntegerFixnum(RubyArray a, RubyArray b) {
            int size = ArrayNodes.getSize(b);
            return this.createArray(Arrays.copyOf((int[])ArrayNodes.getStore(b), size), size);
        }

        @Specialization(guards={"isNullArray(a)", "isLongArray(b)"})
        public RubyBasicObject addNullLongFixnum(RubyArray a, RubyArray b) {
            int size = ArrayNodes.getSize(b);
            return this.createArray(Arrays.copyOf((long[])ArrayNodes.getStore(b), size), size);
        }

        @Specialization(guards={"isNullArray(a)", "isObjectArray(b)"})
        public RubyBasicObject addNullObject(RubyArray a, RubyArray b) {
            int size = ArrayNodes.getSize(b);
            return this.createArray(Arrays.copyOf((Object[])ArrayNodes.getStore(b), size), size);
        }

        @Specialization(guards={"!isObjectArray(a)", "isObjectArray(b)"})
        public RubyBasicObject addOtherObject(RubyArray a, RubyArray b) {
            int combinedSize = ArrayNodes.getSize(a) + ArrayNodes.getSize(b);
            Object[] combined = new Object[combinedSize];
            System.arraycopy(ArrayUtils.box(ArrayNodes.getStore(a)), 0, combined, 0, ArrayNodes.getSize(a));
            System.arraycopy(ArrayNodes.getStore(b), 0, combined, ArrayNodes.getSize(a), ArrayNodes.getSize(b));
            return this.createArray(combined, combinedSize);
        }

        @Specialization(guards={"isObjectArray(a)", "!isObjectArray(b)"})
        public RubyBasicObject addObject(RubyArray a, RubyArray b) {
            int combinedSize = ArrayNodes.getSize(a) + ArrayNodes.getSize(b);
            Object[] combined = new Object[combinedSize];
            System.arraycopy(ArrayNodes.getStore(a), 0, combined, 0, ArrayNodes.getSize(a));
            System.arraycopy(ArrayUtils.box(ArrayNodes.getStore(b)), 0, combined, ArrayNodes.getSize(a), ArrayNodes.getSize(b));
            return this.createArray(combined, combinedSize);
        }

        @Specialization(guards={"isEmptyArray(a)"})
        public RubyBasicObject addEmpty(RubyArray a, RubyArray b) {
            int size = ArrayNodes.getSize(b);
            return this.createArray(ArrayUtils.box(ArrayNodes.getStore(b)), size);
        }

        @Specialization(guards={"isEmptyArray(b)"})
        public RubyBasicObject addOtherEmpty(RubyArray a, RubyArray b) {
            int size = ArrayNodes.getSize(a);
            return this.createArray(ArrayUtils.box(ArrayNodes.getStore(a)), size);
        }
    }

    public static class ArrayType
    extends BasicObjectType {
    }
}

