/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="value")})
public abstract class AppendOneNode
extends RubyNode {
    public AppendOneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract RubyArray executeAppendOne(RubyArray var1, Object var2);

    @Specialization(guards={"isEmptyArray(array)"})
    public RubyBasicObject appendOneEmpty(RubyArray array, int value) {
        ArrayNodes.setStore(array, new int[]{value}, 1);
        return array;
    }

    @Specialization(guards={"isEmptyArray(array)"})
    public RubyBasicObject appendOneEmpty(RubyArray array, long value) {
        ArrayNodes.setStore(array, new long[]{value}, 1);
        return array;
    }

    @Specialization(guards={"isEmptyArray(array)"})
    public RubyBasicObject appendOneEmpty(RubyArray array, double value) {
        ArrayNodes.setStore(array, new double[]{value}, 1);
        return array;
    }

    @Specialization(guards={"isEmptyArray(array)"})
    public RubyBasicObject appendOneEmpty(RubyArray array, Object value) {
        ArrayNodes.setStore(array, new Object[]{value}, 1);
        return array;
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject appendOneSameType(RubyArray array, int value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayMirror.reflect((int[])ArrayNodes.getStore(array)), value, extendProfile);
        return array;
    }

    @Specialization(guards={"isLongArray(array)"})
    public RubyBasicObject appendOneSameType(RubyArray array, long value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayMirror.reflect((long[])ArrayNodes.getStore(array)), value, extendProfile);
        return array;
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public RubyBasicObject appendOneSameType(RubyArray array, double value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayMirror.reflect((double[])ArrayNodes.getStore(array)), value, extendProfile);
        return array;
    }

    @Specialization(guards={"isObjectArray(array)"})
    public RubyBasicObject appendOneSameType(RubyArray array, Object value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayMirror.reflect((Object[])ArrayNodes.getStore(array)), value, extendProfile);
        return array;
    }

    public void appendOneSameTypeGeneric(RubyArray array, ArrayMirror storeMirror, Object value, ConditionProfile extendProfile) {
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + 1;
        ArrayMirror newStoreMirror = extendProfile.profile(newSize > storeMirror.getLength()) ? storeMirror.copyArrayAndMirror(ArrayUtils.capacity(storeMirror.getLength(), newSize)) : storeMirror;
        newStoreMirror.set(oldSize, value);
        ArrayNodes.setStore(array, newStoreMirror.getArray(), newSize);
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject appendOneLongIntoInteger(RubyArray array, long value) {
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + 1;
        int[] oldStore = (int[])ArrayNodes.getStore(array);
        long[] newStore = ArrayUtils.longCopyOf(oldStore, ArrayUtils.capacity(oldStore.length, newSize));
        newStore[oldSize] = value;
        ArrayNodes.setStore(array, newStore, newSize);
        return array;
    }

    @Specialization(guards={"isIntArray(array)", "!isInteger(value)", "!isLong(value)"})
    public RubyBasicObject appendOneGeneralizeInteger(RubyArray array, Object value) {
        this.appendOneGeneralizeGeneric(array, ArrayMirror.reflect((int[])ArrayNodes.getStore(array)), value);
        return array;
    }

    @Specialization(guards={"isLongArray(array)", "!isInteger(value)", "!isLong(value)"})
    public RubyBasicObject appendOneGeneralizeLong(RubyArray array, Object value) {
        this.appendOneGeneralizeGeneric(array, ArrayMirror.reflect((long[])ArrayNodes.getStore(array)), value);
        return array;
    }

    @Specialization(guards={"isDoubleArray(array)", "!isDouble(value)"})
    public RubyBasicObject appendOneGeneralizeDouble(RubyArray array, Object value) {
        this.appendOneGeneralizeGeneric(array, ArrayMirror.reflect((double[])ArrayNodes.getStore(array)), value);
        return array;
    }

    public void appendOneGeneralizeGeneric(RubyArray array, ArrayMirror storeMirror, Object value) {
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + 1;
        Object[] newStore = storeMirror.getBoxedCopy(ArrayUtils.capacity(storeMirror.getLength(), newSize));
        newStore[oldSize] = value;
        ArrayNodes.setStore(array, newStore, newSize);
    }
}

