/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.AppendManyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=AppendManyNode.class)
public final class AppendManyNodeGen
extends AppendManyNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode otherSize_;
    @Node.Child
    private RubyNode other_;
    @CompilerDirectives.CompilationFinal
    private Class<?> otherSizeType_;
    @Node.Child
    private BaseNode_ specialization_;

    private AppendManyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode otherSize, RubyNode other) {
        super(context, sourceSection);
        this.array_ = array;
        this.otherSize_ = otherSize;
        this.other_ = other;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public RubyArray executeAppendMany(RubyArray arrayValue, int otherSizeValue, Object otherValue) {
        return this.specialization_.executeRubyArray1(arrayValue, otherSizeValue, otherValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
        return this.specialization_.executeRubyBasicObject(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static double[] expectDoubleArray(Object value) throws UnexpectedResultException {
        if (value instanceof double[]) {
            return (double[])value;
        }
        throw new UnexpectedResultException(value);
    }

    private static int[] expectIntArray(Object value) throws UnexpectedResultException {
        if (value instanceof int[]) {
            return (int[])value;
        }
        throw new UnexpectedResultException(value);
    }

    private static long[] expectLongArray(Object value) throws UnexpectedResultException {
        if (value instanceof long[]) {
            return (long[])value;
        }
        throw new UnexpectedResultException(value);
    }

    public static AppendManyNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode otherSize, RubyNode other) {
        return new AppendManyNodeGen(context, sourceSection, array, otherSize, other);
    }

    @GeneratedBy(methodName="appendManyGeneralizeDoubleObject(RubyArray, int, Object[])", value=AppendManyNode.class)
    private static final class AppendManyGeneralizeDoubleObjectNode_
    extends BaseNode_ {
        AppendManyGeneralizeDoubleObjectNode_(AppendManyNodeGen root) {
            super(root, 19);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.appendManyGeneralizeDoubleObject(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof Object[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeDoubleObject(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyGeneralizeDoubleObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeDoubleLong(RubyArray, int, long[])", value=AppendManyNode.class)
    private static final class AppendManyGeneralizeDoubleLongNode_
    extends BaseNode_ {
        AppendManyGeneralizeDoubleLongNode_(AppendManyNodeGen root) {
            super(root, 18);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.appendManyGeneralizeDoubleLong(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof long[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeDoubleLong(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyGeneralizeDoubleLongNode_(root);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeDoubleInteger(RubyArray, int, int[])", value=AppendManyNode.class)
    private static final class AppendManyGeneralizeDoubleIntegerNode_
    extends BaseNode_ {
        AppendManyGeneralizeDoubleIntegerNode_(AppendManyNodeGen root) {
            super(root, 17);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            int[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectIntArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.appendManyGeneralizeDoubleInteger(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof int[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeDoubleInteger(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyGeneralizeDoubleIntegerNode_(root);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeLongDouble(RubyArray, int, Object[])", value=AppendManyNode.class)
    private static final class AppendManyGeneralizeLongDouble1Node_
    extends BaseNode_ {
        AppendManyGeneralizeLongDouble1Node_(AppendManyNodeGen root) {
            super(root, 16);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.appendManyGeneralizeLongDouble(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof Object[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeLongDouble(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyGeneralizeLongDouble1Node_(root);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeLongDouble(RubyArray, int, double[])", value=AppendManyNode.class)
    private static final class AppendManyGeneralizeLongDouble0Node_
    extends BaseNode_ {
        AppendManyGeneralizeLongDouble0Node_(AppendManyNodeGen root) {
            super(root, 15);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.appendManyGeneralizeLongDouble(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof double[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeLongDouble(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyGeneralizeLongDouble0Node_(root);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeIntegerDouble(RubyArray, int, Object[])", value=AppendManyNode.class)
    private static final class AppendManyGeneralizeIntegerDouble1Node_
    extends BaseNode_ {
        AppendManyGeneralizeIntegerDouble1Node_(AppendManyNodeGen root) {
            super(root, 14);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.appendManyGeneralizeIntegerDouble(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof Object[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeIntegerDouble(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyGeneralizeIntegerDouble1Node_(root);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeIntegerDouble(RubyArray, int, double[])", value=AppendManyNode.class)
    private static final class AppendManyGeneralizeIntegerDouble0Node_
    extends BaseNode_ {
        AppendManyGeneralizeIntegerDouble0Node_(AppendManyNodeGen root) {
            super(root, 13);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.appendManyGeneralizeIntegerDouble(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof double[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeIntegerDouble(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyGeneralizeIntegerDouble0Node_(root);
        }
    }

    @GeneratedBy(methodName="appendManyLongIntoInteger(RubyArray, int, long[])", value=AppendManyNode.class)
    private static final class AppendManyLongIntoIntegerNode_
    extends BaseNode_ {
        AppendManyLongIntoIntegerNode_(AppendManyNodeGen root) {
            super(root, 12);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.appendManyLongIntoInteger(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof long[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.appendManyLongIntoInteger(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyLongIntoIntegerNode_(root);
        }
    }

    @GeneratedBy(methodName="appendManyBoxIntoObject(RubyArray, int, double[], ConditionProfile)", value=AppendManyNode.class)
    private static final class AppendManyBoxIntoObject2Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;

        AppendManyBoxIntoObject2Node_(AppendManyNodeGen root, ConditionProfile extendProfile) {
            super(root, 11);
            this.extendProfile = extendProfile;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof double[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root, ConditionProfile extendProfile) {
            return new AppendManyBoxIntoObject2Node_(root, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManyBoxIntoObject(RubyArray, int, long[], ConditionProfile)", value=AppendManyNode.class)
    private static final class AppendManyBoxIntoObject1Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;

        AppendManyBoxIntoObject1Node_(AppendManyNodeGen root, ConditionProfile extendProfile) {
            super(root, 10);
            this.extendProfile = extendProfile;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof long[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root, ConditionProfile extendProfile) {
            return new AppendManyBoxIntoObject1Node_(root, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManyBoxIntoObject(RubyArray, int, int[], ConditionProfile)", value=AppendManyNode.class)
    private static final class AppendManyBoxIntoObject0Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;

        AppendManyBoxIntoObject0Node_(AppendManyNodeGen root, ConditionProfile extendProfile) {
            super(root, 9);
            this.extendProfile = extendProfile;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            int[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectIntArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof int[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root, ConditionProfile extendProfile) {
            return new AppendManyBoxIntoObject0Node_(root, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManySameType(RubyArray, int, Object[], ConditionProfile)", value=AppendManyNode.class)
    private static final class AppendManySameType3Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;

        AppendManySameType3Node_(AppendManyNodeGen root, ConditionProfile extendProfile) {
            super(root, 8);
            this.extendProfile = extendProfile;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof Object[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root, ConditionProfile extendProfile) {
            return new AppendManySameType3Node_(root, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManySameType(RubyArray, int, double[], ConditionProfile)", value=AppendManyNode.class)
    private static final class AppendManySameType2Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;

        AppendManySameType2Node_(AppendManyNodeGen root, ConditionProfile extendProfile) {
            super(root, 7);
            this.extendProfile = extendProfile;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof double[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root, ConditionProfile extendProfile) {
            return new AppendManySameType2Node_(root, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManySameType(RubyArray, int, long[], ConditionProfile)", value=AppendManyNode.class)
    private static final class AppendManySameType1Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;

        AppendManySameType1Node_(AppendManyNodeGen root, ConditionProfile extendProfile) {
            super(root, 6);
            this.extendProfile = extendProfile;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof long[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root, ConditionProfile extendProfile) {
            return new AppendManySameType1Node_(root, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManySameType(RubyArray, int, int[], ConditionProfile)", value=AppendManyNode.class)
    private static final class AppendManySameType0Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;

        AppendManySameType0Node_(AppendManyNodeGen root, ConditionProfile extendProfile) {
            super(root, 5);
            this.extendProfile = extendProfile;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            int[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectIntArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof int[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root, ConditionProfile extendProfile) {
            return new AppendManySameType0Node_(root, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManyEmpty(RubyArray, int, Object[])", value=AppendManyNode.class)
    private static final class AppendManyEmpty3Node_
    extends BaseNode_ {
        AppendManyEmpty3Node_(AppendManyNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof Object[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyEmpty3Node_(root);
        }
    }

    @GeneratedBy(methodName="appendManyEmpty(RubyArray, int, double[])", value=AppendManyNode.class)
    private static final class AppendManyEmpty2Node_
    extends BaseNode_ {
        AppendManyEmpty2Node_(AppendManyNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof double[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyEmpty2Node_(root);
        }
    }

    @GeneratedBy(methodName="appendManyEmpty(RubyArray, int, long[])", value=AppendManyNode.class)
    private static final class AppendManyEmpty1Node_
    extends BaseNode_ {
        AppendManyEmpty1Node_(AppendManyNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof long[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyEmpty1Node_(root);
        }
    }

    @GeneratedBy(methodName="appendManyEmpty(RubyArray, int, int[])", value=AppendManyNode.class)
    private static final class AppendManyEmpty0Node_
    extends BaseNode_ {
        AppendManyEmpty0Node_(AppendManyNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyBasicObject(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            int[] otherValue_;
            int otherSizeValue_;
            RubyArray arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeRubyArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeRubyBasicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = AppendManyNodeGen.expectIntArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer && otherValue instanceof int[]) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                int otherSizeValue_ = (Integer)otherSizeValue;
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new AppendManyEmpty0Node_(root);
        }
    }

    @GeneratedBy(value=AppendManyNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(AppendManyNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object otherSizeValue, Object otherValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, otherSizeValue, otherValue));
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            return this.getNext().executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=AppendManyNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(AppendManyNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            return (RubyBasicObject)this.uninitialized(null, arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(AppendManyNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=AppendManyNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final AppendManyNodeGen root;

        BaseNode_(AppendManyNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.otherSize_, this.root.other_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object otherSizeValue, Object otherValue) {
            return this.executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        public abstract RubyBasicObject executeRubyBasicObject_(Object var1, Object var2, Object var3);

        public RubyArray executeRubyArray1(RubyArray arrayValue, int otherSizeValue, Object otherValue) {
            return (RubyArray)this.executeRubyBasicObject_(arrayValue, otherSizeValue, otherValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object otherSizeValue_ = this.executeOtherSize_((Frame)frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            return this.executeRubyBasicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            return (RubyBasicObject)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof RubyArray && otherSizeValue instanceof Integer) {
                RubyArray arrayValue_ = (RubyArray)arrayValue;
                if (otherValue instanceof int[] && ArrayGuards.isEmptyArray(arrayValue_)) {
                    return AppendManyEmpty0Node_.create(this.root);
                }
                if (otherValue instanceof long[] && ArrayGuards.isEmptyArray(arrayValue_)) {
                    return AppendManyEmpty1Node_.create(this.root);
                }
                if (otherValue instanceof double[] && ArrayGuards.isEmptyArray(arrayValue_)) {
                    return AppendManyEmpty2Node_.create(this.root);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isEmptyArray(arrayValue_)) {
                    return AppendManyEmpty3Node_.create(this.root);
                }
                if (otherValue instanceof int[] && ArrayGuards.isIntArray(arrayValue_)) {
                    ConditionProfile extendProfile5 = ConditionProfile.createBinaryProfile();
                    return AppendManySameType0Node_.create(this.root, extendProfile5);
                }
                if (otherValue instanceof long[] && ArrayGuards.isLongArray(arrayValue_)) {
                    ConditionProfile extendProfile6 = ConditionProfile.createBinaryProfile();
                    return AppendManySameType1Node_.create(this.root, extendProfile6);
                }
                if (otherValue instanceof double[] && ArrayGuards.isDoubleArray(arrayValue_)) {
                    ConditionProfile extendProfile7 = ConditionProfile.createBinaryProfile();
                    return AppendManySameType2Node_.create(this.root, extendProfile7);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isObjectArray(arrayValue_)) {
                    ConditionProfile extendProfile8 = ConditionProfile.createBinaryProfile();
                    return AppendManySameType3Node_.create(this.root, extendProfile8);
                }
                if (otherValue instanceof int[] && ArrayGuards.isObjectArray(arrayValue_)) {
                    ConditionProfile extendProfile9 = ConditionProfile.createBinaryProfile();
                    return AppendManyBoxIntoObject0Node_.create(this.root, extendProfile9);
                }
                if (otherValue instanceof long[] && ArrayGuards.isObjectArray(arrayValue_)) {
                    ConditionProfile extendProfile10 = ConditionProfile.createBinaryProfile();
                    return AppendManyBoxIntoObject1Node_.create(this.root, extendProfile10);
                }
                if (otherValue instanceof double[] && ArrayGuards.isObjectArray(arrayValue_)) {
                    ConditionProfile extendProfile11 = ConditionProfile.createBinaryProfile();
                    return AppendManyBoxIntoObject2Node_.create(this.root, extendProfile11);
                }
                if (otherValue instanceof long[] && ArrayGuards.isIntArray(arrayValue_)) {
                    return AppendManyLongIntoIntegerNode_.create(this.root);
                }
                if (otherValue instanceof double[] && ArrayGuards.isIntArray(arrayValue_)) {
                    return AppendManyGeneralizeIntegerDouble0Node_.create(this.root);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isIntArray(arrayValue_)) {
                    return AppendManyGeneralizeIntegerDouble1Node_.create(this.root);
                }
                if (otherValue instanceof double[] && ArrayGuards.isLongArray(arrayValue_)) {
                    return AppendManyGeneralizeLongDouble0Node_.create(this.root);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isLongArray(arrayValue_)) {
                    return AppendManyGeneralizeLongDouble1Node_.create(this.root);
                }
                if (otherValue instanceof int[] && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return AppendManyGeneralizeDoubleIntegerNode_.create(this.root);
                }
                if (otherValue instanceof long[] && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return AppendManyGeneralizeDoubleLongNode_.create(this.root);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return AppendManyGeneralizeDoubleObjectNode_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeOtherSize_(Frame frameValue) {
            Object object;
            Class otherSizeType_ = this.root.otherSizeType_;
            if (otherSizeType_ == Integer.TYPE) {
                return this.root.otherSize_.executeInteger((VirtualFrame)frameValue);
            }
            if (otherSizeType_ != null) return this.root.otherSize_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.otherSize_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.otherSizeType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.otherSizeType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.otherSizeType_ = _type;
            return object;
        }
    }
}

