/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyProc;

public abstract class YieldingCoreMethodNode
extends CoreMethodArrayArgumentsNode {
    @Node.Child
    private YieldDispatchHeadNode dispatchNode;
    @Node.Child
    private BooleanCastNode booleanCastNode;

    public YieldingCoreMethodNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.dispatchNode = new YieldDispatchHeadNode(context);
    }

    private boolean booleanCast(VirtualFrame frame, Object value) {
        if (this.booleanCastNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        return this.booleanCastNode.executeBoolean(frame, value);
    }

    public Object yield(VirtualFrame frame, RubyProc block, Object ... arguments) {
        return this.dispatchNode.dispatch(frame, block, arguments);
    }

    public boolean yieldIsTruthy(VirtualFrame frame, RubyProc block, Object ... arguments) {
        return this.booleanCast(frame, this.yield(frame, block, arguments));
    }

    public Object yieldWithModifiedSelf(VirtualFrame frame, RubyProc block, Object self, Object ... arguments) {
        return this.dispatchNode.dispatchWithModifiedSelf(frame, block, self, arguments);
    }
}

