/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.util.ByteList;

@CoreClass(name="Symbol")
public abstract class SymbolNodes {

    public static class SymbolNodesHelper {
        @CompilerDirectives.TruffleBoundary
        public static ByteList downcase(ByteList originalByteList) {
            ByteList byteList = originalByteList.dup();
            int length = byteList.length();
            for (int i = 0; i < length; ++i) {
                char c = byteList.charAt(i);
                if (c < 'A' || c > 'Z') continue;
                byteList.set(i, c ^ 0x20);
            }
            return byteList;
        }

        @CompilerDirectives.TruffleBoundary
        public static ByteList upcase(ByteList originalByteList) {
            ByteList byteList = originalByteList.dup();
            int length = byteList.length();
            for (int i = 0; i < length; ++i) {
                char c = byteList.charAt(i);
                if (c < 'a' || c > 'z') continue;
                byteList.set(i, c & 0x5F);
            }
            return byteList;
        }

        @CompilerDirectives.TruffleBoundary
        public static ByteList swapcase(ByteList originalByteList) {
            ByteList byteList = originalByteList.dup();
            int length = byteList.length();
            for (int i = 0; i < length; ++i) {
                char c = byteList.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    byteList.set(i, c & 0x5F);
                    continue;
                }
                if (c < 'A' || c > 'Z') continue;
                byteList.set(i, c ^ 0x20);
            }
            return byteList;
        }

        @CompilerDirectives.TruffleBoundary
        public static ByteList capitalize(ByteList originalByteList) {
            char c;
            ByteList byteList = originalByteList.dup();
            int length = byteList.length();
            if (length > 0 && (c = byteList.charAt(0)) >= 'a' && c <= 'z') {
                byteList.set(0, c & 0x5F);
            }
            for (int i = 1; i < length; ++i) {
                char c2 = byteList.charAt(i);
                if (c2 < 'A' || c2 > 'Z') continue;
                byteList.set(i, c2 ^ 0x20);
            }
            return byteList;
        }
    }

    @CoreMethod(names={"upcase"})
    public static abstract class UpcaseNode
    extends CoreMethodArrayArgumentsNode {
        public UpcaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubySymbol upcase(RubySymbol symbol) {
            ByteList byteList = SymbolNodesHelper.upcase(symbol.getByteList());
            return this.getContext().getSymbol(byteList);
        }
    }

    @CoreMethod(names={"swapcase"})
    public static abstract class SwapcaseNode
    extends CoreMethodArrayArgumentsNode {
        public SwapcaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubySymbol swapcase(RubySymbol symbol) {
            ByteList byteList = SymbolNodesHelper.swapcase(symbol.getByteList());
            return this.getContext().getSymbol(byteList);
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size(RubySymbol symbol) {
            return symbol.getByteList().lengthEnc();
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodArrayArgumentsNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject inspect(RubySymbol symbol) {
            return this.createString(symbol.getJRubySymbol().inspect(this.getContext().getRuntime().getCurrentContext()).asString().decodeString());
        }
    }

    @CoreMethod(names={"to_s", "id2name"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject toS(RubySymbol symbol) {
            return this.createString(symbol.getSymbolBytes().dup());
        }
    }

    @CoreMethod(names={"to_sym"})
    public static abstract class ToSymNode
    extends CoreMethodArrayArgumentsNode {
        public ToSymNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubySymbol toSym(RubySymbol symbol) {
            return symbol;
        }
    }

    @CoreMethod(names={"to_proc"})
    public static abstract class ToProcNode
    extends CoreMethodArrayArgumentsNode {
        public ToProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyProc toProc(RubySymbol symbol) {
            return symbol.toProc(Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection(), this);
        }
    }

    @CoreMethod(names={"intern"})
    public static abstract class InternNode
    extends CoreMethodArrayArgumentsNode {
        public InternNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubySymbol intern(RubySymbol symbol) {
            return symbol;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(RubySymbol symbol) {
            return symbol.toString().hashCode();
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodArrayArgumentsNode {
        public EncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyEncoding encoding(RubySymbol symbol) {
            return RubyEncoding.getEncoding(symbol.getByteList().getEncoding());
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean empty(RubySymbol symbol) {
            return symbol.toString().isEmpty();
        }
    }

    @CoreMethod(names={"downcase"})
    public static abstract class DowncaseNode
    extends CoreMethodArrayArgumentsNode {
        public DowncaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubySymbol downcase(RubySymbol symbol) {
            ByteList byteList = SymbolNodesHelper.downcase(symbol.getByteList());
            return this.getContext().getSymbol(byteList);
        }
    }

    @CoreMethod(names={"casecmp"}, required=1)
    public static abstract class CaseCompareNode
    extends CoreMethodArrayArgumentsNode {
        public CaseCompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int caseCompare(RubySymbol symbol, RubySymbol other) {
            return symbol.getByteList().caseInsensitiveCmp(other.getByteList());
        }

        @Specialization(guards={"!isRubySymbol(other)"})
        public RubyBasicObject caseCompare(RubySymbol symbol, Object other) {
            return this.nil();
        }
    }

    @CoreMethod(names={"capitalize"})
    public static abstract class CapitalizeNode
    extends CoreMethodArrayArgumentsNode {
        public CapitalizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubySymbol capitalize(RubySymbol symbol) {
            ByteList byteList = SymbolNodesHelper.capitalize(symbol.getByteList());
            return this.getContext().getSymbol(byteList);
        }
    }

    @CoreMethod(names={"all_symbols"}, onSingleton=true)
    public static abstract class AllSymbolsNode
    extends CoreMethodArrayArgumentsNode {
        public AllSymbolsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject allSymbols() {
            RubyBasicObject array = this.createEmptyArray();
            for (RubySymbol s : this.getContext().getSymbolTable().allSymbols()) {
                ArrayNodes.slowPush(array, s);
            }
            return array;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int compare(RubySymbol a, RubySymbol b) {
            return a.getByteList().cmp(b.getByteList());
        }

        @Specialization(guards={"!isRubySymbol(other)"})
        public RubyBasicObject compare(RubySymbol symbol, Object other) {
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean equal(RubySymbol a, RubySymbol b) {
            return a == b;
        }

        @Specialization(guards={"!isRubySymbol(b)"})
        public boolean equal(RubySymbol a, Object b) {
            return false;
        }
    }
}

