/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Helpers;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.util.Memo;

@CoreClass(name="Proc")
public abstract class ProcNodes {

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        public SourceLocationNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object sourceLocation(RubyProc proc) {
            SourceSection sourceSection = proc.getSharedMethodInfo().getSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.nil();
            }
            RubyBasicObject file = this.createString(sourceSection.getSource().getName());
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), file, sourceSection.getStartLine());
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        public ParametersNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject parameters(RubyProc proc) {
            ArgsNode argsNode = (ArgsNode)proc.getSharedMethodInfo().getParseTree().findFirstChild(ArgsNode.class);
            ArgumentDescriptor[] argsDesc = Helpers.argsNodeToArgumentDescriptors((ArgsNode)argsNode);
            return (RubyArray)this.getContext().toTruffle(Helpers.argumentDescriptorsToParameters((Ruby)this.getContext().getRuntime(), (ArgumentDescriptor[])argsDesc, (proc.getType() == RubyProc.Type.LAMBDA ? 1 : 0) != 0));
        }
    }

    @CoreMethod(names={"lambda?"})
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean lambda(RubyProc proc) {
            return proc.getType() == RubyProc.Type.LAMBDA;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject initialize(RubyProc proc, RubyProc block) {
            proc.initialize(block.getSharedMethodInfo(), block.getCallTargetForProcs(), block.getCallTargetForProcs(), block.getCallTargetForLambdas(), block.getDeclarationFrame(), block.getMethod(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope());
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject initialize(RubyProc proc, NotProvided block) {
            final Memo frameCount = new Memo((Object)0);
            MaterializedFrame grandparentFrame = (MaterializedFrame)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<MaterializedFrame>(){

                public MaterializedFrame visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE, false).materialize();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            RubyProc grandparentBlock = RubyArguments.getBlock(grandparentFrame.getArguments());
            if (grandparentBlock == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("tried to create Proc object without a block", this));
            }
            return this.initialize(proc, grandparentBlock);
        }
    }

    @CoreMethod(names={"call", "[]", "yield"}, argumentsAsArray=true, needsBlock=true)
    public static abstract class CallNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public CallNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        @Specialization
        public Object call(VirtualFrame frame, RubyProc proc, Object[] args, NotProvided block) {
            return this.yieldNode.dispatch(frame, proc, args);
        }

        @Specialization
        public Object call(VirtualFrame frame, RubyProc proc, Object[] args, RubyProc block) {
            return this.yieldNode.dispatchWithModifiedBlock(frame, proc, block, args);
        }
    }

    @CoreMethod(names={"binding"})
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object binding(RubyProc proc) {
            MaterializedFrame frame = proc.getDeclarationFrame();
            return new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(frame.getArguments()), frame);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        public ArityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int arity(RubyProc proc) {
            return proc.getSharedMethodInfo().getArity().getArityNumber();
        }
    }
}

