/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.subsystems.ThreadManager;

@CoreClass(name="Mutex")
public abstract class MutexNodes {
    private static final HiddenKey LOCK_IDENTIFIER = new HiddenKey("lock");
    private static final Property LOCK_PROPERTY;
    private static final DynamicObjectFactory MUTEX_FACTORY;

    protected static ReentrantLock getLock(RubyBasicObject mutex) {
        assert (mutex.getDynamicObject().getShape().hasProperty((Object)LOCK_IDENTIFIER));
        return (ReentrantLock)LOCK_PROPERTY.get(mutex.getDynamicObject(), true);
    }

    static {
        Shape.Allocator allocator = RubyBasicObject.LAYOUT.createAllocator();
        LOCK_PROPERTY = Property.create((Object)LOCK_IDENTIFIER, (Location)allocator.locationForType(ReentrantLock.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), (int)0);
        Shape shape = RubyBasicObject.EMPTY_SHAPE.addProperty(LOCK_PROPERTY);
        MUTEX_FACTORY = shape.createFactory();
    }

    @CoreMethod(names={"unlock"})
    public static abstract class UnlockNode
    extends UnaryCoreMethodNode {
        public UnlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject unlock(RubyBasicObject mutex) {
            ReentrantLock lock = MutexNodes.getLock(mutex);
            RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
            try {
                lock.unlock();
            }
            catch (IllegalMonitorStateException e) {
                if (!lock.isLocked()) {
                    throw new RaiseException(this.getContext().getCoreLibrary().threadError("Attempt to unlock a mutex which is not locked", this));
                }
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("Attempt to unlock a mutex which is locked by another thread", this));
            }
            thread.releasedLock(lock);
            return mutex;
        }
    }

    @CoreMethod(names={"try_lock"})
    public static abstract class TryLockNode
    extends UnaryCoreMethodNode {
        public TryLockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean tryLock(RubyBasicObject mutex) {
            ReentrantLock lock = MutexNodes.getLock(mutex);
            if (lock.isHeldByCurrentThread()) {
                return false;
            }
            if (lock.tryLock()) {
                RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
                thread.acquiredLock(lock);
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"owned?"})
    public static abstract class IsOwnedNode
    extends UnaryCoreMethodNode {
        public IsOwnedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isOwned(RubyBasicObject mutex) {
            return MutexNodes.getLock(mutex).isHeldByCurrentThread();
        }
    }

    @CoreMethod(names={"locked?"})
    public static abstract class IsLockedNode
    extends UnaryCoreMethodNode {
        public IsLockedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isLocked(RubyBasicObject mutex) {
            return MutexNodes.getLock(mutex).isLocked();
        }
    }

    @CoreMethod(names={"lock"})
    public static abstract class LockNode
    extends UnaryCoreMethodNode {
        public LockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject lock(RubyBasicObject mutex) {
            final ReentrantLock lock = MutexNodes.getLock(mutex);
            if (lock.isHeldByCurrentThread()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().threadError("deadlock; recursive locking", this));
            }
            final RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
            this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    lock.lockInterruptibly();
                    thread.acquiredLock(lock);
                    return true;
                }
            });
            return mutex;
        }
    }

    public static class MutexAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyBasicObject(rubyClass, MUTEX_FACTORY.newInstance(new Object[]{new ReentrantLock()}));
        }
    }
}

